/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends Canvas {
    int BLOCKWIDTH = 4;
    int BLOCKHEIGHT = 3;
    Clix clix;
    Display display;
    boolean blocksChanged;
    boolean overLaySet;
    boolean overLayFF;
    boolean blackAndWhite;
    boolean scoreDisplayed = false;
    boolean artChanged;
    int width;
    int height;
    int xOff;
    int yOff;
    int rightClip;
    int bottomClip;
    int tilesOn;
    int rightMost;
    int tColumnTop;
    int tRightMost;
    int cT;
    int key;
    int lastKey;
    int blockChanges;
    int gaX;
    int gaY;
    int gaH;
    int gaCY;
    int[] blocks = new int[216];
    int[] oBlocks = new int[432];
    int[] tBlocks = new int[216];
    int[] sBlocks = new int[216];
    int[] highColors = new int[]{0xFFFF00, 0xFFDD00, 0xFFBB00, 0xFF9900, 0xFF7700};
    int[] blockChangedList = new int[1200];
    int[] columnTops = new int[18];
    int[] colors = new int[]{0, 255, 65280, 0xFF0000, 0xFFFF00, 65535, 0xFF00FF, 0xF0F0F0, 0, 0x444444, 0x888888, 0xBBBBBB, 0xDDDDDD, 0xCCCCCC, 0x222222, 0xFFFFFF};
    int[] loColors = new int[]{0, 136, 34816, 0x880000, 0x888800, 34952, 0x880088, 0x808080, 0, 0x333333, 0x777777, 0xAAAAAA, 0xCCCCCC, 0xBBBBBB, 0x111111, 0xEEEEEE};
    int[] hiColors = new int[]{0, 0x8888FF, 0x88FF88, 0xFF8888, 0xFFFF88, 0x88FFFF, 0xFF88FF, 0xFFFFFF, 0, 0x666666, 0xAAAAAA, 0xCCCCCC, 0xEEEEEE, 0xDDDDDD, 0x404040, 0xFFFFFF};
    int colorOff;
    int cursorX = 0;
    int cursorY = 0;
    int newCursorX = 0;
    int newCursorY = 0;
    int cursorColor = 0;
    int checkColor;
    int linksFnd;
    int overLayCnt = 0;
    public Image gameScreen;
    public Image gameArt;
    Font font = Font.getFont((int)32, (int)1, (int)8);
    Font mediumFont = Font.getFont((int)32, (int)1, (int)0);
    Font bigFont = Font.getFont((int)32, (int)1, (int)16);
    Graphics gG;
    Graphics aG;

    GameCanvas(Display display, Clix clix) {
        this.clix = clix;
        this.display = display;
        this.cursorColor = 0;
        this.blocksChanged = true;
        this.artChanged = false;
        this.overLaySet = false;
        this.overLayFF = false;
        this.colorOff = display.isColor() ? 0 : 8;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.BLOCKHEIGHT = this.BLOCKWIDTH = this.width / 18 - 1;
        if ((this.BLOCKHEIGHT + 1) * 12 > this.height) {
            this.BLOCKHEIGHT = this.height / 12 - 1;
        }
        if (display.numColors() < 4) {
            this.blackAndWhite = true;
        }
        this.xOff = this.width - (this.BLOCKWIDTH + 1) * 18 >> 1;
        this.yOff = this.height - (this.BLOCKHEIGHT + 1) * 12 >> 1;
        if (this.height > (this.BLOCKHEIGHT + 1) * 12 + 12) {
            this.yOff += 6;
        }
        this.gameScreen = Image.createImage((int)this.width, (int)this.height);
        this.gG = this.gameScreen.getGraphics();
        this.rightClip = this.width;
        this.bottomClip = this.height;
        this.blockChanges = 0;
        try {
            this.gameArt = Image.createImage((String)("/g" + (this.display.isColor() ? "" : "2") + ".png"));
        }
        catch (IOException iOException) {
            System.out.println("Unable to load image!!");
        }
        System.out.println("Width:" + this.width + ",Height:" + this.height);
        System.out.println("Double buffered:" + (this.isDoubleBuffered() ? "Yes" : "No"));
    }

    public void drawTitle() {
        this.gaY = -30;
        this.gaH = 28;
        this.gaCY = 0;
        this.gaX = (this.width - 87) / 2;
        this.blocksChanged = true;
        this.artChanged = true;
        this.repaint();
    }

    public void drawHelp() {
        this.gaY = this.height;
        this.gaH = 184;
        this.gaCY = 28;
        this.gaX = (this.width - 87) / 2;
        this.blocksChanged = true;
        this.artChanged = true;
        this.repaint();
    }

    public void drawHiScores() {
        int n = (this.height - (this.height > 70 ? 60 : 56)) / 2;
        this.gG.setFont(this.mediumFont);
        this.gG.setColor(0xFFFF00);
        this.gG.drawString("High Scores", this.width / 2, n, 17);
        this.gG.setFont(this.font);
        int n2 = 0;
        while (n2 < 5) {
            this.gG.setColor(this.highColors[n2]);
            this.gG.drawString(this.clix.hiName[n2], this.width / 2 - 4, 13 + n + n2 * (this.height > 70 ? 10 : 8) + (this.height > 70 ? 6 : 0), 24);
            this.gG.drawString("" + this.clix.hiScore[n2], this.width / 2 + 4, 13 + n + n2 * (this.height > 70 ? 10 : 8) + (this.height > 70 ? 6 : 0), 20);
            ++n2;
        }
        System.gc();
    }

    public void screenSetup() {
        this.rightClip = this.width;
        this.bottomClip = this.height;
        this.gG.setColor(0, 0, 0);
        this.gG.fillRect(0, 0, this.width, this.height);
        if (this.height > (this.BLOCKHEIGHT + 1) * 12 + 12) {
            this.gG.setColor(255, 255, 255);
            this.gG.drawLine(0, this.yOff - 3, this.width, this.yOff - 3);
            this.scoreDisplayed = true;
        }
        this.blocksChanged = true;
    }

    public void reset(int n) {
        Random random = new Random();
        boolean bl = false;
        this.rightClip = this.width;
        this.bottomClip = this.height;
        this.gG.setColor(0, 0, 0);
        this.gG.fillRect(0, this.yOff, this.width, (this.BLOCKHEIGHT + 1) * 12);
        this.blockChanges = 0;
        int n2 = 0;
        while (n2 < 216) {
            switch (n) {
                case 0: {
                    this.blocks[n2] = 0;
                    break;
                }
                case 1: {
                    this.setBlock(n2, Math.abs(random.nextInt()) % (this.clix.level + 1) + 1);
                    break;
                }
            }
            this.sBlocks[n2] = 0;
            ++n2;
        }
        if (n == 1) {
            this.tilesOn = 216;
            this.rightMost = 17;
            n2 = 0;
            while (n2 < 18) {
                this.columnTops[n2] = 0;
                ++n2;
            }
        }
        this.setScore(this.clix.score);
        this.setLevel(this.clix.level);
        if (n == 0) {
            this.cursorColor = 0;
        }
        if (n == 1) {
            this.setCursor(9, 6);
        } else {
            this.setCursor(17, 11);
        }
    }

    public void setLevel(int n) {
        if (!this.scoreDisplayed) {
            return;
        }
        String string = "Level:" + n;
        this.gG.setColor(0);
        this.gG.setFont(this.font);
        this.gG.fillRect(this.width - 7, this.yOff - 22, 7, 18);
        this.gG.setColor(0xFFFF00);
        this.gG.drawString(string, this.width, this.yOff - 2, 40);
    }

    public void setScore(int n) {
        if (!this.scoreDisplayed) {
            return;
        }
        String string = "Score:" + n;
        this.gG.setColor(0);
        this.gG.setFont(this.font);
        this.gG.fillRect(0, this.yOff - 22, this.width - 50, 18);
        this.gG.setColor(0xFFFF00);
        this.gG.drawString(string, 0, this.yOff - 2, 36);
    }

    public void setBlock(int n, int n2) {
        if (this.blocks[n] == n2) {
            return;
        }
        this.blocks[n] = n2;
        this.blockChangedList[this.blockChanges++] = n;
    }

    public void moveBlock(int n, int n2) {
        int n3 = this.blocks[n2];
        this.blocks[n2] = 0;
        if (n3 != 0) {
            this.blockChangedList[this.blockChanges++] = n2;
        }
        if (this.blocks[n] == n3) {
            return;
        }
        this.blocks[n] = n3;
        this.blockChangedList[this.blockChanges++] = n;
    }

    public void drawBlock(int n) {
        int n2 = this.blocks[n];
        int n3 = n / 18;
        int n4 = n % 18;
        String string = n4 + "," + n3 + ":" + n2;
        if (this.blackAndWhite) {
            this.gG.setColor(0);
            this.gG.fillRect(this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1), this.BLOCKWIDTH, this.BLOCKHEIGHT);
            this.gG.setColor(0xFFFFFF);
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    this.gG.drawRect(this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1), this.BLOCKWIDTH - 1, this.BLOCKHEIGHT - 1);
                    break;
                }
                case 2: {
                    this.gG.drawLine(this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1), this.xOff + n4 * (this.BLOCKWIDTH + 1) + this.BLOCKWIDTH - 1, this.yOff + n3 * (this.BLOCKHEIGHT + 1) + this.BLOCKHEIGHT - 1);
                    this.gG.drawLine(this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1) + this.BLOCKHEIGHT - 1, this.xOff + n4 * (this.BLOCKWIDTH + 1) + this.BLOCKWIDTH - 1, this.yOff + n3 * (this.BLOCKHEIGHT + 1));
                    break;
                }
                case 3: {
                    this.gG.fillRect(this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1), this.BLOCKWIDTH, this.BLOCKHEIGHT);
                    break;
                }
                case 4: {
                    this.gG.drawLine(this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1) + 1, this.xOff + n4 * (this.BLOCKWIDTH + 1) + this.BLOCKWIDTH - 1, this.yOff + n3 * (this.BLOCKHEIGHT + 1) + 1);
                    this.gG.drawLine(this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1), this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1) + this.BLOCKHEIGHT - 1);
                    this.gG.drawLine(this.xOff + n4 * (this.BLOCKWIDTH + 1) + this.BLOCKWIDTH - 1, this.yOff + n3 * (this.BLOCKHEIGHT + 1), this.xOff + n4 * (this.BLOCKWIDTH + 1) + this.BLOCKWIDTH - 1, this.yOff + n3 * (this.BLOCKHEIGHT + 1) + this.BLOCKHEIGHT - 1);
                    break;
                }
                case 5: {
                    this.gG.fillRect(this.xOff + n4 * (this.BLOCKWIDTH + 1), this.yOff + n3 * (this.BLOCKHEIGHT + 1), this.BLOCKWIDTH, this.BLOCKHEIGHT);
                    break;
                }
            }
        } else {
            int n5 = this.xOff + n4 * (this.BLOCKWIDTH + 1);
            int n6 = this.yOff + n3 * (this.BLOCKHEIGHT + 1);
            this.gG.setColor(this.colors[n2 + this.colorOff]);
            this.gG.fillRect(n5, n6, this.BLOCKWIDTH, this.BLOCKHEIGHT);
            this.gG.setColor(this.hiColors[n2 + this.colorOff]);
            this.gG.drawLine(n5, n6, n5 + this.BLOCKWIDTH - 1, n6);
            this.gG.drawLine(n5, n6 + 1, n5, n6 + this.BLOCKHEIGHT - 2);
            this.gG.setColor(this.loColors[n2 + this.colorOff]);
            this.gG.drawLine(n5, n6 + this.BLOCKHEIGHT - 1, n5 + this.BLOCKWIDTH - 1, n6 + this.BLOCKHEIGHT - 1);
            this.gG.drawLine(n5 + this.BLOCKWIDTH - 1, n6 + 1, n5 + this.BLOCKWIDTH - 1, n6 + this.BLOCKHEIGHT - 2);
        }
    }

    public void setCursor(int n, int n2) {
        this.newCursorX = n;
        this.newCursorY = n2;
        this.checkLinks();
        this.repaint();
    }

    public void moveCursor(int n, int n2) {
        this.newCursorX += n;
        this.newCursorY += n2;
        if (this.newCursorX < 0) {
            this.newCursorX = 17;
        }
        if (this.newCursorX > 17) {
            this.newCursorX = 0;
        }
        if (this.newCursorY < 0) {
            this.newCursorY = 11;
        }
        if (this.newCursorY > 11) {
            this.newCursorY = 0;
        }
        this.repaint();
        this.clix.repeater = 3;
    }

    public void animateCursor() {
        this.cursorColor = this.cursorColor == 0 ? 7 : 0;
        this.repaint();
    }

    public void checkLinks() {
        if (this.overLaySet && this.tBlocks[this.newCursorY * 18 + this.newCursorX] == -1) {
            return;
        }
        int n = 0;
        int n2 = this.blocks[this.newCursorY * 18 + this.newCursorX];
        if (this.overLaySet) {
            this.blocksChanged = true;
        }
        this.overLaySet = false;
        if (n2 == 0) {
            return;
        }
        if (!(this.newCursorX != 17 && this.blocks[this.newCursorY * 18 + this.newCursorX + 1] == n2 || this.newCursorX != 0 && this.blocks[this.newCursorY * 18 + this.newCursorX - 1] == n2 || this.newCursorY != 11 && this.blocks[(this.newCursorY + 1) * 18 + this.newCursorX] == n2 || this.newCursorY != 0 && this.blocks[(this.newCursorY - 1) * 18 + this.newCursorX] == n2)) {
            return;
        }
        n = 0;
        while (n < 216) {
            this.tBlocks[n] = this.blocks[n];
            ++n;
        }
        this.linksFnd = 0;
        this.checkColor = this.blocks[this.newCursorX + this.newCursorY * 18];
        this.checkLink(this.newCursorX, this.newCursorY);
        this.oBlocks[this.linksFnd] = -1;
        if (this.linksFnd > 2) {
            this.overLayCnt = 0;
            this.overLaySet = true;
            this.overLayFF = !this.blackAndWhite;
        }
    }

    public void checkLink(int n, int n2) {
        this.tBlocks[n + n2 * 18] = -1;
        this.oBlocks[this.linksFnd++] = n;
        this.oBlocks[this.linksFnd++] = n2;
        if (n > 0 && this.tBlocks[n - 1 + n2 * 18] == this.checkColor) {
            this.checkLink(n - 1, n2);
        }
        if (n < 17 && this.tBlocks[n + 1 + n2 * 18] == this.checkColor) {
            this.checkLink(n + 1, n2);
        }
        if (n2 > 0 && this.tBlocks[n + (n2 - 1) * 18] == this.checkColor) {
            this.checkLink(n, n2 - 1);
        }
        if (n2 < 11 && this.tBlocks[n + (n2 + 1) * 18] == this.checkColor) {
            this.checkLink(n, n2 + 1);
        }
    }

    public void clearOverLay() {
        int n = 0;
        int n2 = 1;
        int n3 = 18;
        int n4 = 0;
        while (this.oBlocks[n] > -1) {
            this.setBlock(this.oBlocks[n] + this.oBlocks[n + 1] * 18, 0);
            if (this.oBlocks[n] < n3) {
                n3 = this.oBlocks[n];
            }
            if (this.oBlocks[n] > n4) {
                n4 = this.oBlocks[n];
            }
            n += 2;
            --this.tilesOn;
            ++n2;
        }
        this.overLaySet = false;
        n2 *= n2;
        this.clix.score += n2;
        this.setScore(this.clix.score);
        int n5 = n3;
        while (n5 < n4 + 1) {
            n = 11;
            while (n > this.columnTops[n5] - 1) {
                if (this.blocks[n5 + n * 18] == 0) {
                    this.tColumnTop = n + 1;
                    int n6 = n - 1;
                    while (n6 > this.columnTops[n5] - 1) {
                        if (this.blocks[n5 + n6 * 18] > 0) {
                            this.moveBlock(n5 + n * 18, n5 + n6 * 18);
                            this.tColumnTop = n--;
                        }
                        --n6;
                    }
                    this.columnTops[n5] = this.tColumnTop;
                    break;
                }
                --n;
            }
            ++n5;
        }
        this.tRightMost = 0;
        n5 = n3;
        while (n5 < this.rightMost + 1) {
            this.tRightMost = n5;
            if (this.blocks[n5 + 198] == 0) {
                int n7 = n5 + 1;
                while (n7 < this.rightMost + 1) {
                    if (this.blocks[n7 + 198] > 0) {
                        this.tRightMost = n7;
                        this.cT = (this.columnTops[n5] < this.columnTops[n7] ? this.columnTops[n5] : this.columnTops[n7]) - 1;
                        n = 11;
                        while (n > this.cT) {
                            this.moveBlock(n5 + n * 18, n7 + n * 18);
                            --n;
                        }
                        this.columnTops[n5] = this.columnTops[n7];
                        ++n5;
                    }
                    ++n7;
                }
            }
            ++n5;
        }
        if (this.tRightMost < this.rightMost) {
            this.rightMost = this.tRightMost;
        }
        this.setCursor(this.cursorX, this.cursorY);
        if (this.tilesOn == 0) {
            this.clix.gameState = 3;
            this.clix.gameTicker = 0;
            return;
        }
        n = 11;
        while (n > -1) {
            n5 = 0;
            while (n5 < 17) {
                int n8 = this.blocks[n * 18 + n5];
                if (n8 > 0 && (n5 < 17 && this.blocks[n * 18 + n5 + 1] == n8 || n5 > 0 && this.blocks[n * 18 + n5 - 1] == n8 || n < 11 && this.blocks[(n + 1) * 18 + n5] == n8 || n > 0 && this.blocks[(n - 1) * 18 + n5] == n8)) {
                    return;
                }
                ++n5;
            }
            --n;
        }
        this.clix.gameState = 4;
        this.clix.gameTicker = 0;
    }

    protected void paint(Graphics graphics) {
        int n;
        int n2 = 0;
        if (this.blockChanges > 0 || this.blocksChanged) {
            n2 = 0;
            while (n2 < this.blockChanges) {
                int n3 = this.blockChangedList[n2];
                if (this.sBlocks[n3] != this.blocks[n3]) {
                    this.drawBlock(n3);
                    this.sBlocks[n3] = this.blocks[n3];
                }
                ++n2;
            }
            graphics.setClip(0, 0, this.rightClip, this.bottomClip);
            graphics.drawImage(this.gameScreen, 0, 0, 20);
            graphics.setClip(0, 0, this.width, this.height);
            this.blocksChanged = false;
            this.blockChanges = 0;
        }
        if (this.overLaySet && this.overLayCnt-- == 0) {
            if (this.overLayFF) {
                if (this.blackAndWhite) {
                    graphics.setColor(0);
                } else {
                    graphics.setColor(0xFFFFFF);
                }
                n2 = 0;
                while (this.oBlocks[n2] > -1) {
                    graphics.fillRect(this.xOff + this.oBlocks[n2] * (this.BLOCKWIDTH + 1), this.yOff + this.oBlocks[n2 + 1] * (this.BLOCKHEIGHT + 1), this.BLOCKWIDTH, this.BLOCKHEIGHT);
                    n2 += 2;
                }
            } else {
                this.blocksChanged = true;
            }
            this.overLayCnt = 5;
            boolean bl = this.overLayFF = !this.overLayFF;
        }
        if (this.clix.gameState == 2) {
            n = this.xOff - 1 + this.cursorX * (this.BLOCKWIDTH + 1);
            int n4 = this.yOff - 1 + this.cursorY * (this.BLOCKHEIGHT + 1);
            if (this.cursorX != this.newCursorX || this.cursorY != this.newCursorY) {
                graphics.setColor(0, 0, 0);
                graphics.drawRect(n, n4, this.BLOCKWIDTH + 1, this.BLOCKHEIGHT + 1);
            }
            this.cursorX = this.newCursorX;
            this.cursorY = this.newCursorY;
            n = this.xOff - 1 + this.cursorX * (this.BLOCKWIDTH + 1);
            n4 = this.yOff - 1 + this.cursorY * (this.BLOCKHEIGHT + 1);
            graphics.setColor(this.colors[this.cursorColor + this.colorOff]);
            graphics.drawRect(n, n4, this.BLOCKWIDTH + 1, this.BLOCKHEIGHT + 1);
        }
        if (this.artChanged) {
            int n5 = n = this.gaY >= 0 ? this.gaH : this.gaH + this.gaY;
            if (n > this.height) {
                n = this.height;
            }
            graphics.setClip(0, this.gaY > 0 ? this.gaY : 0, this.width, n);
            graphics.drawImage(this.gameArt, this.gaX, this.gaY - this.gaCY, 20);
            this.artChanged = false;
        }
    }

    public void keyPressed(int n) {
        this.lastKey = n;
        this.key = this.getGameAction(n);
        this.setKey(this.key, true);
    }

    public void keyReleased(int n) {
        this.key = this.getGameAction(n);
        this.setKey(this.key, false);
        if (this.key == 1 || this.key == 6 || this.key == 2 || this.key == 5) {
            this.checkLinks();
        }
        this.clix.repeater = 0;
    }

    public void setKey(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.clix.upKey = bl;
                break;
            }
            case 6: {
                this.clix.downKey = bl;
                break;
            }
            case 2: {
                this.clix.leftKey = bl;
                break;
            }
            case 5: {
                this.clix.rightKey = bl;
                break;
            }
            case 8: {
                this.clix.fireKey = bl;
                break;
            }
        }
        if (this.clix.gameState == 2) {
            if (this.clix.upKey) {
                this.moveCursor(0, -1);
            }
            if (this.clix.downKey) {
                this.moveCursor(0, 1);
            }
            if (this.clix.leftKey) {
                this.moveCursor(-1, 0);
            }
            if (this.clix.rightKey) {
                this.moveCursor(1, 0);
            }
        }
    }

    public void writeTxt(String string, int n, int n2) {
        if (n == 9999) {
            n = (this.height >> 1) - 8;
        }
        this.gG.setColor(n2);
        this.gG.setFont(this.bigFont);
        this.gG.drawString(string, this.width >> 1, n, 17);
    }
}

