/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.nokia.BSCanvas;
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class EscapeCanvas
extends BSCanvas
implements CommandListener {
    private Command nextLevel;
    private Command endGame;
    public Display display;
    private int HalfWidth = this.getWidth() / 2;
    private int HalfHeight = this.getHeight() / 2;
    private MovementThread GameThread;
    private int[][] testCoords = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}};
    private int[][] UserLocations = new int[4][2];
    private byte[] UserFrames = new byte[4];
    private int presentUser;
    private boolean[] UserOnBoard;
    private int MovementDirection;
    public int Level;
    private byte[][] map;
    private Vector Doors;
    private Vector Switches;
    private Vector FloorTiles;
    private byte GameResolution;
    private int exitX;
    private int exitY;
    private boolean[] LevelFlags;
    private Image[][] Players;
    private Image[] TileSet;
    private Image Options;
    private Image[] BackBuffers;
    private Graphics[] BackPanes;
    private int UnWi = 12;
    private Sound[] sounds = new Sound[2];

    public EscapeCanvas() {
        this.Doors = new Vector();
        this.Switches = new Vector();
        this.FloorTiles = new Vector();
        this.map = new byte[32][32];
        try {
            int i;
            byte[][] sound1 = new byte[][]{{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 70, 4, -32, 86, 5, -96, 98, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 69, -123, 96, 90, 6, 32, -94, 44, 65, 22, 0, 0}};
            this.sounds[0] = new Sound(sound1[0], 1);
            this.sounds[1] = new Sound(sound1[1], 1);
            this.BackBuffers = new Image[4];
            this.BackPanes = new Graphics[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.BackBuffers[i2] = Image.createImage((int)192, (int)192);
                this.BackPanes[i2] = this.BackBuffers[i2].getGraphics();
            }
            this.Players = new Image[4][2];
            this.TileSet = new Image[9];
            Image images = Image.createImage((String)"/Tileset7650.png");
            for (i = 0; i < 8; ++i) {
                this.Players[i / 2][i % 2] = this.getTile(images, i);
            }
            for (i = 0; i < 9; ++i) {
                this.TileSet[i] = this.getTile(images, i + 8);
            }
            this.Options = Image.createImage((int)32, (int)8);
            Graphics g = this.Options.getGraphics();
            g.drawImage(images, 32, 8, 0x20 | 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createCommands() {
        this.nextLevel = new Command(this.langT[1], 1, 1);
        this.endGame = new Command(this.langT[2], 1, 1);
    }

    public Image getTile(Image images, int item) {
        int xOff = -(item % 8 * this.UnWi);
        int yOff = -(item / 8 * this.UnWi);
        Image tempImage = Image.createImage((int)this.UnWi, (int)this.UnWi);
        Graphics tempGraphics = tempImage.getGraphics();
        tempGraphics.drawImage(images, xOff, yOff, 20);
        return tempImage;
    }

    private void LoadLevel(Gauge progress) {
        try {
            int j;
            byte[] a;
            int u;
            int y;
            int x;
            int i;
            int i2;
            this.UserOnBoard = new boolean[]{true, true, true, true};
            this.Doors.removeAllElements();
            this.Switches.removeAllElements();
            this.FloorTiles.removeAllElements();
            this.MovementDirection = 4;
            this.presentUser = 0;
            DataInputStream in = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/".concat(String.valueOf(String.valueOf(this.Level)))));
            this.GameResolution = in.readByte();
            int len = 8 * (this.GameResolution + 1);
            for (int y2 = 0; y2 < len; ++y2) {
                block9: for (int x2 = 0; x2 < len; ++x2) {
                    switch (in.readByte()) {
                        case 0: {
                            this.map[y2][x2] = 0;
                            continue block9;
                        }
                        case 1: {
                            this.map[y2][x2] = 2;
                            continue block9;
                        }
                        case 2: {
                            this.map[y2][x2] = 4;
                            continue block9;
                        }
                        case 3: {
                            this.map[y2][x2] = 5;
                            continue block9;
                        }
                        default: {
                            this.map[y2][x2] = 6;
                        }
                    }
                }
            }
            this.exitX = in.readByte();
            this.exitY = in.readByte();
            for (i2 = 0; i2 < 4; ++i2) {
                this.UserLocations[i2][0] = in.readByte() * 12;
                this.UserLocations[i2][1] = in.readByte() * 12;
            }
            this.LevelFlags = new boolean[in.readByte()];
            for (i2 = 0; i2 < this.LevelFlags.length; ++i2) {
                this.LevelFlags[i2] = in.readByte() != 0;
            }
            int t = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            for (i = 0; i < t; ++i) {
                x = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                y = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                u = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                a = new byte[u];
                for (j = 0; j < u; ++j) {
                    a[j] = in.readByte();
                }
                this.Doors.addElement(new MapItem(this, x, y, a, null));
            }
            t = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            for (i = 0; i < t; ++i) {
                x = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                y = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                u = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                a = new byte[u];
                for (j = 0; j < u; ++j) {
                    a[j] = in.readByte();
                }
                this.Switches.addElement(new MapItem(this, x, y, a, null));
            }
            t = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
            for (i = 0; i < t; ++i) {
                x = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                y = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                u = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                a = new byte[u];
                for (int j2 = 0; j2 < u; ++j2) {
                    a[j2] = in.readByte();
                }
                u = Integer.parseInt(new String(new byte[]{in.readByte(), in.readByte()}), 16);
                byte[] b = new byte[u];
                for (int j3 = 0; j3 < u; ++j3) {
                    b[j3] = in.readByte();
                }
                this.FloorTiles.addElement(new MapItem(this, x, y, a, b));
            }
            for (i = 0; i < 4; ++i) {
                this.BackPanes[i].setColor(0);
                this.BackPanes[i].fillRect(0, 0, this.BackBuffers[i].getWidth(), this.BackBuffers[i].getHeight());
            }
            this.drawBackBuffers();
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawTile(int x, int y, Image tile) {
        if (x < 16 && y < 16) {
            this.BackPanes[0].drawImage(tile, x * 12, y * 12, 20);
        } else if (x > 15 && y < 16) {
            this.BackPanes[1].drawImage(tile, (x - 16) * 12, y * 12, 20);
        } else if (x < 16 && y > 15) {
            this.BackPanes[2].drawImage(tile, x * 12, (y - 16) * 12, 20);
        } else {
            this.BackPanes[3].drawImage(tile, (x - 16) * 12, (y - 16) * 12, 20);
        }
    }

    private void drawBackBuffers() {
        for (int y = 0; y < this.map.length; ++y) {
            for (int x = 0; x < this.map[y].length; ++x) {
                this.drawTile(x, y, this.TileSet[this.map[y][x]]);
            }
        }
        this.drawTile(this.exitX, this.exitY, this.TileSet[8]);
    }

    public boolean updateUser(int i) {
        if (i > 10) {
            return false;
        }
        ++this.presentUser;
        if (this.presentUser == 4) {
            this.presentUser = 0;
        }
        if (!this.UserOnBoard[this.presentUser]) {
            return this.updateUser(i + 1);
        }
        return true;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -7) {
            this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            return;
        }
        if (!this.paused) {
            int dy;
            int dx;
            MapItem a;
            int action = this.getGameAction(keyCode);
            if (keyCode == 49) {
                int i = this.presentUser;
                if (!this.updateUser(0)) {
                    this.presentUser = i;
                }
                return;
            }
            if (action == 2 || keyCode == 52) {
                this.MovementDirection = 0;
            } else if (action == 1 || keyCode == 50) {
                this.MovementDirection = 1;
            } else if (action == 5 || keyCode == 54) {
                this.MovementDirection = 2;
            } else if (action == 6 || keyCode == 56) {
                this.MovementDirection = 3;
            } else if ((action == 8 || keyCode == 53) && (a = this.FindSwitch(dx = this.UserLocations[this.presentUser][0] / 12, dy = this.UserLocations[this.presentUser][1] / 12)) != null) {
                for (int i = 0; i < a.Flags.length; ++i) {
                    this.LevelFlags[a.Flags[i]] = !this.LevelFlags[a.Flags[i]];
                }
                this.EvaluateDoors();
                if (this.map[a.Y][a.X] == 6) {
                    this.map[a.Y][a.X] = 7;
                    this.drawTile(a.X, a.Y, this.TileSet[7]);
                } else {
                    this.map[a.Y][a.X] = 6;
                    this.drawTile(a.X, a.Y, this.TileSet[6]);
                }
                BSCanvas.vibrate(50, 1000);
            }
        }
    }

    protected void keyReleased(int keyCode) {
        this.MovementDirection = 4;
    }

    public void loadGame(byte[] saveData, Gauge progress) {
        try {
            this.Level = saveData[0];
            this.LoadLevel(progress);
            this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] saveGame(Gauge progress) {
        try {
            byte[] byArray = new byte[]{(byte)this.Level};
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void showNotify() {
        if (this.GameThread == null || this.GameThread.DieNow) {
            this.GameThread = new MovementThread();
        }
    }

    protected void hideNotify() {
        if (this.GameThread != null) {
            this.GameThread.DieNow = true;
        }
    }

    public void startGame(int diff, Gauge progress) {
        this.Level = 0;
        this.LoadLevel(progress);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void nextLevel(Gauge progress) {
        ++this.Level;
        this.LoadLevel(progress);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public synchronized void UnifiedMethod(int i) {
        if (i == -1) {
            this.repaint();
        }
        if (i == 1) {
            Form f = new Form(this.langT[3]);
            f.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[4]))).append(this.Level + 1))));
            f.setCommandListener((CommandListener)this);
            if (this.Level == 10) {
                f.append(this.langT[5]);
                f.addCommand(this.endGame);
            } else {
                f.addCommand(this.nextLevel);
            }
            this.display.setCurrent((Displayable)f);
        }
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int tx = -this.UserLocations[this.presentUser][0];
        int ty = -this.UserLocations[this.presentUser][1];
        int len = 1;
        if (this.GameResolution > 1) {
            len = 2;
        }
        for (int y = 0; y < len; ++y) {
            for (int x = 0; x < len; ++x) {
                if (x == 0 && y == 0) {
                    g.drawImage(this.BackBuffers[0], this.HalfWidth + tx - 6, this.HalfHeight + ty - 6, 0x10 | 4);
                    continue;
                }
                if (x == 1 && y == 0) {
                    g.drawImage(this.BackBuffers[1], this.HalfWidth + tx - 6 + 192, this.HalfHeight + ty - 6, 0x10 | 4);
                    continue;
                }
                if (x == 0 && y == 1) {
                    g.drawImage(this.BackBuffers[2], this.HalfWidth + tx - 6, this.HalfHeight + ty - 6 + 192, 0x10 | 4);
                    continue;
                }
                g.drawImage(this.BackBuffers[3], this.HalfWidth + tx - 6 + 192, this.HalfHeight + ty - 6 + 192, 0x10 | 4);
            }
        }
        for (int x = 0; x < 4; ++x) {
            int itx = this.UserLocations[x][0] + tx + this.HalfWidth;
            int ity = this.UserLocations[x][1] + ty + this.HalfHeight;
            if (!this.UserOnBoard[x]) continue;
            g.drawImage(this.Players[x][this.UserFrames[x]], itx, ity, 2 | 1);
        }
        g.drawImage(this.Options, this.getWidth(), this.getHeight(), 0x20 | 8);
        if (this.paused) {
            this.drawText(g, this.langT[6], this.HalfWidth, this.HalfHeight);
        }
    }

    public void drawText(Graphics g, String text, int centerX, int topY) {
        Font f = g.getFont();
        int Sw = f.stringWidth(text);
        int Sh = f.getHeight();
        g.setColor(0);
        g.fillRect(centerX - Sw / 2 - 1, topY - 2, Sw, Sh);
        g.setColor(0xFFFFFF);
        g.drawString(text, centerX, topY, 0x10 | 1);
    }

    public boolean UserValidLocation() {
        int dy = this.UserLocations[this.presentUser][1] / 12;
        int dx = this.UserLocations[this.presentUser][0] / 12;
        if (this.map[dy][dx] > 3) {
            return false;
        }
        if (this.map[dy][dx] == 2) {
            this.map[dy][dx] = 3;
            this.ActivatePad(dx, dy);
        }
        int mx = this.UserLocations[this.presentUser][0] % 12;
        int my = this.UserLocations[this.presentUser][1] % 12;
        if (mx == 0 && my == 0) {
            return true;
        }
        if (mx != 0 && my != 0) {
            if (this.map[dy + 1][dx] < 4 && this.map[dy][dx + 1] < 4 && this.map[dy + 1][dx + 1] < 4) {
                if (this.map[dy + 1][dx] == 2) {
                    this.map[dy + 1][dx] = 3;
                    this.ActivatePad(dx, dy + 1);
                } else if (this.map[dy][dx + 1] == 2) {
                    this.map[dy][dx + 1] = 3;
                    this.ActivatePad(dx + 1, dy);
                } else if (this.map[dy + 1][dx + 1] == 2) {
                    this.map[dy + 1][dx + 1] = 3;
                    this.ActivatePad(dx + 1, dy + 1);
                }
                return true;
            }
        } else if (mx == 0) {
            if (this.map[dy + 1][dx] < 4) {
                if (this.map[dy + 1][dx] == 2) {
                    this.map[dy + 1][dx] = 3;
                    this.ActivatePad(dx, dy + 1);
                }
                return true;
            }
        } else if (my == 0 && this.map[dy][dx + 1] < 4) {
            if (this.map[dy][dx + 1] == 2) {
                this.map[dy][dx + 1] = 3;
                this.ActivatePad(dx + 1, dy);
            }
            return true;
        }
        return false;
    }

    public void ActivatePad(int x, int y) {
        BSCanvas.vibrate(50, 1000);
        this.drawTile(x, y, this.TileSet[3]);
        for (int i = 0; i < this.FloorTiles.size(); ++i) {
            int t;
            int j;
            MapItem a = (MapItem)this.FloorTiles.elementAt(i);
            if (a.X != x || a.Y != y) continue;
            for (j = 0; j < a.FlagRequirements.length; ++j) {
                t = a.FlagRequirements[j];
                if (!(t < 32 ? !this.LevelFlags[t] : this.LevelFlags[t -= 32])) continue;
                return;
            }
            for (j = 0; j < a.Flags.length; ++j) {
                t = a.Flags[j];
                if (t < 32) {
                    if (this.LevelFlags[t]) {
                        this.LevelFlags[t] = false;
                        continue;
                    }
                    this.LevelFlags[t] = true;
                    continue;
                }
                if (t < 64) {
                    this.LevelFlags[t -= 32] = true;
                    continue;
                }
                this.LevelFlags[t -= 64] = false;
            }
        }
        this.EvaluateDoors();
    }

    public void EvaluateDoors() {
        for (int i = 0; i < this.Doors.size(); ++i) {
            try {
                MapItem a = (MapItem)this.Doors.elementAt(i);
                this.map[a.Y][a.X] = this.DoorTest(a) ? 1 : 5;
                this.drawTile(a.X, a.Y, this.TileSet[this.map[a.Y][a.X]]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean DoorTest(MapItem a) {
        for (int j = 0; j < a.Flags.length; ++j) {
            int t = a.Flags[j];
            if (!(t < 32 ? !this.LevelFlags[t] : this.LevelFlags[t -= 32])) continue;
            return false;
        }
        return true;
    }

    public MapItem FindSwitch(int x, int y) {
        for (int i = 0; i < 8; ++i) {
            int ty = y + this.testCoords[i][1];
            int tx = x + this.testCoords[i][0];
            if (this.map[ty][tx] <= 5) continue;
            for (int j = 0; j < this.Switches.size(); ++j) {
                MapItem a = (MapItem)this.Switches.elementAt(j);
                if (ty != a.Y || tx != a.X) continue;
                return a;
            }
        }
        return null;
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.nextLevel) {
            this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, s);
        }
        if (c == this.endGame) {
            this.commandListener.commandAction(BSCanvas.GAME_ENDED, s);
        }
    }

    private class MovementThread
    extends Thread {
        public boolean DieNow = false;

        public MovementThread() {
            this.start();
        }

        public void run() {
            int timer = 66;
            while (true) {
                if (EscapeCanvas.this.paused) {
                    this.DieNow = true;
                }
                if (this.DieNow) {
                    return;
                }
                if (EscapeCanvas.this.MovementDirection < 4) {
                    boolean x = false;
                    int oldX = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser][0];
                    int oldY = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser][1];
                    if (EscapeCanvas.this.MovementDirection == 0) {
                        x = true;
                        int[] nArray = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser];
                        nArray[0] = nArray[0] - 2;
                    } else if (EscapeCanvas.this.MovementDirection == 1) {
                        x = true;
                        int[] nArray = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser];
                        nArray[1] = nArray[1] - 2;
                    } else if (EscapeCanvas.this.MovementDirection == 2) {
                        x = true;
                        int[] nArray = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser];
                        nArray[0] = nArray[0] + 2;
                    } else if (EscapeCanvas.this.MovementDirection == 3) {
                        x = true;
                        int[] nArray = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser];
                        nArray[1] = nArray[1] + 2;
                    }
                    if (!EscapeCanvas.this.UserValidLocation()) {
                        ((EscapeCanvas)EscapeCanvas.this).UserLocations[((EscapeCanvas)EscapeCanvas.this).presentUser][0] = oldX;
                        ((EscapeCanvas)EscapeCanvas.this).UserLocations[((EscapeCanvas)EscapeCanvas.this).presentUser][1] = oldY;
                    }
                    if (x) {
                        ((EscapeCanvas)EscapeCanvas.this).UserFrames[((EscapeCanvas)EscapeCanvas.this).presentUser] = EscapeCanvas.this.UserFrames[EscapeCanvas.this.presentUser] == 0 ? (byte)1 : 0;
                    }
                    int mx = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser][0] % 12;
                    int my = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser][1] % 12;
                    if (mx == 0 && my == 0) {
                        int dx = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser][0] / 12;
                        int dy = EscapeCanvas.this.UserLocations[EscapeCanvas.this.presentUser][1] / 12;
                        if (dx == EscapeCanvas.this.exitX && dy == EscapeCanvas.this.exitY) {
                            ((EscapeCanvas)EscapeCanvas.this).UserOnBoard[((EscapeCanvas)EscapeCanvas.this).presentUser] = false;
                            BSCanvas.playSound(EscapeCanvas.this.sounds[0]);
                            if (!EscapeCanvas.this.updateUser(0)) {
                                BSCanvas.playSound(EscapeCanvas.this.sounds[1]);
                                this.DieNow = true;
                                EscapeCanvas.this.UnifiedMethod(1);
                                return;
                            }
                        }
                    }
                }
                EscapeCanvas.this.UnifiedMethod(-1);
                try {
                    Thread.sleep(timer);
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private class MapItem {
        public int X;
        public int Y;
        public byte[] Flags;
        public byte[] FlagRequirements;

        public MapItem(EscapeCanvas this$0, int x, int y, byte[] flags, byte[] fr) {
            this.Flags = flags;
            this.X = x;
            this.Y = y;
            this.FlagRequirements = fr;
        }
    }
}

