/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CLevel {
    static byte h;
    static int iPosX;
    static int iPosY;
    public Vector m_Delete;
    public Vector m_EEmitter;
    public Vector m_Enemies;
    public GameCanvas m_Game;
    static byte m_byFlagBoss;
    static byte m_byFlagEnemy;
    byte[] m_byFlagHandled;
    static byte m_byFlagSpawnPoint;
    byte[] m_byFlags;
    static byte m_byHeader;
    byte[] m_byID;
    static byte m_bySpawnTest;
    byte[] m_byV;
    char[] m_chU;
    static int m_iCurrentU;
    static int m_iCurrentUOffset;
    static int m_iLevelInfo;
    static int m_iNumTiles;
    static int m_iSpawnX;
    static int m_iSpawnXNew;
    static int m_iSpawnY;
    static int m_iSpawnYNew;
    static int m_iTileSet;
    static int m_iTileStart;
    static int m_iTilesDrawn;
    Image m_imBoss;
    Image[] m_imEnemy;
    Image m_imTileSet;
    CTileSet m_tsBoss;
    CTileSet[] m_tsEnemy;
    CTileSet m_tsGfx;
    static byte w;
    static int xh;
    static int xt;
    static int yh;
    static int yt;

    static {
        m_byFlagEnemy = (byte)-128;
        m_byFlagSpawnPoint = (byte)-96;
        m_byFlagBoss = (byte)-64;
    }

    public CLevel(GameCanvas game) {
        this.m_Game = game;
        m_iTileSet = -1;
        this.m_Enemies = new Vector(15, 4);
        this.m_EEmitter = new Vector(5, 2);
        this.m_Delete = new Vector(4, 2);
    }

    public final boolean CheckBoxCollision(int iCX, int iCY, int iW, int iH) {
        int i = m_iTileStart;
        while (i < m_iNumTiles) {
            if ((this.m_byFlags[i] & 0x80) != 128) {
                iPosX = this.m_chU[i] * 11 - m_iCurrentU;
                if (iPosX > 176) break;
                w = (byte)(this.m_tsGfx.m_anTileData[(this.m_byID[i] << 2) + 2] >> 1);
                iPosY = this.m_byV[i] * 11;
                h = (byte)(this.m_tsGfx.m_anTileData[(this.m_byID[i] << 2) + 3] >> 1);
                if (CCollision.CollideRectRect(iCX, iCY, iW, iH, iPosX + w, iPosY + h, w, h)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public final byte CheckEnemyBoxCollision(int iX, int iY, int iW, int iH, byte byShotStrength) {
        Enumeration en = this.m_Enemies.elements();
        while (en.hasMoreElements()) {
            CEnemy e = (CEnemy)en.nextElement();
            if (e.m_byStrength <= 0 || e.m_bIsBoss && byShotStrength > 50 || !e.CollideBox(iX, iY, iW, iH)) continue;
            e.m_byStrength = (byte)(e.m_byStrength - byShotStrength);
            if (e.m_byStrength < 0) {
                e.m_byStrength = 0;
            }
            if (e.m_byStrength == 0) {
                if (e.m_bIsBoss) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public final byte CheckEnemyPointCollision(int iX, int iY, byte byShotStrength) {
        Enumeration en = this.m_Enemies.elements();
        while (en.hasMoreElements()) {
            CEnemy e = (CEnemy)en.nextElement();
            if (e.m_byStrength <= 0 || !e.CollidePoint(iX, iY)) continue;
            e.m_byStrength = (byte)(e.m_byStrength - byShotStrength);
            if (e.m_byStrength < 0) {
                e.m_byStrength = 0;
            }
            if (e.m_byStrength == 0) {
                if (e.m_bIsBoss) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public final boolean CheckPointCollision(int iX, int iY) {
        int i = m_iTileStart;
        while (i < m_iNumTiles) {
            if ((this.m_byFlags[i] & 0x80) != 128) {
                iPosX = this.m_chU[i] * 11 - m_iCurrentU;
                if (iPosX > 176) break;
                w = (byte)(this.m_tsGfx.m_anTileData[(this.m_byID[i] << 2) + 2] >> 1);
                iPosY = this.m_byV[i] * 11;
                h = (byte)(this.m_tsGfx.m_anTileData[(this.m_byID[i] << 2) + 3] >> 1);
                if (CCollision.CollidePointRect(iX, iY, iPosX + w, iPosY + h, w, h)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private final void FindFirstTile() {
        int i = m_iTileStart;
        while (i < m_iNumTiles) {
            iPosX = this.m_chU[i] * 11 - m_iCurrentU;
            if (iPosX + this.m_tsGfx.m_anTileData[(this.m_byID[i] << 2) + 2] >= 0) break;
            ++m_iTileStart;
            ++i;
        }
    }

    public void FindNearestEnemy() {
        CEnemy.iNEX = this.m_Game.iDisplaySizeX;
        CEnemy.iNEY = this.m_Game.iDisplaySizeY >> 1;
        if (this.m_Game.m_byMode != 1) {
            return;
        }
        int l = 100000;
        Enumeration en = this.m_Enemies.elements();
        while (en.hasMoreElements()) {
            CEnemy e = (CEnemy)en.nextElement();
            int ew = e.m_iX + (e.m_tsGfx.m_anTileData[2] >> 1);
            int eh = e.m_iY + (e.m_tsGfx.m_anTileData[3] >> 1);
            int le = (ew - this.m_Game.m_Ship.m_iShipPosX) * (ew - this.m_Game.m_Ship.m_iShipPosX) + (eh - this.m_Game.m_Ship.m_iShipPosY) * (eh - this.m_Game.m_Ship.m_iShipPosY);
            if (le >= l) continue;
            l = le;
            CEnemy.iNEX = ew;
            CEnemy.iNEY = eh;
        }
    }

    public void Load(String strFileName, int iTileSet, int iBoss, byte byLoadMode) {
        System.gc();
        DataInputStream diData = new DataInputStream(this.getClass().getResourceAsStream(strFileName));
        m_iTileStart = 0;
        m_iTileSet = iTileSet;
        this.ReleaseData();
        try {
            int j;
            this.m_imTileSet = Image.createImage((String)("/" + iTileSet + "/t.png"));
            this.m_tsGfx = new CTileSet(this.m_imTileSet, "/" + iTileSet + "/t.dat");
            this.m_tsGfx.SetClipRect(0, 0, this.m_Game.iDisplaySizeX, this.m_Game.iDisplaySizeY);
            if (byLoadMode == 1) {
                this.m_imBoss = Image.createImage((String)("/b" + iBoss + ".png"));
                this.m_tsBoss = new CTileSet(this.m_imBoss, "/b" + iBoss + ".d");
                this.m_tsBoss.SetClipRect(0, 0, this.m_Game.iDisplaySizeX, this.m_Game.iDisplaySizeY);
                this.m_imEnemy = new Image[6];
                this.m_tsEnemy = new CTileSet[6];
                j = 0;
                while (j < 6) {
                    this.m_imEnemy[j] = Image.createImage((String)("/" + iTileSet + "/" + (j + 1) + ".png"));
                    this.m_tsEnemy[j] = new CTileSet(this.m_imEnemy[j], "/" + iTileSet + "/" + (j + 1) + ".d");
                    this.m_tsEnemy[j].SetClipRect(0, 0, this.m_Game.iDisplaySizeX, this.m_Game.iDisplaySizeY);
                    ++j;
                }
            }
            m_byHeader = (byte)diData.read();
            m_iNumTiles = this.ReadInt(diData);
            m_iLevelInfo = this.ReadInt(diData);
            this.m_chU = new char[m_iNumTiles];
            this.m_byV = new byte[m_iNumTiles];
            this.m_byID = new byte[m_iNumTiles];
            this.m_byFlags = new byte[m_iNumTiles];
            this.m_byFlagHandled = new byte[m_iNumTiles];
            j = 0;
            while (j < m_iNumTiles) {
                this.m_chU[j] = this.ReadChar(diData);
                this.m_byV[j] = (byte)diData.read();
                this.m_byID[j] = (byte)diData.read();
                this.m_byFlags[j] = (byte)diData.read();
                this.m_byFlagHandled[j] = 0;
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.Reset();
        diData = null;
        System.gc();
    }

    public char ReadChar(DataInputStream di) {
        char chRes = '\u0000';
        try {
            char cRead = (char)di.read();
            chRes = (char)(chRes | cRead);
            cRead = (char)di.read();
            chRes = (char)(chRes | cRead << 8);
        }
        catch (IOException e) {
            e.printStackTrace();
            chRes = '\uffff';
        }
        return chRes;
    }

    public int ReadInt(DataInputStream di) {
        int iRes = 0;
        try {
            int iRead = di.read();
            iRes |= iRead;
            iRead = di.read();
            iRes |= iRead << 8;
            iRead = di.read();
            iRes |= iRead << 16;
            iRead = di.read();
            iRes |= iRead << 24;
        }
        catch (IOException e) {
            e.printStackTrace();
            iRes = -1;
        }
        return iRes;
    }

    public void ReleaseData() {
        if (this.m_imEnemy != null) {
            int i = 0;
            while (i < 6) {
                this.m_imEnemy[i] = null;
                System.gc();
                Thread.yield();
                ++i;
            }
        }
        this.m_imTileSet = null;
        this.m_imEnemy = null;
        this.m_imBoss = null;
        System.gc();
        Thread.yield();
        this.m_chU = null;
        this.m_byV = null;
        this.m_byID = null;
        this.m_byFlags = null;
        this.m_byFlagHandled = null;
        this.m_tsBoss = null;
        this.m_tsEnemy = null;
        this.m_tsGfx = null;
        System.gc();
        Thread.yield();
    }

    public final void Render(Graphics g) {
        int i = m_iTileStart;
        while (i < m_iNumTiles) {
            if ((this.m_byFlags[i] & 0x80) != 128) {
                iPosX = this.m_chU[i] * 11 - m_iCurrentU;
                if (iPosX > 176) break;
                iPosY = this.m_byV[i] * 11;
                this.m_tsGfx.DrawTile(g, this.m_byID[i], iPosX, iPosY + 9, false);
            }
            ++i;
        }
        Enumeration en = this.m_Enemies.elements();
        while (en.hasMoreElements()) {
            ((CEnemy)en.nextElement()).Draw(g);
        }
    }

    public void Reset() {
        m_iSpawnX = 10;
        m_iSpawnXNew = 10;
        m_iSpawnYNew = m_iSpawnY = 88;
        m_bySpawnTest = 1;
        m_iCurrentU = 0;
        m_iCurrentUOffset = 2;
        m_iTileStart = 0;
        this.FindFirstTile();
        this.m_Game.m_Ship.m_iShipPosX = 10;
        this.m_Game.m_Ship.m_iShipPosY = m_iSpawnY;
        int i = 0;
        while (i < m_iNumTiles) {
            this.m_byFlagHandled[i] = 0;
            ++i;
        }
        this.m_Enemies.removeAllElements();
        this.m_EEmitter.removeAllElements();
    }

    public final void Respawn() {
        m_iSpawnXNew = m_iSpawnX;
        m_iSpawnYNew = m_iSpawnY;
        m_bySpawnTest = 1;
        m_iCurrentU = m_iSpawnX;
        m_iCurrentUOffset = 2;
        this.m_Game.m_Ship.m_iShipPosX = 10;
        this.m_Game.m_Ship.m_iShipPosY = m_iSpawnY;
        m_iTileStart = 0;
        this.FindFirstTile();
        int i = m_iTileStart;
        while (i < m_iNumTiles) {
            iPosX = this.m_chU[i] * 11 - m_iCurrentU;
            if (iPosX + 176 > 176) {
                this.m_byFlagHandled[i] = 0;
            }
            ++i;
        }
        this.m_Enemies.removeAllElements();
        this.m_EEmitter.removeAllElements();
    }

    public final void Update() {
        this.FindFirstTile();
        if (m_bySpawnTest == 0 && (m_iCurrentU += m_iCurrentUOffset) > m_iSpawnXNew) {
            m_iSpawnX = m_iSpawnXNew;
            m_iSpawnY = m_iSpawnYNew;
            m_bySpawnTest = 1;
        }
        int i = m_iTileStart;
        while (i < m_iNumTiles) {
            if (this.m_byFlagHandled[i] != 1) {
                iPosX = this.m_chU[i] * 11 - m_iCurrentU;
                if (iPosX > 176) break;
                if ((this.m_byFlags[i] & 0x80) == 128) {
                    if ((byte)(this.m_byFlags[i] & 0xE0) == m_byFlagSpawnPoint) {
                        m_bySpawnTest = 0;
                        m_iSpawnXNew = this.m_chU[i] * 11;
                        m_iSpawnYNew = this.m_byV[i] * 11;
                    }
                    if ((byte)(this.m_byFlags[i] & 0xE0) == m_byFlagEnemy) {
                        iPosY = this.m_byV[i] * 11;
                        System.gc();
                        CEnemyEmitter em = new CEnemyEmitter(this.m_Game);
                        em.m_byType = (byte)(this.m_byFlags[i] & 0x1F);
                        em.m_byNumToSpawn = CConfig.EnemyParam[em.m_byType][0];
                        em.m_bySpawnTime = CConfig.EnemyParam[em.m_byType][1];
                        em.m_iPosX = iPosX;
                        em.m_iPosY = iPosY;
                        this.m_EEmitter.addElement(em);
                    }
                    if ((byte)(this.m_byFlags[i] & 0xE0) == m_byFlagBoss) {
                        iPosY = this.m_byV[i] * 11;
                        if ((byte)(this.m_byFlags[i] & 1) == 1) {
                            System.gc();
                            CEnemy e = new CEnemy(this.m_Game);
                            e.m_iX = iPosX;
                            e.m_iY = iPosY;
                            e.m_iUOffset = 0;
                            e.m_byStrength = (byte)64;
                            e.m_byShootMode = 1;
                            e.m_byMoveMode = (byte)-1;
                            e.m_tsGfx = this.m_tsBoss;
                            e.m_bCentered = false;
                            System.gc();
                            e.m_byFrames = new byte[1];
                            e.m_byFrames[0] = 0;
                            e.m_byNumFrames = 1;
                            e.m_tsExp = this.m_Game.m_Ship.m_tsShipExplosion;
                            e.m_bIsBoss = true;
                            this.m_Enemies.addElement(e);
                        } else {
                            m_iCurrentUOffset = 0;
                        }
                    }
                    this.m_byFlagHandled[i] = 1;
                }
            }
            ++i;
        }
        Enumeration en = this.m_EEmitter.elements();
        while (en.hasMoreElements()) {
            CEnemyEmitter em = (CEnemyEmitter)en.nextElement();
            em.Update();
            if (em.m_byNumToSpawn != 0) continue;
            this.m_Delete.addElement(em);
        }
        Enumeration en2 = this.m_Delete.elements();
        while (en2.hasMoreElements()) {
            this.m_EEmitter.removeElement(en2.nextElement());
        }
        this.m_Delete.removeAllElements();
        Enumeration en3 = this.m_Enemies.elements();
        while (en3.hasMoreElements()) {
            CEnemy e = (CEnemy)en3.nextElement();
            e.m_iX -= m_iCurrentUOffset;
            if (e.m_iX < -24 || e.m_iY < -24 || e.m_iY > this.m_Game.iDisplaySizeY + 24) {
                this.m_Delete.addElement(e);
                continue;
            }
            if (e.m_byMode > 0) {
                e.Update();
                continue;
            }
            if (e.m_bIsBoss) {
                if (this.m_Game.m_byMode != 3) {
                    this.m_Game.PlayWinMusic();
                }
                this.m_Game.m_byMode = (byte)3;
                return;
            }
            this.m_Delete.addElement(e);
        }
        Enumeration en4 = this.m_Delete.elements();
        while (en4.hasMoreElements()) {
            this.m_Enemies.removeElement(en4.nextElement());
        }
        this.m_Delete.removeAllElements();
    }
}

