/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class HugoInTheSnow
extends MIDlet
implements Runnable,
CommandListener {
    static HugoInTheSnow instance;
    private Setup setup;
    private Intro intro;
    private Menu menu;
    private Game game;
    private Thread thread;
    public static Sprite bg;
    public static final int SCREENWIDTH = 176;
    public static final int SCREENHEIGHT = 208;
    private HighscoreHandler highscoreHandler;
    protected static boolean soundEnabled;
    protected static boolean vibraEnabled;
    protected boolean highscoreStop = false;
    private Command okCommand;
    public static int[] KEY_LEFT;
    public static int[] KEY_RIGHT;
    public static int[] KEY_UP;
    public static int[] KEY_DOWN;
    public static int[] KEY_ENTER;
    public static int[] KEY_LEFT_SOFTKEY;
    public static int[] KEY_RIGHT_SOFTKEY;

    public static boolean checkKey(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }

    protected void destroyApp(boolean bl) {
        Display.getDisplay((MIDlet)this).setCurrent(null);
        this.notifyDestroyed();
    }

    protected void pauseApp() {
        this.notifyPaused();
    }

    public HugoInTheSnow() {
        Language.init();
        this.highscoreHandler = new HighscoreHandler();
        instance = this;
        Setup.load(0);
        bg = Setup.getSprite("baggrund.kspr");
        this.intro = new Intro();
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.intro);
    }

    public void run() {
        this.intro.run(Language.get("IntroBubbleText"), true);
        this.intro.destroy();
        System.gc();
        Setup.load(1);
        this.game = new Game();
        this.menu = new Menu();
        this.intro.setGame(this.game);
        this.game.setIntro(this.intro);
        while (true) {
            this.menu.reset();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menu);
            this.menu.run();
            soundEnabled = this.menu.optionFlags[0];
            vibraEnabled = false;
            this.game.reset();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.game);
            this.game.run();
            this.intro.setGamePaintMode(true);
            this.game.setIntroMode(true);
            if (this.highscoreHandler.gotHighscore(this.game.getScore())) {
                this.intro.run(Language.get("HighscoreWonBubbleText"), false);
                Form form = new Form(Language.get("Highscore"));
                TextField textField = new TextField(Language.get("EnterName"), "", 8, 0);
                form.append((Item)textField);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
                form.setCommandListener((CommandListener)this);
                this.okCommand = new Command(Language.get("Accept"), 1, 0);
                form.addCommand(this.okCommand);
                this.highscoreStop = false;
                while (!this.highscoreStop) {
                }
                form = new Form(Language.get("Highscore"));
                form.append(Language.get("PleaseWait"));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
                this.highscoreHandler.add(textField.getString(), this.game.getScore());
                this.highscoreHandler.storeData();
            } else {
                this.intro.run(Language.get("HighscoreLostBubbleText"), false);
            }
            this.game.setIntroMode(false);
        }
    }

    protected static Font getFontSmall() {
        return Font.getFont((int)0, (int)0, (int)8);
    }

    public void commandAction(Command command, Displayable displayable) {
        this.highscoreStop = true;
    }

    static {
        KEY_LEFT = new int[]{52, -3};
        KEY_RIGHT = new int[]{54, -4};
        KEY_UP = new int[]{50, -1};
        KEY_DOWN = new int[]{56, -2};
        KEY_ENTER = new int[]{53, -5};
        KEY_LEFT_SOFTKEY = new int[]{-6};
        KEY_RIGHT_SOFTKEY = new int[]{-7};
    }
}

