/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public final class OMScreenGame
extends OMScreen {
    public int nTestTime = 0;
    public final int nTestPause;
    public final int nTestPauseMin;
    public int nNextTestPause = 300;
    public final int nTestSplash;
    final int nEnemyAppearDuration;
    final int nEnemyWaitDuration;
    final int nEnemyFireDuration;
    final int nEnemyDeathDuration;
    final int nTimeSplashScreen;
    final int nMaxBullets;
    final int nShootAnimationDur;
    final int nShotgunReloadDuration;
    int nShootgunState = 0;
    final int clMsgBackground;
    final int clMsgBorder;
    final int clMsgText;
    final int clLife1;
    final int clLife2;
    final int clTwinkle;
    final int clScore;
    final int clScoreShadow;
    final int nMsgBorder;
    final int nMsgPadding;
    final int nMaxLifes;
    final int[] nEnemyThresholds = new int[]{18, 64, 128, 200, 300, 450};
    protected int nComboHits = 0;
    protected int nComboCnt = 0;
    protected int nComboTwinkStart = 0;
    protected int nComboType = 0;
    protected final int nComboTwinkDuration1;
    protected final int nComboTwinkDuration2;
    protected final int nComboTwinkDuration3;
    protected final int nPauseBetweenEnemies;
    protected int nBossesCanAppear = 0;
    protected int nBossesKilled = 0;
    protected int nEnemiesInWave = 0;
    protected int nGameState = 0;
    protected char[] cKeysBuffer = new char[16];
    protected static final Random random = new Random();
    OMLevelLoader level;
    Tile tileBullet1;
    Tile tileBullet2;
    Tile tileShot1;
    Tile tileShot2;
    Tile tileShot3;
    Tile tileLife;
    Tile tileHead;
    Tile tileChallenge;
    Event[] events;
    int nShootgunTime;
    int nLifes = 9;
    int nBullets = 6;
    int nNextEvent;
    int nLastEvent;
    final int nTwinkleDuration;
    int nTwinkleStartTime = 0;
    boolean bTwinkle = false;

    OMScreenGame(OMLevelLoader oMLevelLoader, OM oM) {
        super(oM, 2);
        this.nTestPause = 300;
        this.nTestPauseMin = 200;
        this.nTestSplash = 1000;
        this.nEnemyAppearDuration = 500;
        this.nEnemyWaitDuration = 1500;
        this.nEnemyFireDuration = 800;
        this.nEnemyDeathDuration = 800;
        this.nTimeSplashScreen = 5000;
        this.nMaxBullets = 6;
        this.nShootAnimationDur = 600;
        this.nShotgunReloadDuration = 1000;
        this.clMsgBackground = 0xFF0000;
        this.clMsgBorder = 0xFFFFFF;
        this.clMsgText = 0xFFFFFF;
        this.clLife1 = 16083562;
        this.clLife2 = 0xA31313;
        this.clTwinkle = 0xFFFF00;
        this.clScore = 0xFF0000;
        this.clScoreShadow = 0;
        this.nMsgBorder = 1;
        this.nMsgPadding = 10;
        this.nMaxLifes = 9;
        this.nComboTwinkDuration1 = 2000;
        this.nComboTwinkDuration2 = 3000;
        this.nComboTwinkDuration3 = 5000;
        this.nPauseBetweenEnemies = 5000;
        this.nTwinkleDuration = 2000;
        this.level = oMLevelLoader;
        this.events = new Event[6];
        if (this.events != null) {
            for (int i = 0; i < this.events.length; ++i) {
                this.events[i] = new Event(0, 0, 0);
            }
        }
    }

    public void playSound(int n) {
        switch (n) {
            case 3: {
                this.om.playShootSound();
                break;
            }
            case 5: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.om.playReloadSound();
            }
        }
    }

    public void onLoadResources() {
        this.loadImage(105);
        this.loadImage(100);
        this.loadImage(101);
        this.loadImage(103);
        int[] nArray = this.level.getRequiredImages();
        for (int i = 0; i < nArray.length; ++i) {
            this.loadImage(nArray[i]);
        }
        this.tileBullet1 = new Tile(105, 111, 19, 7, 16, 0, 0);
        this.tileBullet2 = new Tile(105, 118, 19, 7, 16, 0, 0);
        this.tileShot1 = new Tile(105, 0, 0, 37, 35, 0, 0);
        this.tileShot2 = new Tile(105, 37, 0, 37, 35, 0, 0);
        this.tileShot3 = new Tile(105, 74, 0, 37, 35, 0, 0);
        this.tileLife = new Tile(105, 0, 35, 56, 5, 0, 0);
        this.tileHead = new Tile(this.level.bWithBoss ? 101 : 100, 0, 0, this.getImageWidth(this.level.bWithBoss ? 101 : 100), this.getImageHeight(this.level.bWithBoss ? 101 : 100), 0, 0);
        this.tileChallenge = new Tile(103, 0, 0, this.getImageWidth(103), this.getImageHeight(103), 0, 0);
    }

    public void paintStatic(int n) {
        for (int i = 0; i < this.level.staticPositionsX[n].length; ++i) {
            this.drawTile(this.level.staticTiles[n][i], this.level.staticPositionsX[n][i], this.level.staticPositionsY[n][i]);
        }
    }

    public void paintAnimations(int n) {
        if (this.level.animations == null) {
            return;
        }
        for (int i = 0; i < this.level.animations.length; ++i) {
            Animation animation = this.level.animations[i];
            if (animation == null) continue;
            int n2 = 0;
            switch (animation.nState) {
                case 1: {
                    n2 = this.indexByTime(animation.tiles.length, this.nDuration - animation.nInitiatedMoment, animation.nDuration);
                    break;
                }
                case 2: {
                    n2 = animation.tiles.length - 1;
                    break;
                }
                case 0: {
                    n2 = 0;
                }
            }
            for (int j = 0; j < animation.tiles[n2].length; ++j) {
                Tile tile = animation.tiles[n2][j];
                if (tile.n3DLayer != n) continue;
                this.drawTile(tile, animation.xLeft, animation.yTop);
            }
        }
    }

    public void paintEnemies(boolean bl) {
        if (this.events == null) {
            return;
        }
        for (int i = this.events.length - 1; i >= 0; --i) {
            Event event = this.events[i];
            Enemy enemy = this.level.enemies[event.nEnemy];
            if (!event.bActive || enemy.bTopMost[i] != bl) continue;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = false;
            switch (event.nEnemyAction) {
                case 5: {
                    n = enemy.nType != 0 && (this.om.nBossesKilled == this.level.nEnemiesToKill / 2 || this.om.nBossesKilled == this.level.nEnemiesToKill) ? 3 : 2;
                    n3 = 800;
                    break;
                }
                case 3: 
                case 4: {
                    if (this.nGameState != 2) {
                        n = 1;
                    } else {
                        n = 0;
                        bl2 = true;
                    }
                    n3 = 800;
                    break;
                }
                case 2: {
                    n = 0;
                    bl2 = true;
                    break;
                }
                case 1: {
                    n = 0;
                    n3 = 500;
                }
            }
            n2 = bl2 ? enemy.tiles[n].length - 1 : this.indexByTime(enemy.tiles[n].length, this.nDuration - event.nTimeEvent, n3 * this.om.nCheatSlow);
            this.drawTile(enemy.tiles[n][n2], enemy.xLeft[i], enemy.yTop[i]);
        }
    }

    public void paintBullets() {
        for (int i = 0; i < 6; ++i) {
            this.drawTile(this.nBullets > i ? this.tileBullet1 : this.tileBullet2, 3 + (this.tileBullet1.w + 1) * i, this.getCanvasHeight() - this.tileBullet1.h);
        }
    }

    public void paintLife() {
        this.drawTile(this.tileLife, 3, 3);
        this.setColor(this.bTwinkle && (this.nDuration - this.nTwinkleStartTime) % 100 < 50 ? 0xFFFF00 : 16083562);
        this.drawLine(4, 4, 4 + 53 * this.nLifes / 9, 4);
        this.setColor(this.bTwinkle && (this.nDuration - this.nTwinkleStartTime) % 100 < 50 ? 0xFFFF00 : 0xA31313);
        this.drawLine(4, 5, 4 + 53 * this.nLifes / 9, 5);
        this.drawLine(4, 6, 4 + 53 * this.nLifes / 9, 6);
    }

    public void paintShotgun() {
        switch (this.nShootgunState) {
            case 0: {
                this.drawTile(this.tileShot1, 139, 173);
                break;
            }
            case 1: {
                this.drawTile(this.tileShot1, this.getCanvasWidth() - this.tileShot1.w, this.getCanvasHeight() - Math.abs(this.indexByTime(2 * this.tileShot1.h, this.nDuration - this.nShootgunTime, 1000) - this.tileShot1.h));
                break;
            }
            case 2: {
                this.drawTile(this.tileShot2, 139, 173);
                break;
            }
            case 3: {
                this.drawTile(this.tileShot3, 139, 173);
            }
        }
    }

    public void paintScore() {
        this.setMenuFont();
        this.setColor(0);
        this.drawString(this.itos(this.om.nScore), this.getCanvasWidth() - 2, 4, 24);
        this.setColor(this.bTwinkle && (this.nDuration - this.nTwinkleStartTime) % 100 < 50 ? 0xFFFF00 : 0xFF0000);
        this.drawString(this.itos(this.om.nScore), this.getCanvasWidth() - 3, 3, 24);
        if (this.om.bAutoCombat && this.nDuration % 2000 < 1000) {
            this.setColor(0);
            this.drawString(20, this.getCanvasWidth() / 2 + 1, this.getCanvasWidth() / 2 + 1, 17);
            this.setColor(0xFFFF00);
            this.drawString(20, this.getCanvasWidth() / 2, this.getCanvasWidth() / 2, 17);
        }
    }

    public void paintSplashScreen() {
        if (this.om.bChallenge) {
            int n = this.getFontHeight() + 2;
            this.setColor(0xFF0000);
            this.setDefaultFont();
            this.drawString(this.om.bChallenge ? 42 : this.level.name, this.getCanvasWidth() / 2, 10, 17);
            this.drawTile(this.tileChallenge, this.getCanvasWidth() / 2 - this.tileChallenge.w / 2, this.getCanvasHeight() / 2 - this.tileChallenge.h / 2);
            this.setMenuFont();
            this.drawString(this.concat(this.cs[86], this.cs[this.om.nFirstKey == 52 ? 88 : 89]), this.getCanvasWidth() / 2, this.getCanvasHeight() - 2 * this.getMenuFontHeight(), 17);
            this.drawString(this.concat(this.cs[87], this.cs[this.om.nFirstKey == 52 ? 90 : 91]), this.getCanvasWidth() / 2, this.getCanvasHeight() - this.getMenuFontHeight(), 17);
        } else {
            int n = this.getFontHeight() + 2;
            int n2 = 255;
            if (this.nDuration < 1250) {
                n2 = this.nDuration * 255 / 1250;
            }
            this.setColor(n2, 0, 0);
            this.setDefaultFont();
            this.drawString(this.level.name, this.getCanvasWidth() / 2, this.getCanvasHeight() / 2, 65);
        }
    }

    public void paintEnemiesCounter() {
        if (!this.om.bChallenge) {
            this.drawTile(this.tileHead, this.getCanvasWidth() / 2 - this.tileHead.w, 2);
            this.setMenuFont();
            this.setColor(0);
            this.drawString(this.itos(this.level.nEnemiesToKill - (this.level.bWithBoss ? this.om.nBossesKilled : this.om.nEnemiesKilled)), this.getCanvasWidth() / 2 + 1 + 1, 4, 20);
            this.setColor(0xFF0000);
            this.drawString(this.itos(this.level.nEnemiesToKill - (this.level.bWithBoss ? this.om.nBossesKilled : this.om.nEnemiesKilled)), this.getCanvasWidth() / 2 + 1, 3, 20);
        }
    }

    public void paintCombo() {
        if (this.nComboType != 0 && (this.nDuration - this.nComboTwinkStart) % 100 < 50) {
            int n;
            int n2;
            switch (this.nComboType) {
                case 2: {
                    n2 = 27;
                    n = 47;
                    break;
                }
                case 3: {
                    n2 = 28;
                    n = 48;
                    break;
                }
                default: {
                    n2 = 26;
                    n = 46;
                }
            }
            this.setDefaultFont();
            this.setColor(0);
            this.drawString(n2, this.getCanvasWidth() / 2 + 1, this.getCanvasHeight() - 1 - this.getFontHeight(), 33);
            this.setColor(0xFFFF00);
            this.drawString(n2, this.getCanvasWidth() / 2, this.getCanvasHeight() - 2 - this.getFontHeight(), 33);
            this.setColor(0);
            this.drawString(n, this.getCanvasWidth() / 2 + 1, this.getCanvasHeight() - 1, 33);
            this.setColor(0xFFFF00);
            this.drawString(n, this.getCanvasWidth() / 2, this.getCanvasHeight() - 2, 33);
        }
    }

    public void paintGameOverMessage() {
        int n = -1;
        boolean bl = false;
        if (this.nGameState == 2) {
            if (!this.level.bWithBoss) {
                n = 49;
            }
            bl = true;
        } else if (this.nGameState == 3) {
            n = 5;
            bl = true;
        } else if (this.om.bPaused) {
            n = 50;
            bl = true;
        }
        if (bl) {
            this.setMenuFont();
            this.setColor(0xFF0000);
            this.drawString(20, this.getCanvasWidth() / 2, this.getCanvasHeight() - 1, 33);
        }
        if (n != -1) {
            int n2 = this.getCanvasHeight() / 2 - 10;
            int n3 = this.getCanvasHeight() / 2 + this.getFontHeight() + 5;
            int n4 = this.getCanvasWidth() / 2 - this.getStringWidth(n) / 2 - 10;
            int n5 = this.getCanvasWidth() / 2 + this.getStringWidth(n) / 2 + 10;
            this.setColor(0xFF0000);
            this.g.setClip(n4, n2, n5 - n4, n3 - n2);
            for (int i = -this.getCanvasHeight(); i < this.getCanvasHeight(); i += 2) {
                this.drawLine(i, 0, i + this.getCanvasHeight(), this.getCanvasHeight());
            }
            this.g.setClip(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
            this.drawLine(n4, n2, n5, n2);
            this.drawLine(n5, n2, n5, n3);
            this.drawLine(n5, n3, n4, n3);
            this.drawLine(n4, n3, n4, n2);
            this.setDefaultFont();
            this.setColor(0);
            this.drawString(n, this.getCanvasWidth() / 2 + 1, this.getCanvasHeight() / 2 + 1, 17);
            this.setColor(0xFFFF00);
            this.drawString(n, this.getCanvasWidth() / 2, this.getCanvasHeight() / 2, 17);
        }
    }

    public void onPaint() {
        this.setColor(0);
        this.fillRect(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
        if ((this.nGameState == 0 && !this.om.bAutoCombat || this.om.bAutoCombat && this.nDuration < 1000) && !this.om.bChallenge) {
            this.paintSplashScreen();
        } else {
            this.paintStatic(0);
            this.paintAnimations(0);
            this.paintAnimations(1);
            this.paintEnemies(false);
            this.paintStatic(1);
            this.paintAnimations(2);
            this.paintEnemies(true);
            this.paintScore();
            this.paintLife();
            this.paintBullets();
            this.paintShotgun();
            this.paintCombo();
            this.paintEnemiesCounter();
            this.paintGameOverMessage();
        }
    }

    public void updateGameStatus() {
        if (this.nComboType == 1 && this.nDuration - this.nComboTwinkStart >= 2000) {
            this.nComboType = 0;
        }
        if (this.nComboType == 2 && this.nDuration - this.nComboTwinkStart >= 3000) {
            this.nComboType = 0;
        }
        if (this.nComboType == 3 && this.nDuration - this.nComboTwinkStart >= 5000) {
            this.nComboType = 0;
        }
        if (this.nGameState == 0 && this.nDuration >= 5000 || this.om.bAutoCombat || this.om.bChallenge) {
            this.nGameState = 1;
            this.bWaitKeyAfterPause = true;
        }
        if (this.bTwinkle && this.nDuration - this.nTwinkleStartTime >= 2000) {
            this.bTwinkle = false;
        }
        if (this.nLifes <= 0) {
            this.om.bGameOver = true;
            this.playSound(1);
            this.nGameState = 3;
            if (this.om.bAutoCombat) {
                this.stop();
                this.om.setNextScreen(this);
            }
        }
        if (!this.om.bChallenge && this.level.isLevelPassed(this.level.bWithBoss ? this.om.nBossesKilled : this.om.nEnemiesKilled)) {
            this.playSound(4);
            this.nGameState = 2;
        }
    }

    public void updateObjectsStatus() {
        Object object;
        int n;
        switch (this.nShootgunState) {
            case 1: {
                if (this.nDuration - this.nShootgunTime <= 1000) break;
                this.nShootgunState = 0;
                break;
            }
            case 2: {
                if (this.nDuration - this.nShootgunTime < 300) break;
                this.nShootgunState = 3;
                break;
            }
            case 3: {
                if (this.nDuration - this.nShootgunTime < 600) break;
                this.nShootgunState = 0;
            }
        }
        if (this.level.animations != null) {
            for (n = this.level.animations.length - 1; n >= 0; --n) {
                object = this.level.animations[n];
                if (object == null || ((Animation)object).nState != 1 || this.nDuration - ((Animation)object).nInitiatedMoment < ((Animation)object).nDuration) continue;
                ((Animation)object).nState = 2;
            }
        }
        if (this.events != null) {
            block13: for (n = this.events.length - 1; n >= 0; --n) {
                object = this.events[n];
                if (!((Event)object).bActive) continue;
                switch (((Event)object).nEnemyAction) {
                    case 1: {
                        if (this.nDuration - ((Event)object).nTimeEvent <= 500 * this.om.nCheatSlow) continue block13;
                        ((Event)object).nEnemyAction = 2;
                        ((Event)object).nTimeEvent = this.nDuration;
                        continue block13;
                    }
                    case 2: {
                        if (this.nDuration - ((Event)object).nTimeEvent <= this.getEnemyWaitDuration() * this.om.nCheatSlow) continue block13;
                        ((Event)object).nEnemyAction = 3;
                        ((Event)object).nTimeEvent = this.nDuration;
                        continue block13;
                    }
                    case 3: {
                        if (this.nDuration - ((Event)object).nTimeEvent <= 800 * this.om.nCheatSlow / 2) continue block13;
                        ((Event)object).nEnemyAction = 4;
                        if (this.nGameState != 1 || this.level.enemies[((Event)object).nEnemy].nType != 1 || this.om.bCheatUndead) continue block13;
                        this.nLifes = this.nLifes < this.level.enemies[((Event)object).nEnemy].nHitPoints ? 0 : this.nLifes - this.level.enemies[((Event)object).nEnemy].nHitPoints;
                        this.nComboHits = 0;
                        Display.getDisplay((MIDlet)this.om).vibrate(100);
                        continue block13;
                    }
                    case 4: {
                        if (this.nDuration - ((Event)object).nTimeEvent <= 800 * this.om.nCheatSlow) continue block13;
                        ((Event)object).nEnemyAction = 3;
                        ((Event)object).nTimeEvent = this.nDuration;
                        if (this.nGameState != 1 || this.om.bCheatUndead) continue block13;
                        this.nLifes = this.nLifes < this.level.enemies[((Event)object).nEnemy].nHitPoints ? 0 : this.nLifes - this.level.enemies[((Event)object).nEnemy].nHitPoints;
                        this.nComboHits = 0;
                        Display.getDisplay((MIDlet)this.om).vibrate(100);
                        continue block13;
                    }
                    case 5: {
                        if (this.nDuration - ((Event)object).nTimeEvent <= 800 * this.om.nCheatSlow) continue block13;
                        this.events[n].bActive = false;
                    }
                }
            }
        }
    }

    public void entryEvent() {
        int n;
        int n2;
        int n3 = 0;
        if (this.nDuration < this.nNextEvent) {
            return;
        }
        if (this.nGameState != 1) {
            return;
        }
        if (this.events != null) {
            for (n2 = this.events.length - 1; n2 >= 0; --n2) {
                if (this.events[n2].bActive) {
                    ++n3;
                }
                if (n3 < this.getMaxEnemies()) continue;
                return;
            }
        }
        n2 = OMScreenGame.random(6);
        int n4 = n = this.level.enemies == null ? 0 : OMScreenGame.random(this.level.enemies.length);
        if (this.level.enemies[n].nType != 0) {
            n2 = 4;
        }
        if (this.events != null && this.level.enemies != null && !this.events[n2].bActive && this.level.enemies[n].bAllowedWindows[n2] && (this.level.animations == null || this.level.animations[n2] == null || this.level.animations[n2].nState != 1)) {
            boolean bl = true;
            if (this.nBossesCanAppear <= 0) {
                bl = false;
            }
            if (this.level.enemies[n].nType == 1 && this.om.nBossesKilled >= this.level.nEnemiesToKill / 2) {
                bl = false;
            }
            if (this.level.enemies[n].nType == 2 && this.om.nBossesKilled < this.level.nEnemiesToKill / 2) {
                bl = false;
            }
            if (this.nBossesCanAppear > 0 && bl && this.level.enemies[n].nType != 0 || this.nBossesCanAppear <= 0 && this.level.enemies[n].nType == 0) {
                if (this.level.enemies[n].nType != 0) {
                    --this.nBossesCanAppear;
                }
                this.events[n2].nEnemy = n;
                this.events[n2].nTimeEvent = this.nDuration;
                this.events[n2].nEnemyAction = 1;
                this.events[n2].bActive = true;
                ++this.nEnemiesInWave;
                int n5 = this.getEnemyFrequency() - (this.nDuration - this.nLastEvent);
                this.nNextEvent = this.nLastEvent + (n5 > 0 ? OMScreenGame.random(n5) : 0);
                this.nLastEvent += this.getEnemyFrequency();
                if (this.nEnemiesInWave == 6 || this.nEnemiesInWave > 1 && OMScreenGame.random(100) > 70) {
                    this.nEnemiesInWave = 0;
                    this.nNextEvent += 5000;
                }
            }
        }
    }

    public void onTick() {
        if (!this.om.bPaused) {
            this.entryEvent();
            this.updateObjectsStatus();
            this.updateGameStatus();
            this.generateTestEvents();
        }
    }

    void entryTwikle() {
        for (int i = 0; i < this.nEnemyThresholds.length; ++i) {
            if (this.om.nEnemiesKilled != this.nEnemyThresholds[i]) continue;
            this.nTwinkleStartTime = this.nDuration;
            this.bTwinkle = true;
            this.nLifes = this.nLifes + 3 > 9 ? 9 : this.nLifes + 3;
        }
    }

    public int getEnemyWaitDuration() {
        for (int i = this.nEnemyThresholds.length - 1; i >= 0; --i) {
            if (this.om.nEnemiesKilled < this.nEnemyThresholds[i]) continue;
            return 1500 - (i + 1) * 100;
        }
        return 1500;
    }

    public int getEnemyFrequency() {
        for (int i = this.nEnemyThresholds.length - 1; i >= 0; --i) {
            if (this.om.nEnemiesKilled < this.nEnemyThresholds[i]) continue;
            return this.level.nNominalEnemyFrequency / ((i + 1) * 2);
        }
        return this.level.nNominalEnemyFrequency;
    }

    public int getMaxEnemies() {
        for (int i = this.nEnemyThresholds.length - 1; i >= 0; --i) {
            if (this.om.nEnemiesKilled < this.nEnemyThresholds[i]) continue;
            return i + 2 > 4 ? 4 : i + 2;
        }
        return 1;
    }

    public void generateTestEvents() {
        if (this.om.bAutoCombat) {
            int n;
            if (this.nDuration <= 1000 || this.nTestTime > 0 && this.nDuration - this.nTestTime < this.nNextTestPause) {
                return;
            }
            this.nNextTestPause = 200 + OMScreenGame.random(300);
            this.nTestTime = this.nDuration;
            if (this.nBullets == 0) {
                this.processKey(this.om.nReloadKey);
                return;
            }
            if (this.events != null) {
                n = -1;
                int n2 = 0;
                for (int i = 0; i < this.events.length; ++i) {
                    if (!this.events[i].bActive || this.events[i].nEnemyAction != 2 && this.events[i].nEnemyAction != 3 && this.events[i].nEnemyAction != 4) continue;
                    int n3 = this.nDuration - this.events[i].nTimeEvent;
                    if (this.events[i].nEnemyAction == 3 || this.events[i].nEnemyAction == 4) {
                        n3 += 500;
                    }
                    if (n != -1 && n3 <= n2) continue;
                    n = i;
                    n2 = n3;
                }
                if (n != -1) {
                    this.processKey(this.om.nFirstKey + n);
                    return;
                }
            }
            if (this.level.animations != null) {
                for (n = 0; n < this.level.animations.length; ++n) {
                    if (this.level.animations[n] == null || this.level.animations[n].nState != 0 || this.events[n].bActive || OMScreenGame.random(15) <= 13) continue;
                    this.processKey(this.om.nFirstKey + n);
                    return;
                }
            }
        }
    }

    public void testCheats(int n) {
        int n2 = this.cKeysBuffer.length;
        for (int i = 1; i < n2; ++i) {
            this.cKeysBuffer[i - 1] = this.cKeysBuffer[i];
        }
        this.cKeysBuffer[n2 - 1] = (char)n;
        if (this.cKeysBuffer[n2 - 1] == '3' && this.cKeysBuffer[n2 - 2] == '2' && this.cKeysBuffer[n2 - 3] == '3' && this.cKeysBuffer[n2 - 4] == '3' && this.cKeysBuffer[n2 - 5] == '6' && this.cKeysBuffer[n2 - 6] == '8') {
            boolean bl = this.om.bCheatUndead = !this.om.bCheatUndead;
        }
        if (this.cKeysBuffer[n2 - 1] == '6' && this.cKeysBuffer[n2 - 2] == '4' && this.cKeysBuffer[n2 - 3] == '5' && this.cKeysBuffer[n2 - 4] == '6' && this.cKeysBuffer[n2 - 5] == '6') {
            boolean bl = this.om.bCheatNoReloads = !this.om.bCheatNoReloads;
        }
        if (this.cKeysBuffer[n2 - 1] == '3' && this.cKeysBuffer[n2 - 2] == '6' && this.cKeysBuffer[n2 - 3] == '6' && this.cKeysBuffer[n2 - 4] == '3' && this.cKeysBuffer[n2 - 5] == '4' && this.cKeysBuffer[n2 - 6] == '8') {
            this.om.nEnemiesKilled = this.om.nBossesKilled = this.level.nEnemiesToKill - 1;
        }
        if (this.cKeysBuffer[n2 - 1] == '9' && this.cKeysBuffer[n2 - 2] == '6' && this.cKeysBuffer[n2 - 3] == '5' && this.cKeysBuffer[n2 - 4] == '7') {
            this.om.nCheatSlow = this.om.nCheatSlow == 1 ? 10 : 1;
        }
    }

    public void onKeyPressed(int n) {
        if (this.om.bAutoCombat && this.nDuration >= 1000) {
            this.om.bGameOver = true;
            this.stop();
            this.om.setNextScreen(this);
            return;
        }
        if (this.nGameState == 2 || this.nGameState == 3) {
            this.om.playReloadSound();
            this.stop();
            this.om.setNextScreen(this);
            return;
        }
        this.processKey(n);
    }

    public void processKey(int n) {
        if (this.nGameState == 0) {
            return;
        }
        if (this.nShootgunState == 1) {
            return;
        }
        if (n == this.om.nReloadKey && this.nBullets < 6 || n >= this.om.nFirstKey && n <= this.om.nLastKey && this.nBullets == 0) {
            if (n != this.om.nReloadKey || this.nComboHits != 6) {
                if (n != this.om.nReloadKey) {
                    System.out.println("nKeyCode!=om.nReloadKey");
                }
                if (this.nComboHits != 6) {
                    System.out.println("nComboHits!=nMaxBullets");
                }
                this.nComboCnt = 0;
            }
            this.nComboHits = 0;
            this.nBullets = 6;
            this.nShootgunTime = this.nDuration;
            this.nShootgunState = 1;
            this.playSound(2);
            return;
        }
        if (n >= this.om.nFirstKey && n <= this.om.nLastKey) {
            Animation animation;
            Event event = this.events == null ? null : this.events[n - this.om.nFirstKey];
            Animation animation2 = animation = this.level.animations == null ? null : this.level.animations[n - this.om.nFirstKey];
            if (!this.om.bCheatNoReloads) {
                --this.nBullets;
            }
            this.nShootgunTime = this.nDuration;
            this.nShootgunState = 2;
            this.playSound(3);
            if (event.bActive && event.nEnemyAction == 5) {
                return;
            }
            if (event.bActive && event.nEnemyAction == 1 && this.nDuration - event.nTimeEvent < 250) {
                return;
            }
            if (animation != null && animation.nState == 1) {
                return;
            }
            if (event.bActive) {
                ++this.nComboHits;
                if (this.nComboHits == 6) {
                    ++this.nComboCnt;
                    switch (this.nComboCnt) {
                        case 6: {
                            this.nComboType = 3;
                            if (this.level.bWithBoss && !this.om.bChallenge) {
                                ++this.nBossesCanAppear;
                            }
                            this.om.nScore += 1000;
                            this.nComboCnt = 0;
                            break;
                        }
                        case 3: {
                            this.nComboType = 2;
                            if (this.level.bWithBoss && !this.om.bChallenge) {
                                ++this.nBossesCanAppear;
                            }
                            this.om.nScore += 400;
                            break;
                        }
                        default: {
                            this.nComboType = 1;
                            this.om.nScore += 100;
                        }
                    }
                    this.nComboTwinkStart = this.nDuration;
                }
                event.nTimeEvent = this.nDuration;
                event.nEnemyAction = 5;
                this.om.nScore += this.level.enemies[event.nEnemy].nGivenScore;
                ++this.om.nEnemiesKilled;
                this.om.nBossesKilled = this.om.nBossesKilled + (this.level.enemies[event.nEnemy].nType == 0 ? 0 : 1);
                this.entryTwikle();
            } else if (animation != null && animation.nState == 0) {
                this.playSound(5);
                animation.nState = 1;
                animation.nInitiatedMoment = this.nDuration;
                this.om.nScore = this.om.nScore + 100 + this.om.nObjectsDestroed * 20;
                ++this.om.nObjectsDestroed;
            }
        }
    }

    public void onStart() {
        this.om.nScore = 0;
        this.om.nObjectsDestroed = 0;
        this.om.nEnemiesKilled = 0;
        this.om.nBossesKilled = 0;
        if (this.om.bChallenge) {
            this.nLastEvent = this.getEnemyFrequency();
            this.nNextEvent = this.getEnemyFrequency();
        } else {
            this.nLastEvent = 5000 + this.getEnemyFrequency();
            this.nNextEvent = 5000 + this.getEnemyFrequency();
        }
        this.level.init();
    }

    static int random(int n) {
        return (random.nextInt() & Integer.MAX_VALUE) % n;
    }

    public int indexByTime(int n, int n2, int n3) {
        return n2 < n3 ? n2 * n / n3 : n - 1;
    }
}

