/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameScreen
extends Canvas {
    Random rand = new Random();
    public MenuScreen menuScreen;
    public int gamelevel = 1;
    public int reallevel = 1;
    public Timer frameUpdateTimer;
    public int frameRate = 20;
    public FrameUpdateTask frameUpdateTask;
    public boolean isrunning = false;
    public boolean gameOver = false;
    public int gameSpeed;
    public int points;
    public int lives;
    public HiScoreTask hiscoreTask;
    public Image ground;
    public boolean leftpressed;
    public boolean rightpressed;
    public boolean uppressed;
    public boolean firepressed;
    public int drawWidth;
    public int drawHeight;
    public final int PLATFORM1_WIDTH;
    public final int PLATFORM2_WIDTH;
    public final int PLATFORM_HEIGHT;
    public Fires fires;
    public Enemies enemies;
    public Platforms platforms;
    public Player player;
    public Bonuses bonuses;
    public RocketFuel rocket;
    public int GROUNDLEVEL;
    public int[] BONUSPOINTS = new int[]{300, 275, 250, 225};
    public int GS_ASSEMBLE = 0;
    public int GS_READY = 1;
    public int GS_LIFTOFF = 2;
    public int GS_LEVELCLEAR = 3;
    public int gamestate;
    private EThread EngineThread;

    public int customRand(int maxval) {
        return (Math.abs(this.rand.nextInt()) & 0xFFFF) * maxval / 65536;
    }

    public GameScreen(MenuScreen ms) {
        this.PLATFORM1_WIDTH = 18;
        this.PLATFORM2_WIDTH = 27;
        this.PLATFORM_HEIGHT = 4;
        this.menuScreen = ms;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startFrameUpdate() {
        if (this.frameUpdateTimer == null) {
            this.frameUpdateTimer = new Timer();
        }
        if (this.frameUpdateTask != null) {
            this.frameUpdateTask.cancel();
        }
        if (this.EngineThread == null) {
            EThread EngineThread = new EThread();
            EngineThread.start();
        }
        this.frameUpdateTask = new FrameUpdateTask();
        this.frameUpdateTimer.schedule((TimerTask)this.frameUpdateTask, 0L, (long)(1000 / this.frameRate));
    }

    private void stopFrameUpdate() {
        this.frameUpdateTask.cancel();
    }

    private void jbInit() throws Exception {
        this.ground = GameMidlet.getImage("ground");
        this.drawWidth = this.getWidth();
        this.drawHeight = this.getHeight();
        this.GROUNDLEVEL = this.drawHeight - 5;
        this.player = new Player(this, this.drawWidth, this.GROUNDLEVEL - 8);
        this.fires = new Fires(this.drawWidth, this.drawHeight);
        this.enemies = new Enemies(this.drawWidth, this.GROUNDLEVEL);
        this.platforms = new Platforms(this.drawWidth, this.drawHeight);
        this.bonuses = new Bonuses(this.drawWidth, this.GROUNDLEVEL);
        this.rocket = new RocketFuel(this.platforms.platforms[2].x - 15, this.platforms.platforms[2].x + 10, this.platforms.platforms[0].x + 5, this.GROUNDLEVEL, this.drawWidth);
        this.NewGame();
    }

    public void NewGame() {
        this.gamestate = this.GS_ASSEMBLE;
        this.platforms.Init();
        this.player.Init();
        this.fires.Init();
        this.enemies.Init();
        this.bonuses.Init();
        this.rocket.Init(this.platforms.platforms[2].x - 15, this.platforms.platforms[2].x + 10, this.platforms.platforms[0].x + 5, this.GROUNDLEVEL);
        this.gamelevel = 1;
        this.reallevel = 1;
        this.lives = 5;
        this.points = 0;
        this.gameOver = false;
    }

    public void NewLevel() {
        ++this.gamelevel;
        ++this.reallevel;
        if (this.gamelevel > 7) {
            this.gamelevel = 1;
        }
        this.player.Init();
        this.fires.Init();
        this.enemies.Init();
        this.bonuses.Init();
        this.rocket.Init(this.platforms.platforms[2].x - 15, this.platforms.platforms[2].x + 10, this.platforms.platforms[0].x + 5, this.GROUNDLEVEL);
        this.rocket.AssembleRocket();
        this.gamestate = this.GS_ASSEMBLE;
    }

    public void NextLife() {
        this.rocket.PlayerDied();
        this.player.Init();
        this.fires.Init();
        this.enemies.Init();
        --this.lives;
        if (this.lives < 1) {
            this.GameOver();
        }
    }

    public void GameOver() {
        this.gameOver = true;
    }

    public void showNotify() {
        this.startFrameUpdate();
    }

    public void hideNotify() {
        this.stopFrameUpdate();
    }

    public void keyPressed(int keyCode) {
        if (this.gamestate == this.GS_LEVELCLEAR) {
            this.NewLevel();
            return;
        }
        if (keyCode == 49) {
            this.leftpressed = true;
            this.uppressed = true;
            this.rightpressed = false;
            return;
        }
        if (keyCode == 51) {
            this.leftpressed = false;
            this.uppressed = true;
            this.rightpressed = true;
            return;
        }
        if (keyCode == 56 || keyCode == 57) {
            return;
        }
        if (keyCode == 55) {
            return;
        }
        int gameAction = this.getGameAction(keyCode);
        switch (gameAction) {
            case 2: {
                this.leftpressed = true;
                this.rightpressed = false;
                return;
            }
            case 5: {
                this.leftpressed = false;
                this.rightpressed = true;
                return;
            }
            case 1: {
                this.uppressed = true;
                return;
            }
            case 8: {
                this.firepressed = true;
                return;
            }
        }
        if (!this.gameOver) {
            this.saveGame();
        }
        this.isrunning = false;
        this.menuScreen.showMenu();
    }

    public void keyReleased(int keyCode) {
        if (keyCode == 49) {
            this.leftpressed = false;
            this.uppressed = false;
            return;
        }
        if (keyCode == 51) {
            this.uppressed = false;
            this.rightpressed = false;
            return;
        }
        int gameAction = this.getGameAction(keyCode);
        switch (gameAction) {
            case 2: {
                this.leftpressed = false;
                return;
            }
            case 5: {
                this.rightpressed = false;
                return;
            }
            case 1: {
                this.uppressed = false;
                return;
            }
            case 8: {
                this.firepressed = false;
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.drawWidth, this.drawHeight);
        g.drawImage(this.ground, 0, this.GROUNDLEVEL, 20);
        if (this.gamestate == this.GS_LEVELCLEAR) {
            g.setColor(255, 255, 255);
            g.drawString(this.menuScreen.str[22], this.drawWidth / 2, this.drawHeight / 2, 65);
        } else {
            this.platforms.Paint(g);
            this.rocket.Paint(g);
            this.bonuses.Paint(g);
            this.enemies.Paint(g);
            if (this.gamestate != this.GS_LIFTOFF) {
                this.player.Paint(g);
                this.fires.Paint(g);
            }
            g.setColor(255, 255, 255);
            g.drawString(Integer.toString(this.points), 0, 0, 20);
            g.setColor(255, 255, 255);
            g.drawString(Integer.toString(this.lives), this.drawWidth, 0, 24);
        }
        if (this.gameOver) {
            g.setColor(255, 255, 255);
            g.drawString(this.menuScreen.str[18], this.drawWidth / 2, this.drawHeight / 2, 65);
            this.stopFrameUpdate();
            return;
        }
    }

    private void saveGame() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            GameMidlet.saveGameData = bout.toByteArray();
            SingleItemDB.save("GameData", GameMidlet.saveGameData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanUp() {
        if (this.frameUpdateTimer != null) {
            this.frameUpdateTimer.cancel();
        }
    }

    private class HiScoreTask
    extends TimerTask {
        private HiScoreTask() {
        }

        public void run() {
            if (GameScreen.this.menuScreen.hs.isHighScore(GameScreen.this.points)) {
                GameMidlet.instance.setDisplayable((Displayable)GameScreen.this.menuScreen.nameForm);
            }
        }
    }

    class EThread
    extends Thread {
        private Random random = new Random();

        EThread() {
            if (GameMidlet.gameRunning && (GameMidlet.saveGameData = SingleItemDB.load("GameData")) != null) {
                try {
                    ByteArrayInputStream bin = new ByteArrayInputStream(GameMidlet.saveGameData);
                    DataInputStream din = new DataInputStream(bin);
                    GameScreen.this.lives = din.readByte();
                    GameScreen.this.points = din.readInt();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            GameScreen.this.gameSpeed = 100;
            GameMidlet.gameRunning = true;
            SingleItemDB.delete("GameData");
        }

        public void run() {
            GameScreen.this.isrunning = true;
            while (GameScreen.this.isrunning && !GameScreen.this.gameOver) {
                try {
                    if (GameScreen.this.gamestate != GameScreen.this.GS_LEVELCLEAR) {
                        if (GameScreen.this.leftpressed) {
                            GameScreen.this.player.Left();
                        } else if (GameScreen.this.rightpressed) {
                            GameScreen.this.player.Right();
                        } else {
                            GameScreen.this.player.NotLeftRight();
                        }
                        if (GameScreen.this.uppressed) {
                            GameScreen.this.player.Up();
                        } else {
                            GameScreen.this.player.NotUp();
                        }
                        if (GameScreen.this.firepressed) {
                            GameScreen.this.fires.fireShot(GameScreen.this.player.x, GameScreen.this.player.y, GameScreen.this.player.dir);
                        }
                        GameScreen.this.player.Move();
                        GameScreen.this.bonuses.Move();
                        GameScreen.this.rocket.Move(GameScreen.this.player);
                        GameScreen.this.rocket.CrashTest(GameScreen.this.platforms);
                        GameScreen.this.rocket.PickupTest(GameScreen.this.player);
                        GameScreen.this.enemies.Next();
                        if (GameScreen.this.reallevel > 4 || GameScreen.this.menuScreen.difficulty.getSelectedIndex() > 2) {
                            GameScreen.this.enemies.CrashAvoid(GameScreen.this.platforms.platforms[0].x, GameScreen.this.platforms.platforms[0].y - 1, GameScreen.this.platforms.platforms[0].x2, GameScreen.this.platforms.platforms[0].y2 - 1);
                            GameScreen.this.enemies.CrashAvoid(GameScreen.this.platforms.platforms[1].x, GameScreen.this.platforms.platforms[1].y - 1, GameScreen.this.platforms.platforms[1].x2, GameScreen.this.platforms.platforms[1].y2 - 1);
                            GameScreen.this.enemies.CrashAvoid(GameScreen.this.platforms.platforms[2].x, GameScreen.this.platforms.platforms[2].y - 1, GameScreen.this.platforms.platforms[2].x2, GameScreen.this.platforms.platforms[2].y2 - 1);
                        } else {
                            GameScreen.this.enemies.CrashTest(GameScreen.this.platforms.platforms[0].x, GameScreen.this.platforms.platforms[0].y - 1, GameScreen.this.platforms.platforms[0].x2, GameScreen.this.platforms.platforms[0].y2 - 1);
                            GameScreen.this.enemies.CrashTest(GameScreen.this.platforms.platforms[1].x, GameScreen.this.platforms.platforms[1].y - 1, GameScreen.this.platforms.platforms[1].x2, GameScreen.this.platforms.platforms[1].y2 - 1);
                            GameScreen.this.enemies.CrashTest(GameScreen.this.platforms.platforms[2].x, GameScreen.this.platforms.platforms[2].y - 1, GameScreen.this.platforms.platforms[2].x2, GameScreen.this.platforms.platforms[2].y2 - 1);
                        }
                        if (GameScreen.this.enemies.CrashTest(GameScreen.this.player.x - 4, GameScreen.this.player.y - 7, GameScreen.this.player.x + 4, GameScreen.this.player.y + 7)) {
                            System.out.println("Player Hit!");
                            GameScreen.this.player.flyState = 4;
                        }
                        GameScreen.this.player.CrashTest(GameScreen.this.platforms.platforms[0].x, GameScreen.this.platforms.platforms[0].y, GameScreen.this.platforms.platforms[0].x2, GameScreen.this.platforms.platforms[0].y2);
                        GameScreen.this.player.CrashTest(GameScreen.this.platforms.platforms[1].x, GameScreen.this.platforms.platforms[1].y, GameScreen.this.platforms.platforms[1].x2, GameScreen.this.platforms.platforms[1].y2);
                        GameScreen.this.player.CrashTest(GameScreen.this.platforms.platforms[2].x, GameScreen.this.platforms.platforms[2].y, GameScreen.this.platforms.platforms[2].x2, GameScreen.this.platforms.platforms[2].y2);
                        GameScreen.this.fires.Move();
                        GameScreen.this.fires.HitTest(GameScreen.this.enemies);
                        GameScreen.this.fires.HitTest(GameScreen.this.platforms);
                        GameScreen.this.bonuses.CrashTest(GameScreen.this.platforms);
                        GameScreen.this.bonuses.PickupTest(GameScreen.this.player);
                        if (GameScreen.this.gamestate == GameScreen.this.GS_READY && GameScreen.this.player.CrashTest(GameScreen.this.rocket.pieces[0].x + 2, GameScreen.this.rocket.pieces[0].y - 30, GameScreen.this.rocket.pieces[0].x + 10, GameScreen.this.rocket.pieces[0].y)) {
                            GameScreen.this.gamestate = GameScreen.this.GS_LEVELCLEAR;
                            GameScreen.this.points += 5000;
                        }
                        if (GameScreen.this.player.flyState == 4) {
                            Thread.sleep(200L);
                            GameScreen.this.NextLife();
                            Thread.sleep(500L);
                        }
                    }
                    Thread.sleep(GameScreen.this.gameSpeed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (GameScreen.this.gameOver) {
                GameMidlet.gameRunning = false;
                SingleItemDB.delete("GameData");
                GameScreen.this.hiscoreTask = new HiScoreTask();
                GameScreen.this.frameUpdateTimer.schedule((TimerTask)GameScreen.this.hiscoreTask, 2000L);
            }
        }
    }

    private class FrameUpdateTask
    extends TimerTask {
        private FrameUpdateTask() {
        }

        public void run() {
            GameScreen.this.repaint();
        }
    }

    private class Enemies {
        private Enemy[] enemies;
        public int enemCount;
        int screenWidth;
        int screenHeight;
        Image[][] EnemyImg = new Image[8][2];
        Image[] EnemyCrash = new Image[8];
        public int FLYFLOOR;

        public Enemies(int drawWidth, int GROUNDLEVEL) {
            this.EnemyImg[1][0] = GameMidlet.getImage("enemy1");
            this.EnemyImg[2][0] = GameMidlet.getImage("enemy2a");
            this.EnemyImg[2][1] = GameMidlet.getImage("enemy2b");
            this.EnemyImg[3][0] = GameMidlet.getImage("enemy4a");
            this.EnemyImg[3][1] = GameMidlet.getImage("enemy4b");
            this.EnemyImg[4][0] = GameMidlet.getImage("enemy3");
            this.EnemyImg[5][0] = GameMidlet.getImage("enemy2a");
            this.EnemyImg[5][1] = GameMidlet.getImage("enemy2b");
            this.EnemyImg[6][0] = GameMidlet.getImage("enemy4a");
            this.EnemyImg[6][1] = GameMidlet.getImage("enemy4b");
            this.EnemyImg[7][0] = GameMidlet.getImage("enemy3");
            this.EnemyCrash[1] = GameMidlet.getImage("enemycrash1");
            this.EnemyCrash[2] = GameMidlet.getImage("enemycrash2");
            this.EnemyCrash[3] = GameMidlet.getImage("enemycrash4");
            this.EnemyCrash[4] = GameMidlet.getImage("enemycrash3");
            this.EnemyCrash[5] = GameMidlet.getImage("enemycrash2");
            this.EnemyCrash[6] = GameMidlet.getImage("enemycrash4");
            this.EnemyCrash[7] = GameMidlet.getImage("enemycrash3");
            this.enemies = new Enemy[20];
            this.screenWidth = drawWidth + 10;
            this.screenHeight = GROUNDLEVEL - 30;
            this.FLYFLOOR = (GROUNDLEVEL - 10) * 10;
            this.Init();
        }

        public void Init() {
            this.enemCount = 0;
            for (int n = 0; n < this.enemies.length; ++n) {
                this.enemies[n] = null;
            }
        }

        public void Next() {
            int n;
            if (this.enemCount < 3 + GameScreen.this.reallevel + GameScreen.this.menuScreen.difficulty.getSelectedIndex() && GameScreen.this.customRand(100) < 10 - this.enemCount) {
                for (n = 0; n < this.enemies.length; ++n) {
                    if (this.enemies[n] != null) continue;
                    this.enemies[n] = GameScreen.this.menuScreen.balls.getSelectedIndex() == 0 ? new Enemy(this.screenWidth, this.screenHeight, GameScreen.this.gamelevel) : new Enemy(this.screenWidth, this.screenHeight, GameScreen.this.customRand(GameScreen.this.gamelevel) + 1);
                    ++this.enemCount;
                    break;
                }
            }
            for (n = 0; n < this.enemies.length; ++n) {
                if (this.enemies[n] == null || this.enemies[n].Move()) continue;
                this.enemies[n] = null;
                --this.enemCount;
            }
        }

        public boolean CrashTest(int x1, int y1, int x2, int y2) {
            boolean crashdetected = false;
            y1 *= 10;
            y2 *= 10;
            for (int n = 0; n < this.enemies.length; ++n) {
                if (this.enemies[n] == null || !this.enemies[n].CrashTest(x1, y1, x2, y2)) continue;
                crashdetected = true;
            }
            return crashdetected;
        }

        public boolean CrashAvoid(int x1, int y1, int x2, int y2) {
            boolean crashdetected = false;
            y1 *= 10;
            y2 *= 10;
            for (int n = 0; n < this.enemies.length; ++n) {
                if (this.enemies[n] == null || !this.enemies[n].CrashAvoid(x1, y1, x2, y2)) continue;
                crashdetected = true;
            }
            return crashdetected;
        }

        public void Paint(Graphics g) {
            for (int n = 0; n < this.enemies.length; ++n) {
                if (this.enemies[n] == null) continue;
                this.enemies[n].Paint(g);
            }
        }

        private class Enemy {
            int posX;
            int posY;
            int sizeX;
            int sizeY;
            final int NORMAL;
            final int CRASHED;
            int state = 0;
            int dispimg = 0;
            int enemtype;

            public Enemy(int drawWidth, int drawHeight, int type) {
                this.NORMAL = 0;
                this.CRASHED = 1;
                this.posX = Enemies.this.screenWidth + 10;
                this.posY = 10 * (5 + GameScreen.this.customRand(Enemies.this.screenHeight));
                this.sizeX = 4;
                this.sizeY = 30;
                this.enemtype = type;
            }

            public boolean CrashTest(int x1, int y1, int x2, int y2) {
                if (this.posX > x1 - this.sizeX && this.posX < x2 + this.sizeX && this.posY > y1 - this.sizeY && this.posY < y2 + this.sizeY) {
                    this.state = 1;
                    return true;
                }
                return false;
            }

            public boolean CrashAvoid(int x1, int y1, int x2, int y2) {
                if (x1 < this.posX + this.sizeX && x2 > this.posX - this.sizeX && y1 < this.posY + this.sizeY && y2 > this.posY - this.sizeY) {
                    if (this.posX < x1) {
                        this.posX = x1 - this.sizeX;
                    } else if (this.posX > x2) {
                        this.posX = x2 + this.sizeX;
                    } else {
                        this.posY = this.posY > y2 ? y2 + this.sizeY : y1 - this.sizeY;
                    }
                }
                return false;
            }

            public boolean Move() {
                if (this.state == 0) {
                    if (this.enemtype == 1) {
                        this.posX -= 4;
                    } else if (this.enemtype == 2) {
                        this.posX += 4;
                    } else if (this.enemtype == 3) {
                        this.posX += 4;
                        this.posY += GameScreen.this.customRand(5) * 4 - 8;
                    } else if (this.enemtype == 4) {
                        this.posX -= 4;
                        this.posY += GameScreen.this.customRand(5) * 16 - 32;
                    } else if (this.enemtype == 5) {
                        this.posX += 4;
                        this.posY += GameScreen.this.customRand(5) * 4 - 8;
                    } else if (this.enemtype == 6) {
                        this.posX -= 4;
                        this.posY += GameScreen.this.customRand(5) * 4 - 8;
                    } else if (this.enemtype == 7) {
                        this.posX -= 4;
                        this.posY += GameScreen.this.customRand(5) * 16 - 32;
                    }
                    if (this.posY < 0) {
                        this.posY = 0;
                    }
                    if (this.posY > Enemies.this.FLYFLOOR) {
                        this.posY = Enemies.this.FLYFLOOR;
                    }
                    if (this.posX < 0) {
                        this.posX = Enemies.this.screenWidth + this.posX;
                    }
                    if (this.posX > Enemies.this.screenWidth) {
                        this.posX -= Enemies.this.screenWidth;
                    }
                    return true;
                }
                return false;
            }

            public void Paint(Graphics g) {
                if (this.state == 0) {
                    if (this.enemtype == 2 || this.enemtype == 3 || this.enemtype == 5 || this.enemtype == 6) {
                        this.dispimg = 1 - this.dispimg;
                        g.drawImage(Enemies.this.EnemyImg[this.enemtype][this.dispimg], this.posX, this.posY / 10, 3);
                    } else {
                        g.drawImage(Enemies.this.EnemyImg[this.enemtype][0], this.posX, this.posY / 10, 3);
                    }
                } else {
                    g.drawImage(Enemies.this.EnemyCrash[this.enemtype], this.posX, this.posY / 10, 3);
                }
            }
        }
    }

    public class Fires {
        public Fire[] fires = new Fire[4];
        int screenWidth;
        int screenHeight;

        public Fires(int drawWidth, int drawHeight) {
            this.screenWidth = drawWidth;
            this.screenHeight = drawHeight;
            this.Init();
        }

        public void Init() {
            for (int n = 0; n < this.fires.length; ++n) {
                this.fires[n] = null;
            }
        }

        public void Move() {
            for (int n = 0; n < this.fires.length; ++n) {
                if (this.fires[n] == null) continue;
                this.fires[n] = this.fires[n].NextState();
            }
        }

        public void fireShot(int playerX, int playerY, int playerDir) {
            for (int n = 0; n < this.fires.length; ++n) {
                if (this.fires[n] != null) continue;
                this.fires[n] = new Fire(playerX, playerY, playerDir);
                break;
            }
        }

        public void Paint(Graphics g) {
            for (int n = 0; n < this.fires.length; ++n) {
                if (this.fires[n] == null) continue;
                this.fires[n].Paint(g);
            }
        }

        public void HitTest(Enemies enemies) {
            int pts = 0;
            for (int n = 0; n < this.fires.length; ++n) {
                if (this.fires[n] == null) continue;
                if (this.fires[n].drawX1 < this.fires[n].drawX2) {
                    if (enemies.CrashTest(this.fires[n].drawX1, this.fires[n].startY - 1, this.fires[n].drawX2, this.fires[n].startY + 2)) {
                        this.fires[n] = null;
                        pts += 25;
                        continue;
                    }
                    if (!enemies.CrashTest(this.fires[n].drawX1 - this.screenWidth, this.fires[n].startY - 1, this.fires[n].drawX2 - this.screenWidth, this.fires[n].startY + 1)) continue;
                    this.fires[n] = null;
                    pts += 25;
                    continue;
                }
                if (enemies.CrashTest(this.fires[n].drawX2, this.fires[n].startY - 1, this.fires[n].drawX1, this.fires[n].startY + 2)) {
                    this.fires[n] = null;
                    pts += 25;
                    continue;
                }
                if (!enemies.CrashTest(this.fires[n].drawX2 + this.screenWidth, this.fires[n].startY - 1, this.fires[n].drawX1 + this.screenWidth, this.fires[n].startY + 1)) continue;
                this.fires[n] = null;
                pts += 25;
            }
            GameScreen.this.points += pts;
        }

        public void HitTest(Platforms platforms) {
            for (int n = 0; n < this.fires.length; ++n) {
                if (this.fires[n] == null) continue;
                if (this.fires[n].drawX1 < this.fires[n].drawX2) {
                    if (platforms.CrashTest(this.fires[n].drawX1, this.fires[n].startY - 1, this.fires[n].drawX2, this.fires[n].startY + 1)) {
                        this.fires[n] = null;
                        continue;
                    }
                    if (!platforms.CrashTest(this.fires[n].drawX1 - this.screenWidth, this.fires[n].startY - 1, this.fires[n].drawX2 - this.screenWidth, this.fires[n].startY + 1)) continue;
                    this.fires[n] = null;
                    continue;
                }
                if (platforms.CrashTest(this.fires[n].drawX2, this.fires[n].startY - 1, this.fires[n].drawX1, this.fires[n].startY + 1)) {
                    this.fires[n] = null;
                    continue;
                }
                if (!platforms.CrashTest(this.fires[n].drawX2 + this.screenWidth, this.fires[n].startY - 1, this.fires[n].drawX1 + this.screenWidth, this.fires[n].startY + 1)) continue;
                this.fires[n] = null;
            }
        }

        private class Fire {
            int startX;
            int startY;
            int state;
            int drawX1;
            int drawX2;
            int direction;
            static final int MAXSTATE = 8;

            public Fire(int x, int y, int dir) {
                this.startX = x;
                this.startY = y;
                this.drawX1 = x;
                this.drawX2 = x;
                this.state = 0;
                this.direction = dir == 0 ? -1 : 1;
            }

            public Fire NextState() {
                ++this.state;
                if (this.state > 1) {
                    this.drawX1 += 10 * this.direction;
                }
                if (this.state < 5) {
                    this.drawX2 += 20 * this.direction;
                }
                if (this.state > 8) {
                    return null;
                }
                return this;
            }

            public void Paint(Graphics g) {
                g.setColor(255, 0, 0);
                g.drawLine(this.drawX1, this.startY, this.drawX2, this.startY);
                if (this.drawX2 > Fires.this.screenWidth) {
                    g.drawLine(0, this.startY, this.drawX2 - Fires.this.screenWidth, this.startY);
                } else if (this.drawX2 < 0) {
                    g.drawLine(Fires.this.screenWidth, this.startY, this.drawX2 + Fires.this.screenWidth, this.startY);
                }
            }

            static {
                MAXSTATE = 8;
            }
        }
    }

    private class Platforms {
        public Image[] images;
        public Platform[] platforms;
        public int screenHeight;
        public int screenWidth;

        public Platforms(int drawWidth, int drawHeight) {
            this.screenHeight = drawHeight;
            this.screenWidth = drawWidth;
            this.images = new Image[2];
            this.platforms = new Platform[3];
            this.images[0] = GameMidlet.getImage("platform1");
            this.images[1] = GameMidlet.getImage("platform2");
            this.Init();
        }

        public void Init() {
            this.platforms[0] = new Platform(15, GameScreen.this.customRand(2 * this.screenHeight / 3) + 20, 18, 4, 0);
            this.platforms[1] = new Platform(4 * this.screenWidth / 10, GameScreen.this.customRand(this.screenHeight / 2) + 20, 18, 4, 0);
            this.platforms[2] = new Platform(this.screenWidth - 15 - 27, GameScreen.this.customRand(this.screenHeight / 2) + 20, 27, 4, 1);
        }

        public boolean CrashTest(int x1, int y1, int x2, int y2) {
            return this.platforms[0].CrashDetect(x1, y1, x2, y2) || this.platforms[1].CrashDetect(x1, y1, x2, y2) || this.platforms[2].CrashDetect(x1, y1, x2, y2);
        }

        public void Paint(Graphics g) {
            this.platforms[0].Paint(g);
            this.platforms[1].Paint(g);
            this.platforms[2].Paint(g);
        }

        private class Platform {
            int x;
            int y;
            int x2;
            int y2;
            int imageid;

            public Platform(int x1, int y1, int width, int height, int imid) {
                this.x = x1;
                this.y = y1;
                this.x2 = this.x + width;
                this.y2 = this.y + height;
                this.imageid = imid;
            }

            public boolean CrashDetect(int oX1, int oY1, int oX2, int oY2) {
                return oX2 > this.x && oX1 < this.x2 && oY2 > this.y && oY1 < this.y2;
            }

            public void Paint(Graphics g) {
                g.drawImage(Platforms.this.images[this.imageid], this.x, this.y, 20);
            }
        }
    }

    public class Player {
        public final int LEFT;
        public final int RIGHT;
        public final int WALK;
        public final int FLY;
        public final int DIE;
        int x;
        int y;
        int dir;
        int vspeed;
        int hspeed;
        int flyState;
        public Image flyleft;
        public Image flyright = GameMidlet.getImage("flyright");
        public Image walkleft;
        public Image walkright;
        public Image walkleft2;
        public Image walkright2;
        public Image crash;
        public boolean walkImgState;
        public int screenWidth;
        public int screenHeight;

        public Player(GameScreen this$0, int drawWidth, int GROUNDLEVEL) {
            this.LEFT = 0;
            this.RIGHT = 1;
            this.WALK = 0;
            this.FLY = 2;
            this.DIE = 4;
            this.flyleft = GameMidlet.getImage("flyleft");
            this.walkright = GameMidlet.getImage("walkright");
            this.walkleft = GameMidlet.getImage("walkleft");
            this.walkright2 = GameMidlet.getImage("walkright2");
            this.walkleft2 = GameMidlet.getImage("walkleft2");
            this.crash = GameMidlet.getImage("enemycrash1");
            this.screenWidth = drawWidth;
            this.screenHeight = GROUNDLEVEL;
            this.Init();
        }

        public void Init() {
            this.x = this.screenWidth / 2;
            this.y = this.screenHeight;
            this.dir = 1;
            this.vspeed = 0;
            this.hspeed = 0;
            this.flyState = 0;
            this.walkImgState = false;
        }

        public void Paint(Graphics g) {
            switch (this.flyState + this.dir) {
                case 2: {
                    g.drawImage(this.flyleft, this.x, this.y, 3);
                    break;
                }
                case 3: {
                    g.drawImage(this.flyright, this.x, this.y, 3);
                    break;
                }
                case 0: {
                    g.drawImage(this.walkImgState ? this.walkleft : this.walkleft2, this.x, this.y, 3);
                    break;
                }
                case 1: {
                    g.drawImage(this.walkImgState ? this.walkright : this.walkright2, this.x, this.y, 3);
                    break;
                }
                case 4: 
                case 5: {
                    g.drawImage(this.crash, this.x, this.y, 3);
                }
            }
        }

        public void Left() {
            if (this.flyState == 4) {
                return;
            }
            boolean bl = this.walkImgState = !this.walkImgState;
            if (this.flyState == 2) {
                if (this.hspeed > -5) {
                    --this.hspeed;
                }
            } else {
                this.hspeed = this.hspeed > -3 ? --this.hspeed : ++this.hspeed;
            }
            this.dir = 0;
        }

        public void Right() {
            if (this.flyState == 4) {
                return;
            }
            boolean bl = this.walkImgState = !this.walkImgState;
            if (this.flyState == 2) {
                if (this.hspeed < 5) {
                    ++this.hspeed;
                }
            } else {
                this.hspeed = this.hspeed < 3 ? ++this.hspeed : --this.hspeed;
            }
            this.dir = 1;
        }

        public void Up() {
            if (this.flyState == 4) {
                return;
            }
            if (this.vspeed < 6) {
                this.vspeed += 2;
                this.flyState = 2;
            }
        }

        public void NotUp() {
            if (this.flyState == 4) {
                return;
            }
            if (this.vspeed > -5) {
                --this.vspeed;
            }
        }

        public void NotLeftRight() {
            if (this.flyState == 4) {
                return;
            }
            if (this.hspeed < 0) {
                ++this.hspeed;
            }
            if (this.hspeed > 0) {
                --this.hspeed;
            }
        }

        public void Move() {
            if (this.flyState == 4) {
                return;
            }
            this.x += this.hspeed;
            if (this.x < 0) {
                this.x = this.screenWidth - 0;
            }
            if (this.x > this.screenWidth - 0) {
                this.x = 0;
            }
            this.y -= this.vspeed;
            if (this.y < 10) {
                this.y = 10;
                this.vspeed = 0;
            }
            if (this.y >= this.screenHeight) {
                this.y = this.screenHeight;
                this.flyState = 0;
                this.vspeed = 0;
            }
        }

        public boolean CrashTest(int x1, int y1, int x2, int y2) {
            if (x1 < this.x + 4 && x2 > this.x - 4 && y1 < this.y + 8 && y2 > this.y - 8) {
                if (this.x < x1) {
                    this.x = x1 - 4;
                } else if (this.x > x2) {
                    this.x = x2 + 4;
                } else if (this.y > y2) {
                    this.y = y2 + 8;
                    this.vspeed = 0;
                } else {
                    this.y = y1 - 8;
                    this.vspeed = 0;
                    this.flyState = 0;
                }
                return true;
            }
            return false;
        }
    }

    public class Bonuses {
        public Bonus[] bonuses = new Bonus[5];
        public Image[] images = new Image[4];
        public int tics;
        public int bonuscount;
        public int screenWidth;
        public int screenHeight;

        public Bonuses(int drawWidth, int drawHeight) {
            this.images[0] = GameMidlet.getImage("bonus1");
            this.images[1] = GameMidlet.getImage("bonus2");
            this.images[2] = GameMidlet.getImage("bonus3");
            this.images[3] = GameMidlet.getImage("bonus4");
            this.screenWidth = drawWidth;
            this.screenHeight = drawHeight;
            this.Init();
        }

        public void Init() {
            this.bonuscount = 0;
            this.tics = 0;
            for (int n = 0; n < this.bonuses.length; ++n) {
                this.bonuses[n] = null;
            }
        }

        public void CrashTest(Platforms platforms) {
            for (int n = 0; n < this.bonuses.length; ++n) {
                if (this.bonuses[n] == null || this.bonuses[n].state != 0 || !platforms.CrashTest(this.bonuses[n].x, this.bonuses[n].y - 2, this.bonuses[n].x + 11, this.bonuses[n].y + 1)) continue;
                this.bonuses[n].state = 1;
            }
        }

        public void PickupTest(Player player) {
            int pts = 0;
            for (int n = 0; n < this.bonuses.length; ++n) {
                if (this.bonuses[n] == null || !player.CrashTest(this.bonuses[n].x, this.bonuses[n].y - 7, this.bonuses[n].x + 11, this.bonuses[n].y + 1)) continue;
                pts += GameScreen.this.BONUSPOINTS[this.bonuses[n].bonustype];
                this.bonuses[n] = null;
                --this.bonuscount;
                this.tics = 0;
            }
            GameScreen.this.points += pts;
        }

        public void Move() {
            try {
                int n;
                ++this.tics;
                if (this.tics > 100 && this.bonuscount == 0 || this.tics > 300 && this.bonuscount < 5) {
                    this.tics = 0;
                    for (n = 0; n < this.bonuses.length; ++n) {
                        if (this.bonuses[n] != null) continue;
                        this.bonuses[n] = new Bonus();
                        ++this.bonuscount;
                        break;
                    }
                }
                for (n = 0; n < this.bonuses.length; ++n) {
                    if (this.bonuses[n] == null) continue;
                    this.bonuses[n].Move();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void Paint(Graphics g) {
            for (int n = 0; n < this.bonuses.length; ++n) {
                if (this.bonuses[n] == null) continue;
                this.bonuses[n].Paint(g);
            }
        }

        public class Bonus {
            int state = 0;
            int bonustype;
            int x;
            int y;

            public Bonus() {
                this.bonustype = GameScreen.this.customRand(3);
                this.x = Math.abs(((Bonuses)Bonuses.this).GameScreen.this.rand.nextInt()) % Bonuses.this.screenWidth;
                this.y = 0;
            }

            public void Move() {
                if (this.state == 0) {
                    this.y += 2;
                    if (this.y >= Bonuses.this.screenHeight) {
                        this.y = Bonuses.this.screenHeight;
                        this.state = 1;
                    }
                }
            }

            public void Paint(Graphics g) {
                g.drawImage(Bonuses.this.images[this.bonustype], this.x, this.y, 36);
            }
        }
    }

    public class RocketFuel {
        public Image[] images = new Image[4];
        public Image[] liftoff = new Image[2];
        public RocketPiece[] pieces = new RocketPiece[4];
        int ground;
        int fueltimer;
        int fuelcount;
        int liftoffimg;
        int nextpick;
        int screenWidth;

        public RocketFuel(int x1, int x2, int x3, int screenHeight, int drawWidth) {
            this.screenWidth = drawWidth;
            this.liftoffimg = 1;
            this.ground = screenHeight - 1;
            this.images[0] = GameMidlet.getImage("gate1");
            this.images[1] = GameMidlet.getImage("gate2");
            this.images[2] = GameMidlet.getImage("gate3");
            this.images[3] = GameMidlet.getImage("fuel");
            this.liftoff[0] = GameMidlet.getImage("gate_active1");
            this.liftoff[1] = GameMidlet.getImage("gate_active2");
            this.Init(x1, x2, x3, this.ground);
        }

        public void Init(int x1, int x2, int x3, int ground) {
            this.fueltimer = 0;
            this.fuelcount = 0;
            this.nextpick = 1;
            this.pieces[0] = new RocketPiece(0, x1, ground, 4, ground, 20);
            this.pieces[1] = new RocketPiece(1, x2, 0, 0, ground - 10, 20);
            this.pieces[2] = new RocketPiece(2, x3, 0, 0, ground - 20, 20);
            for (int n = 3; n < this.pieces.length; ++n) {
                this.pieces[n] = null;
            }
        }

        public void CrashTest(Platforms platforms) {
            for (int n = 0; n < this.pieces.length; ++n) {
                if (this.pieces[n] == null || this.pieces[n].state != 0 || !platforms.CrashTest(this.pieces[n].x, this.pieces[n].y - 2, this.pieces[n].x + this.pieces[n].width, this.pieces[n].y + 1)) continue;
                this.pieces[n].state = 1;
            }
        }

        public int PickupTest(Player player) {
            if (this.pieces[this.nextpick] != null && (this.pieces[this.nextpick].state == 0 || this.pieces[this.nextpick].state == 1) && player.CrashTest(this.pieces[this.nextpick].x + 3, this.pieces[this.nextpick].y - 7, this.pieces[this.nextpick].x + this.pieces[this.nextpick].width - 3, this.pieces[this.nextpick].y - 2)) {
                GameScreen.this.points += 50;
                this.pieces[this.nextpick].state = 2;
            }
            return GameScreen.this.points;
        }

        public void PlayerDied() {
            for (int n = 0; n < this.pieces.length; ++n) {
                if (this.pieces[n] == null || this.pieces[n].state != 2) continue;
                this.pieces[n].state = 0;
            }
        }

        public void AssembleRocket() {
            this.nextpick = 3;
            this.pieces[1].state = 3;
            this.pieces[2].state = 3;
            this.pieces[1].x = this.pieces[0].x;
            this.pieces[1].y = this.pieces[1].targetheight;
            this.pieces[2].x = this.pieces[0].x;
            this.pieces[2].y = this.pieces[2].targetheight;
        }

        public void Move(Player player) {
            for (int n = 0; n < this.pieces.length; ++n) {
                if (this.pieces[n] == null) continue;
                this.pieces[n] = this.pieces[n].Move(player);
            }
            if (this.nextpick == 3 && this.pieces[3] == null) {
                ++this.fueltimer;
                if (this.fueltimer > 50 && this.fuelcount < 4) {
                    this.pieces[3] = new RocketPiece(3, GameScreen.this.customRand(this.screenWidth), 0, 0, this.ground, 14);
                    this.fueltimer = 0;
                }
            }
        }

        public void Paint(Graphics g) {
            for (int n = 0; n < this.pieces.length; ++n) {
                if (this.pieces[n] == null) continue;
                this.pieces[n].Paint(g);
            }
        }

        public class RocketPiece {
            int imageid;
            int x;
            int y;
            int width;
            int state;
            int targetheight;

            public RocketPiece(int id, int x1, int y1, int status, int target, int wi) {
                this.imageid = id;
                this.x = x1;
                this.y = y1;
                this.state = status;
                this.targetheight = target;
                this.width = wi;
            }

            public RocketPiece Move(Player player) {
                if (this.state == 0) {
                    this.y += 2;
                    if (this.y >= RocketFuel.this.ground) {
                        this.state = 1;
                        this.y = RocketFuel.this.ground;
                    }
                } else if (this.state == 3) {
                    this.y += 2;
                    if (this.y >= this.targetheight) {
                        this.y = this.targetheight;
                        this.state = 4;
                        ((RocketFuel)RocketFuel.this).GameScreen.this.points += 1000;
                        if (this.imageid == 3) {
                            ++RocketFuel.this.fuelcount;
                            if (RocketFuel.this.fuelcount == 4) {
                                ((RocketFuel)RocketFuel.this).GameScreen.this.gamestate = ((RocketFuel)RocketFuel.this).GameScreen.this.GS_READY;
                            }
                            return null;
                        }
                    }
                } else if (this.state == 2) {
                    this.y = player.y + 5;
                    this.x = player.x - 5;
                    if (this.x > RocketFuel.this.pieces[0].x - 3 && this.x < RocketFuel.this.pieces[0].x + 3) {
                        this.state = 3;
                        this.x = RocketFuel.this.pieces[0].x;
                        if (RocketFuel.this.nextpick < 3) {
                            ++RocketFuel.this.nextpick;
                        }
                    }
                } else if (((RocketFuel)RocketFuel.this).GameScreen.this.gamestate == ((RocketFuel)RocketFuel.this).GameScreen.this.GS_LIFTOFF) {
                    this.y -= 2;
                }
                return this;
            }

            public void Paint(Graphics g) {
                if (this.imageid == 0 && (((RocketFuel)RocketFuel.this).GameScreen.this.gamestate == ((RocketFuel)RocketFuel.this).GameScreen.this.GS_READY || ((RocketFuel)RocketFuel.this).GameScreen.this.gamestate == ((RocketFuel)RocketFuel.this).GameScreen.this.GS_LIFTOFF)) {
                    RocketFuel.this.liftoffimg = 1 - RocketFuel.this.liftoffimg;
                    g.drawImage(RocketFuel.this.liftoff[RocketFuel.this.liftoffimg], this.x, this.y, 36);
                } else {
                    g.drawImage(RocketFuel.this.images[this.imageid], this.x, this.y, 36);
                }
            }
        }
    }
}

