/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HighScores {
    public static final int NUM_SCORES = 10;
    public static MenuScreen menuScreen;
    private int[] scores = new int[10];
    private String[] names = new String[10];

    private HighScores(int[] s, String[] n) {
        for (int i = 0; i < 10; ++i) {
            if (s != null && n != null && i < s.length && i < n.length) {
                this.scores[i] = s[i];
                this.names[i] = n[i];
                continue;
            }
            this.scores[i] = 0;
            this.names[i] = "-";
        }
    }

    private static HighScores unpack(byte[] data) {
        try {
            int i;
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            int[] scores = new int[10];
            String[] names = new String[10];
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < 10; ++i) {
                scores[i] = din.readInt();
            }
            for (i = 0; i < 10; ++i) {
                char ch;
                sb.delete(0, sb.length());
                while ((ch = din.readChar()) != ';') {
                    sb.append(ch);
                }
                names[i] = sb.toString();
                if (names[i].length() <= 10) continue;
                names[i] = names[i].substring(0, 10);
            }
            din.close();
            bin.close();
            HighScores highScores = new HighScores(scores, names);
            return highScores;
        }
        catch (Exception e) {
            HighScores highScores = null;
            return highScores;
        }
    }

    private byte[] pack() {
        try {
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            for (i = 0; i < 10; ++i) {
                dout.writeInt(this.scores[i]);
            }
            for (i = 0; i < 10; ++i) {
                dout.writeChars(String.valueOf(String.valueOf(this.names[i])).concat(String.valueOf(String.valueOf(';'))));
            }
            dout.close();
            byte[] data = bout.toByteArray();
            bout.close();
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public int getScore(int ind) {
        if (ind < 0 || ind >= 10) {
            return -1;
        }
        return this.scores[ind];
    }

    public String getName(int ind) {
        if (ind < 0 || ind >= 10) {
            return "";
        }
        return this.names[ind];
    }

    public boolean isHighScore(int score) {
        System.out.println("New score:".concat(String.valueOf(String.valueOf(Integer.toString(score)))));
        System.out.println("Previous score:".concat(String.valueOf(String.valueOf(Integer.toString(this.scores[9])))));
        return score > this.scores[9];
    }

    public boolean setHighScore(int score, String name) {
        int ind;
        if (!this.isHighScore(score)) {
            return false;
        }
        for (ind = 9; ind > 0 && this.scores[ind - 1] <= score; --ind) {
        }
        for (int i = 9; i > ind; --i) {
            this.scores[i] = this.scores[i - 1];
            this.names[i] = this.names[i - 1];
        }
        this.scores[ind] = score;
        this.names[ind] = name;
        if (HighScores.saveHighScores(this)) {
            // empty if block
        }
        return true;
    }

    public static void resetHighScores() {
        SingleItemDB.delete("HighScores");
    }

    public static HighScores loadHighScores() {
        byte[] data = SingleItemDB.load("HighScores");
        HighScores hs = HighScores.unpack(data);
        if (hs == null) {
            hs = new HighScores(null, null);
        }
        return hs;
    }

    public static boolean saveHighScores(HighScores hs) {
        byte[] data = hs.pack();
        if (data == null) {
            return false;
        }
        return SingleItemDB.save("HighScores", data);
    }

    static {
        NUM_SCORES = 10;
    }
}

