/*
 * Decompiled with CFR 0.152.
 */
package ecnet.ninja;

import ecnet.ninja.GameCanvas;
import ecnet.ninja.GameImageLoader;
import ecnet.ninja.GameMIDlet;
import ecnet.ninja.Loading;
import ecnet.ninja.NokiaGameEffects;
import ecnet.ninja.ScoreBoard;
import ecnet.ninja.TaskControl;
import ecnet.ninja.TitleCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Timer;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class NinjaMain {
    public static final short MAX_SCORE = 10;
    public static final short TITLE = 0;
    public static final short MENU = 1;
    public static final short GAMEEND = 2;
    Display display;
    RecordStore rec;
    GameMIDlet midlet;
    GameImageLoader gameLoader;
    TitleCanvas titleCanvas;
    TaskControl task;
    GameCanvas gameCanvas;
    ScoreBoard score;
    Loading loading;
    Timer timer;
    NokiaGameEffects gameEffect;
    int gameStep;
    int level;
    int totalScore;
    int rank;
    int loadingCount;
    int[] nScore;
    Font font;
    boolean resumeFlag;
    boolean soundFlag;

    public NinjaMain(Display display, GameMIDlet gameMIDlet) {
        this.display = display;
        this.midlet = gameMIDlet;
        this.soundFlag = true;
        this.timer = new Timer();
        this.nScore = new int[10];
        if (this.gameEffect == null) {
            this.gameEffect = new NokiaGameEffects();
        }
        this.gameEffect.soundResume();
    }

    private void openRMS() {
        try {
            if (this.rec == null) {
                this.rec = RecordStore.openRecordStore((String)"ScoreDB", (boolean)true);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void readRMS() {
        block7: {
            try {
                if (this.rec.getNumRecords() == 0) {
                    int n = 0;
                    while (n < 10) {
                        this.nScore[n] = 0;
                        ++n;
                    }
                    this.soundFlag = true;
                    break block7;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rec.getRecord(1));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    int n = 0;
                    while (n < 10) {
                        this.nScore[n] = dataInputStream.readInt();
                        ++n;
                    }
                }
                catch (IOException iOException) {}
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    void saveRMS() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n = 0;
            while (n < 10) {
                dataOutputStream.writeInt(this.nScore[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            if (this.rec.getNumRecords() == 0) {
                this.rec.addRecord(byArray, 0, byArray.length);
            } else {
                this.rec.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void closeRMS() {
        try {
            if (this.rec != null) {
                this.rec.closeRecordStore();
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void scoreCal() {
        if (this.totalScore >= this.nScore[9]) {
            this.nScore[9] = this.totalScore;
            this.rank = 9;
            while (this.nScore[this.rank - 1] <= this.nScore[this.rank]) {
                int n = this.nScore[this.rank - 1];
                this.nScore[this.rank - 1] = this.nScore[this.rank];
                this.nScore[this.rank] = n;
                --this.rank;
                if (this.rank <= 0) break;
            }
            ++this.rank;
        } else {
            this.rank = 0;
        }
    }

    public void control() {
        switch (this.gameStep) {
            case 0: {
                this.openRMS();
                this.readRMS();
                if (this.titleCanvas == null) {
                    this.titleCanvas = new TitleCanvas(this);
                }
                this.display.setCurrent((Displayable)this.titleCanvas);
                this.gameEffect.titleSound();
                break;
            }
            case 2: {
                this.resumeFlag = false;
                this.scoreCal();
                if (this.rank != 0) {
                    this.saveRMS();
                }
                if (this.score == null) {
                    this.score = new ScoreBoard(this);
                }
                this.score.rank = this.rank;
                this.display.setCurrent((Displayable)this.score);
                this.task.cancel();
                this.task = null;
                this.gameCanvas = null;
                this.gameLoader = null;
            }
        }
    }
}

