/*
 * Decompiled with CFR 0.152.
 */
package ecnet.ninja;

import com.nokia.mid.sound.Sound;
import com.nokia.mid.sound.SoundListener;
import com.nokia.mid.ui.DeviceControl;

class NokiaGameEffects
implements SoundListener {
    private volatile boolean isPaused = true;
    private volatile int state = 1;
    private Sound sound = null;
    private volatile int currentSoundPriority = 0;
    String[] strSound = new String[]{"024A3A59150CB5391550040009205605606E0A348000", "024A3A59150CB539155004000B24830C2502D000", "024A3A59150CB539155004001320A2D027029023025049580000", "024A3A59150CB539155004000D20838824AC0D45116800", "024A3A59150CB53915500400171CA2312144344B230D0000", "024A3A59150CB539155004000B20728A2B131000", "024A3A59150CB539155004000B1C5A04E0836D00", "024A3A59150CB539155004000D1C5A06E0A29030D000", "024A3A59150CB539155004000F1CA27049C81881268000", "024A3A59150CB539155004000F205E06E0A25049780000", "024A3A59150CB539155004001B1CA27423421049889AA288C0C20000", "024A3A804041330DB6A2702B427023049A8800", "024A3A804001924DB66285A856AA2B4274236214591A28E50000", "024A3A804001B20DB6A2B02D149681880000"};
    String title = "024A3A59150CB539155004001318A2B02F032C38C36C2EC32800";
    String title2 = "024A3A59150CB53915502400FF20718A22C20C26C22C49C428AB0B30830C30830B30AA12718A22C20C26C20C22C49C41A480";
    String title3 = "024A3A51A195AAA0041AAA3A7AA40A40840A40A40840A4144A84A093902103502103103502103103502103102102AA00";

    NokiaGameEffects() {
    }

    private byte[] byteMake(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n + 1);
            int n2 = c >= '0' && c <= '9' ? c - 48 : c - 65 + 10;
            c = string.charAt(n);
            n2 = c >= '0' && c <= '9' ? (n2 += (c - 48) * 16) : (n2 += (c - 65 + 10) * 16);
            byArray[n / 2] = (byte)n2;
            n += 2;
        }
        return byArray;
    }

    public void soundStateChanged(Sound sound, int n) {
        if (sound == this.sound && n == 1) {
            this.setState(1);
            this.currentSoundPriority = 0;
        }
    }

    private synchronized void setState(int n) {
        this.state = n;
    }

    private synchronized void setIsPaused(boolean bl) {
        this.isPaused = bl;
    }

    void soundPause() {
        if (this.sound != null) {
            this.sound.stop();
        }
    }

    void soundResume() {
        this.setIsPaused(false);
    }

    void vibraPause() {
        DeviceControl.stopVibra();
    }

    private void playSound(int n, byte[] byArray) {
        if (!this.isPaused && n > this.currentSoundPriority) {
            try {
                if (this.sound == null) {
                    this.sound = new Sound(byArray, 1);
                    this.sound.setSoundListener(this);
                }
                if (this.state == 0) {
                    this.sound.stop();
                }
                this.sound.init(byArray, 1);
                this.sound.play(1);
                this.setState(0);
                this.currentSoundPriority = n;
            }
            catch (Exception exception) {
                this.setState(1);
                this.currentSoundPriority = 0;
            }
        }
    }

    void eachSound(int n) {
        this.playSound(n + 1, this.byteMake(this.strSound[n]));
    }

    void titleSound() {
        this.playSound(5, this.byteMake(this.title));
    }

    void vibrate() {
        try {
            DeviceControl.startVibra(50, 500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void flashLights() {
        DeviceControl.flashLights(250L);
    }

    void lightOn() {
        DeviceControl.setLights(0, 100);
    }

    void lightOff() {
        DeviceControl.setLights(0, 0);
    }
}

