/*
 * Decompiled with CFR 0.152.
 */
package AfterDark;

import AfterDark.GameManager;
import AfterDark.Human;
import AfterDark.Rectangle;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Enemy
extends Human {
    static Image eImg = null;

    public Enemy(int objType, int locX, int locY, int width, int height) {
        super(objType, locX, locY, width, height);
        this.speedX = 2;
        this.speedY = 2;
    }

    public void Initial(String name, int objType, String imgURL, int maxHP, int actImgWidth) {
        try {
            if (eImg == null) {
                eImg = Image.createImage((String)imgURL);
            }
        }
        catch (Exception ioe) {
            return;
        }
        this.Initial(name, objType, maxHP, this.curLoc.GetX(), this.curLoc.GetY());
    }

    public void Initial(String name, int objType, int maxHP, int posX, int posY) {
        this.name = name;
        this.SetType(objType);
        this.legArea = new Rectangle(this.curLoc);
        int actImgWidth = 24;
        this.curLoc.SetWidth(actImgWidth);
        this.curLoc.SetHeight(24);
        switch (objType) {
            default: {
                this.attPower = 8;
                break;
            }
            case 0: {
                this.attPower = 4;
                break;
            }
            case 1: {
                this.attPower = 5;
                break;
            }
            case 5: {
                this.attPower = 10;
                break;
            }
            case 6: {
                this.curLoc.SetWidth(15);
                this.curLoc.SetHeight(27);
                this.legArea.SetBounds(this.curLoc.GetX(), this.curLoc.GetY(), 15, 27);
                break;
            }
            case 23: {
                this.attPower = 15;
                this.curLoc.SetWidth(29);
                this.curLoc.SetHeight(38);
                this.legArea.SetBounds(this.curLoc.GetX(), this.curLoc.GetY(), 29, 33);
                break;
            }
            case 24: {
                this.attPower = 20;
                this.curLoc.SetWidth(58);
                this.curLoc.SetHeight(55);
                this.legArea.SetBounds(this.curLoc.GetX() + 13, this.curLoc.GetY() + 7, 32, 32);
                break;
            }
            case 25: {
                this.attPower = 15;
                this.curLoc.SetWidth(16);
                this.curLoc.SetHeight(14);
                this.legArea.SetBounds(this.curLoc.GetX(), this.curLoc.GetY(), 16, 16);
                break;
            }
            case 26: {
                this.attPower = 15;
                this.curLoc.SetWidth(16);
                this.curLoc.SetHeight(14);
                this.legArea.SetBounds(this.curLoc.GetX(), this.curLoc.GetY(), 16, 16);
            }
        }
        this.SetHP(maxHP);
        this.SetMaxHP(maxHP);
        this.actionImgWidth = this.curLoc.GetWidth();
        this.bodyOffsetX = (this.curLoc.GetWidth() - this.legArea.GetWidth()) / 2;
        this.SetDirection(1);
        this.SetAction(0);
        this.SetLocation(posX, posY);
    }

    public void SetLocation(int locX, int locY) {
        int disX = this.curLoc.GetWidth() - this.legArea.GetWidth();
        int disY = this.curLoc.GetHeight() - this.legArea.GetHeight();
        this.curLoc.SetLocation(locX, locY);
        this.curPosY = this.curLoc.GetY() + this.curLoc.GetHeight();
        this.legArea.SetLocation(this.curLoc.GetX() + disX, this.curLoc.GetY() + disY);
    }

    public void Run(int pLocX, int pLocY) {
        if (this.GetHP() <= 0 && this.GetAction() != 7) {
            this.SetAction(7);
        } else {
            if (this.IsDead()) {
                return;
            }
            if (this.GetHP() >= 0) {
                this.SelectAction(pLocX, pLocY);
            }
        }
        this.isMoving = false;
        switch (this.actionId) {
            case 0: {
                break;
            }
            case 1: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        this.ChangeAction(0);
                    } else {
                        this.drawImgId = this.actionScript == 2 ? 2 : 0;
                        this.dalayAction = 3;
                    }
                }
                int temp1 = this.MoveToDirection(this.speedX, false);
                this.UpdateCanMove(this.speedX, temp1);
                break;
            }
            case 2: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        this.ChangeAction(0);
                    } else {
                        this.drawImgId = this.actionScript == 2 ? 2 : 0;
                        this.dalayAction = 2;
                    }
                }
                int temp1 = this.MoveToDirection(this.speedX + 1, false);
                this.UpdateCanMove(this.speedX + 1, temp1);
                break;
            }
            case 3: {
                if (--this.dalayAction > 0) break;
                if (++this.actionScript > this.actionScriptLength) {
                    this.ChangeAction(0);
                    break;
                }
                ++this.drawImgId;
                this.dalayAction = 6;
                break;
            }
            case 6: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        this.ChangeAction(0);
                        break;
                    }
                    this.drawImgId = 3;
                    this.dalayAction = 3;
                    break;
                }
                if (this.actionScript > 0 || this.GetType() == 24) break;
                int moveDis = 2 + this.dalayAction * 3;
                int temp1 = this.MoveToDirection(moveDis, false);
                this.UpdateCanMove(moveDis, temp1);
                break;
            }
            case 7: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        this.destroy = true;
                        break;
                    }
                    if (this.actionScript > 1) {
                        this.drawImgId = 3;
                        this.dalayAction = 6;
                        break;
                    }
                    this.drawImgId = 3;
                    this.dalayAction = 3;
                    break;
                }
                if (this.actionScript > 0) break;
                this.moveDis = this.MoveToDirection(2 + this.dalayAction * 3, false);
            }
        }
    }

    public void SetAction(int newAct) {
        this.actionId = newAct;
        this.actionScript = 0;
        switch (newAct) {
            case 0: {
                this.actionScriptLength = 0;
                this.dalayAction = 0;
                this.drawImgId = 0;
                break;
            }
            case 1: {
                this.actionScriptLength = 3;
                this.dalayAction = 3;
                this.drawImgId = 1;
                break;
            }
            case 2: {
                this.actionScriptLength = 2;
                this.dalayAction = 2;
                this.drawImgId = 1;
                break;
            }
            case 3: {
                this.actionScriptLength = 1;
                this.dalayAction = 6;
                this.drawImgId = 2;
                break;
            }
            case 6: {
                this.stage = 0;
                this.explosionStage = 0;
                this.actionScriptLength = 2;
                this.dalayAction = 5;
                this.drawImgId = 0;
                break;
            }
            case 7: {
                this.stage = 0;
                this.explosionStage = 0;
                this.actionScriptLength = 2;
                this.dalayAction = 5;
                this.drawImgId = 0;
            }
        }
    }

    public void Reset() {
        super.Reset();
    }

    public void SelectAction(int pLocX, int pLocY) {
        int distance = this.FindDistance(pLocX, pLocY);
        if (this.actionId != 6 && this.actionId != 7) {
            switch (this.GetType()) {
                case 0: {
                    if (!this.ChangeAction(GameManager.Random(3) + 1)) break;
                    if (distance > 75) {
                        this.SetDirection(GameManager.Random(4));
                        break;
                    }
                    this.SetDirection(this.FindDirectionType1(pLocX, pLocY));
                    break;
                }
                case 1: {
                    if (distance > 130) {
                        GameManager.Random(4);
                    } else if (distance < 80) {
                        this.ChangeAction(2);
                    } else {
                        this.ChangeAction(1);
                    }
                    if (distance > 90) {
                        this.SetDirection(GameManager.Random(4));
                        break;
                    }
                    int newDir = this.FindDirectionType2(pLocX, pLocY);
                    this.SetDirection(newDir != -1 ? newDir : GameManager.Random(4));
                    break;
                }
                case 2: 
                case 5: {
                    if (!this.ChangeAction(GameManager.Random(3) + 1)) break;
                    if (distance > 90) {
                        this.SetDirection(GameManager.Random(4));
                        break;
                    }
                    this.SetDirection(this.FindDirectionType3(pLocX, pLocY));
                    break;
                }
                case 3: {
                    if (distance > 150) {
                        GameManager.Random(4);
                    } else if (distance < 100) {
                        this.ChangeAction(2);
                    } else {
                        this.ChangeAction(1);
                    }
                    if (distance > 90) {
                        this.SetDirection(GameManager.Random(4));
                        break;
                    }
                    int newDir = this.FindDirectionType3(pLocX, pLocY);
                    this.SetDirection(newDir != -1 ? newDir : GameManager.Random(4));
                    break;
                }
                case 23: {
                    this.ChangeAction(GameManager.Random(3) + 1);
                    if (distance > 150) {
                        this.SetDirection(GameManager.Random(4));
                        break;
                    }
                    int newDir = this.FindDirectionType3(pLocX, pLocY);
                    this.SetDirection(newDir != -1 ? newDir : GameManager.Random(4));
                    break;
                }
                case 4: {
                    if (distance > 200) {
                        this.ChangeAction(0);
                    } else if (distance < 20) {
                        this.ChangeAction(3);
                    } else {
                        this.ChangeAction(1);
                    }
                    if (distance > 150) {
                        this.SetDirection(GameManager.Random(4));
                        break;
                    }
                    int newDir = this.FindDirectionType3(pLocX, pLocY);
                    this.SetDirection(newDir != -1 ? newDir : GameManager.Random(4));
                    break;
                }
                case 25: 
                case 26: {
                    if (distance > 300) {
                        this.ChangeAction(0);
                    } else if (distance < 10) {
                        this.ChangeAction(3);
                    } else if (distance > 100) {
                        if (this.gauge == 0) {
                            this.gauge = GameManager.Random(200) - 100;
                        }
                        this.ChangeAction(2);
                    } else {
                        this.ChangeAction(1);
                    }
                    if (distance > 150) {
                        this.SetDirection(GameManager.Random(4));
                        break;
                    }
                    int newDir = 0;
                    if (this.gauge > 0) {
                        --this.gauge;
                        newDir = this.FindDirectionType3(this.curLoc.GetX(), pLocY);
                    } else if (this.gauge < 0) {
                        ++this.gauge;
                        newDir = this.FindDirectionType3(pLocX, this.curLoc.GetY());
                    } else {
                        this.gauge = 0;
                        newDir = this.FindDirectionType3(pLocX, pLocY);
                    }
                    this.SetDirection(newDir != -1 ? newDir : GameManager.Random(4));
                }
            }
        }
    }

    public int FindDirectionType1(int locX, int locY) {
        int disX = this.GetCenterLocationX() - locX;
        int disY = this.GetCenterLocationY() - locY;
        if (Math.abs(disX) < Math.abs(disY)) {
            if (disX == 0) {
                return disY > 0 ? 0 : 1;
            }
            if (disX > 0) {
                return 2;
            }
            return 3;
        }
        if (disY == 0) {
            return disX > 0 ? 2 : 3;
        }
        if (disY > 0) {
            return 0;
        }
        return 1;
    }

    public int FindDirectionType2(int locX, int locY) {
        int disX = this.GetCenterLocationX() - locX;
        int disY = this.GetCenterLocationY() - locY;
        if (GameManager.Random(100) > 50) {
            if (disX == 0) {
                return disY > 0 ? 0 : 1;
            }
            if (disX > 0) {
                return 2;
            }
            return 3;
        }
        if (disY == 0) {
            return disX > 0 ? 2 : 3;
        }
        if (disY > 0) {
            return 0;
        }
        return 1;
    }

    public void DrawMessage(Graphics g, String[] msg, int topPosX, int topPosY, int imgWidth, int imgHeight, int gap, int msgColor, int backColor) {
        if (this.GetType() == 24 || this.GetType() == 23) {
            try {
                super.DrawMessage(g, msg, topPosX, topPosY, imgWidth, imgHeight, gap, msgColor, backColor);
            }
            catch (Exception e) {
                // empty catch block
            }
            g.setClip(topPosX + gap, topPosY + gap, imgWidth, imgHeight);
            g.drawImage(eImg, topPosX - 72 + gap, topPosY - 189 + gap, 20);
        } else {
            try {
                super.DrawMessage(g, msg, topPosX, topPosY, imgWidth, imgHeight, gap, msgColor, backColor);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void Draw(Graphics g, int xOffset, int yOffset) {
        int width = this.actionImgWidth;
        int height = this.curLoc.GetHeight();
        int posX = xOffset + this.curLoc.GetX() + this.bodyOffsetX;
        int posY = yOffset + this.curLoc.GetY();
        if (this.GetAction() == 6) {
            g.setColor(this.damage < 0 ? 0xFF0000 : 65280);
            g.setClip(0, 0, 176, 178);
            g.drawString(String.valueOf(Math.abs(this.damage)), posX + width / 2, posY - 11, 20);
        }
        g.setClip(posX, posY, width, height);
        switch (this.type) {
            case 6: {
                g.drawImage(eImg, posX - 77, posY - 160, 20);
                break;
            }
            case 0: {
                g.drawImage(eImg, posX - this.drawImgId * width, posY, 20);
                break;
            }
            case 1: {
                g.drawImage(eImg, posX - this.drawImgId * width, posY - 24, 20);
                break;
            }
            case 2: {
                g.drawImage(eImg, posX - this.drawImgId * width, posY - 48, 20);
                break;
            }
            case 3: {
                g.drawImage(eImg, posX - this.drawImgId * width, posY - 72, 20);
                break;
            }
            case 4: {
                g.drawImage(eImg, posX - this.drawImgId * width, posY - 96, 20);
                break;
            }
            case 5: {
                if (this.actionId == 1 || this.actionId == 2) {
                    if (this.actionScript > 2) {
                        return;
                    }
                    g.drawImage(eImg, posX - this.actionScript * width, posY - 189, 20);
                    break;
                }
                g.drawImage(eImg, posX, posY - 189, 20);
                break;
            }
            case 23: {
                g.drawImage(eImg, posX - 58, posY - 120, 20);
                break;
            }
            case 24: {
                g.drawImage(eImg, posX, posY - 120, 20);
                if (this.actionId != 6 && this.actionId != 7) break;
                g.setClip(posX += 23, posY += 6, 15, 25);
                g.drawImage(eImg, posX - 58, posY - 161, 20);
                break;
            }
            case 25: {
                if (this.actionId == 3) {
                    g.drawImage(eImg, posX - 16, posY - 175, 20);
                    break;
                }
                g.drawImage(eImg, posX, posY - 175, 20);
                break;
            }
            case 26: {
                DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                if (this.actionId == 3) {
                    dg.drawImage(eImg, posX - eImg.getWidth() + width + 16, posY - 175, 20, 8192);
                    break;
                }
                dg.drawImage(eImg, posX - eImg.getWidth() + width, posY - 175, 20, 8192);
            }
        }
        if (this.actionId == 6 || this.actionId == 7) {
            if (this.GetType() == 24) {
                int i = 0;
                while (i < 4) {
                    this.DrawExplosion(g, 1, GameManager.Random(this.GetWidth() / 3) + xOffset, GameManager.Random(this.GetHeight() / 3) + yOffset);
                    ++i;
                }
            } else if (this.actionId == 7) {
                this.DrawExplosion(g, 1, xOffset, yOffset);
            } else {
                this.DrawExplosion(g, 0, xOffset, yOffset);
            }
        }
    }
}

