/*
 * Decompiled with CFR 0.152.
 */
package AfterDark;

import AfterDark.GameManager;
import AfterDark.Map;
import AfterDark.MovingObject;
import AfterDark.Rectangle;
import AfterDark.Room;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Human
extends MovingObject {
    static final int LEG_OFFSET = 3;
    protected int MAX_HP = 100;
    protected int DEFAULT_ATT_POWER = 5;
    protected int DEFAULT_DEF_POWER = 4;
    protected Image img = null;
    protected String name;
    protected int hp = 10;
    protected int actionId = 0;
    protected int drawImgId = 0;
    protected int actionScript = 0;
    protected int actionScriptLength = 0;
    protected int dalayAction = 2;
    protected int bodyOffsetX = 0;
    protected int curPosY = 0;
    protected int actionImgWidth = 0;
    protected boolean isMoving = true;
    protected boolean isKeyHold = false;
    protected int invisible = 0;
    protected int attWidth = 34;
    protected int attHeight = 25;
    protected Rectangle attArea = null;
    protected Rectangle legArea = null;
    protected int attPower = this.DEFAULT_ATT_POWER;
    protected int defPower = this.DEFAULT_DEF_POWER;
    protected int damage = 0;
    protected int explosionStage = 0;
    protected int numWeapon = 0;
    protected int weaponId = 0;
    protected int gauge = 0;
    protected int newItem = -1;
    protected int[] itemStock = null;
    protected boolean canMoveUp = true;
    protected boolean canMoveDown = true;
    protected boolean canMoveLeft = true;
    protected boolean canMoveRight = true;
    protected int oldDirection = -1;
    protected int msgTimer = 0;
    protected String[] msg = null;

    public Human(int objType, int locX, int locY, int width, int height) {
        super(objType, locX, locY, width, height);
        this.speedX = 4;
        this.speedY = 4;
        this.curPosY = this.curLoc.GetY() + this.curLoc.GetHeight();
        int bodyWidth = this.curLoc.GetWidth();
        this.itemStock = new int[18];
        int i = 0;
        while (i < this.itemStock.length) {
            this.itemStock[i] = -1;
            ++i;
        }
        this.itemStock[0] = 0;
        this.numWeapon = 1;
        this.SetWeaponId(0);
    }

    public void Initial(String name, int objType, String imgURL, int maxHP, int actImgWidth) {
        try {
            this.img = Image.createImage((String)imgURL);
        }
        catch (Exception ioe) {
            return;
        }
        this.Initial(name, objType, this.img, maxHP, actImgWidth);
    }

    public void Initial(String name, int objType, Image playerImg, int maxHP, int actImgWidth) {
        this.name = name;
        this.SetType(objType);
        this.SetMaxHP(maxHP);
        this.SetHP(maxHP);
        this.actionImgWidth = actImgWidth;
        this.bodyOffsetX = (this.curLoc.GetWidth() - this.actionImgWidth) / 2;
        this.direction = 1;
        this.SetAction(0);
        if (this.GetType() == 20 || this.GetType() == 22) {
            this.attWidth = 34;
            this.attHeight = 25;
            this.attArea = new Rectangle(this.GetLocationX(), this.GetLocationY(), this.attWidth, this.attHeight);
        } else {
            this.attWidth = 30;
            this.attHeight = 30;
            this.attArea = new Rectangle(this.GetLocationX(), this.GetLocationY(), this.attWidth, this.attHeight);
        }
        this.legArea = new Rectangle();
        this.SetLocation(this.curLoc.GetX(), this.curLoc.GetY());
        int bodyWidth = this.curLoc.GetWidth();
        this.legArea.SetWidth(bodyWidth);
        this.legArea.SetHeight(bodyWidth);
        try {
            this.img = playerImg;
            if (MovingObject.weaponImg == null) {
                MovingObject.weaponImg = Image.createImage((String)"/AfterDark/Images/Player/menu.png");
            }
        }
        catch (Exception ioe) {
            return;
        }
    }

    public void Run() {
        if (this.gauge > 0) {
            --this.gauge;
        }
        if (this.GetHP() <= 0 && this.GetAction() != 7) {
            this.SetAction(7);
        } else {
            if (this.IsDead()) {
                return;
            }
            if (this.invisible > 0) {
                --this.invisible;
            }
        }
        this.isMoving = false;
        switch (this.actionId) {
            case 0: {
                break;
            }
            case 1: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        if (this.isKeyHold) {
                            this.SetAction(1);
                        } else {
                            this.ChangeAction(0);
                        }
                    } else {
                        this.drawImgId = this.actionScript == 2 ? 2 : 0;
                        this.dalayAction = 2;
                    }
                }
                this.moveDis = this.MoveToDirection(this.speedX, true);
                break;
            }
            case 2: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        if (this.isKeyHold) {
                            this.SetAction(2);
                        } else {
                            this.ChangeAction(0);
                        }
                    } else {
                        this.drawImgId = this.actionScript == 2 ? 2 : 0;
                        this.dalayAction = 1;
                    }
                }
                this.moveDis = this.MoveToDirection(this.speedX + 2, true);
                break;
            }
            case 3: {
                if (--this.dalayAction > 0) break;
                if (++this.actionScript > this.actionScriptLength) {
                    if (this.isKeyHold) {
                        this.SetAction(3);
                        break;
                    }
                    this.ChangeAction(0);
                    break;
                }
                ++this.drawImgId;
                this.dalayAction = this.GetType() == 21 && this.drawImgId == 5 ? 4 : 2;
                break;
            }
            case 5: {
                if (--this.dalayAction > 0) break;
                if (++this.actionScript > this.actionScriptLength) {
                    this.ChangeAction(0);
                    break;
                }
                this.dalayAction = 20;
                break;
            }
            case 4: {
                if (--this.dalayAction <= 0) {
                    this.ChangeAction(0);
                    break;
                }
                this.moveDis = this.MoveToDirection(8, true);
                break;
            }
            case 6: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        this.invisible = 20;
                        this.ChangeAction(0);
                        break;
                    }
                    this.drawImgId = 1;
                    this.dalayAction = 2;
                    break;
                }
                this.moveDis = this.MoveOppositeDirection(this.GetType() == 22 ? 2 + this.dalayAction * 4 : 2 + this.dalayAction * 3, false);
                break;
            }
            case 7: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        this.destroy = true;
                        break;
                    }
                    this.drawImgId = 1;
                    this.dalayAction = 7;
                    break;
                }
                if (this.actionScript > 0) break;
                this.moveDis = this.MoveOppositeDirection(2 + this.dalayAction * 3, false);
                break;
            }
            case 8: {
                if (--this.dalayAction <= 0) {
                    if (++this.actionScript > this.actionScriptLength) {
                        this.ChangeAction(0);
                    } else if (this.actionScript < 4) {
                        ++this.drawImgId;
                        this.dalayAction = this.drawImgId == 5 ? 25 : 6;
                    } else {
                        --this.drawImgId;
                        this.dalayAction = 3;
                    }
                }
                if (this.drawImgId != 5) break;
                this.moveDis = this.MoveToDirection(this.speedX * 2, true);
                break;
            }
            case 9: 
            case 10: {
                if (--this.dalayAction > 0) break;
                if (++this.actionScript > this.actionScriptLength) {
                    this.ChangeAction(0);
                    this.newItem = -1;
                    break;
                }
                this.dalayAction = 4;
            }
        }
    }

    public void Reset() {
        super.Reset();
        this.destroy = false;
        this.isKeyHold = false;
        this.hp = 10;
        this.actionId = 0;
        this.actionScript = 0;
        this.actionScriptLength = 0;
        this.drawImgId = 0;
        this.dalayAction = 0;
        this.curPosY = 0;
        this.invisible = 0;
        this.damage = 0;
        this.explosionStage = 0;
        this.gauge = 0;
        this.canMoveUp = true;
        this.canMoveDown = true;
        this.canMoveLeft = true;
        this.canMoveRight = true;
        this.oldDirection = -1;
        this.isMoving = true;
        int i = 0;
        while (i < this.itemStock.length) {
            this.itemStock[i] = -1;
            ++i;
        }
        this.itemStock[0] = 0;
        this.numWeapon = 1;
        this.SetWeaponId(0);
    }

    public void SetLocation(int locX, int locY) {
        this.curLoc.SetLocation(locX, locY);
        this.curPosY = this.curLoc.GetY() + this.curLoc.GetHeight() - 3;
        this.legArea.SetLocation(this.curLoc.GetX(), this.curPosY - this.curLoc.GetWidth() / 2 - 6);
    }

    public boolean IsMoving() {
        return this.isMoving;
    }

    public boolean IsInvisible() {
        return this.invisible > 0;
    }

    public boolean IsDead() {
        return this.IsDestroy();
    }

    public boolean IsAttack() {
        return this.GetType() == 20 ? this.actionId == 3 && this.drawImgId == 4 : (this.GetType() == 21 ? this.actionId == 3 && this.drawImgId == 5 : this.actionId == 3 && this.drawImgId == 4);
    }

    public Rectangle GetAttackArea() {
        return this.attArea;
    }

    public Rectangle GetLegArea() {
        return this.legArea;
    }

    public boolean ChangeAction(int newAct) {
        if (this.actionId == 0 || newAct == 0) {
            this.SetAction(newAct);
            return true;
        }
        return false;
    }

    public void SetAction(int newAct) {
        this.actionId = newAct;
        this.actionScript = 0;
        switch (newAct) {
            case 0: {
                this.actionScriptLength = 0;
                this.dalayAction = 0;
                this.drawImgId = 0;
                break;
            }
            case 1: {
                this.actionScriptLength = 3;
                this.dalayAction = 2;
                this.drawImgId = 1;
                break;
            }
            case 2: {
                this.actionScriptLength = 2;
                this.dalayAction = 2;
                this.drawImgId = 1;
                break;
            }
            case 3: {
                switch (this.direction) {
                    case 0: {
                        if (this.GetType() == 20 || this.GetType() == 22) {
                            this.attArea.SetBounds(this.GetCenterLocationX() - this.attWidth / 2, this.GetCenterLocationY() - this.attHeight, this.attWidth, this.attHeight);
                            break;
                        }
                        this.attArea.SetLocation(this.GetCenterLocationX() - this.attWidth / 2, this.GetCenterLocationY() - 17);
                        break;
                    }
                    case 1: {
                        if (this.GetType() == 20 || this.GetType() == 22) {
                            this.attArea.SetBounds(this.GetCenterLocationX() - this.attWidth / 2, this.GetCenterLocationY() + 10, this.attWidth, this.attHeight);
                            break;
                        }
                        this.attArea.SetLocation(this.GetCenterLocationX() - this.attWidth / 2, this.GetCenterLocationY() - 3);
                        break;
                    }
                    case 2: {
                        if (this.GetType() == 20 || this.GetType() == 22) {
                            this.attArea.SetBounds(this.GetCenterLocationX() - 28, this.GetCenterLocationY() - this.attWidth / 2, this.attHeight, this.attWidth);
                            break;
                        }
                        this.attArea.SetLocation(this.GetCenterLocationX() - this.attWidth / 2 - 10, this.GetCenterLocationY() - 13);
                        break;
                    }
                    case 3: {
                        if (this.GetType() == 20 || this.GetType() == 22) {
                            this.attArea.SetBounds(this.GetCenterLocationX() + 5, this.GetCenterLocationY() - this.attWidth / 2, this.attHeight, this.attWidth);
                            break;
                        }
                        this.attArea.SetLocation(this.GetCenterLocationX() - this.attWidth / 2 + 10, this.GetCenterLocationY() - 13);
                    }
                }
                this.actionScriptLength = 2;
                this.dalayAction = 2;
                this.drawImgId = 3;
                break;
            }
            case 4: {
                this.actionScriptLength = 0;
                this.dalayAction = 4;
                this.drawImgId = 6;
                break;
            }
            case 5: {
                this.actionScriptLength = 1;
                this.dalayAction = 10;
                this.drawImgId = 2;
                break;
            }
            case 6: {
                this.stage = 0;
                this.explosionStage = 0;
                this.actionScriptLength = 1;
                this.dalayAction = 4;
                this.drawImgId = 7;
                break;
            }
            case 7: {
                this.stage = 0;
                this.explosionStage = 0;
                this.actionScriptLength = 2;
                this.dalayAction = 6;
                this.drawImgId = 7;
                break;
            }
            case 8: {
                this.actionScriptLength = 6;
                this.dalayAction = 4;
                this.drawImgId = 2;
                break;
            }
            case 9: {
                this.actionScriptLength = 1;
                this.dalayAction = 4;
                this.drawImgId = 3;
                break;
            }
            case 10: {
                this.actionScriptLength = 1;
                this.dalayAction = 15;
                this.drawImgId = 8;
                break;
            }
        }
    }

    public int GetAction() {
        return this.actionId;
    }

    public int GetLegLocationY() {
        return this.curPosY;
    }

    public int FindDistance(int toX, int toY) {
        int disY;
        int disX = Math.abs(this.GetCenterLocationX() - toX);
        int min = disX < (disY = Math.abs(this.GetCenterLocationY() - toY)) ? disX : disY;
        return disX + disY - (min >> 1) - (min >> 2) + (min >> 4);
    }

    public void ChangeDirection(int newDir) {
        if (this.actionId != 6 || this.actionId != 7) {
            this.direction = newDir;
        }
    }

    public void SetHP(int newHP) {
        this.damage = newHP - this.hp;
        this.hp = newHP;
        if (this.hp > 0) {
            this.destroy = false;
            this.SetAction(0);
        } else if (this.hp < 0) {
            this.hp = 0;
            this.SetAction(7);
        }
    }

    public int GetHP() {
        return this.hp;
    }

    public int GetMaxHP() {
        return this.MAX_HP;
    }

    public void SetMaxHP(int maxHP) {
        this.MAX_HP = maxHP;
    }

    public int GetItem(int num) {
        return this.itemStock[num];
    }

    public void SetItem(int id, int itemId) {
        this.itemStock[id] = itemId;
    }

    public boolean AddNewItem(int itemId) {
        int i = 3;
        while (i < this.itemStock.length) {
            if (this.itemStock[i] == -1) {
                this.itemStock[i] = itemId;
                this.newItem = itemId;
                return true;
            }
            ++i;
        }
        return false;
    }

    public int UseItem(int id) {
        if (this.itemStock[id] != -1) {
            switch (this.itemStock[id]) {
                case 4: {
                    this.MAX_HP += 15;
                    this.SetHP(this.GetHP() + 50 > this.MAX_HP ? this.MAX_HP : this.hp + 50);
                    break;
                }
                case 5: {
                    this.itemStock[id] = -1;
                    this.gauge = 114;
                    return this.gauge;
                }
                case 6: {
                    this.gauge = 114;
                    this.invisible += 114;
                    break;
                }
                default: {
                    return -1;
                }
            }
            this.itemStock[id] = -1;
        }
        return -1;
    }

    public boolean RemoveItem(int iId) {
        int i = 3;
        while (i < this.itemStock.length) {
            if (this.itemStock[i] == iId) {
                this.itemStock[i] = -1;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean HasItemId(int iId) {
        int i = 0;
        while (i < this.itemStock.length) {
            if (this.itemStock[i] == iId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int GetNumWeapon() {
        return this.numWeapon;
    }

    public void SetNumWeapon(int num) {
        this.numWeapon = num;
    }

    public boolean SetNewWeapon(int weapId) {
        int i = 0;
        while (i < 3) {
            if (this.itemStock[i] == weapId) {
                return false;
            }
            ++i;
        }
        this.itemStock[this.numWeapon] = weapId;
        ++this.numWeapon;
        return true;
    }

    public int GetWeaponId() {
        return this.weaponId;
    }

    public void SetWeaponId(int id) {
        this.weaponId = id;
        switch (id) {
            case 0: {
                this.attPower = this.DEFAULT_ATT_POWER;
                this.defPower = this.DEFAULT_DEF_POWER;
                break;
            }
            case 1: {
                this.attPower = this.DEFAULT_ATT_POWER * 2;
                this.defPower = this.DEFAULT_DEF_POWER + 3;
                break;
            }
            case 2: {
                this.attPower = this.DEFAULT_ATT_POWER * 3;
                this.defPower = this.DEFAULT_DEF_POWER + 8;
            }
        }
    }

    public int GetAttackPower() {
        return this.attPower;
    }

    public int GetDefensePower() {
        return this.defPower;
    }

    public void KeyUp() {
        this.ChangeDirection(0);
        this.SetKeyHold(true);
    }

    public void KeyDown() {
        this.ChangeDirection(1);
        if (this.GetType() != 22) {
            this.SetKeyHold(true);
        }
    }

    public void KeyLeft() {
        this.ChangeDirection(2);
        if (this.GetType() != 22) {
            this.SetKeyHold(true);
        }
    }

    public void KeyRight() {
        this.ChangeDirection(3);
        if (this.GetType() != 22) {
            this.SetKeyHold(true);
        }
    }

    public void KeyFire() {
        if (this.GetType() != 22) {
            this.ChangeAction(3);
        }
    }

    public void SetKeyHold(boolean keyHold) {
        this.isKeyHold = keyHold;
        if (!(this.GetType() == 22 || this.isKeyHold || this.actionId != 1 && this.actionId != 2)) {
            this.SetAction(0);
        }
    }

    public int GetPosX() {
        int myPosX = this.GetCenterLocationX();
        return myPosX /= 30;
    }

    public int GetPosY() {
        int myPosY = this.curLoc.GetY() + this.curLoc.GetHeight() - 3;
        return myPosY /= 30;
    }

    public int GetObjectId() {
        int myPosX = this.GetPosX();
        int myPosY = this.GetPosY();
        return Room.GetObjectId(myPosX, myPosY);
    }

    public boolean IsDoorUnlock(int doorLocX, int doorLocY) {
        int keyId = Map.GetDoorLockId(doorLocX, doorLocY);
        if (keyId == -1) {
            return true;
        }
        int i = 3;
        while (i < this.itemStock.length) {
            if (this.GetItem(i) == keyId) {
                Map.UnlockDoorId(Map.GetMapId(), doorLocX, doorLocY);
                String[] str = new String[]{"You unlock the door", "with " + Map.GetItemInfo(keyId)};
                this.SetMessage(str, 20);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean OpenTheDoor(int newDoorId, int x, int y) {
        if (this.IsDoorUnlock(x, y)) {
            Room.SetObjectId(newDoorId, x, y);
            return true;
        }
        int keyId = Map.GetDoorLockId(x, y);
        if (keyId == 20) {
            String[] newMsg = new String[]{"Door is locked. I cannot", "open this door with key."};
            this.SetMessage(newMsg, 30);
        } else if (keyId != -1) {
            String[] newMsg = new String[]{"Door is locked.", "I need to find " + Map.GetItemInfo(keyId)};
            this.SetMessage(newMsg, 30);
        }
        return false;
    }

    public int MoveToDirection(int dis, boolean changeRoomData) {
        int canMoveDis = 0;
        this.isMoving = true;
        switch (this.direction) {
            case 0: {
                canMoveDis = this.CheckCollision(dis, 0, changeRoomData);
                this.MoveY(-canMoveDis);
                this.legArea.MoveY(-canMoveDis);
                return canMoveDis;
            }
            case 1: {
                canMoveDis = this.CheckCollision(dis, 1, changeRoomData);
                this.MoveY(canMoveDis);
                this.legArea.MoveY(canMoveDis);
                return canMoveDis;
            }
            case 2: {
                canMoveDis = this.CheckCollision(dis, 2, changeRoomData);
                this.MoveX(-canMoveDis);
                this.legArea.MoveX(-canMoveDis);
                return canMoveDis;
            }
            case 3: {
                canMoveDis = this.CheckCollision(dis, 3, changeRoomData);
                this.MoveX(canMoveDis);
                this.legArea.MoveX(canMoveDis);
                return canMoveDis;
            }
        }
        return -1;
    }

    public int MoveOppositeDirection(int dis, boolean changeRoomData) {
        int canMoveDis = 0;
        this.isMoving = true;
        switch (this.direction) {
            case 0: {
                canMoveDis = this.CheckCollision(dis, 1, changeRoomData);
                this.MoveY(canMoveDis);
                this.legArea.MoveY(canMoveDis);
                return canMoveDis;
            }
            case 1: {
                canMoveDis = this.CheckCollision(dis, 0, changeRoomData);
                this.MoveY(-canMoveDis);
                this.legArea.MoveY(-canMoveDis);
                return canMoveDis;
            }
            case 2: {
                canMoveDis = this.CheckCollision(dis, 3, changeRoomData);
                this.MoveX(canMoveDis);
                this.legArea.MoveX(canMoveDis);
                return canMoveDis;
            }
            case 3: {
                canMoveDis = this.CheckCollision(dis, 2, changeRoomData);
                this.MoveX(-canMoveDis);
                this.legArea.MoveX(-canMoveDis);
                return canMoveDis;
            }
        }
        return -1;
    }

    public boolean IsObstruction(int toX, int toY) {
        int fromX = this.GetCenterLocationX();
        int dis = fromX - toX;
        if (dis < 0) {
            int canMoveDis = this.CheckCollision(dis = -dis, 3, false);
            if (canMoveDis >= dis) {
                int fromY = this.GetLegLocationY();
                dis = fromY - toY;
                if (dis < 0) {
                    canMoveDis = this.CheckCollision(dis = -dis, 1, false);
                    return canMoveDis < dis;
                }
                canMoveDis = this.CheckCollision(dis, 0, false);
                return canMoveDis < dis;
            }
        } else {
            int canMoveDis = this.CheckCollision(dis, 2, false);
            if (canMoveDis >= dis) {
                int fromY = this.GetLegLocationY();
                dis = fromY - toY;
                if (dis < 0) {
                    canMoveDis = this.CheckCollision(dis = -dis, 1, false);
                    return canMoveDis < dis;
                }
                canMoveDis = this.CheckCollision(dis, 0, false);
                return canMoveDis < dis;
            }
        }
        return true;
    }

    public int CheckCollision(int moveOffset, int direct, boolean changeRoomData) {
        int widthOffset = this.curLoc.GetWidth() / 2 - 2;
        int heightOffset = this.curLoc.GetHeight() - 3;
        int curPosX = this.GetCenterLocationX();
        this.curPosY = this.curLoc.GetY() + heightOffset;
        try {
            switch (direct) {
                case 0: {
                    int posY2;
                    int rightBound;
                    int leftBound;
                    int width;
                    int rWidth;
                    int lWidth;
                    int objPosX;
                    int minX = curPosX - widthOffset;
                    int maxX = curPosX + widthOffset;
                    int leftPosX = minX / 30;
                    int rightPosX = maxX / 30;
                    int posY1 = this.curPosY / 30;
                    int leftRoomData = Room.GetObjectId(leftPosX, posY1);
                    int rightRoomData = Room.GetObjectId(rightPosX, posY1);
                    int objPosY = (posY1 + 1) * 30;
                    int leftDisY = objPosY - Room.GetObstructionDistance(leftRoomData, direct);
                    int rightDisY = objPosY - Room.GetObstructionDistance(rightRoomData, direct);
                    int moveTo = this.curPosY - moveOffset;
                    if (moveTo <= rightDisY && this.curPosY >= rightDisY && rightRoomData != -1) {
                        objPosX = Room.GetObstructionDistance(rightRoomData, 3);
                        lWidth = 30 - Room.GetObstructionDistance(rightRoomData, 2);
                        width = lWidth - (rWidth = objPosX);
                        if (width > 0) {
                            leftBound = objPosX += rightPosX * 30;
                            rightBound = objPosX + width;
                            if (minX < rightBound && maxX > leftBound || minX > leftBound && maxX < rightBound || minX < leftBound && maxX > leftBound || minX < rightBound && maxX > rightBound) {
                                return this.curPosY - rightDisY;
                            }
                        }
                    }
                    if (moveTo <= leftDisY && this.curPosY >= leftDisY && leftPosX != rightPosX && leftRoomData != -1 && (width = (rWidth = 30 - (objPosX = Room.GetObstructionDistance(leftRoomData, 3))) - (lWidth = Room.GetObstructionDistance(leftRoomData, 2))) > 0) {
                        leftBound = objPosX += leftPosX * 30;
                        rightBound = objPosX + width;
                        if (minX < rightBound && maxX > leftBound || minX > leftBound && maxX < rightBound || minX < leftBound && maxX > leftBound || minX < rightBound && maxX > rightBound) {
                            return this.curPosY - leftDisY;
                        }
                    }
                    if (posY1 != (posY2 = moveTo / 30)) {
                        while (--posY1 >= posY2) {
                            int lWidth2;
                            int rWidth2;
                            int rightBound2;
                            int leftBound2;
                            int width2;
                            int objPosX2;
                            leftRoomData = Room.GetObjectId(leftPosX, posY1);
                            rightRoomData = Room.GetObjectId(rightPosX, posY1);
                            leftDisY = (objPosY -= 30) - Room.GetObstructionDistance(leftRoomData, direct);
                            rightDisY = objPosY - Room.GetObstructionDistance(rightRoomData, direct);
                            if (changeRoomData && (this.GetType() == 20 || this.GetType() == 21) && leftPosX == rightPosX) {
                                int rData = Room.GetRoomData(leftPosX, posY1);
                                if (Room.IsCloseDoorYId(rData)) {
                                    this.OpenTheDoor(rData + 1, leftPosX, posY1);
                                } else {
                                    this.newItem = Map.GetItemId(leftPosX, posY1);
                                    if (this.newItem == 17 || this.newItem == 18) {
                                        Map.SetItemId(this.newItem, leftPosX, posY1);
                                        this.SetAction(10);
                                        String[] newItemMsg = new String[]{Map.GetItemName(this.newItem), Map.GetItemInfo(this.newItem)};
                                        this.SetMessage(newItemMsg, 30);
                                        if (this.newItem == 17) {
                                            GameManager.ShowEvent(30);
                                        } else if (this.newItem == 18) {
                                            GameManager.ShowEvent(31);
                                        }
                                    } else if (this.newItem != -1) {
                                        boolean canSaveItem = false;
                                        if (this.newItem < 3) {
                                            this.SetNewWeapon(this.newItem);
                                            canSaveItem = true;
                                        } else {
                                            canSaveItem = this.AddNewItem(this.newItem);
                                        }
                                        if (!canSaveItem) {
                                            Map.SetItemId(this.newItem, leftPosX, posY1);
                                        }
                                        this.SetAction(10);
                                        if (Room.IsCloseTreasureId(rData) && canSaveItem) {
                                            Room.SetRoomData(rData + 1, leftPosX, posY1);
                                        }
                                        String[] newItemMsg = new String[]{Map.GetItemName(this.newItem), Map.GetItemInfo(this.newItem)};
                                        this.SetMessage(newItemMsg, 30);
                                        if (this.newItem == 0) {
                                            GameManager.ShowEvent(3);
                                        } else if (this.newItem == 7) {
                                            Map.SetEventId(7, 11, 4, 7);
                                        } else if (this.newItem == 8) {
                                            Map.SetEventId(8, 12, 8, 2);
                                        } else if (this.newItem == 9) {
                                            Map.SetEventId(10, 14, 5, 6);
                                        } else if ((this.newItem == 14 || this.newItem == 16 || this.newItem == 15) && this.HasItemId(14) && this.HasItemId(16) && this.HasItemId(15)) {
                                            Map.UnlockDoorId(3, 7, 0);
                                            GameManager.ShowEvent(98);
                                        }
                                    } else if (Room.IsExaminableId(rData)) {
                                        this.SetAction(9);
                                    }
                                }
                            }
                            if (rightRoomData != -1) {
                                int rWidth3;
                                objPosX2 = Room.GetObstructionDistance(rightRoomData, 3);
                                int lWidth3 = 30 - Room.GetObstructionDistance(rightRoomData, 2);
                                width2 = lWidth3 - (rWidth3 = objPosX2);
                                if (width2 > 0) {
                                    leftBound2 = objPosX2 += rightPosX * 30;
                                    rightBound2 = objPosX2 + width2;
                                    if (minX < rightBound2 && maxX > leftBound2 || minX > leftBound2 && maxX < rightBound2 || minX < leftBound2 && maxX > leftBound2 || minX < rightBound2 && maxX > rightBound2) {
                                        return this.curPosY >= rightDisY && moveTo <= rightDisY ? this.curPosY - rightDisY : moveOffset;
                                    }
                                }
                            }
                            if (leftPosX != rightPosX && leftRoomData != -1 && (width2 = (rWidth2 = 30 - (objPosX2 = Room.GetObstructionDistance(leftRoomData, 3))) - (lWidth2 = Room.GetObstructionDistance(leftRoomData, 2))) > 0) {
                                leftBound2 = objPosX2 += leftPosX * 30;
                                rightBound2 = objPosX2 + width2;
                                if (minX < rightBound2 && maxX > leftBound2 || minX > leftBound2 && maxX < rightBound2 || minX < leftBound2 && maxX > leftBound2 || minX < rightBound2 && maxX > rightBound2) {
                                    return this.curPosY >= leftDisY && moveTo <= leftDisY ? this.curPosY - leftDisY : moveOffset;
                                }
                            }
                            if (Room.IsCornerWallId(leftRoomData)) {
                                return leftDisY >= moveTo ? this.curPosY - leftDisY : moveOffset;
                            }
                            if (!Room.IsCornerWallId(rightRoomData)) continue;
                            return rightDisY >= moveTo ? this.curPosY - rightDisY : moveOffset;
                        }
                    }
                    break;
                }
                case 1: {
                    int posY2;
                    int rightBound;
                    int leftBound;
                    int width;
                    int rWidth;
                    int lWidth;
                    int objPosX;
                    int minX = curPosX - widthOffset;
                    int maxX = curPosX + widthOffset;
                    int leftPosX = minX / 30;
                    int rightPosX = maxX / 30;
                    int posY1 = this.curPosY / 30;
                    int leftRoomData = Room.GetObjectId(leftPosX, posY1);
                    int rightRoomData = Room.GetObjectId(rightPosX, posY1);
                    int objPosY = posY1 * 30;
                    int leftDisY = objPosY + Room.GetObstructionDistance(leftRoomData, direct);
                    int rightDisY = objPosY + Room.GetObstructionDistance(rightRoomData, direct);
                    int moveTo = this.curPosY + moveOffset;
                    if (Room.IsCornerWallId(leftRoomData)) {
                        return leftDisY <= moveTo ? leftDisY - this.curPosY - 1 : moveOffset;
                    }
                    if (Room.IsCornerWallId(rightRoomData)) {
                        return rightDisY <= moveTo ? rightDisY - this.curPosY - 1 : moveOffset;
                    }
                    if (rightRoomData != -1) {
                        objPosX = Room.GetObstructionDistance(rightRoomData, 3);
                        lWidth = 30 - Room.GetObstructionDistance(rightRoomData, 2);
                        width = lWidth - (rWidth = objPosX);
                        if (width > 0) {
                            leftBound = objPosX += rightPosX * 30;
                            rightBound = objPosX + width;
                            if (minX < rightBound && maxX > leftBound || minX > leftBound && maxX < rightBound || minX < leftBound && maxX > leftBound || minX < rightBound && maxX > rightBound) {
                                if (moveTo >= rightDisY) {
                                    if (changeRoomData && (this.GetType() == 20 || this.GetType() == 21) && leftPosX == rightPosX && Room.IsCloseDoorYId(rightRoomData)) {
                                        this.OpenTheDoor(rightRoomData + 1, leftPosX, posY1);
                                    }
                                    return rightDisY - this.curPosY - 1;
                                }
                                return moveOffset;
                            }
                        }
                    }
                    if (leftPosX != rightPosX && leftRoomData != -1 && (width = (rWidth = 30 - (objPosX = Room.GetObstructionDistance(leftRoomData, 3))) - (lWidth = Room.GetObstructionDistance(leftRoomData, 2))) > 0) {
                        leftBound = objPosX += leftPosX * 30;
                        rightBound = objPosX + width;
                        if (minX < rightBound && maxX > leftBound || minX > leftBound && maxX < rightBound || minX < leftBound && maxX > leftBound || minX < rightBound && maxX > rightBound) {
                            if (moveTo >= leftDisY) {
                                return leftDisY - this.curPosY - 1;
                            }
                            return moveOffset;
                        }
                    }
                    if (posY1 != (posY2 = moveTo / 30)) {
                        while (++posY1 <= posY2) {
                            int rightBound3;
                            int leftBound3;
                            int width3;
                            int rWidth4;
                            int lWidth4;
                            int objPosX3;
                            leftRoomData = Room.GetObjectId(leftPosX, posY1);
                            rightRoomData = Room.GetObjectId(rightPosX, posY1);
                            leftDisY = (objPosY += 30) + Room.GetObstructionDistance(leftRoomData, direct);
                            rightDisY = objPosY + Room.GetObstructionDistance(rightRoomData, direct);
                            if (rightRoomData != -1) {
                                objPosX3 = Room.GetObstructionDistance(rightRoomData, 3);
                                lWidth4 = 30 - Room.GetObstructionDistance(rightRoomData, 2);
                                width3 = lWidth4 - (rWidth4 = objPosX3);
                                if (width3 > 0) {
                                    leftBound3 = objPosX3 += rightPosX * 30;
                                    rightBound3 = objPosX3 + width3;
                                    if (minX < rightBound3 && maxX > leftBound3 || minX > leftBound3 && maxX < rightBound3 || minX < leftBound3 && maxX > leftBound3 || minX < rightBound3 && maxX > rightBound3) {
                                        return moveTo >= rightDisY ? rightDisY - this.curPosY - 1 : moveOffset;
                                    }
                                }
                            }
                            if (leftPosX == rightPosX || leftRoomData == -1 || (width3 = (rWidth4 = 30 - (objPosX3 = Room.GetObstructionDistance(leftRoomData, 3))) - (lWidth4 = Room.GetObstructionDistance(leftRoomData, 2))) <= 0) continue;
                            leftBound3 = objPosX3 += leftPosX * 30;
                            rightBound3 = objPosX3 + width3;
                            if (!(minX < rightBound3 && maxX > leftBound3 || minX > leftBound3 && maxX < rightBound3 || minX < leftBound3 && maxX > leftBound3) && (minX >= rightBound3 || maxX <= rightBound3)) continue;
                            return moveTo >= leftDisY ? leftDisY - this.curPosY - 1 : moveOffset;
                        }
                    }
                    break;
                }
                case 2: {
                    int leftPosX2;
                    int downDisY2;
                    int upDisY2;
                    int objPosY2;
                    int minX = curPosX - widthOffset;
                    int leftPosX1 = minX / 30;
                    int posY = this.curPosY / 30;
                    int leftRoomData = Room.GetObjectId(leftPosX1, posY);
                    int objPosX = (leftPosX1 + 1) * 30;
                    int leftDisX = objPosX - Room.GetObstructionDistance(leftRoomData, direct);
                    int moveTo = minX - moveOffset;
                    if (leftRoomData != -1 && leftDisX <= minX) {
                        if (leftDisX >= moveTo) {
                            if (!Room.IsCornerWallId(leftRoomData)) {
                                int downDisY2;
                                int upDisY2;
                                int objPosY2 = posY * 30;
                                int objDis = Room.GetObstructionDistance(leftRoomData, 0);
                                if (objDis < 30 && this.curPosY > (upDisY2 = objPosY2 + 30 - objDis)) {
                                    return moveOffset;
                                }
                                objDis = Room.GetObstructionDistance(leftRoomData, 1);
                                if (objDis < 30 && this.curPosY < (downDisY2 = objPosY2 + Room.GetObstructionDistance(leftRoomData, 1))) {
                                    return moveOffset;
                                }
                            }
                            if (changeRoomData && (this.GetType() == 20 || this.GetType() == 21) && Room.IsCloseDoorXId(leftRoomData)) {
                                this.OpenTheDoor(-1, leftPosX1, posY);
                            }
                            return minX - leftDisX;
                        }
                        objPosY2 = posY * 30;
                        upDisY2 = objPosY2 + 30 - Room.GetObstructionDistance(leftRoomData, 0);
                        downDisY2 = objPosY2 + Room.GetObstructionDistance(leftRoomData, 1);
                        if (this.curPosY < upDisY2 && this.curPosY > downDisY2) {
                            return minX - leftDisX > moveOffset ? moveOffset : minX - leftDisX;
                        }
                    }
                    if (leftPosX1 != (leftPosX2 = moveTo / 30)) {
                        while (--leftPosX1 >= leftPosX2) {
                            leftRoomData = Room.GetObjectId(leftPosX1, posY);
                            leftDisX = (objPosX -= 30) - Room.GetObstructionDistance(leftRoomData, direct);
                            if (leftRoomData == -1 || leftDisX > minX) continue;
                            if (leftDisX >= moveTo) {
                                if (!Room.IsCornerWallId(leftRoomData)) {
                                    objPosY2 = posY * 30;
                                    int objDis = Room.GetObstructionDistance(leftRoomData, 0);
                                    if (objDis < 30 && this.curPosY > (upDisY2 = objPosY2 + 30 - objDis)) {
                                        return moveOffset;
                                    }
                                    objDis = Room.GetObstructionDistance(leftRoomData, 1);
                                    if (objDis < 30 && this.curPosY < (downDisY2 = objPosY2 + Room.GetObstructionDistance(leftRoomData, 1))) {
                                        return moveOffset;
                                    }
                                }
                                if (changeRoomData && (this.GetType() == 20 || this.GetType() == 21) && Room.IsCloseDoorXId(leftRoomData)) {
                                    this.OpenTheDoor(-1, leftPosX1, posY);
                                }
                                return minX - leftDisX;
                            }
                            objPosY2 = posY * 30;
                            upDisY2 = objPosY2 + 30 - Room.GetObstructionDistance(leftRoomData, 0);
                            downDisY2 = objPosY2 + Room.GetObstructionDistance(leftRoomData, 1);
                            if (this.curPosY >= upDisY2 || this.curPosY <= downDisY2) continue;
                            return minX - leftDisX > moveOffset ? moveOffset : minX - leftDisX;
                        }
                    }
                    break;
                }
                case 3: {
                    int rightPosX2;
                    int downDisY3;
                    int upDisY3;
                    int objPosY3;
                    int maxX = curPosX + widthOffset;
                    int rightPosX1 = maxX / 30;
                    int posY = this.curPosY / 30;
                    int rightRoomData = Room.GetObjectId(rightPosX1, posY);
                    int objPosX = rightPosX1 * 30;
                    int rightDisX = objPosX + Room.GetObstructionDistance(rightRoomData, direct);
                    int moveTo = maxX + moveOffset;
                    if (rightRoomData != -1 && rightDisX >= maxX) {
                        if (rightDisX <= moveTo) {
                            if (!Room.IsCornerWallId(rightRoomData)) {
                                int downDisY3;
                                int upDisY3;
                                int objPosY3 = posY * 30;
                                int objDis = Room.GetObstructionDistance(rightRoomData, 0);
                                if (objDis < 30 && this.curPosY > (upDisY3 = objPosY3 + 30 - objDis)) {
                                    return moveOffset;
                                }
                                objDis = Room.GetObstructionDistance(rightRoomData, 1);
                                if (objDis < 30 && this.curPosY < (downDisY3 = objPosY3 + Room.GetObstructionDistance(rightRoomData, 1))) {
                                    return moveOffset;
                                }
                            }
                            if (changeRoomData && (this.GetType() == 20 || this.GetType() == 21) && Room.IsCloseDoorXId(rightRoomData)) {
                                this.OpenTheDoor(-1, rightPosX1, posY);
                            }
                            return rightDisX - maxX - 1;
                        }
                        objPosY3 = posY * 30;
                        upDisY3 = objPosY3 + 30 - Room.GetObstructionDistance(rightRoomData, 0);
                        downDisY3 = objPosY3 + Room.GetObstructionDistance(rightRoomData, 1);
                        if (this.curPosY < upDisY3 && this.curPosY > downDisY3) {
                            return rightDisX - maxX - 1 > moveOffset ? moveOffset : rightDisX - maxX - 1;
                        }
                    }
                    if (rightPosX1 == (rightPosX2 = moveTo / 30)) break;
                    while (++rightPosX1 <= rightPosX2) {
                        rightRoomData = Room.GetObjectId(rightPosX1, posY);
                        rightDisX = (objPosX += 30) + Room.GetObstructionDistance(rightRoomData, direct);
                        if (rightRoomData == -1 || rightDisX < maxX) continue;
                        if (rightDisX <= moveTo) {
                            if (!Room.IsCornerWallId(rightRoomData)) {
                                objPosY3 = posY * 30;
                                int objDis = Room.GetObstructionDistance(rightRoomData, 0);
                                if (objDis < 30 && this.curPosY > (upDisY3 = objPosY3 + 30 - objDis)) {
                                    return moveOffset;
                                }
                                objDis = Room.GetObstructionDistance(rightRoomData, 1);
                                if (objDis < 30 && this.curPosY < (downDisY3 = objPosY3 + Room.GetObstructionDistance(rightRoomData, 1))) {
                                    return moveOffset;
                                }
                            }
                            if (changeRoomData && (this.GetType() == 20 || this.GetType() == 21) && Room.IsCloseDoorXId(rightRoomData)) {
                                this.OpenTheDoor(-1, rightPosX1, posY);
                            }
                            return rightDisX - maxX - 1;
                        }
                        objPosY3 = posY * 30;
                        upDisY3 = objPosY3 + 30 - Room.GetObstructionDistance(rightRoomData, 0);
                        downDisY3 = objPosY3 + Room.GetObstructionDistance(rightRoomData, 1);
                        if (this.curPosY >= upDisY3 || this.curPosY <= downDisY3) continue;
                        return rightDisX - maxX - 1 > moveOffset ? moveOffset : rightDisX - maxX - 1;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return moveOffset;
    }

    public void SetMessage(String[] newMsg, int timer) {
        this.msgTimer = timer;
        this.msg = newMsg;
    }

    public int GetMessageTimer() {
        return this.msgTimer;
    }

    public int GetMessageHeight(Image img, String[] msg, int imgHeight, int gap) {
        if (msg == null) {
            return 0;
        }
        int strHeight = GameManager.font1.getHeight();
        strHeight = gap * 2 + (imgHeight > strHeight * msg.length ? imgHeight : strHeight * msg.length);
        return strHeight;
    }

    public void DrawMessage(Graphics g) {
        int msgHeight = this.GetMessageHeight(this.img, this.msg, 24, 4);
        this.DrawMessage(g, this.msg, 0, 208 - msgHeight, 24, 24, 4, 0xFF0000, 0xFFFFFF);
    }

    public void DrawMessage(Graphics g, String[] msg, int topPosX, int topPosY, int imgWidth, int imgHeight, int gap, int msgColor, int backColor) {
        if (this.msgTimer > 0) {
            --this.msgTimer;
        }
        if (msg == null) {
            return;
        }
        int strHeight = GameManager.font1.getHeight();
        int msgWidth = 176;
        int msgHeight = this.GetMessageHeight(this.img, msg, imgHeight, gap);
        g.setClip(topPosX, topPosY, msgWidth, msgHeight);
        g.setColor(255);
        g.fillRect(topPosX, topPosY, msgWidth, msgHeight);
        g.setColor(backColor);
        g.fillRect(topPosX + 2, topPosY + 2, msgWidth - 4, msgHeight - 4);
        g.setColor(msgColor);
        int i = 0;
        while (i < msg.length) {
            g.drawString(msg[i], topPosX + gap * 2 + imgWidth, topPosY + gap + strHeight * i, 20);
            ++i;
        }
        g.setClip(topPosX + gap, topPosY + gap, imgWidth, imgHeight);
        g.drawImage(this.img, topPosX - 192 + gap, topPosY - 72 + gap, 20);
    }

    public void DrawItem(Graphics g, int itemId, int posX, int posY) {
        int pType = this.GetType();
        if (itemId == 10 || itemId == 11 || itemId == 12 || itemId == 13) {
            itemId = 3;
        } else if (itemId == 7 || itemId == 8 || itemId == 9) {
            itemId = 7;
        } else if (itemId == 14 || itemId == 15 || itemId == 16) {
            itemId = 8;
        } else if (itemId == 17 || itemId == 18) {
            itemId = 5;
        } else if (itemId == 19) {
            itemId = 0;
            pType = 20;
        }
        g.setClip(posX, posY, 21, 21);
        g.drawImage(MovingObject.weaponImg, posX - itemId * 21, pType == 20 && itemId < 3 ? posY - 342 : posY - 363, 20);
    }

    public void DrawMenu(Graphics g, int posX, int posY) {
        g.setClip(posX, posY, 176, 30);
        g.setColor(0);
        g.fillRect(posX + 96, posY + 16, 38, 5);
        g.setColor(255);
        g.fillRect(posX + 96, posY + 16, this.gauge / 3, 5);
        g.drawImage(MovingObject.weaponImg, posX, posY - 384, 20);
        g.setClip(posX + 3, posY + 3, 24, 24);
        g.drawImage(this.img, posX - 189, posY - 69, 20);
        if (this.GetNumWeapon() > 0) {
            this.DrawItem(g, this.weaponId, posX + 149, posY + 5);
        }
        g.setClip(posX, posY, 176, 30);
        g.setColor(0xFF0000);
        g.drawString(String.valueOf(this.hp), posX + 65, posY + 10, 20);
    }

    public void DrawExplosion(Graphics g, int exType, int xOffset, int yOffset) {
        if (++this.stage > (exType == 40 ? 2 : 1)) {
            this.stage = 0;
            this.explosionStage = this.explosionStage < 2 ? ++this.explosionStage : 0;
        }
        int posX = xOffset + this.GetCenterLocationX() - 12;
        int posY = yOffset + this.GetCenterLocationY() - 12;
        g.setClip(posX, posY, 25, 25);
        g.drawImage(MovingObject.weaponImg, posX - this.explosionStage * 25 - 114, posY - exType * 25 - 268, 20);
    }

    public void Draw(Graphics g, int xOffset, int yOffset) {
        int width = this.actionImgWidth;
        int height = this.curLoc.GetHeight();
        int posX = xOffset + this.curLoc.GetX() + this.bodyOffsetX;
        int posY = yOffset + this.curLoc.GetY();
        if (this.invisible > 0) {
            g.setColor(this.damage < 0 ? 0xFF0000 : 65280);
            g.setClip(0, 0, 176, 178);
            g.drawString(String.valueOf(Math.abs(this.damage)), posX + width / 2, posY - 11, 20);
            if (this.invisible % 2 > 0) {
                return;
            }
        }
        switch (this.actionId) {
            default: {
                g.setClip(posX, posY, width, height);
                if (this.direction != 3) {
                    g.drawImage(this.img, posX, posY - this.direction * height, 20);
                    break;
                }
                DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                dg.drawImage(this.img, posX - this.img.getWidth() + width, posY - 2 * height, 20, 8192);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                g.setClip(posX, posY, width, height);
                if (this.direction != 3) {
                    g.drawImage(this.img, posX - this.drawImgId * width, posY - this.direction * height, 20);
                    break;
                }
                DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                dg.drawImage(this.img, posX - this.img.getWidth() + (this.drawImgId + 1) * width, posY - 2 * height, 20, 8192);
                break;
            }
            case 3: {
                g.setClip(posX, posY, width, height);
                if (this.direction != 3) {
                    g.drawImage(this.img, posX - this.drawImgId * width, posY - this.direction * height, 20);
                    if (this.GetNumWeapon() <= 0 || this.GetType() == 21 && this.GetWeaponId() == 2) break;
                    if (this.GetType() == 20 || this.GetType() == 22) {
                        switch (this.drawImgId) {
                            case 3: {
                                if (this.direction == 0) {
                                    posX -= 18;
                                    posY -= 2;
                                } else if (this.direction == 1) {
                                    --posX;
                                    posY -= 7;
                                } else {
                                    posX -= 3;
                                    posY -= 3;
                                }
                                g.setClip(posX, posY, 38, 38);
                                g.drawImage(MovingObject.weaponImg, posX, posY - this.direction * 38 - this.weaponId * 114, 20);
                                break;
                            }
                            case 4: {
                                if (this.direction == 0) {
                                    posX -= 4;
                                    posY -= 20;
                                } else if (this.direction == 1) {
                                    posX -= 8;
                                    posY += 10;
                                } else {
                                    posX -= 16;
                                    posY -= 13;
                                }
                                g.setClip(posX, posY, 38, 38);
                                g.drawImage(MovingObject.weaponImg, posX - 38, posY - this.direction * 38 - this.weaponId * 114, 20);
                                break;
                            }
                            case 5: {
                                if (this.direction == 0) {
                                    posX += 5;
                                    posY += 2;
                                } else if (this.direction == 1) {
                                    posX -= 19;
                                    posY -= 17;
                                } else {
                                    posX += 6;
                                    posY -= 15;
                                }
                                g.setClip(posX, posY, 38, 38);
                                g.drawImage(MovingObject.weaponImg, posX - 76, posY - this.direction * 38 - this.weaponId * 114, 20);
                            }
                        }
                        break;
                    }
                    if (this.GetType() != 21) break;
                    switch (this.drawImgId) {
                        case 4: {
                            if (this.direction == 0) {
                                posX -= 3;
                                posY -= 5;
                            } else if (this.direction == 1) {
                                posX -= 8;
                                posY -= 6;
                            } else {
                                posX -= 11;
                                posY -= 5;
                            }
                            g.setClip(posX, posY, 38, 38);
                            g.drawImage(MovingObject.weaponImg, posX - 114, posY - this.direction * 38 - this.weaponId * 114, 20);
                            break;
                        }
                        case 5: {
                            if (this.direction == 0) {
                                posX -= 7;
                                posY -= 8;
                            } else if (this.direction == 1) {
                                posX -= 7;
                                posY -= 5;
                            } else {
                                posX -= 12;
                                posY -= 7;
                            }
                            g.setClip(posX, posY, 38, 38);
                            g.drawImage(MovingObject.weaponImg, posX - 152, posY - this.direction * 38 - this.weaponId * 114, 20);
                        }
                    }
                    break;
                }
                DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                dg.drawImage(this.img, posX - this.img.getWidth() + (this.drawImgId + 1) * width, posY - 2 * height, 20, 8192);
                if (this.GetNumWeapon() <= 0 || this.GetType() == 21 && this.GetWeaponId() == 2) break;
                if (this.GetType() == 20 || this.GetType() == 22) {
                    switch (this.drawImgId) {
                        case 3: {
                            g.setClip(posX -= 11, posY -= 3, 38, 38);
                            dg.drawImage(MovingObject.weaponImg, posX - MovingObject.weaponImg.getWidth() + 38, posY - 76 - this.weaponId * 114, 20, 8192);
                            break;
                        }
                        case 4: {
                            g.setClip(posX += 2, posY -= 13, 38, 38);
                            dg.drawImage(MovingObject.weaponImg, posX - MovingObject.weaponImg.getWidth() + 76, posY - 76 - this.weaponId * 114, 20, 8192);
                            break;
                        }
                        case 5: {
                            g.setClip(posX -= 20, posY -= 15, 38, 38);
                            dg.drawImage(MovingObject.weaponImg, posX - MovingObject.weaponImg.getWidth() + 114, posY - 76 - this.weaponId * 114, 20, 8192);
                        }
                    }
                    break;
                }
                if (this.GetType() == 21) {
                    switch (this.drawImgId) {
                        case 4: {
                            g.setClip(posX -= 3, posY -= 5, 38, 38);
                            dg.drawImage(MovingObject.weaponImg, posX - MovingObject.weaponImg.getWidth() + 152, posY - 76 - this.weaponId * 114, 20, 8192);
                            break;
                        }
                        case 5: {
                            g.setClip(posX -= 2, posY -= 7, 38, 38);
                            dg.drawImage(MovingObject.weaponImg, posX - MovingObject.weaponImg.getWidth() + 190, posY - 76 - this.weaponId * 114, 20, 8192);
                        }
                    }
                }
                break;
            }
            case 7: {
                g.setClip(posX, posY, width, height);
                if (this.actionScript <= 0) {
                    if (this.direction != 3) {
                        g.drawImage(this.img, posX - this.drawImgId * width, posY - this.direction * height, 20);
                        break;
                    }
                    DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                    dg.drawImage(this.img, posX - this.img.getWidth() + (this.drawImgId + 1) * width, posY - 2 * height, 20, 8192);
                    break;
                }
                if (this.direction != 3) {
                    g.drawImage(this.img, posX - this.drawImgId * width, posY - height * 3, 20);
                    break;
                }
                DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                dg.drawImage(this.img, posX - this.img.getWidth() + (this.drawImgId + 1) * width, posY - height * 3, 20, 8192);
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                g.setClip(posX, posY, width, height);
                g.drawImage(this.img, posX - this.drawImgId * width, posY - height * 3, 20);
                break;
            }
            case 10: {
                g.setClip(posX, posY, width, height);
                g.drawImage(this.img, posX - this.drawImgId * width, posY - height, 20);
                this.DrawItem(g, this.newItem, posX + 3, posY - 13);
            }
        }
        if (!(this.GetType() != 22 || this.IsDead() || this.actionId != 6 && this.actionId != 7)) {
            this.DrawExplosion(g, 0, xOffset, yOffset);
        }
    }

    public void Run(int pLocX, int pLocY) {
        if (this.GetType() == 22 && this.GetHP() > 0) {
            this.SelectAction(pLocX, pLocY);
        }
        this.Run();
        if (this.isMoving) {
            this.UpdateCanMove(this.speedX, this.moveDis);
        }
    }

    public void SelectAction(int pLocX, int pLocY) {
        int distance = this.FindDistance(pLocX, pLocY);
        int disX = this.GetCenterLocationX() - pLocX;
        int disY = this.GetCenterLocationY() - pLocY;
        block0 : switch (this.GetType()) {
            case 22: {
                if (this.actionId == 6) break;
                if (distance < 150 && this.actionId != 3) {
                    int newDir = this.FindDirectionType3(pLocX, pLocY);
                    this.SetDirection(newDir != -1 ? newDir : GameManager.Random(4));
                }
                if (Math.abs(disY) < 5 && distance > 50) {
                    this.SetDirection(disX > 0 ? 2 : 3);
                    this.ChangeAction(3);
                    break;
                }
                if (Math.abs(disX) < 5 && distance > 50) {
                    this.SetDirection(disY > 0 ? 0 : 2);
                    this.ChangeAction(3);
                    break;
                }
                if (distance > 200) {
                    this.ChangeAction(0);
                    break;
                }
                if (distance < 20) {
                    this.ChangeAction(3);
                    break;
                }
                switch (GameManager.Random(5)) {
                    case 0: {
                        this.ChangeAction(1);
                        break block0;
                    }
                    default: {
                        this.ChangeAction(2);
                        break block0;
                    }
                    case 2: {
                        this.ChangeAction(4);
                        break block0;
                    }
                    case 3: 
                }
                this.ChangeAction(8);
            }
        }
    }

    public int FindDirectionType3(int locX, int locY) {
        int disX = this.GetCenterLocationX() - locX;
        int disY = this.GetCenterLocationY() - locY;
        if (Math.abs(disX) < Math.abs(disY)) {
            if (disX == 0) {
                if (disY > 0 && this.canMoveUp && this.oldDirection != 0) {
                    this.oldDirection = 1;
                    return 0;
                }
                if (this.canMoveDown && this.oldDirection != 1) {
                    this.oldDirection = 0;
                    return 1;
                }
            } else {
                if (disX > 0 && this.canMoveLeft && this.oldDirection != 2) {
                    this.oldDirection = 3;
                    return 2;
                }
                if (disY > 0 && this.canMoveUp && this.oldDirection != 0) {
                    this.oldDirection = 1;
                    return 0;
                }
                if (this.canMoveDown && this.oldDirection != 1) {
                    this.oldDirection = 0;
                    return 1;
                }
                if (this.canMoveRight && this.oldDirection != 3) {
                    this.oldDirection = 2;
                    return 3;
                }
            }
        } else if (disY == 0) {
            if (disX > 0 && this.canMoveLeft && this.oldDirection != 2) {
                this.oldDirection = 3;
                return 2;
            }
            if (this.canMoveRight && this.oldDirection != 3) {
                this.oldDirection = 2;
                return 3;
            }
        } else {
            if (disY > 0 && this.canMoveUp && this.oldDirection != 0) {
                this.oldDirection = 1;
                return 0;
            }
            if (disX > 0 && this.canMoveLeft && this.oldDirection != 2) {
                this.oldDirection = 3;
                return 2;
            }
            if (this.canMoveRight && this.oldDirection != 3) {
                this.oldDirection = 2;
                return 3;
            }
            if (this.canMoveDown && this.oldDirection != 1) {
                this.oldDirection = 0;
                return 1;
            }
        }
        return -1;
    }

    public void UpdateCanMove(int moveDis, int canMoveDis) {
        if (canMoveDis < moveDis) {
            switch (this.GetDirection()) {
                case 0: {
                    this.canMoveUp = false;
                    break;
                }
                case 1: {
                    this.canMoveDown = false;
                    break;
                }
                case 2: {
                    this.canMoveLeft = false;
                    break;
                }
                case 3: {
                    this.canMoveRight = false;
                }
            }
        } else {
            this.canMoveUp = true;
            this.canMoveDown = true;
            this.canMoveLeft = true;
            this.canMoveRight = true;
        }
    }

    static {
        LEG_OFFSET = 3;
    }
}

