/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class ClockCanvasBackup
extends GameCanvas {
    final int ANIMATION_FPS;
    final int START_CLOCK_FPS;
    final int MUSICSTART;
    int musicCounter = 40;
    boolean musicPlaying = false;
    Display display;
    private int gameTicks = 0;
    int animCounter = 0;
    int dispTicks = 0;
    String dispText = "";
    int level = 1;
    int speed = 1;
    int xM_Pointer;
    int yM_Pointer;
    int xH_Pointer;
    int yH_Pointer;
    int lineLength = 64;
    int[] xTable = new int[]{0, 7, 13, 20, 26, 32, 38, 43, 48, 52, 56, 59, 61, 62, 63, 64};
    int[] yTable = new int[]{64, 63, 62, 61, 59, 56, 52, 48, 43, 38, 32, 26, 20, 13, 7, 0};
    int pauze = 0;
    boolean initialized = false;
    boolean repainting = false;
    int lineCenterX = 88;
    int lineCenterY = 125;
    private Image bg;
    private Image textLoose;
    private Image textWin;
    private Image zoom;
    private Image help;
    private Image logo;
    private boolean showHelp = true;
    private int animStatus = 0;
    private int animStatusOld = 0;
    private int nextAnimStatus;
    String[] anim = new String[]{"standby", "start", "clock", "loose", "win", "vuurwerk"};
    int winMargin = 5;
    private int minutesPerFrame = 1;
    private int game_fps = 40;
    private int gameTime = 0;
    private boolean antiCheat = true;
    Player audioPlayer;

    public ClockCanvasBackup(Display display) {
        super(false);
        this.ANIMATION_FPS = 40;
        this.START_CLOCK_FPS = 20;
        this.MUSICSTART = 40;
        this.display = display;
        this.setFullScreenMode(true);
        try {
            this.bg = Image.createImage((String)"/background176.png");
            this.zoom = Image.createImage((String)"/zoom176.png");
            this.textLoose = Image.createImage((String)"/textloose.png");
            this.textWin = Image.createImage((String)"/textwin.png");
            this.help = Image.createImage((String)"/help176.png");
            this.logo = Image.createImage((String)"/sonylogo.png");
            try {
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/jingle.mp3");
                this.audioPlayer = Manager.createPlayer((InputStream)inputStream, (String)"audio/mpeg");
            }
            catch (MediaException mediaException) {
                System.out.println("MediaException");
            }
        }
        catch (IOException iOException) {
            System.out.println("I/O exception.");
        }
    }

    public void setGameFPS(int n) {
        this.game_fps = n;
    }

    public int getGameFPS() {
        return this.game_fps;
    }

    void start() {
        this.display.setCurrent((Displayable)this);
        this.repaint();
    }

    void check() {
        if (this.gameTime >= 720 - this.winMargin || this.gameTime <= this.winMargin) {
            this.resetClock();
            this.displayMessage("great!");
            this.nextAnimStatus = 4;
            this.animCounter = 35;
        } else {
            this.nextAnimStatus = 3;
            this.animCounter = 0;
            if (this.winMargin < 15) {
                this.winMargin += this.winMargin;
            }
        }
    }

    void setAnimStatus(int n, int n2) {
        this.animStatus = n;
        this.animCounter = n2;
        if (this.animStatus != 2) {
            this.game_fps = 40;
        } else {
            this.game_fps = 20;
            this.resetClock();
        }
    }

    void displayMessage(String string) {
        this.dispText = string;
        this.dispTicks = 50;
    }

    void pauze() {
        this.pauze = 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void advance() {
        if (this.animCounter >= 1) {
            if (this.animCounter == 1 && this.animStatus == 1) {
                this.setAnimStatus(2, 0);
            } else if (this.animCounter == 1 && this.animStatus == 3) {
                this.setAnimStatus(2, 0);
            } else if (this.animCounter == 1 && this.animStatus == 4) {
                this.setAnimStatus(5, 0);
            } else if (this.animCounter == 1 && this.animStatus == 5) {
                this.setAnimStatus(2, 0);
            }
            --this.animCounter;
        }
        if (this.animStatus == 2) {
            if (this.pauze > 0) {
                --this.pauze;
                if (this.pauze == 0) {
                    this.setAnimStatus(this.nextAnimStatus, this.animCounter);
                }
            } else {
                this.updateTime();
                this.calculatePointers();
            }
        }
        this.animStatusOld = this.animStatus;
        try {
            this.paint(this.getGraphics());
            this.flushGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClockCanvasBackup clockCanvasBackup = this;
        synchronized (clockCanvasBackup) {
            try {
                ((Object)((Object)this)).wait(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void calculatePointers() {
        int n = this.gameTime % 60;
        if (n < 15) {
            this.xM_Pointer = this.xTable[n] / 2;
            this.yM_Pointer = -this.yTable[n] / 2;
        } else if (n < 30) {
            this.xM_Pointer = this.yTable[n - 15] / 2;
            this.yM_Pointer = this.xTable[n - 15] / 2;
        } else if (n < 45) {
            this.xM_Pointer = -this.xTable[n - 30] / 2;
            this.yM_Pointer = this.yTable[n - 30] / 2;
        } else if (n < 60) {
            this.xM_Pointer = -this.yTable[n - 45] / 2;
            this.yM_Pointer = -this.xTable[n - 45] / 2;
        }
        int n2 = this.gameTime / 12;
        if (n2 < 15) {
            this.xH_Pointer = this.xTable[n2] / 3;
            this.yH_Pointer = -this.yTable[n2] / 3;
        } else if (n2 < 30) {
            this.xH_Pointer = this.yTable[n2 - 15] / 3;
            this.yH_Pointer = this.xTable[n2 - 15] / 3;
        } else if (n2 < 45) {
            this.xH_Pointer = -this.xTable[n2 - 30] / 3;
            this.yH_Pointer = this.yTable[n2 - 30] / 3;
        } else if (n2 < 60) {
            this.xH_Pointer = -this.yTable[n2 - 45] / 3;
            this.yH_Pointer = -this.xTable[n2 - 45] / 3;
        }
    }

    private void updateTime() {
        ++this.gameTicks;
        if (this.gameTicks % 2 == 0) {
            if (this.minutesPerFrame == 4) {
                if (this.game_fps < 40) {
                    ++this.game_fps;
                }
            } else {
                ++this.game_fps;
            }
        }
        if (this.game_fps == 40 && this.minutesPerFrame < 4) {
            this.minutesPerFrame *= 2;
            this.game_fps /= 2;
        }
        this.gameTime += this.minutesPerFrame;
        if (this.gameTime >= 719) {
            this.gameTime %= 720;
        }
        if (this.antiCheat && this.gameTime > 16) {
            this.antiCheat = false;
        }
    }

    private void resetClock() {
        this.antiCheat = true;
        this.gameTicks = 0;
        this.gameTime = 0;
        this.minutesPerFrame = 1;
    }

    public void toggleHelp() {
        this.showHelp = !this.showHelp;
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (n2 == 8 || n2 == 53) {
            try {
                this.audioPlayer.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            this.musicPlaying = false;
            if (!this.showHelp) {
                if (this.animStatus == 2 && !this.antiCheat) {
                    this.check();
                    this.pauze();
                } else if (this.animStatus == 0) {
                    this.setAnimStatus(1, 40);
                } else if (this.animStatus == 3) {
                    this.setAnimStatus(3, 30);
                } else if (this.animStatus == 4 || this.animStatus == 5) {
                    this.setAnimStatus(2, 0);
                }
            } else {
                this.showHelp = false;
            }
        }
    }

    void flushKeys() {
        this.getKeyStates();
    }

    public void paint(Graphics graphics) {
        this.repainting = true;
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setColor(0);
        graphics.fillRect(n, n2, n3, n4);
        if (this.animStatus != 2) {
            graphics.drawImage(this.bg, 0, 0, 20);
        } else {
            graphics.drawImage(this.zoom, 0, 0, 20);
        }
        if (this.animStatus != 2) {
            graphics.drawImage(this.logo, 0, 0, 20);
        }
        if (this.animStatus == 3) {
            graphics.drawImage(this.textLoose, n3 / 2 - this.textLoose.getWidth() / 2, 25, 20);
        }
        if (this.animStatus == 4 || this.animStatus == 5) {
            graphics.drawImage(this.textWin, n3 / 2 - this.textWin.getWidth() / 2, 150, 20);
            if (!this.musicPlaying) {
                try {
                    System.out.println("music playing");
                    this.audioPlayer.setLoopCount(1);
                    this.audioPlayer.start();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.musicPlaying = true;
            }
        }
        if (this.animStatus == 2) {
            graphics.setColor(3806735);
            graphics.drawLine(this.lineCenterX, this.lineCenterY, this.lineCenterX + this.xM_Pointer, this.lineCenterY + this.yM_Pointer);
            graphics.drawLine(this.lineCenterX + 1, this.lineCenterY, this.lineCenterX + 1 + this.xM_Pointer, this.lineCenterY + this.yM_Pointer);
            graphics.drawLine(this.lineCenterX, this.lineCenterY + 1, this.lineCenterX + this.xM_Pointer, this.lineCenterY + 1 + this.yM_Pointer);
            graphics.drawLine(this.lineCenterX + 1, this.lineCenterY + 1, this.lineCenterX + 1 + this.xM_Pointer, this.lineCenterY + 1 + this.yM_Pointer);
            graphics.drawLine(this.lineCenterX, this.lineCenterY, this.lineCenterX + this.xH_Pointer, this.lineCenterY + this.yH_Pointer);
            graphics.drawLine(this.lineCenterX + 1, this.lineCenterY, this.lineCenterX + 1 + this.xH_Pointer, this.lineCenterY + this.yH_Pointer);
            graphics.drawLine(this.lineCenterX, this.lineCenterY + 1, this.lineCenterX + this.xH_Pointer, this.lineCenterY + 1 + this.yH_Pointer);
            graphics.drawLine(this.lineCenterX + 1, this.lineCenterY + 1, this.lineCenterX + 1 + this.xH_Pointer, this.lineCenterY + 1 + this.yH_Pointer);
        }
        if (this.showHelp) {
            graphics.drawImage(this.help, n3 / 2 - this.help.getWidth() / 2, 0, 20);
        }
        Font font = graphics.getFont();
        graphics.setColor(0xFF0000);
        graphics.setFont(font);
        graphics.setColor(0xEEEEEE);
        graphics.drawString("Quit", 140, 200, 0);
        this.repainting = false;
    }
}

