/*
 * Decompiled with CFR 0.152.
 */
public class ClockThread
extends Thread {
    private int skip_ticks;
    private long nextGameTick = System.currentTimeMillis();
    private long sleepTime;
    private boolean pauze;
    private boolean initialized;
    private boolean stop;
    private ClockCanvas clockCanvas;

    ClockThread(ClockCanvas clockCanvas) {
        this.clockCanvas = clockCanvas;
    }

    void go() {
        if (!this.initialized) {
            this.initialized = true;
            this.start();
        } else {
            this.pauze = false;
        }
    }

    void pauze() {
        this.pauze = true;
    }

    void requestStop() {
        this.stop = true;
    }

    public void run() {
        this.clockCanvas.flushKeys();
        this.stop = false;
        this.pauze = false;
        while (!this.stop) {
            if (this.pauze) continue;
            this.skip_ticks = 1000 / this.clockCanvas.getGameFPS();
            this.nextGameTick += (long)this.skip_ticks;
            this.clockCanvas.advance();
            this.sleepTime = this.nextGameTick - System.currentTimeMillis();
            if (this.sleepTime <= 0L) continue;
            try {
                ClockThread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

