/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SOUND
implements PlayerListener {
    static SOUND sound = null;
    static final int MAX_MIDI = 8;
    Player[] player = new Player[8];
    String[] szFileName = new String[]{"ragmos_open.mid", "ragmos_field.mid", "ragmos_attack.mid", "ragmos_skill_1.mid", "ragmos_skill_2.mid", "menumove.mid", "ragmos_lvup.mid", "ragmos_miss.mid"};
    int[] bytesFileName = new int[]{3445, 3433, 126, 562, 121, 116, 571, 92};
    byte[][] midData = new byte[8][];
    InputStream[] midStream = new InputStream[8];
    int nowPlaying = -1;
    int nextPlaying = -1;
    boolean isPlay = false;

    void loadMid() {
        try {
            for (int i = 0; i < 8; ++i) {
                InputStream inputStream = Runtime.getRuntime().getClass().getResourceAsStream("/" + this.szFileName[i]);
                this.midData[i] = new byte[this.bytesFileName[i]];
                inputStream.read(this.midData[i]);
                inputStream.close();
                this.midStream[i] = new ByteArrayInputStream(this.midData[i]);
                this.player[i] = Manager.createPlayer((InputStream)this.midStream[i], (String)"audio/midi");
                this.player[i].addPlayerListener((PlayerListener)this);
                this.player[i].realize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    SOUND() {
        this.loadMid();
    }

    static SOUND getInstance() {
        if (sound == null) {
            sound = new SOUND();
        }
        return sound;
    }

    void play(int n) {
        if (!GameCanvas.isSound) {
            return;
        }
        if (n == 7) {
            return;
        }
        if (this.isPlay && (this.nowPlaying == 0 || this.nowPlaying == 1) && n != 0 && n != 1) {
            return;
        }
        if (this.isPlay && n != 0 && n != 1 && n != 6) {
            return;
        }
        if (this.isPlay && n == 6) {
            this.nextPlaying = 6;
            return;
        }
        this.stop();
        if (this.isPlay) {
            if (n == 0 || n == 1 || n == 6) {
                this.rePlay(n);
            }
            return;
        }
        try {
            if (n == 6) {
                this.player[6] = Manager.createPlayer((InputStream)new ByteArrayInputStream(this.midData[6]), (String)"audio/midi");
                this.player[6].addPlayerListener((PlayerListener)this);
                this.player[6].realize();
            }
            this.isPlay = true;
            this.player[n].start();
            this.nowPlaying = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void rePlay(int n) {
        this.nextPlaying = n;
    }

    void stop() {
        if (this.nowPlaying == -1) {
            return;
        }
        try {
            if (this.player[this.nowPlaying].getState() == 400) {
                this.player[this.nowPlaying].setMediaTime(0L);
                this.player[this.nowPlaying].stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string.equals("stopped") || string.equals("endOfMedia")) {
            if (this.nowPlaying == 6) {
                this.player[6].close();
                this.player[2].close();
                this.player[3].close();
                try {
                    this.player[2] = Manager.createPlayer((InputStream)new ByteArrayInputStream(this.midData[2]), (String)"audio/midi");
                    this.player[2].addPlayerListener((PlayerListener)this);
                    this.player[2].realize();
                    this.player[3] = Manager.createPlayer((InputStream)new ByteArrayInputStream(this.midData[2]), (String)"audio/midi");
                    this.player[3].addPlayerListener((PlayerListener)this);
                    this.player[3].realize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.isPlay = false;
            this.nowPlaying = -1;
            if (this.nextPlaying != -1) {
                this.play(this.nextPlaying);
                this.nextPlaying = -1;
            }
        } else if (string.equals("started")) {
            this.isPlay = true;
        }
    }
}

