/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class Character
implements KeyValue,
CommonValue {
    private Image Heart;
    private Image[] Character_Images = new Image[6];
    private int[] HEIGHT;
    private int[] WIDTH;
    public Sprite[] Character_Sprites;
    public int Activity;
    public int LookAt;
    private boolean moveJump;
    private int lastFrame;
    private int repeatNbr;
    private int lastRepeat;
    private int OldY;
    private boolean HoldAtLastFrame;
    public int PositionXL;
    public int PositionYL;
    public int BOUND_XMAX;
    private boolean falling;
    public int SCORE;
    public int Life;
    private long timeSinceLastChange;
    public Vector bulletList;
    private boolean SPECIAL_LEVEL;
    private boolean PLAY_EFFECT;
    private Player plGunShot;
    private Player plExplosion;

    public Character() {
        String string;
        InputStream inputStream;
        try {
            this.Character_Images[0] = Image.createImage((String)"/char_wait.png");
            this.Character_Images[1] = Image.createImage((String)"/char_walk.png");
            this.Character_Images[2] = Image.createImage((String)"/char_attack.png");
            this.Character_Images[3] = Image.createImage((String)"/char_jump.png");
            this.Character_Images[4] = Image.createImage((String)"/char_gun.png");
            this.Character_Images[5] = Image.createImage((String)"/char_fall.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.Heart = Image.createImage((String)"/heart.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Character_Sprites = new Sprite[6];
        this.Character_Sprites[0] = new Sprite(this.Character_Images[0], 40, 48);
        this.Character_Sprites[1] = new Sprite(this.Character_Images[1], 48, 44);
        this.Character_Sprites[2] = new Sprite(this.Character_Images[2], 56, 48);
        this.Character_Sprites[3] = new Sprite(this.Character_Images[3], 48, 43);
        this.Character_Sprites[4] = new Sprite(this.Character_Images[4], 57, 41);
        this.Character_Sprites[5] = new Sprite(this.Character_Images[5], 42, 42);
        this.HEIGHT = new int[6];
        this.HEIGHT[0] = 48;
        this.HEIGHT[1] = 44;
        this.HEIGHT[2] = 48;
        this.HEIGHT[3] = 43;
        this.HEIGHT[4] = 41;
        this.HEIGHT[5] = 42;
        this.WIDTH = new int[6];
        this.WIDTH[0] = 40;
        this.WIDTH[1] = 48;
        this.WIDTH[2] = 56;
        this.WIDTH[3] = 48;
        this.WIDTH[4] = 57;
        this.WIDTH[5] = 42;
        try {
            inputStream = this.getClass().getResourceAsStream("/gunshot.mid");
            string = "audio/midi";
            this.plGunShot = Manager.createPlayer((InputStream)inputStream, (String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inputStream = this.getClass().getResourceAsStream("/explosion.mid");
            string = "audio/midi";
            this.plExplosion = Manager.createPlayer((InputStream)inputStream, (String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(int n, boolean bl, boolean bl2, int n2) {
        this.Activity = 0;
        this.LookAt = 0;
        this.timeSinceLastChange = 0L;
        this.BOUND_XMAX = n;
        this.PositionXL = 64;
        this.PositionYL = 0;
        this.OldY = 0;
        this.Life = 3;
        this.bulletList = new Vector();
        this.repeatNbr = 0;
        this.HoldAtLastFrame = false;
        this.falling = false;
        this.SPECIAL_LEVEL = bl;
        this.PLAY_EFFECT = bl2;
        this.SCORE = n2;
    }

    public boolean Win() {
        if (this.PositionXL >= this.BOUND_XMAX) {
            if (this.Life == 1) {
                this.SCORE += 10;
            }
            if (this.Life == 2) {
                this.SCORE += 40;
            }
            this.SCORE = this.Life == 3 ? (this.SCORE += 80) : (this.SCORE += 100);
            return true;
        }
        return false;
    }

    public boolean LifeDown() {
        --this.Life;
        return this.Life == 0;
    }

    public void LifeUp() {
        ++this.Life;
        if (this.Life == 4) {
            this.Life = 3;
        }
    }

    public void DrawChar(Graphics graphics, long l, int[][] nArray) {
        int n;
        int n2 = this.Activity;
        if (this.falling) {
            this.Activity = 5;
        }
        if (this.LookAt == 0) {
            n = 0;
            if (this.Activity == 2) {
                n = 3;
            }
            this.Character_Sprites[this.Activity].setTransform(0);
            this.Character_Sprites[this.Activity].defineReferencePixel(n, 0);
        } else if (this.LookAt == 1) {
            this.Character_Sprites[this.Activity].setTransform(2);
            n = 0;
            if (this.Activity == 1) {
                n = -8;
            }
            if (this.Activity == 4) {
                n = -17;
            }
            if (this.Activity == 2) {
                n = -13;
            }
            this.Character_Sprites[this.Activity].defineReferencePixel(this.WIDTH[this.Activity] + n, 0);
        }
        this.timeSinceLastChange += l;
        if (this.timeSinceLastChange > 80L) {
            n = 1;
            if (this.Activity == 3 && (this.Character_Sprites[this.Activity].getFrame() == 2 || this.Character_Sprites[this.Activity].getFrame() == 4)) {
                if (this.repeatNbr < 9) {
                    ++this.repeatNbr;
                    n = 0;
                } else {
                    this.repeatNbr = 0;
                    n = 1;
                }
            }
            if (n != 0) {
                this.Character_Sprites[this.Activity].nextFrame();
                this.timeSinceLastChange = 0L;
            }
        }
        n = 60;
        if (this.PositionYL < 0) {
            n += this.PositionYL;
        }
        if (this.PositionYL > 80) {
            n += this.PositionYL - 80;
        }
        int n3 = 5;
        if (this.SPECIAL_LEVEL) {
            n3 = 0;
        }
        this.Character_Sprites[this.Activity].setRefPixelPosition(64, 220 - this.HEIGHT[this.Activity] - n + n3);
        this.Character_Sprites[this.Activity].paint(graphics);
        this.Activity = n2;
        this.falling = false;
    }

    public void DrawLife(Graphics graphics) {
        for (int i = 0; i < this.Life; ++i) {
            graphics.drawImage(this.Heart, 3 + i * 10, 3, 0);
        }
        graphics.setColor(0xFFFFFF);
        Font font = Font.getFont((int)0, (int)1, (int)0);
        graphics.setFont(font);
        graphics.drawString(" " + this.SCORE, 176, 0, 24);
    }

    public void DrawBullet(Graphics graphics, long l) {
        for (int i = 0; i < this.bulletList.size(); ++i) {
            if (!((Bullet)this.bulletList.elementAt(i)).Draw(graphics, this.PositionXL, this.PositionYL, l)) continue;
            this.bulletList.removeElementAt(i);
        }
    }

    public void CheckBullet(Vector vector, Enemy[] enemyArray) {
        for (int i = 0; i < this.bulletList.size(); ++i) {
            if (!((Bullet)this.bulletList.elementAt(i)).HurtEnemy(vector, enemyArray)) continue;
            try {
                if (this.PLAY_EFFECT) {
                    this.plExplosion.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.SCORE += 10;
        }
    }

    public boolean Actuate(int n, int[][] nArray) {
        int n2;
        boolean bl = this.HoldAtLastFrame;
        this.HoldAtLastFrame = false;
        if (this.Activity == 3) {
            if (this.PerformJump(nArray)) {
                return false;
            }
            if (1 + this.Character_Sprites[this.Activity].getFrame() >= this.Character_Sprites[this.Activity].getFrameSequenceLength()) {
                this.Activity = 0;
            }
            return false;
        }
        if (this.Activity == 2) {
            if (1 + this.Character_Sprites[this.Activity].getFrame() >= this.Character_Sprites[this.Activity].getFrameSequenceLength()) {
                this.Activity = 0;
            }
            return false;
        }
        if (this.FallDown(nArray)) {
            n2 = 1;
            switch (this.LookAt) {
                case 0: {
                    if (this.OnSlopeRight(nArray, false) == 0) break;
                    n2 = 0;
                    break;
                }
                case 1: {
                    if (this.OnSlopeLeft(nArray, false) == 0) break;
                    n2 = 0;
                }
            }
            if (n2 != 0) {
                this.PositionYL -= 2;
                this.CheckDuringFall(nArray);
                this.OldY = this.PositionYL;
                if (this.PositionYL < -30) {
                    this.PositionYL = -30;
                    return true;
                }
                this.falling = true;
                return false;
            }
        }
        this.OldY = this.PositionYL;
        this.Activity = 0;
        if ((n & 1) != 0) {
            this.Activity = 3;
            this.moveJump = false;
            if ((n & 4) != 0) {
                this.LookAt = 0;
                this.moveJump = true;
            } else if ((n & 8) != 0) {
                this.LookAt = 1;
                this.moveJump = true;
            }
            this.Character_Sprites[this.Activity].setFrame(0);
            this.lastFrame = -1;
            this.repeatNbr = 0;
            this.lastRepeat = -1;
            this.Actuate(0, nArray);
            return false;
        }
        if ((n & 0x20) != 0) {
            this.HoldAtLastFrame = true;
            this.Activity = 4;
            this.Character_Sprites[this.Activity].setFrame(0);
            if (bl) {
                return false;
            }
            n2 = 0;
            switch (this.LookAt) {
                case 0: {
                    n2 = this.PositionXL + 60 + 54;
                    break;
                }
                case 1: {
                    n2 = this.PositionXL + 60 - 15;
                }
            }
            int n3 = 0;
            if (this.SPECIAL_LEVEL) {
                n3 = 5;
            }
            this.bulletList.addElement(new Bullet(n2, this.PositionYL + 17 + n3, this.LookAt));
            try {
                if (this.PLAY_EFFECT) {
                    this.plGunShot.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        if ((n & 0x10) != 0) {
            this.Activity = 2;
            this.Character_Sprites[this.Activity].setFrame(0);
            return false;
        }
        if ((n & 4) != 0) {
            this.PositionXL += 4;
            this.StayIntoBounds();
            this.OnSlopeRight(nArray, true);
            if (this.BlockedFront(nArray)) {
                this.PositionXL -= 4;
            }
            this.Activity = 1;
            this.LookAt = 0;
            return false;
        }
        if ((n & 8) != 0) {
            this.PositionXL -= 4;
            this.StayIntoBounds();
            this.OnSlopeLeft(nArray, true);
            if (this.BlockedFront(nArray)) {
                this.PositionXL += 4;
            }
            this.Activity = 1;
            this.LookAt = 1;
            return false;
        }
        return false;
    }

    public void StayIntoBounds() {
        if (this.PositionXL < 64) {
            this.PositionXL = 64;
        }
        if (this.PositionXL > this.BOUND_XMAX) {
            this.PositionXL = this.BOUND_XMAX;
        }
    }

    public boolean PerformJump(int[][] nArray) {
        if (this.Character_Sprites[this.Activity].getFrame() == 2 || this.Character_Sprites[this.Activity].getFrame() == 4) {
            if (this.lastRepeat == this.repeatNbr) {
                return true;
            }
        } else {
            if (this.lastFrame == this.Character_Sprites[this.Activity].getFrame()) {
                return true;
            }
            this.lastFrame = this.Character_Sprites[this.Activity].getFrame();
        }
        if (this.Character_Sprites[this.Activity].getFrame() < 2) {
            this.PositionYL += 6;
            if (this.PositionYL > 205) {
                this.PositionYL = 205;
            }
        }
        if (this.Character_Sprites[this.Activity].getFrame() == 2) {
            this.PositionYL += 6;
            if (this.PositionYL > 205) {
                this.PositionYL = 205;
            }
            if (!this.FallDown(nArray)) {
                this.Activity = 0;
                return true;
            }
        }
        if (this.Character_Sprites[this.Activity].getFrame() > 2) {
            this.PositionYL -= 6;
            if (!this.CheckDuringFall(nArray)) {
                this.Activity = 0;
                return true;
            }
        }
        this.OldY = this.PositionYL;
        if (this.moveJump) {
            if (this.LookAt == 0) {
                this.PositionXL += 4;
            }
            if (this.LookAt == 1) {
                this.PositionXL -= 4;
            }
            this.StayIntoBounds();
        }
        return false;
    }

    public boolean FallDown(int[][] nArray) {
        int n = 15 - (this.PositionYL + 60) / 20;
        if (this.SPECIAL_LEVEL) {
            int n2 = (this.PositionXL + this.WIDTH[this.Activity] - 15) / 20;
            if (nArray[n2][n] >= 28 && nArray[n2][n] <= 36 && this.PositionYL % 20 == 0) {
                return false;
            }
            n2 = (this.PositionXL + 17) / 20;
            return nArray[n2][n] < 28 || nArray[n2][n] > 36 || this.PositionYL % 20 != 0;
        }
        int n3 = (this.PositionXL + this.WIDTH[this.Activity] - 20) / 20;
        if (nArray[n3][n] != 0 && this.PositionYL % 20 == 0) {
            return this.FallSlope(nArray);
        }
        n3 = (this.PositionXL + 20) / 20;
        if (nArray[n3][n] != 0 && this.PositionYL % 20 == 0) {
            return this.FallSlope(nArray);
        }
        return true;
    }

    public boolean CheckDuringFall(int[][] nArray) {
        int n = this.PositionYL;
        this.PositionYL = this.OldY;
        while (this.PositionYL >= n) {
            if (!this.FallDown(nArray)) {
                return false;
            }
            --this.PositionYL;
        }
        return true;
    }

    public boolean BlockedFront(int[][] nArray) {
        if (this.SPECIAL_LEVEL) {
            return false;
        }
        int n = (this.PositionXL + this.WIDTH[this.Activity] - 15) / 20;
        int n2 = 15 - (this.PositionYL + 60 + this.HEIGHT[this.Activity]) / 20;
        if (nArray[n][n2] != 0 && this.PositionYL % 20 == 0) {
            return true;
        }
        n = (this.PositionXL + 17) / 20;
        return nArray[n][n2] != 0 && this.PositionYL % 20 == 0;
    }

    public int OnSlopeRight(int[][] nArray, boolean bl) {
        if (this.SPECIAL_LEVEL) {
            return 0;
        }
        int n = this.PositionXL / 20;
        int n2 = 15 - (this.PositionYL + 60) / 20;
        if (nArray[n][n2] == 9 || nArray[n][n2] == 10) {
            if (bl) {
                this.PositionYL += 2;
            }
            return 1;
        }
        n = (this.PositionXL - 1) / 20;
        if (nArray[n][n2] == 9 || nArray[n][n2] == 10) {
            if (bl) {
                this.PositionYL += 2;
            }
            return 1;
        }
        n = (this.PositionXL + this.WIDTH[this.Activity]) / 20;
        if (nArray[n][n2] == 5 || nArray[n][n2] == 12 || nArray[n][n2] == 13) {
            if (bl) {
                this.PositionYL -= 2;
            }
            return 2;
        }
        return 0;
    }

    public int OnSlopeLeft(int[][] nArray, boolean bl) {
        if (this.SPECIAL_LEVEL) {
            return 0;
        }
        int n = this.PositionXL / 20;
        int n2 = 15 - (this.PositionYL + 60) / 20;
        if (nArray[n][n2] == 3 || nArray[n][n2] == 9 || nArray[n][n2] == 10) {
            if (bl) {
                this.PositionYL -= 2;
            }
            return 2;
        }
        n = (this.PositionXL + this.WIDTH[this.Activity]) / 20;
        if (nArray[n][n2] == 11 || nArray[n][n2] == 12 || nArray[n][n2] == 13) {
            if (bl) {
                this.PositionYL += 2;
            }
            return 1;
        }
        return 0;
    }

    public boolean FallSlope(int[][] nArray) {
        int n;
        if (this.SPECIAL_LEVEL) {
            return false;
        }
        int n2 = 15 - (this.PositionYL + 60) / 20;
        int n3 = (this.PositionXL + this.WIDTH[this.Activity]) / 20;
        int n4 = nArray[n3][n2];
        n3 = this.PositionXL / 20;
        int n5 = nArray[n3][n2];
        if (n4 == 2 || n4 == 3) {
            return true;
        }
        if (n4 == 0 && n5 == 3) {
            return false;
        }
        if (n4 == 4 && n5 == 3) {
            return false;
        }
        if (n4 == 4 && n5 == 2) {
            return false;
        }
        if (n5 == 2) {
            n = 20 - this.PositionXL % 20 / 2;
            this.PositionYL -= --n;
        }
        if (n5 == 3) {
            n = 10 - this.PositionXL % 20 / 2;
            this.PositionYL -= --n;
        }
        if (n5 == 6) {
            return true;
        }
        if (n5 == 5) {
            n = 10 - this.PositionXL % 20 / 2;
            this.PositionYL -= --n;
        }
        if (n4 == 6) {
            n = 20 - this.PositionXL % 20 / 2;
            this.PositionYL -= --n;
        }
        return false;
    }
}

