/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public final class GameEngine
extends GameCanvas
implements Runnable {
    public static final String[] PAK_NAMES = new String[]{"/0.pak"};
    private static String resourceFileName = "";
    static boolean pauseNeeded;
    static GameEngine instance;
    static Game game;
    static boolean BreakMainLoop;
    static int FPS;
    static Graphics GraphicsContext;
    static int ScreenResX;
    static int ScreenResY;
    static int WindowOffsetX;
    static int WindowOffsetY;
    static int ViewMapMaxX;
    static int ViewMapMinX;
    static int WindowResX;
    static int WindowResY;
    static int ViewMapMaxY;
    static int ViewMapMinY;
    static int MapX;
    static int MapY;
    static int TotalGfxSpace;
    static int[] LiveState;
    static int[] LastState;
    static int[] Pressed;
    static int[] Debounced;
    private Thread gameThread = null;
    boolean MasterQuit;
    int frameCounter;
    static boolean paused;
    static EngineEntry parent;
    static boolean restartSound;
    static int restartTicks;
    static boolean keyPressed;
    public static String[] text;
    static String GAME_NAME;
    static String HISCORE_URL;
    static String PORTAL_NAME;
    private int action;
    private static String uploadName;
    public static boolean uploadEnabled;
    public static boolean scoreUploaded;
    private static String UID;
    private String onlineNames;
    private ByteArrayOutputStream bout;
    private DataOutputStream dout;
    private int encryptionStart;
    public static Random random;
    static boolean DEMO_MODE;
    static boolean runConnector;

    GameEngine(EngineEntry engineEntry) {
        super(false);
        System.currentTimeMillis();
        parent = engineEntry;
        GameEngine.initMGS();
        instance = this;
        GameEngine.initResource(0);
        ScreenResX = 176;
        ScreenResY = 220;
        game = new Game();
    }

    protected final void sizeChanged(int n, int n2) {
        ScreenResX = n;
        ScreenResY = n2;
    }

    public final void start() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    public final void stop() {
        this.gameThread = null;
    }

    public final void showNotify() {
        if (paused) {
            GameEngine.appResume();
        }
        GameEngine.ResetKeys();
        restartSound = true;
        restartTicks = 5;
    }

    public final void hideNotify() {
        restartSound = false;
        Sound.StopTune();
        if (!pauseNeeded) {
            GameEngine.appPause();
        }
        pauseNeeded = true;
        game.setPressAnyKeyState();
        GameEngine.ResetKeys();
    }

    public static void appResume() {
        if (!pauseNeeded && !GameEngine.game.frontendPause) {
            paused = false;
        }
        GameEngine.ResetKeys();
        game.pauseGame();
    }

    private static void appPause() {
        paused = true;
        if (Sound.getType() == 2 && Game.Task == 5) {
            Sound.pauseTune();
        }
    }

    public final void run() {
        if (runConnector) {
            this.runScoreConnector();
            runConnector = false;
            return;
        }
        Graphics graphics = this.getGraphics();
        long l = 0L;
        try {
            while (!this.MasterQuit) {
                this.setFullScreenMode(true);
                this.sizeChanged(176, 220);
                BreakMainLoop = false;
                System.currentTimeMillis();
                while (!BreakMainLoop) {
                    long l2 = System.currentTimeMillis();
                    System.currentTimeMillis();
                    if (this.isShown()) {
                        System.currentTimeMillis();
                        if (l2 - l > (long)(1000 / FPS)) {
                            try {
                                GameEngine.UpdateKeys();
                                l = l2;
                                game.Update();
                                this.Render(graphics);
                                ++this.frameCounter;
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    try {
                        Thread.yield();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
        }
        EngineEntry.instance.notifyDestroyed();
    }

    private void Render(Graphics graphics) {
        GraphicsContext = graphics;
        game.render();
        if (Game.error != null) {
            graphics.setClip(0, 0, ScreenResX, ScreenResY);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(Game.error, -80, 20, 0);
        }
        this.flushGraphics();
    }

    static void InitWorldSystem() {
        WindowResX = ScreenResX;
        WindowResY = ScreenResY;
        WindowOffsetX = 0;
        WindowOffsetY = 0;
    }

    static void SetCamWorldBoundingBox(int n, int n2, int n3, int n4) {
        ViewMapMinX = n;
        ViewMapMinY = n2;
        ViewMapMaxX = n3;
        ViewMapMaxY = n4;
    }

    static void setTransform(int n, int n2) {
        GraphicsContext.translate(n, n2);
    }

    static void SetCam$4868d30e(int n, int n2) {
        int n3;
        int n4 = n;
        MapX = n4 - (WindowResX >> 1);
        MapY = n2;
        if (MapX > ViewMapMaxX - WindowResX) {
            MapX = ViewMapMaxX - WindowResX;
        }
        if (MapX < ViewMapMinX) {
            MapX = ViewMapMinX;
        }
        if (MapY > (n3 = ViewMapMaxY - WindowResY - GameEngine.game.hudY)) {
            MapY = n3;
        }
        if (MapY < ViewMapMinY) {
            MapY = ViewMapMinY;
        }
    }

    public static Sprites createSprite(String string) {
        Sprites sprites = new Sprites();
        new Sprites().Data = GameEngine.doCreateImage(string + ".png");
        if (sprites.Data == null) {
            return null;
        }
        sprites.w = sprites.Data.getWidth();
        sprites.h = sprites.Data.getHeight();
        TotalGfxSpace += sprites.w * sprites.h;
        return sprites;
    }

    static Sprites createSprite(int n, int n2) {
        Sprites sprites;
        try {
            sprites = new Sprites();
            new Sprites().Data = Image.createImage((int)n, (int)n2);
            sprites.w = sprites.Data.getWidth();
            sprites.h = sprites.Data.getHeight();
        }
        catch (Exception exception) {
            return null;
        }
        return sprites;
    }

    static void DestroySPRITE(Sprites sprites) {
        if (sprites != null) {
            TotalGfxSpace -= sprites.w * sprites.h;
            sprites.Data = null;
        }
    }

    static void DrawSPRITEInWorldNoClip(Sprites sprites, int n, int n2) {
        GameEngine.DrawSPRITENoClip(sprites, WindowOffsetX + n - MapX, WindowOffsetY + n2 - MapY);
    }

    static void DrawSPRITEInWorld(Sprites sprites, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GameEngine.DrawSPRITE(sprites, WindowOffsetX + n - MapX, WindowOffsetY + n2 - MapY, n3, n4, n5, n6, n7);
    }

    static void DrawSPRITE(Sprites sprites, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        int n9 = 20;
        if (sprites == null) {
            return;
        }
        if (sprites.Data == null) {
            return;
        }
        if ((n7 & 1) == 1) {
            n8 = 2;
            n9 = 24;
        }
        if ((n7 & 2) == 2) {
            n8 |= 1;
        }
        GraphicsContext.drawRegion(sprites.Data, n5, n6, n3, n4, n8, n, n2, n9);
    }

    static void DrawSPRITENoClip(Sprites sprites, int n, int n2) {
        if (sprites == null) {
            return;
        }
        if (sprites.Data == null) {
            return;
        }
        int n3 = sprites.w;
        int n4 = sprites.h;
        GraphicsContext.drawRegion(sprites.Data, 0, 0, n3, n4, 0, n, n2, 20);
    }

    static void FillRect(int n, int n2, int n3, int n4, int n5) {
        GraphicsContext.setClip(0, 0, ScreenResX, ScreenResY);
        GraphicsContext.setColor(n5);
        GraphicsContext.fillRect(n, n2, n3, n4);
    }

    static void drawRect(int n, int n2, int n3, int n4, int n5) {
        GraphicsContext.setClip(0, 0, ScreenResX, ScreenResY);
        GraphicsContext.setColor(n5);
        GraphicsContext.drawRect(n, n2, n3, n4);
    }

    static void FillRectToSPRITE(Sprites sprites, int n, int n2, int n3, int n4, int n5) {
        if (sprites == null) {
            return;
        }
        if (sprites.Data == null) {
            return;
        }
        Graphics graphics = sprites.Data.getGraphics();
        graphics.setClip(0, 0, sprites.w, sprites.h);
        graphics.clipRect(0, 0, sprites.w, sprites.w);
        graphics.setColor(n5);
        graphics.fillRect(n, n2, n3, n4);
    }

    static void CopySPRITESection(Sprites sprites, Sprites sprites2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Graphics graphics = sprites2.Data.getGraphics();
        if (n7 == 0) {
            graphics.drawRegion(sprites.Data, n, n2, n3, n4, 0, n5, n6, 20);
            return;
        }
        if (n7 == 1) {
            if (n7 != 0) {
                for (int i = 0; i < n4; ++i) {
                    graphics.setClip(n5, n6 + i, n3, 1);
                    graphics.clipRect(n5, n6 + i, n3, 1);
                    graphics.drawImage(sprites.Data, n5 - n, n6 + i - (n2 + n4 - i - 1), 20);
                }
            } else {
                graphics.setClip(n5, n6, n3, n4);
                graphics.clipRect(n5, n6, n3, n4);
                graphics.drawImage(sprites.Data, n5 - n, n6 - n2, 20);
            }
        }
    }

    private static void UpdateKeys() {
        int n;
        for (n = 0; n < 32; ++n) {
            GameEngine.LastState[n] = Pressed[n];
        }
        GameEngine.LastState[19] = Pressed[0] | Pressed[5];
        GameEngine.LastState[20] = Pressed[1] | Pressed[11];
        GameEngine.LastState[21] = Pressed[2] | Pressed[7];
        GameEngine.LastState[22] = Pressed[3] | Pressed[9];
        GameEngine.LastState[23] = Pressed[8] | Pressed[18] | Pressed[16];
        GameEngine.LastState[18] = Pressed[8] | Pressed[18];
        GameEngine.LastState[25] = Pressed[11];
        GameEngine.LastState[26] = Pressed[14];
        GameEngine.LastState[24] = Pressed[13];
        GameEngine.LastState[27] = Pressed[4];
        GameEngine.LastState[28] = Pressed[6];
        for (n = 0; n < 32; ++n) {
            GameEngine.Pressed[n] = LiveState[n];
        }
        GameEngine.Pressed[19] = LiveState[0] | LiveState[5];
        GameEngine.Pressed[20] = LiveState[1] | LiveState[11];
        GameEngine.Pressed[21] = LiveState[2] | LiveState[7];
        GameEngine.Pressed[22] = LiveState[3] | LiveState[9];
        GameEngine.Pressed[23] = LiveState[8] | LiveState[18] | LiveState[16];
        GameEngine.Pressed[18] = LiveState[8] | LiveState[18];
        GameEngine.Pressed[25] = LiveState[11];
        GameEngine.Pressed[26] = LiveState[14];
        GameEngine.Pressed[24] = LiveState[13];
        GameEngine.Pressed[27] = LiveState[4];
        GameEngine.Pressed[28] = LiveState[6];
        for (n = 0; n < 32; ++n) {
            int n2;
            int n3;
            int[] nArray;
            if (Pressed[n] != 0 && LastState[n] == 0) {
                nArray = Debounced;
                n3 = n;
                n2 = 1;
            } else {
                nArray = Debounced;
                n3 = n;
                n2 = 0;
            }
            nArray[n3] = n2;
        }
    }

    static void ResetKeys() {
        GameEngine.LiveState[0] = 0;
        GameEngine.LiveState[1] = 0;
        GameEngine.LiveState[2] = 0;
        GameEngine.LiveState[3] = 0;
        GameEngine.LiveState[18] = 0;
        GameEngine.LiveState[16] = 0;
        GameEngine.LiveState[17] = 0;
        GameEngine.LiveState[4] = 0;
        GameEngine.LiveState[5] = 0;
        GameEngine.LiveState[6] = 0;
        GameEngine.LiveState[7] = 0;
        GameEngine.LiveState[8] = 0;
        GameEngine.LiveState[9] = 0;
        GameEngine.LiveState[10] = 0;
        GameEngine.LiveState[11] = 0;
        GameEngine.LiveState[12] = 0;
        GameEngine.LiveState[13] = 0;
        GameEngine.LiveState[14] = 0;
        GameEngine.LiveState[15] = 0;
        GameEngine.LiveState[19] = 0;
        GameEngine.LiveState[20] = 0;
        GameEngine.LiveState[21] = 0;
        GameEngine.LiveState[22] = 0;
        GameEngine.LiveState[23] = 0;
        GameEngine.Debounced[18] = 0;
        GameEngine.Debounced[16] = 0;
    }

    public final synchronized void keyPressed(int n) {
        block4: {
            block5: {
                int n2;
                int n3;
                block7: {
                    block6: {
                        n3 = this.decodeKey(n);
                        keyPressed = true;
                        if (GameEngine.game.FETask == 13) {
                            game.keyEntered(n);
                        }
                        if (n3 == -1) break block4;
                        if (!Game.reverseTooltips) break block5;
                        if (n3 != 17) break block6;
                        n2 = 16;
                        break block7;
                    }
                    if (n3 != 16) break block5;
                    n2 = 17;
                }
                n3 = n2;
            }
            GameEngine.LiveState[n3] = 1;
        }
    }

    private int decodeKey(int n) {
        try {
            switch (n) {
                case 48: {
                    return 13;
                }
                case 49: {
                    return 4;
                }
                case 50: {
                    return 5;
                }
                case 51: {
                    return 6;
                }
                case 52: {
                    return 7;
                }
                case 53: {
                    return 8;
                }
                case 54: {
                    return 9;
                }
                case 55: {
                    return 10;
                }
                case 56: {
                    return 11;
                }
                case 57: {
                    return 12;
                }
                case 42: {
                    return 14;
                }
                case 35: {
                    return 15;
                }
                case -6: {
                    return 16;
                }
                case -7: {
                    return 17;
                }
            }
            switch (this.getGameAction(n)) {
                case 1: {
                    return 0;
                }
                case 6: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
                case 8: {
                    return 18;
                }
            }
        }
        catch (Exception exception) {}
        return -1;
    }

    public final synchronized void keyReleased(int n) {
        block2: {
            block3: {
                int n2;
                int n3;
                block5: {
                    block4: {
                        n3 = this.decodeKey(n);
                        if (n3 == -1) break block2;
                        if (!Game.reverseTooltips) break block3;
                        if (n3 != 17) break block4;
                        n2 = 16;
                        break block5;
                    }
                    if (n3 != 16) break block3;
                    n2 = 17;
                }
                n3 = n2;
            }
            GameEngine.LiveState[n3] = 0;
        }
    }

    public final void pointerPressed(int n, int n2) {
        GameEngine.game.CursorX = n;
        GameEngine.game.CursorY = n2 - 2;
        GameEngine.LiveState[29] = 1;
        int n3 = ScreenResX - Game.TOOTIP_W - 1;
        int n4 = ScreenResY - Game.TOOTIP_H - 3;
        if (n >= 0 && n <= 1 + Game.TOOTIP_W + 5 && n2 >= n4 && n2 <= n4 + Game.TOOTIP_H + 5) {
            int n5;
            int[] nArray;
            if (Game.reverseTooltips) {
                nArray = LiveState;
                n5 = 17;
            } else {
                nArray = LiveState;
                n5 = 16;
            }
            nArray[n5] = 1;
            keyPressed = true;
            return;
        }
        if (n >= n3 - 5 && n <= n3 + Game.TOOTIP_W + 3 && n2 >= n4 && n2 <= n4 + Game.TOOTIP_H + 5) {
            int n6;
            int[] nArray;
            if (Game.reverseTooltips) {
                nArray = LiveState;
                n6 = 16;
            } else {
                nArray = LiveState;
                n6 = 17;
            }
            nArray[n6] = 1;
        }
    }

    public final void pointerReleased(int n, int n2) {
        GameEngine.LiveState[29] = 0;
        GameEngine.LiveState[18] = 0;
        int n3 = ScreenResX - Game.TOOTIP_W - 1;
        int n4 = ScreenResY - Game.TOOTIP_H - 3;
        if (n >= 0 && n <= 1 + Game.TOOTIP_W + 5 && n2 >= n4 && n2 <= n4 + Game.TOOTIP_H + 5) {
            int n5;
            int[] nArray;
            if (Game.reverseTooltips) {
                nArray = LiveState;
                n5 = 17;
            } else {
                nArray = LiveState;
                n5 = 16;
            }
            nArray[n5] = 0;
            keyPressed = true;
            return;
        }
        if (n >= n3 - 5 && n <= n3 + Game.TOOTIP_W + 3 && n2 >= n4 && n2 <= n4 + Game.TOOTIP_H + 5) {
            int n6;
            int[] nArray;
            if (Game.reverseTooltips) {
                nArray = LiveState;
                n6 = 16;
            } else {
                nArray = LiveState;
                n6 = 17;
            }
            nArray[n6] = 0;
        }
    }

    public final void pointerDragged(int n, int n2) {
    }

    static byte[] LoadData(String string) {
        try {
            return GameEngine.gluGetResource(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static int LoadDataShort(String string, short[] sArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(GameEngine.gluGetResource(string));
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = dataInputStream.readShort();
            }
            dataInputStream.close();
            byteArrayInputStream.close();
            return sArray.length;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static byte[] gluGetResource(String string) {
        string = string.substring(1);
        try {
            return GameEngine.gluGetClassLoaderResourceArrayByName(string);
        }
        catch (Throwable throwable) {
            return GameEngine.gluGetClassLoaderResourceArrayByName(string);
        }
    }

    private static void initResource(int n) {
        String string = PAK_NAMES[n];
        if (resourceFileName.equals(string)) {
            return;
        }
        resourceFileName = "";
    }

    private static Image doCreateImage(String string) {
        try {
            byte[] byArray = GameEngine.gluGetResource(string);
            return Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static InputStream gluGetClassLoaderResourceStreamByName(String string) {
        InputStream inputStream = instance.getClass().getResourceAsStream("/" + string);
        return inputStream;
    }

    private static byte[] gluGetClassLoaderResourceArrayByName(String string) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = GameEngine.gluGetClassLoaderResourceStreamByName(string);
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void initText(String string) {
        try {
            InputStream inputStream = null;
            DataInputStream dataInputStream = null;
            inputStream = instance.getClass().getResourceAsStream(string);
            dataInputStream = new DataInputStream(inputStream);
            text = new String[dataInputStream.readInt()];
            for (int i = 0; i < text.length; ++i) {
                GameEngine.text[i] = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {}
        if (text[0].indexOf("1") != -1) {
            Game.USE_BMP_FONT = true;
        }
    }

    private static String getText(int n) {
        if (n < text.length) {
            return text[n];
        }
        return "No text: " + n;
    }

    public static String getText(int n, String[] stringArray) {
        String string = new String(GameEngine.getText(n));
        if (stringArray.length == 1) {
            string = GameEngine.replaceText(string, "%U", stringArray[0]);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                string = GameEngine.replaceText(string, "%U", stringArray[i]);
            }
        }
        return string;
    }

    private static String replaceText(String string, String string2, String string3) {
        String string4 = null;
        int n = 0;
        n = string.indexOf(string2);
        string4 = n != -1 ? string.substring(0, n) + string3 + string.substring(n + string2.length()) : string;
        return string4;
    }

    public static String[] getStrings(String string, int n, Font font) {
        int n2;
        if (n == ScreenResX) {
            int n3 = 16;
            if (!Game.USE_BMP_FONT) {
                n3 = 22;
            }
            n -= n3;
        }
        Vector<String> vector = new Vector<String>();
        int n4 = 0;
        int n5 = string.length();
        String string2 = null;
        do {
            n2 = n4;
            int n6 = string.indexOf(10, n2);
            block1: do {
                int n7 = n2;
                String string3 = string2;
                n2 = GameEngine.getWordIndex(string, n2);
                if (n6 > -1 && n6 < n2) {
                    n2 = n6;
                }
                string2 = string.substring(n4, n2).trim();
                int n8 = Game.USE_BMP_FONT ? string2.length() * 8 : font.stringWidth(string2);
                if (n8 <= n) continue;
                if (n7 == n4) {
                    for (int i = string2.length() - 1; i > 0; --i) {
                        String string4 = string2.substring(0, i);
                        if (font.stringWidth(string4) > n) continue;
                        n2 = n7 + i;
                        string2 = string4;
                        break block1;
                    }
                    break;
                }
                n2 = n7;
                string2 = string3;
                break;
            } while (n2 != n6 && n2 < n5);
            vector.addElement(string2);
        } while ((n4 = ++n2) < n5);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static int getWordIndex(String string, int n) {
        int n2;
        char c = string.charAt(n);
        if (GameEngine.charIsWord(c)) {
            return n + 1;
        }
        int n3 = 0;
        while ((n2 = string.indexOf(32, n)) == 0) {
            ++n;
        }
        n3 = n2;
        n3 = n3 == -1 ? string.length() : ++n3;
        for (n2 = n + 1; n2 < n3; ++n2) {
            if (!GameEngine.charIsWord(string.charAt(n2))) continue;
            return n2;
        }
        return n3;
    }

    private static boolean charIsWord(int n) {
        return n >= 11904 && n < 44032 || n >= 63744 && n < 64256 || n >= 65280 && n < 65504;
    }

    private static void initMGS() {
        String string = Game.getJadValue("ms-highscoreUpload");
        if (string != null) {
            uploadEnabled = string.equals("1");
        }
        if (uploadEnabled) {
            if (uploadName == null) {
                uploadName = new String();
            }
            HISCORE_URL = Game.getJadValue("ProvisionX-Highscore-Url");
            GAME_NAME = Game.getJadValue("ProvisionX-Highscore-gameCode");
            PORTAL_NAME = Game.getJadValue("ProvisionX-Highscore-portalCode");
            if (UID.length() == 0) {
                boolean bl = true;
                string = Game.getJadValue("ms-uid");
                if (string != null) {
                    UID = Game.getJadValue(string);
                    if (UID != null) {
                        bl = false;
                    }
                    if (UID == null) {
                        UID = new String();
                    }
                }
                if (bl && UID.length() == 0) {
                    int n = 8;
                    while (n-- != 0) {
                        char c = (char)(65 + GameEngine.rndPositive(57));
                        UID = UID + c;
                    }
                }
            }
        }
    }

    private static int rndPositive(int n) {
        return Math.abs(random.nextInt() % n);
    }

    public final void initScoreConnector(int n, String string, String string2, String string3, String string4, int n2) {
        GameEngine.game.FETask = 12;
        try {
            this.action = n;
            this.bout = new ByteArrayOutputStream();
            this.dout = new DataOutputStream(this.bout);
            this.dout.writeInt(this.action);
            this.dout.writeUTF(string2);
            this.dout.writeUTF(string);
            this.encryptionStart = this.bout.size();
            this.dout.writeUTF("playerName");
            this.dout.writeUTF(string3);
            this.dout.writeUTF("scoreGroup");
            this.dout.writeUTF("g" + n2);
            this.dout.writeUTF("ap-returnScoreGroup");
            this.dout.writeUTF("g" + n2);
            this.dout.writeUTF("score");
            this.dout.writeUTF(string4);
            if (UID != null) {
                this.dout.writeUTF("ep-ms-uid");
                this.dout.writeUTF(UID);
            }
            runConnector = true;
            new Thread(this).start();
            return;
        }
        catch (Exception exception) {
            if (n == 1) {
                scoreUploaded = false;
            }
            GameEngine.game.FETask = 0;
            game.setMenu(Game.createForm(text[129], text[136], GameEngine.game.menuHighScores, null));
            return;
        }
    }

    private void runScoreConnector() {
        byte[] byArray = null;
        HttpConnection httpConnection = null;
        try {
            Object object;
            byte[] byArray2 = this.bout.toByteArray();
            if ("JhsbK823FAgQ".length() > 0) {
                object = "JhsbK823FAgQ".getBytes();
                for (int i = this.encryptionStart; i < byArray2.length; ++i) {
                    int n = i;
                    byArray2[n] = (byte)(byArray2[n] ^ object[i % ((byte[])object).length]);
                }
            }
            this.bout.close();
            this.dout.close();
            httpConnection = (HttpConnection)Connector.open((String)HISCORE_URL, (int)3, (boolean)true);
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Length", Integer.toString(byArray2.length));
            httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpConnection.setRequestProperty("Connection", "close");
            OutputStream outputStream = httpConnection.openOutputStream();
            object = outputStream;
            outputStream.write(byArray2);
            ((OutputStream)object).flush();
            DataInputStream dataInputStream = httpConnection.openDataInputStream();
            if (httpConnection.getResponseCode() == 200) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                while ((n = dataInputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                dataInputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
                dataInputStream2.readLong();
                int n2 = dataInputStream2.readInt();
                if (n2 == 1) {
                    String string;
                    GameEngine gameEngine;
                    int n3 = dataInputStream2.readInt();
                    dataInputStream2.readUTF();
                    int n4 = dataInputStream2.readInt();
                    if (n4 > 10) {
                        n4 = 10;
                    }
                    if (n3 != -1) {
                        gameEngine = this;
                        string = text[138] + n3 + "\n\n";
                    } else {
                        gameEngine = this;
                        string = "";
                    }
                    gameEngine.onlineNames = string;
                    for (int i = 0; i < n4; ++i) {
                        this.onlineNames = this.onlineNames + (i + 1) + ". " + dataInputStream2.readUTF() + " " + dataInputStream2.readUTF() + "\n";
                    }
                    this.onlineNames = this.onlineNames.trim();
                }
            } else {
                if (httpConnection != null) {
                    httpConnection.close();
                }
                throw new Exception();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
            if (this.action != 1) {
                if (this.action == 2) {
                    GameEngine.game.FETask = 0;
                    game.setMenu(Game.createForm(text[129], this.onlineNames, GameEngine.game.menuHighScores, null));
                }
                return;
            }
            scoreUploaded = true;
            GameEngine.game.FETask = 0;
            game.setMenu(Game.createForm(text[130], text[158], GameEngine.game.menuHighScores, null));
        }
        catch (Exception exception) {
            System.out.println("runScoreConnector()");
            GameEngine.game.FETask = 0;
            game.setMenu(Game.createForm(text[129], text[136], GameEngine.game.menuHighScores, null));
        }
    }

    public static int scaleY(int n) {
        return n * ScreenResY / 100;
    }

    static {
        FPS = 14;
        WindowOffsetX = 0;
        WindowOffsetY = 0;
        ViewMapMaxX = 528;
        ViewMapMinX = 0;
        WindowResX = 0;
        WindowResY = 0;
        ViewMapMaxY = 0;
        ViewMapMinY = 0;
        MapX = 0;
        MapY = 0;
        TotalGfxSpace = 0;
        LiveState = new int[32];
        LastState = new int[32];
        Pressed = new int[32];
        Debounced = new int[32];
        restartSound = false;
        restartTicks = 0;
        keyPressed = false;
        scoreUploaded = true;
        UID = new String();
        random = new Random();
        DEMO_MODE = true;
        runConnector = false;
    }
}

