/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.chep;

import com.nokia.mid.appl.chep.ChessBoard;
import com.nokia.mid.appl.chep.ChessRMS;
import com.nokia.mid.appl.chep.FullCanvasScreen;
import com.nokia.mid.appl.chep.HighScores;
import com.nokia.mid.appl.chep.Local;
import com.nokia.mid.ui.DeviceControl;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class ChessPuzzleMidlet
extends MIDlet
implements CommandListener {
    static ChessPuzzleMidlet instance;
    private Display m_Display = null;
    public List m_ListScr;
    public FullCanvasScreen m_FullCanvasScreen;
    public Form m_FormScr;
    public ChessRMS m_ChessRMS;
    protected Timer m_Timer;
    public HighScores[] m_HighScoreArray = null;
    public Command m_CommandSelect;
    public Command m_CommandBack;
    public Command m_CommandMore;
    public Command m_CommandOK;
    protected int m_CurrentScreen = 0;
    protected int m_LastScreen = 0;
    protected int MAIN_MENU_SCR = 1;
    protected int MODE_MENU_SCR = 2;
    protected int PUZZLE_MENU_SCR = 3;
    protected int HIGHSCORE_MENU_SCR = 4;
    protected int SPLASH_SCR = 5;
    protected int PUZZLE_SCR = 6;
    protected int LEVEL_MENU_SCR = 7;
    protected int HIGHSCORE_DIS_SCR = 8;
    protected int HIGHSCORE_DEL_SCR = 9;
    protected int INSTRUCTION_SCR = 10;
    protected int TIMED_MODE = 1;
    protected int CASUAL_MODE = 0;
    protected final Image m_Pieces;
    private int m_PuzzleType;
    private int m_Mode;
    private int m_Level;
    private int m_SavedSolvedCount;
    private int m_SavedClockCount;
    private int m_LastSelectedMenuIndex = 0;
    private String m_AppMessage = "";
    private boolean m_PlayMenu = false;
    private int m_ScreenWidth = 128;
    private int m_ScreenHeight = 128;
    private int m_ScreenLPT;
    private int m_ScreenTPT;
    private int m_BrdXOffSet = 8;
    private int m_BrdYOffset = 14;
    private ChessBoard m_Board;
    private Image m_PieceCopy;
    private boolean m_GameImagesInit = false;
    private boolean m_PuzzleInitLocked = false;
    private Image m_WhiteSquareImage;
    private Image m_BlackSquareImage;
    private int m_PieceWidth;
    private int m_PieceHeight;
    private int m_FromSquare;
    private int m_ToSquare;
    private boolean m_IsDragging;
    private int m_HighLightSq;
    private int m_OldHighLightSq;
    private boolean m_DrawBoard;
    private boolean m_DrawGameSettings;
    private boolean m_DrawSolCount;
    private boolean m_DrawTopScore;
    private boolean m_DrawTextBox;
    private boolean m_DrawDisplayBounds;
    private boolean m_DrawHighlightCursors;
    private boolean m_TrophyDisplayed;
    private boolean m_DrawTrophy;
    private boolean m_SqPainted = true;
    private int m_ClockCount;
    private int m_ClockDisplay;
    private boolean m_PauseClock;
    private int m_DismissCount;
    private int m_DismissSec = 1;
    private int m_PuzzlesSolved;
    private int m_MaxSolvedCount;
    private int m_TimePenalty;

    public ChessPuzzleMidlet() {
        instance = this;
        this.m_Display = Display.getDisplay((MIDlet)this);
        this.m_Pieces = this.CreateImage("/icons/cp.png");
        this.m_FullCanvasScreen = new FullCanvasScreen(this);
        this.m_ChessRMS = new ChessRMS();
        this.m_CommandSelect = new Command(Local.getText(23), 4, 1);
        this.m_CommandBack = new Command(Local.getText(5), 2, 1);
        this.m_CommandOK = new Command(Local.getText(19), 4, 1);
        this.m_ScreenLPT = 0;
        this.m_ScreenTPT = 0;
        this.m_ChessRMS.ManageUserSettings(0, 0, 0, 0, 0);
        this.m_PuzzleType = this.m_ChessRMS.m_UserPuzzleType;
        this.m_Mode = this.m_ChessRMS.m_UserPuzzleMode;
        this.m_Level = this.m_ChessRMS.m_UserPuzzleLevel;
        this.m_SavedSolvedCount = this.m_ChessRMS.m_UserSolvedCount;
        this.m_SavedClockCount = this.m_ChessRMS.m_UserClockCount;
        this.m_Timer = new Timer();
        this.m_Timer.scheduleAtFixedRate((TimerTask)new CountDown(), 0L, 1000L);
        this.m_Board = new ChessBoard(this.m_ChessRMS);
        this.m_HighScoreArray = null;
        this.m_HighScoreArray = new HighScores[8];
        this.m_ChessRMS.ManageScoreRecord(0, 0, "00/00", this.m_HighScoreArray);
    }

    public void startApp() {
        DeviceControl.setLights(0, 100);
        Displayable displayable = this.m_Display.getCurrent();
        if (displayable == null) {
            this.m_CurrentScreen = this.SPLASH_SCR;
            this.m_Display.setCurrent((Displayable)this.m_FullCanvasScreen);
        } else {
            this.m_Display.setCurrent(displayable);
        }
    }

    public void pauseApp() {
        if (this.m_CurrentScreen == this.PUZZLE_SCR || this.m_LastScreen == this.PUZZLE_SCR) {
            this.PausePuzzleGame();
        }
    }

    public void destroyApp(boolean bl) {
        if (this.m_CurrentScreen == this.PUZZLE_SCR || this.m_LastScreen == this.PUZZLE_SCR) {
            this.PausePuzzleGame();
        }
    }

    public static void QuitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    private void MainMenuScreenDone(int n) {
        int n2;
        this.m_LastSelectedMenuIndex = n;
        if (this.m_PlayMenu) {
            n2 = n--;
            this.m_PlayMenu = false;
            if (this.m_Mode == this.CASUAL_MODE) {
                --n;
                if (1 == n2) {
                    this.m_ClockCount = 0;
                    this.m_ClockDisplay = 0;
                    boolean bl = true;
                    this.SaveGame(bl);
                    this.NextDrill();
                    this.m_AppMessage = "";
                    this.m_DrawTextBox = false;
                    --n2;
                }
            }
            if (0 == n2) {
                if (!this.m_GameImagesInit) {
                    this.InitPuzzleScr();
                } else {
                    this.m_LastScreen = this.m_CurrentScreen;
                    this.m_CurrentScreen = this.PUZZLE_SCR;
                    this.m_Display.setCurrent((Displayable)this.m_FullCanvasScreen);
                }
                return;
            }
        }
        switch (n) {
            case 0: {
                if (this.m_PuzzleInitLocked) break;
                this.m_PuzzleInitLocked = true;
                n2 = 1;
                this.SaveGame(n2 != 0);
                this.InitPuzzleScr();
                this.m_PuzzleInitLocked = false;
                break;
            }
            case 1: {
                int[] nArray = new int[]{15, 16, 4, 27};
                this.InitMenuScr(this.PUZZLE_MENU_SCR, nArray, Local.getText(21), null, null, 0);
                break;
            }
            case 2: {
                int[] nArray = new int[]{11, 10};
                this.InitMenuScr(this.LEVEL_MENU_SCR, nArray, Local.getText(14), null, null, 0);
                break;
            }
            case 3: {
                int[] nArray = new int[]{6, 24};
                this.InitMenuScr(this.MODE_MENU_SCR, nArray, Local.getText(12), null, null, 0);
                break;
            }
            case 4: {
                int[] nArray = new int[]{11, 10, 22};
                this.InitMenuScr(this.HIGHSCORE_MENU_SCR, nArray, Local.getText(25), null, null, 0);
                break;
            }
            case 5: {
                String string = "";
                short[] sArray = new short[]{0, 1, 2};
                int n3 = 0;
                while (n3 < sArray.length) {
                    string = string.concat(Local.getText(sArray[n3]) + "\n\n");
                    ++n3;
                }
                this.InitFormScr(Local.getText(13), string, this.INSTRUCTION_SCR);
                break;
            }
        }
    }

    private Image CreateImage(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return image;
    }

    private void InitMenuScr(int n, int[] nArray, String string, String string2, String string3, int n2) {
        this.m_ListScr = new List("", 3);
        this.m_ListScr.removeCommand(this.m_CommandOK);
        this.m_ListScr.removeCommand(this.m_CommandBack);
        if (string3 != null && string2 != null) {
            Image image = this.CreateImage("/icons/arrow.png");
            Alert alert = new Alert(string2, string3, image, null);
            alert.setTimeout(1000);
            this.m_Display.setCurrent(alert, (Displayable)this.m_ListScr);
        }
        if (0 != this.m_SavedSolvedCount || 0 != this.m_SavedClockCount) {
            this.m_PlayMenu = true;
        }
        if (this.m_PlayMenu && n == this.MAIN_MENU_SCR) {
            this.m_ListScr.append(Local.getText(8), null);
        }
        if (this.m_Mode == this.CASUAL_MODE && this.m_PlayMenu && n == this.MAIN_MENU_SCR) {
            this.m_ListScr.append(Local.getText(18), null);
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            this.m_ListScr.append(Local.getText(nArray[n3]), null);
            ++n3;
        }
        int n4 = n2;
        if (n == this.LEVEL_MENU_SCR) {
            n4 = this.m_Level - 1;
        } else if (n == this.MODE_MENU_SCR) {
            n4 = this.m_Mode;
        } else if (n == this.PUZZLE_MENU_SCR) {
            int n5 = this.m_PuzzleType;
            if (this.m_Level == 2) {
                ++n5;
            }
            n5 /= 2;
            n4 = --n5;
        }
        this.m_ListScr.setSelectedIndex(n4, true);
        this.m_ListScr.addCommand(this.m_CommandSelect);
        this.m_ListScr.addCommand(this.m_CommandBack);
        this.m_ListScr.setCommandListener((CommandListener)this);
        this.m_ListScr.setTitle(string);
        this.m_LastScreen = this.m_CurrentScreen;
        this.m_CurrentScreen = n;
        if (string3 == null && string2 == null) {
            this.m_Display.setCurrent((Displayable)this.m_ListScr);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = null;
        String string2 = null;
        if ((command == this.m_CommandSelect || command.getCommandType() == 1) && this.m_CurrentScreen == this.MAIN_MENU_SCR) {
            this.MainMenuScreenDone(this.m_ListScr.getSelectedIndex());
            return;
        }
        if (this.m_CurrentScreen == this.HIGHSCORE_DEL_SCR) {
            if (command == this.m_CommandOK) {
                int n = 0;
                while (n < this.m_HighScoreArray.length) {
                    if (0 != this.m_HighScoreArray[n].m_playerTime) {
                        this.m_HighScoreArray[n].m_playDate = "00/00";
                        this.m_HighScoreArray[n].m_playerTime = 0;
                        this.m_ChessRMS.ManageScoreRecord(n + 1, 0, "00/00", this.m_HighScoreArray);
                    }
                    ++n;
                }
                int[] nArray = new int[]{11, 10, 22};
                this.InitMenuScr(this.HIGHSCORE_MENU_SCR, nArray, Local.getText(25), null, null, 2);
                return;
            }
            if (command == this.m_CommandBack) {
                int[] nArray = new int[]{11, 10, 22};
                this.InitMenuScr(this.HIGHSCORE_MENU_SCR, nArray, Local.getText(25), null, null, 2);
                return;
            }
        }
        if ((command == this.m_CommandSelect || command.getCommandType() == 1) && this.m_CurrentScreen == this.HIGHSCORE_MENU_SCR) {
            if (this.m_ListScr.getSelectedIndex() == 2) {
                this.InitResetHighScoreDisScr();
                return;
            }
            this.m_LastSelectedMenuIndex = this.m_ListScr.getSelectedIndex();
            this.InitHighScoreDisScr(this.m_ListScr.getSelectedIndex() + 1);
            return;
        }
        if (command == this.m_CommandBack && this.m_CurrentScreen == this.HIGHSCORE_DIS_SCR) {
            int[] nArray = new int[]{11, 10, 22};
            this.InitMenuScr(this.HIGHSCORE_MENU_SCR, nArray, Local.getText(25), null, null, this.m_LastSelectedMenuIndex);
            return;
        }
        if (command == this.m_CommandBack && this.m_CurrentScreen == this.MAIN_MENU_SCR) {
            ChessPuzzleMidlet.QuitApp();
            return;
        }
        if (command == this.m_CommandBack) {
            int n = this.m_LastSelectedMenuIndex;
            if (this.m_CurrentScreen == this.HIGHSCORE_MENU_SCR) {
                n = 4;
                if (this.m_PlayMenu) {
                    ++n;
                    if (this.m_Mode == this.CASUAL_MODE) {
                        ++n;
                    }
                }
            }
            int[] nArray = new int[]{17, 21, 14, 12, 25, 13};
            this.InitMenuScr(this.MAIN_MENU_SCR, nArray, Local.getText(7), null, null, n);
            return;
        }
        int n = this.m_LastSelectedMenuIndex;
        if (this.m_PlayMenu) {
            --n;
            if (this.m_Mode == this.CASUAL_MODE) {
                --n;
            }
        }
        if ((command == this.m_CommandSelect || command.getCommandType() == 1) && this.m_CurrentScreen == this.LEVEL_MENU_SCR) {
            string = Local.getText(14);
            string2 = this.m_ListScr.getString(this.m_ListScr.getSelectedIndex());
            this.m_Level = this.m_ListScr.getSelectedIndex() + 1;
            if (this.m_PuzzleType % 2 == 1 && this.m_Level == 1) {
                ++this.m_PuzzleType;
            } else if (this.m_PuzzleType % 2 == 0 && this.m_Level == 2) {
                --this.m_PuzzleType;
            }
        }
        if ((command == this.m_CommandSelect || command.getCommandType() == 1) && this.m_CurrentScreen == this.MODE_MENU_SCR) {
            string = Local.getText(12);
            string2 = this.m_ListScr.getString(this.m_ListScr.getSelectedIndex());
            this.m_Mode = this.m_ListScr.getSelectedIndex();
        }
        if ((command == this.m_CommandSelect || command.getCommandType() == 1) && this.m_CurrentScreen == this.PUZZLE_MENU_SCR) {
            string = Local.getText(21);
            string2 = this.m_ListScr.getString(this.m_ListScr.getSelectedIndex());
            this.m_PuzzleType = this.m_ListScr.getSelectedIndex() + 1;
            this.m_PuzzleType *= 2;
            if (this.m_Level == 2) {
                --this.m_PuzzleType;
            }
        }
        boolean bl = true;
        this.SaveGame(bl);
        int[] nArray = new int[]{17, 21, 14, 12, 25, 13};
        this.InitMenuScr(this.MAIN_MENU_SCR, nArray, Local.getText(7), string, string2, n);
    }

    private short GetModeTextID() {
        if (0 == this.m_Mode) {
            return 6;
        }
        if (1 == this.m_Mode) {
            return 24;
        }
        return 0;
    }

    private short GetLevelTextID() {
        if (1 == this.m_Level) {
            return 11;
        }
        if (2 == this.m_Level) {
            return 10;
        }
        return 0;
    }

    private short GetTypeTextID() {
        if (1 == this.m_PuzzleType || 2 == this.m_PuzzleType) {
            return 15;
        }
        if (3 == this.m_PuzzleType || 4 == this.m_PuzzleType) {
            return 16;
        }
        if (5 == this.m_PuzzleType || 6 == this.m_PuzzleType) {
            return 4;
        }
        if (7 == this.m_PuzzleType || 8 == this.m_PuzzleType) {
            return 27;
        }
        return 0;
    }

    private void InitFormScr(String string, String string2, int n) {
        this.m_FormScr = new Form(string);
        this.m_FormScr.removeCommand(this.m_CommandSelect);
        this.m_FormScr.removeCommand(this.m_CommandOK);
        if (n == this.HIGHSCORE_DEL_SCR) {
            this.m_FormScr.addCommand(this.m_CommandOK);
        }
        this.m_FormScr.addCommand(this.m_CommandBack);
        this.m_FormScr.setCommandListener((CommandListener)this);
        if (this.m_FormScr.size() > 0) {
            this.m_FormScr.delete(0);
        }
        this.m_FormScr.append((Item)new StringItem(null, string2 + "\n\n"));
        this.m_LastScreen = this.m_CurrentScreen;
        this.m_CurrentScreen = n;
        this.m_Display.setCurrent((Displayable)this.m_FormScr);
    }

    private void InitResetHighScoreDisScr() {
        this.InitFormScr(Local.getText(25), Local.getText(3), this.HIGHSCORE_DEL_SCR);
    }

    private void UpdateHighScores(int n) {
        if (this.m_HighScoreArray == null || this.m_HighScoreArray.length < 8) {
            this.m_HighScoreArray = null;
            this.m_HighScoreArray = new HighScores[8];
            this.m_ChessRMS.ManageScoreRecord(0, 0, "00/00", this.m_HighScoreArray);
        }
        if (n > 5999) {
            n = 5999;
        }
        this.m_HighScoreArray[this.m_PuzzleType - 1].m_playDate = "00/00";
        this.m_HighScoreArray[this.m_PuzzleType - 1].m_playerTime = n;
        this.m_ChessRMS.ManageScoreRecord(this.m_PuzzleType, n, "00/00", this.m_HighScoreArray);
    }

    private void InitHighScoreDisScr(int n) {
        String string = "";
        short[] sArray = new short[]{15, 16, 4, 27};
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_HighScoreArray.length) {
            if (n == 1 && n3 % 2 != 0 || n == 2 && n3 % 2 == 0) {
                string = string.concat(Local.getText(sArray[n2]) + "\n");
                ++n2;
                int n4 = this.m_HighScoreArray[n3].m_playerTime;
                String string2 = n4 == 0 ? "00:00" : this.FormatTime(n4);
                string = string.concat(string2 + "\n");
            }
            ++n3;
        }
        this.InitFormScr(Local.getText(25), string, this.HIGHSCORE_DIS_SCR);
    }

    protected void PaintSplashScr(Graphics graphics) {
        Image image = this.CreateImage("/icons/Icon.png");
        int n = 102;
        int n2 = 102;
        this.DrawDisplayBounds(n, n2, graphics);
        graphics.drawImage(image, this.m_ScreenLPT + 43, this.m_ScreenTPT + 23, 20);
        graphics.setColor(56, 56, 178);
        int n3 = 73;
        while (n3 < 99) {
            graphics.drawLine(this.m_ScreenLPT, this.m_ScreenTPT + n3, this.m_ScreenLPT + this.m_ScreenWidth - 1, this.m_ScreenTPT + n3);
            n3 += 2;
        }
        String string = Local.getText(7);
        Font font = Font.getFont((int)0, (int)1, (int)0);
        graphics.setFont(font);
        graphics.setColor(255, 202, 101);
        int n4 = font.stringWidth(string);
        int n5 = this.m_ScreenWidth / 2 - n4 / 2;
        graphics.drawString(string, n5, this.m_ScreenTPT + 80, 20);
    }

    protected void Dismiss() {
        int[] nArray = new int[]{17, 21, 14, 12, 25, 13};
        this.InitMenuScr(this.MAIN_MENU_SCR, nArray, Local.getText(7), null, null, 0);
    }

    private void InitPuzzleScr() {
        this.m_IsDragging = false;
        this.m_AppMessage = "";
        this.m_DrawGameSettings = true;
        this.m_DismissCount = 0;
        this.m_DrawHighlightCursors = false;
        this.m_FromSquare = -1;
        this.m_ToSquare = -1;
        this.m_HighLightSq = 36;
        this.m_OldHighLightSq = 36;
        this.m_PuzzlesSolved = this.m_SavedSolvedCount;
        this.m_MaxSolvedCount = 6;
        this.m_TimePenalty = 30;
        this.m_DrawBoard = true;
        this.m_TrophyDisplayed = false;
        this.m_DrawTrophy = false;
        this.m_DrawSolCount = false;
        this.m_DrawTopScore = false;
        this.m_PauseClock = true;
        if (this.m_Mode == this.TIMED_MODE) {
            this.m_DrawSolCount = true;
            this.m_DrawTopScore = true;
        }
        if (!this.m_GameImagesInit) {
            this.m_PieceWidth = this.m_Pieces.getWidth() / 7;
            this.m_PieceHeight = this.m_Pieces.getHeight() / 4;
            this.m_PieceCopy = Image.createImage((int)this.m_PieceWidth, (int)this.m_PieceHeight);
            this.InitPuzzleImages();
        }
        this.m_ClockDisplay = this.m_ClockCount = this.m_SavedClockCount;
        if (this.m_CurrentScreen != this.PUZZLE_SCR || this.m_Display.getCurrent() != this.m_FullCanvasScreen) {
            this.m_LastScreen = this.m_CurrentScreen;
            this.m_CurrentScreen = this.PUZZLE_SCR;
            this.m_Display.setCurrent((Displayable)this.m_FullCanvasScreen);
        }
    }

    private int GetSquareX(int n) {
        int n2 = this.m_Board.GetColumn(n);
        return n2 * this.m_PieceWidth;
    }

    private int GetSquareY(int n) {
        int n2 = this.m_Board.GetRow(n);
        return n2 * this.m_PieceHeight;
    }

    protected void PuzzleKeyPressed(int n) {
        block21: {
            block20: {
                if (this.m_TrophyDisplayed || this.m_DrawTextBox || this.m_DrawGameSettings) {
                    if (n != -7) {
                        this.m_DismissCount = 5;
                        this.UpdateClock();
                        return;
                    }
                }
                if (!this.m_Board.IsBoardLoaded()) {
                    if (n != -7) {
                        return;
                    }
                }
                if (n == -6) break block20;
                if (n != -7) break block21;
            }
            this.m_PlayMenu = true;
            int[] nArray = new int[]{17, 21, 14, 12, 25, 13};
            this.InitMenuScr(this.MAIN_MENU_SCR, nArray, Local.getText(7), null, null, 0);
            return;
        }
        if (!this.m_SqPainted) {
            return;
        }
        this.m_OldHighLightSq = this.m_HighLightSq;
        this.m_SqPainted = false;
        if (8 == this.m_FullCanvasScreen.getGameAction(n)) {
            if (this.m_IsDragging) {
                this.DropPiece();
            } else {
                this.DragPiece();
            }
        } else if (2 == this.m_FullCanvasScreen.getGameAction(n)) {
            this.GetHighLightSquare(-1);
        } else if (5 == this.m_FullCanvasScreen.getGameAction(n)) {
            this.GetHighLightSquare(1);
        } else if (1 == this.m_FullCanvasScreen.getGameAction(n)) {
            this.GetHighLightSquare(-8);
        } else if (6 == this.m_FullCanvasScreen.getGameAction(n)) {
            this.GetHighLightSquare(8);
        } else {
            return;
        }
        this.m_FullCanvasScreen.repaint();
    }

    private void GetHighLightSquare(int n) {
        if (this.m_HighLightSq == 0 && n < 0) {
            this.m_HighLightSq = 64;
        }
        if (this.m_HighLightSq == 63 && n > 0) {
            this.m_HighLightSq = -1;
        }
        if (this.m_HighLightSq > 0 && this.m_HighLightSq < 8 && n == -8) {
            this.m_HighLightSq += 64;
        }
        if (this.m_HighLightSq > 55 && this.m_HighLightSq < 63 && n == 8) {
            this.m_HighLightSq -= 64;
        }
        this.m_HighLightSq += n;
    }

    private void DragPiece() {
        if (this.m_Board.m_PieceArray[this.m_HighLightSq] >= 6) {
            return;
        }
        this.m_FromSquare = this.m_HighLightSq;
        this.m_IsDragging = true;
    }

    private void DropPiece() {
        this.m_ToSquare = this.m_HighLightSq;
        this.m_IsDragging = false;
        if (this.m_FromSquare == this.m_ToSquare) {
            return;
        }
        this.m_PauseClock = true;
        boolean bl = this.IsAnswerRight();
        if (!bl) {
            if (this.TIMED_MODE == this.m_Mode) {
                this.m_ClockCount += this.m_TimePenalty;
                this.m_ClockDisplay = this.m_ClockCount;
            }
            this.m_AppMessage = Local.getText(26);
            this.m_DrawTextBox = true;
            this.m_DismissCount = 0;
            if (7 == this.m_PuzzleType || 8 == this.m_PuzzleType) {
                this.m_HighLightSq = this.m_Board.m_SolutionFromSq;
            }
            return;
        }
        if (bl) {
            ++this.m_PuzzlesSolved;
            if (this.m_MaxSolvedCount == this.m_PuzzlesSolved && this.TIMED_MODE == this.m_Mode) {
                int n = this.m_ChessRMS.GetLowestScore(this.m_PuzzleType);
                if (this.m_ClockCount < n || 0 == n) {
                    this.UpdateHighScores(this.m_ClockCount);
                    this.m_TrophyDisplayed = true;
                    this.m_DismissSec = 3;
                    this.m_DismissCount = 0;
                    this.m_DrawTrophy = true;
                    this.m_DrawHighlightCursors = false;
                    this.m_IsDragging = false;
                    this.m_DrawSolCount = false;
                    this.m_DrawTopScore = false;
                } else {
                    this.m_AppMessage = Local.getText(20);
                    this.m_DrawTextBox = true;
                    this.m_DrawHighlightCursors = true;
                    this.m_IsDragging = true;
                    this.m_DismissCount = 0;
                }
                this.m_ClockDisplay = this.m_ClockCount;
                this.m_ClockCount = 0;
                this.m_SqPainted = true;
                this.m_PuzzlesSolved = 0;
                boolean bl2 = true;
                this.SaveGame(bl2);
                this.m_Board.IncrementPuzzle();
                return;
            }
            if (this.CASUAL_MODE == this.m_Mode) {
                this.m_ClockDisplay = this.m_ClockCount = 0;
                boolean bl3 = true;
                this.SaveGame(bl3);
            }
            this.m_AppMessage = Local.getText(9);
            this.m_DrawTextBox = true;
            this.m_DrawHighlightCursors = true;
            this.m_IsDragging = true;
            this.m_SqPainted = true;
            this.m_DismissCount = 0;
            this.m_Board.IncrementPuzzle();
            return;
        }
    }

    private void NextDrill() {
        this.m_FromSquare = -1;
        this.m_ToSquare = -1;
        this.m_OldHighLightSq = 36;
        this.m_HighLightSq = 36;
        this.m_IsDragging = false;
        this.m_Board.NextPuzzle(this.m_PuzzleType);
        if (7 == this.m_PuzzleType || 8 == this.m_PuzzleType) {
            this.m_HighLightSq = this.m_Board.m_SolutionFromSq;
        }
    }

    private void DrawText(String string, int n, int n2, int n3, Graphics graphics) {
        Font font = Font.getDefaultFont();
        int n4 = font.stringWidth(string);
        int n5 = font.getHeight();
        int n6 = this.m_ScreenWidth / 2 - n4 / 2;
        int n7 = this.m_ScreenHeight / 2 - n5 / 2;
        graphics.setColor(0x333333);
        graphics.fillRect(n6, n7, n4 + 8, n5 + 7);
        graphics.setColor(n);
        graphics.fillRect(n6 - 3, n7 - 3, n4 + 6, n5 + 5);
        graphics.setColor(0xFFFF66);
        graphics.drawRect(n6 - 4, n7 - 4, n4 + 7, n5 + 6);
        graphics.setColor(n3);
        graphics.drawString(string, n6 + 2, n7, 0x10 | 4);
    }

    private void DrawGameSettings(int n, int n2, Graphics graphics) {
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        Font font = graphics.getFont();
        int n3 = this.m_PuzzleType;
        if (0 == n3 % 2) {
            --n3;
        }
        n3 /= 2;
        String string = Local.getText(this.GetTypeTextID());
        String string2 = Local.getText(this.GetLevelTextID());
        String string3 = Local.getText(this.GetModeTextID());
        int n4 = font.stringWidth(string);
        int n5 = font.stringWidth(string2);
        int n6 = font.stringWidth(string3);
        int n7 = n4 > n5 ? n4 : n5;
        n7 = n7 > n6 ? n7 : n6;
        int n8 = font.getHeight();
        int n9 = this.m_ScreenWidth / 2 - n7 / 2;
        int n10 = this.m_ScreenHeight / 2 - n8 / 2;
        graphics.setColor(0x333333);
        graphics.fillRect(n9, n10 - n8 - 2, n7 + 8, n8 * 3 + 11);
        graphics.setColor(n);
        graphics.fillRect(n9 - 3, n10 - n8 - 5, n7 + 6, n8 * 3 + 9);
        graphics.setColor(0xFFFF66);
        graphics.drawRect(n9 - 4, n10 - n8 - 6, n7 + 7, n8 * 3 + 10);
        graphics.setColor(n2);
        n9 = this.m_ScreenWidth / 2 - n4 / 2;
        graphics.drawString(string, n9, n10 - n8 - 2, 0x10 | 4);
        n9 = this.m_ScreenWidth / 2 - n5 / 2;
        graphics.drawString(string2, n9, n10, 0x10 | 4);
        n9 = this.m_ScreenWidth / 2 - n6 / 2;
        graphics.drawString(string3, n9, n10 + n8 + 3, 0x10 | 4);
    }

    private boolean IsAnswerRight() {
        return this.m_FromSquare == this.m_Board.m_SolutionFromSq && this.m_ToSquare == this.m_Board.m_SolutionToSq;
    }

    private void InitPuzzleImages() {
        this.m_WhiteSquareImage = Image.createImage((int)this.m_PieceWidth, (int)this.m_PieceHeight);
        this.m_BlackSquareImage = Image.createImage((int)this.m_PieceWidth, (int)this.m_PieceHeight);
        Graphics graphics = this.m_WhiteSquareImage.getGraphics();
        Graphics graphics2 = this.m_BlackSquareImage.getGraphics();
        graphics.drawImage(this.m_Pieces, -6 * this.m_PieceWidth, 0, 20);
        graphics2.drawImage(this.m_Pieces, -6 * this.m_PieceWidth, -this.m_PieceHeight, 20);
        this.m_GameImagesInit = true;
    }

    private void DrawBoard(Graphics graphics) {
        int n = 0;
        while (n < 64) {
            if (this.m_Board.m_PieceArray[n] != 6 && n != this.m_FromSquare) {
                this.DrawPiece(n, this.m_Board.m_PieceArray[n], graphics);
            } else {
                this.DrawBoardSquare(n, graphics);
            }
            ++n;
        }
        graphics.setColor(0xFFFF66);
        graphics.drawRect(this.m_ScreenLPT + this.m_BrdXOffSet - 1, this.m_ScreenTPT + this.m_BrdYOffset - 1, 8 * this.m_PieceWidth + 1, 8 * this.m_PieceHeight + 1);
    }

    private void DrawEmptyBoard(Graphics graphics) {
        int n = 0;
        while (n < 64) {
            this.DrawBoardSquare(n, graphics);
            ++n;
        }
        graphics.setColor(0xFFFF66);
        graphics.drawRect(this.m_ScreenLPT + this.m_BrdXOffSet - 1, this.m_ScreenTPT + this.m_BrdYOffset - 1, 8 * this.m_PieceWidth + 1, 8 * this.m_PieceHeight + 1);
    }

    private void DrawBoardSquare(int n, Graphics graphics) {
        int n2 = this.m_Board.GetRow(n);
        int n3 = this.m_Board.GetColumn(n);
        if (n3 % 2 == 0 && n2 % 2 == 0 || n3 % 2 != 0 && n2 % 2 != 0) {
            graphics.drawImage(this.m_WhiteSquareImage, n3 * this.m_PieceWidth + this.m_ScreenLPT + this.m_BrdXOffSet, n2 * this.m_PieceHeight + this.m_ScreenTPT + this.m_BrdYOffset, 20);
        } else {
            graphics.drawImage(this.m_BlackSquareImage, n3 * this.m_PieceWidth + this.m_ScreenLPT + this.m_BrdXOffSet, n2 * this.m_PieceHeight + this.m_ScreenTPT + this.m_BrdYOffset, 20);
        }
    }

    private void DrawPiece(Graphics graphics) {
        int n = 0;
        while (n < 64) {
            if (this.m_Board.m_PieceArray[n] != 6) {
                this.DrawPiece(n, this.m_Board.m_PieceArray[n], graphics);
            } else {
                this.DrawBoardSquare(n, graphics);
            }
            ++n;
        }
    }

    private void DrawPiece(int n, int n2, Graphics graphics) {
        boolean bl = false;
        if (n < 0 || n > 63) {
            return;
        }
        if (n2 / 6 < 1) {
            bl = true;
        }
        n2 %= 7;
        boolean bl2 = this.m_Board.IsSquareWhite(n);
        Graphics graphics2 = this.m_PieceCopy.getGraphics();
        if (bl) {
            graphics2.drawImage(this.m_Pieces, -n2 * this.m_PieceWidth, -(bl2 ? 0 : 1) * this.m_PieceHeight, 20);
        } else {
            graphics2.drawImage(this.m_Pieces, -n2 * this.m_PieceWidth, -(bl2 ? 2 : 3) * this.m_PieceHeight, 20);
        }
        graphics.drawImage(this.m_PieceCopy, this.m_Board.GetColumn(n) * this.m_PieceWidth + this.m_ScreenLPT + this.m_BrdXOffSet, this.m_Board.GetRow(n) * this.m_PieceHeight + this.m_ScreenTPT + this.m_BrdYOffset, 20);
    }

    private void ReDrawBoardSquare(int n, Graphics graphics) {
        if (this.m_Board.m_PieceArray[n] != 6 && n != this.m_FromSquare) {
            this.DrawPiece(n, this.m_Board.m_PieceArray[n], graphics);
        } else {
            this.DrawBoardSquare(n, graphics);
        }
    }

    private void DrawDisplayBounds(int n, int n2, Graphics graphics) {
        graphics.setColor(n);
        graphics.fillRect(0, 0, this.m_FullCanvasScreen.getWidth(), this.m_FullCanvasScreen.getHeight());
        graphics.setColor(n2);
        graphics.fillRect(this.m_ScreenLPT, this.m_ScreenTPT - 1, this.m_ScreenWidth, this.m_ScreenHeight + 1);
    }

    private void DrawSolvedCount(Graphics graphics) {
        int n = this.m_PuzzlesSolved + 1;
        String string = n + "/" + this.m_MaxSolvedCount;
        Font font = Font.getFont((int)0, (int)1, (int)8);
        graphics.setFont(font);
        graphics.setColor(153);
        graphics.fillRect(this.m_ScreenLPT + this.m_BrdXOffSet, this.m_ScreenTPT, font.stringWidth(string) + 7, font.getHeight());
        graphics.setColor(0xFFFF66);
        graphics.drawString(string, this.m_ScreenLPT + this.m_BrdXOffSet, this.m_ScreenTPT + 1, 0x10 | 4);
    }

    private boolean DismissMessage() {
        if (this.m_TrophyDisplayed) {
            this.m_TrophyDisplayed = false;
            this.m_DismissCount = 0;
            this.m_LastSelectedMenuIndex = this.m_Level - 1;
            this.InitHighScoreDisScr(this.m_Level);
            return true;
        }
        if (this.m_DrawTextBox && this.m_AppMessage.equals(Local.getText(20))) {
            this.m_AppMessage = "";
            this.m_DrawTextBox = false;
            this.m_DismissCount = 0;
            this.InitPuzzleScr();
            this.m_FullCanvasScreen.repaint();
            return true;
        }
        if (this.m_DrawTextBox || this.m_DrawGameSettings) {
            this.m_DismissCount = 0;
            this.m_AppMessage = "";
            this.m_DrawTextBox = false;
            this.m_DrawHighlightCursors = true;
            if (this.m_DrawGameSettings) {
                this.m_DrawGameSettings = false;
                this.NextDrill();
            }
            if (this.IsAnswerRight()) {
                this.NextDrill();
            }
            this.m_DrawBoard = true;
            this.m_FullCanvasScreen.repaint();
            this.m_PauseClock = false;
            return true;
        }
        return false;
    }

    protected void UpdateClock() {
        if (this.m_CurrentScreen == this.PUZZLE_SCR && this.m_FullCanvasScreen.isShown()) {
            if (this.m_TrophyDisplayed || this.m_DrawTextBox || this.m_DrawGameSettings) {
                ++this.m_DismissCount;
                if (this.m_DismissCount > this.m_DismissSec) {
                    this.DismissMessage();
                }
            }
            if (!this.m_PauseClock) {
                ++this.m_ClockCount;
                this.m_ClockDisplay = this.m_ClockCount;
            }
            this.m_FullCanvasScreen.repaint();
            return;
        }
        if (this.m_CurrentScreen == this.SPLASH_SCR && this.m_FullCanvasScreen.isShown()) {
            ++this.m_ClockCount;
            this.m_ClockDisplay = this.m_ClockCount;
            if (this.m_ClockCount > 3) {
                this.Dismiss();
                return;
            }
        }
    }

    private String FormatTime(long l) {
        long l2 = l / 60L;
        long l3 = l % 60L;
        if (l2 > 99L) {
            return "99:59";
        }
        String string = "";
        if (l2 < 10L) {
            string = "0";
        }
        string = string + l2 + ":";
        if (l3 < 10L) {
            string = string + "0";
        }
        return string + l3;
    }

    private void DrawClock(Graphics graphics) {
        String string = this.FormatTime(this.m_ClockDisplay);
        Font font = Font.getFont((int)0, (int)1, (int)8);
        graphics.setFont(font);
        graphics.setColor(153);
        int n = this.m_ScreenLPT + this.m_ScreenWidth / 2 - font.stringWidth(string) / 2;
        if (this.m_Mode == this.TIMED_MODE && !this.m_TrophyDisplayed) {
            n -= 6;
        }
        graphics.fillRect(n, this.m_ScreenTPT, font.stringWidth(string), font.getHeight());
        graphics.setColor(0xFFFF66);
        graphics.drawString(string, n, this.m_ScreenTPT + 1, 0x10 | 4);
    }

    private void DrawTopScore(Graphics graphics) {
        String string = "00:00";
        int n = 0;
        while (n < this.m_HighScoreArray.length) {
            int n2;
            if (n + 1 == this.m_PuzzleType && (n2 = this.m_HighScoreArray[n].m_playerTime) != 0) {
                string = this.FormatTime(n2);
            }
            ++n;
        }
        Font font = Font.getFont((int)0, (int)1, (int)8);
        graphics.setFont(font);
        graphics.setColor(153);
        int n3 = this.m_ScreenLPT + this.m_ScreenWidth - this.m_BrdXOffSet - font.stringWidth(string);
        graphics.fillRect(n3, this.m_ScreenTPT, font.stringWidth(string), font.getHeight());
        graphics.setColor(0xFFFF66);
        graphics.drawString(string, n3, this.m_ScreenTPT + 1, 0x10 | 4);
    }

    protected void PaintPuzzleScr(Graphics graphics) {
        if (!this.m_FullCanvasScreen.isShown()) {
            return;
        }
        if (this.m_TrophyDisplayed) {
            this.DrawTrophy(graphics);
            this.m_DrawTrophy = false;
        }
        if (this.m_DrawDisplayBounds) {
            this.DrawDisplayBounds(153, 153, graphics);
            this.m_DrawDisplayBounds = false;
        }
        if (this.m_DrawBoard) {
            if (this.m_DrawGameSettings) {
                this.DrawEmptyBoard(graphics);
            } else {
                this.DrawBoard(graphics);
            }
            this.m_DrawBoard = false;
        }
        if (!this.m_SqPainted) {
            this.ReDrawBoardSquare(this.m_OldHighLightSq, graphics);
            this.m_SqPainted = true;
        }
        if (this.m_IsDragging) {
            this.DrawPiece(this.m_HighLightSq, this.m_Board.m_PieceArray[this.m_FromSquare], graphics);
        }
        if (this.m_ToSquare != -1 && !this.IsAnswerRight()) {
            this.ReDrawBoardSquare(this.m_HighLightSq, graphics);
            int n = this.m_FromSquare;
            this.m_FromSquare = -1;
            this.ReDrawBoardSquare(n, graphics);
            this.m_ToSquare = -1;
        }
        if (this.m_DrawHighlightCursors) {
            graphics.setColor(255, 0, 0);
            if (this.m_IsDragging) {
                graphics.setColor(0, 0, 255);
            }
            graphics.drawRect(this.GetSquareX(this.m_HighLightSq) + this.m_ScreenLPT + this.m_BrdXOffSet, this.GetSquareY(this.m_HighLightSq) + this.m_ScreenTPT + this.m_BrdYOffset, this.m_PieceWidth - 1, this.m_PieceHeight - 1);
            if (this.m_IsDragging && this.m_HighLightSq != this.m_FromSquare) {
                graphics.setColor(0, 0, 255);
                graphics.drawRect(this.GetSquareX(this.m_FromSquare) + this.m_ScreenLPT + this.m_BrdXOffSet, this.GetSquareY(this.m_FromSquare) + this.m_ScreenTPT + this.m_BrdYOffset, this.m_PieceWidth - 1, this.m_PieceHeight - 1);
            }
        }
        if (this.m_DrawTextBox) {
            Font font = Font.getDefaultFont();
            this.DrawText(this.m_AppMessage, 153, 0xFFFF66, 0xFFFF66, graphics);
        }
        if (this.m_DrawGameSettings) {
            this.DrawGameSettings(153, 0xFFFF66, graphics);
        }
        if (this.m_DrawSolCount) {
            this.DrawSolvedCount(graphics);
        }
        if (this.m_DrawTopScore) {
            this.DrawTopScore(graphics);
        }
        this.DrawClock(graphics);
    }

    protected void PausePuzzleGame() {
        this.m_PauseClock = true;
        boolean bl = false;
        this.SaveGame(bl);
    }

    protected void StartPuzzleGame() {
        DeviceControl.setLights(0, 100);
        if (this.m_TrophyDisplayed) {
            this.m_DrawTrophy = true;
            this.m_DrawHighlightCursors = false;
            this.m_DrawSolCount = false;
            this.m_DrawTopScore = false;
        } else {
            this.m_DrawBoard = true;
            this.m_DrawDisplayBounds = true;
            this.m_DrawHighlightCursors = true;
            if (this.m_Mode == this.TIMED_MODE) {
                this.m_DrawSolCount = true;
                this.m_DrawTopScore = true;
            }
            if (!this.m_DrawGameSettings && !this.m_DrawTextBox) {
                this.m_PauseClock = false;
            }
        }
        this.m_FullCanvasScreen.repaint();
    }

    private void DrawTrophy(Graphics graphics) {
        Image image = this.CreateImage("/icons/trophy.png");
        int n = 102;
        int n2 = 102;
        this.DrawDisplayBounds(n, n2, graphics);
        int n3 = this.m_ScreenWidth / 2 - image.getWidth() / 2;
        int n4 = this.m_ScreenHeight / 2 - image.getHeight() / 2;
        graphics.drawImage(image, n3, n4, 20);
    }

    public void SaveGame(boolean bl) {
        if (bl) {
            this.m_SavedSolvedCount = 0;
            this.m_SavedClockCount = 0;
            this.m_PlayMenu = false;
        } else {
            this.m_SavedSolvedCount = this.m_PuzzlesSolved;
            this.m_SavedClockCount = this.m_ClockCount;
        }
        this.m_ChessRMS.ManageUserSettings(this.m_PuzzleType, this.m_Mode, this.m_Level, this.m_SavedSolvedCount, this.m_SavedClockCount);
    }

    protected class CountDown
    extends TimerTask {
        protected CountDown() {
        }

        public void run() {
            if (ChessPuzzleMidlet.this.m_CurrentScreen == ChessPuzzleMidlet.this.PUZZLE_SCR || ChessPuzzleMidlet.this.m_CurrentScreen == ChessPuzzleMidlet.this.SPLASH_SCR) {
                ChessPuzzleMidlet.this.UpdateClock();
                return;
            }
        }
    }
}

