/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.chep;

import com.nokia.mid.appl.chep.ChessRMS;
import com.nokia.mid.appl.chep.HuffNode;
import java.io.IOException;
import java.io.InputStream;

public class ChessBoard {
    static final String m_FileName = "/Puzzles.BIN";
    public int[] m_PieceArray;
    public int m_SolutionFromSq;
    public int m_SolutionToSq;
    private char m_mask;
    private char m_code;
    private int m_byte;
    private int m_bit;
    private int m_square;
    private int m_PuzzleType = 1;
    private ChessRMS m_RMS;
    private InputStream m_InStream;
    private boolean m_BoardLoaded = false;
    private int m_LastSolutionFirstByte = 0;
    private int m_LastEndOfPuzzleByte = 0;
    private int m_LastPuzzleType = 0;
    private int m_LastPuzzleOffsetByte = 0;
    private int m_LastByte = 0;
    private int m_LastBit = 0;
    private int m_LastSolutionOffsetByte = 0;
    private boolean m_CanIncrement = false;
    private int[] m_CodeCount = new int[]{13, 11};
    HuffNode[][] m_CodeTable = new HuffNode[][]{{new HuffNode(32, '\u0000', 6), new HuffNode(8, '\u0004', 5), new HuffNode(8, '\u0005', 12), new HuffNode(2, '\u0018', 2), new HuffNode(2, '\u0019', 9), new HuffNode(2, '\u001a', 3), new HuffNode(2, '\u001b', 10), new HuffNode(2, '\u001c', 4), new HuffNode(2, '\u001d', 11), new HuffNode(1, '<', 0), new HuffNode(1, '=', 7), new HuffNode(1, '>', 1), new HuffNode(1, '?', 8)}, {new HuffNode(32, '\u0000', 6), new HuffNode(2, '\b', 2), new HuffNode(2, '\t', 9), new HuffNode(2, '\n', 3), new HuffNode(2, '\u000b', 10), new HuffNode(2, '\f', 4), new HuffNode(2, '\r', 11), new HuffNode(1, '\u001c', 0), new HuffNode(1, '\u001d', 7), new HuffNode(1, '\u001e', 1), new HuffNode(1, '\u001f', 8), new HuffNode(0, '\u0000', 0), new HuffNode(0, '\u0000', 0)}};

    public ChessBoard(ChessRMS chessRMS) {
        this.m_RMS = chessRMS;
        this.StorePuzzleHeader();
    }

    public void NextPuzzle(int n) {
        this.SetBoardLoadState(false);
        if (0 != n) {
            this.m_PuzzleType = n;
        }
        this.m_SolutionFromSq = 0;
        this.m_SolutionToSq = 0;
        this.m_PieceArray = new int[64];
        this.m_mask = (char)128;
        this.m_code = '\u0000';
        this.m_byte = 0;
        this.m_bit = 0;
        this.m_square = 0;
        this.IncrementPuzzle();
        this.ReadPuzzle();
        this.SetBoardLoadState(true);
    }

    public boolean IsSquareWhite(int n) {
        boolean bl = false;
        if (this.GetColumn(n) % 2 == 0 && this.GetRow(n) % 2 == 0 || this.GetColumn(n) % 2 != 0 && this.GetRow(n) % 2 != 0) {
            bl = true;
        }
        return bl;
    }

    public int GetRow(int n) {
        return n / 8;
    }

    public int GetColumn(int n) {
        return n % 8;
    }

    public void StorePuzzleHeader() {
        try {
            this.m_InStream = this.getClass().getResourceAsStream(m_FileName);
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[4];
            int n = this.m_RMS.GetPuzzleRecordCount();
            int n2 = 0;
            int n3 = 0;
            int n4 = this.m_InStream.read();
            if (0 != n && n4 != n) {
                this.m_RMS.DeleteChessStore(false);
            }
            int n5 = 1;
            while (n5 <= n4) {
                int n6 = this.m_InStream.read(byArray, 0, 4);
                n3 = this.ConvertByteToInt(byArray);
                n6 = this.m_InStream.read(byArray2, 0, 4);
                n2 = this.ConvertByteToInt(byArray2);
                if (0 != n && n4 == n) {
                    this.m_RMS.GetPuzzleRecord(n5);
                    if (n3 != this.m_RMS.m_PuzzleFirstByte || n2 != this.m_RMS.m_SolutionFirstByte) {
                        this.m_RMS.ManagePuzzleRecord(false, n5, n3, n2, 0, 0, 0);
                    }
                } else {
                    this.m_RMS.ManagePuzzleRecord(true, n5, n3, n2, 0, 0, 0);
                }
                ++n5;
            }
            this.m_InStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    private int ConvertByteToInt(byte[] byArray) {
        int n = 0;
        n += this.UnsignedByteToInt(byArray[3]) << 24;
        n += this.UnsignedByteToInt(byArray[2]) << 16;
        n += this.UnsignedByteToInt(byArray[1]) << 8;
        return n += this.UnsignedByteToInt(byArray[0]) << 0;
    }

    private int UnsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private void SetBoardLoadState(boolean bl) {
        this.m_BoardLoaded = bl;
    }

    public boolean IsBoardLoaded() {
        return this.m_BoardLoaded;
    }

    private void ReadPuzzle() {
        this.m_RMS.GetPuzzleRecord(this.m_PuzzleType);
        int n = this.m_RMS.m_PuzzleFirstByte + this.m_RMS.m_PuzzleOffsetByte;
        int n2 = this.m_RMS.m_SolutionFirstByte + this.m_RMS.m_SolutionOffsetByte;
        this.MakeBoard(n, this.m_RMS.m_PuzzleOffsetBit, n2, this.m_PieceArray);
    }

    private int MakeBoard(int n, int n2, int n3, int[] nArray) {
        int n4;
        try {
            this.m_InStream = this.getClass().getResourceAsStream(m_FileName);
            this.m_InStream.skip(n);
            this.m_bit = n2;
            int n5 = this.m_InStream.read();
            while (this.m_square < 64) {
                this.m_code = (char)(this.m_code << 1);
                if ((n5 & this.m_mask >> this.m_bit) != 0) {
                    this.m_code = (char)(this.m_code + '\u0001');
                }
                int n6 = 0;
                if (this.m_square < 8 || this.m_square > 55) {
                    n6 = 1;
                }
                n4 = 0;
                while (n4 < this.m_CodeCount[n6]) {
                    if (this.m_code == this.m_CodeTable[n6][n4].m_code) {
                        nArray[this.m_square] = this.m_CodeTable[n6][n4].m_value;
                        ++this.m_square;
                        this.m_code = '\u0000';
                        break;
                    }
                    ++n4;
                }
                if (7 >= ++this.m_bit) continue;
                ++this.m_byte;
                n5 = this.m_InStream.read();
                this.m_bit = 0;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
        if (this.m_square < 64) {
            return 0;
        }
        int n7 = n + this.m_byte + 1;
        n4 = n3 - n7;
        try {
            this.m_InStream.skip(n4);
            int n8 = this.m_InStream.read();
            this.m_SolutionFromSq = n8 / 16 * 8 + n8 % 16;
            int n9 = this.m_InStream.read();
            this.m_SolutionToSq = n9 / 16 * 8 + n9 % 16;
            this.m_InStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        this.m_LastSolutionFirstByte = this.m_RMS.m_SolutionFirstByte;
        this.m_LastEndOfPuzzleByte = n7;
        this.m_LastPuzzleType = this.m_PuzzleType;
        this.m_LastPuzzleOffsetByte = this.m_RMS.m_PuzzleOffsetByte;
        this.m_LastByte = this.m_byte;
        this.m_LastBit = this.m_bit;
        this.m_LastSolutionOffsetByte = this.m_RMS.m_SolutionOffsetByte;
        this.m_CanIncrement = true;
        return 1;
    }

    public void IncrementPuzzle() {
        if (!this.m_CanIncrement) {
            return;
        }
        if (this.m_LastSolutionFirstByte - this.m_LastEndOfPuzzleByte > 3) {
            this.m_RMS.ManagePuzzleRecord(false, this.m_LastPuzzleType, 0, 0, this.m_LastPuzzleOffsetByte + this.m_LastByte, this.m_LastBit, this.m_LastSolutionOffsetByte + 2);
        } else {
            this.m_RMS.ManagePuzzleRecord(false, this.m_LastPuzzleType, 0, 0, 0, 0, 0);
        }
        this.m_CanIncrement = false;
    }
}

