/*
 * Decompiled with CFR 0.152.
 */
package com.innograte.j2me.games.dwindle;

import com.innograte.j2me.games.dwindle.IDwindleCallback;
import java.util.Random;

public class Dwindle {
    IDwindleCallback callback;
    private Random rand;
    public static final int MAX_COLORS = 8;
    int score;
    int level;
    int numActivatedNewLeftToNextLevel;
    int numActiveColors;
    int neighborsRequired = 3;
    private static final byte[] numActiveColorsPerLevel;
    private static final byte[] numStartRowsPerLevel;
    private static final byte[] numActivateNewBlocksPerLevel;
    private static final int[] stepDelayPerLevel;
    private static final int[] LEVEL_HEIGHT_BONUS;
    public static final byte BOMB25 = 125;
    public static final byte BOMB9 = 109;
    public static final byte DROPPED = 100;
    public static final byte EMPTY = 0;
    public static final int BLOCKS_X = 12;
    public static final int BLOCKS_Y = 15;
    byte[][] blocks = new byte[12][15];
    byte[] newBlocks = new byte[12];
    int numNewBlocks = 0;
    boolean[][] visited = new boolean[12][15];

    public Dwindle(IDwindleCallback iDwindleCallback) {
        this.rand = new Random();
        this.callback = iDwindleCallback;
    }

    public void clearVisited(boolean bl) {
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 15; ++j) {
                if (!this.visited[i][j]) continue;
                if (bl && this.blocks[i][j] != 0) {
                    this.blocks[i][j] = 100;
                }
                this.visited[i][j] = false;
            }
        }
    }

    public boolean action(int n, int n2) {
        if (this.blocks[n][n2] == 0) {
            return false;
        }
        if (this.blocks[n][n2] == 109) {
            this.score += this.bomb9(n, n2);
            this.clearVisited(true);
            return true;
        }
        if (this.blocks[n][n2] == 125) {
            this.score += this.bomb25(n, n2);
            this.clearVisited(true);
            return true;
        }
        int n3 = this.count(n, n2);
        if (n3 >= this.neighborsRequired) {
            this.score += n3;
            this.bonus(n3);
            this.clearVisited(true);
            return true;
        }
        this.clearVisited(false);
        return false;
    }

    private int bomb9(int n, int n2) {
        int n3 = 0;
        for (int i = n - 1; i <= n + 1; ++i) {
            if (i < 0 || i >= 12) continue;
            for (int j = n2 - 1; j <= n2 + 1; ++j) {
                if (j < 0 || j >= 15 || this.blocks[n][n2] == 0 || this.visited[i][j]) continue;
                this.visited[i][j] = true;
                ++n3;
            }
        }
        return n3;
    }

    private int bomb25(int n, int n2) {
        int n3 = 0;
        for (int i = n - 2; i <= n + 2; ++i) {
            if (i < 0 || i >= 12) continue;
            for (int j = n2 - 2; j <= n2 + 2; ++j) {
                if (j < 0 || j >= 15 || this.blocks[n][n2] == 0 || this.visited[i][j]) continue;
                this.visited[i][j] = true;
                ++n3;
            }
        }
        return n3;
    }

    int calcLevelBonus() {
        int n = -1;
        for (int i = 0; i < 12; ++i) {
            byte[] byArray = this.blocks[i];
            for (int j = 0; j < 15; ++j) {
                if (j < n || byArray[j] == 0) continue;
                n = j;
            }
        }
        return LEVEL_HEIGHT_BONUS[n] * (this.level + 10) / 10;
    }

    void bonus(int n) {
        int n2 = n / 10;
        if (n2 > 0) {
            n2 = n * (n2 + 2) / 2 * (this.numActiveColors - 2);
            this.score += n2;
            this.callback.bonus(n2);
        }
    }

    private int count(int n, int n2) {
        byte by = this.blocks[n][n2];
        return this.countNeighbors(n, n2, by);
    }

    private int countNeighbors(int n, int n2, byte by) {
        if (this.visited[n][n2] || this.blocks[n][n2] != by) {
            return 0;
        }
        this.visited[n][n2] = true;
        int n3 = 1;
        if (n - 1 >= 0) {
            n3 += this.countNeighbors(n - 1, n2, by);
        }
        if (n + 1 < 12) {
            n3 += this.countNeighbors(n + 1, n2, by);
        }
        if (n2 - 1 >= 0) {
            n3 += this.countNeighbors(n, n2 - 1, by);
        }
        if (n2 + 1 < 15) {
            n3 += this.countNeighbors(n, n2 + 1, by);
        }
        return n3;
    }

    public void cleanupDropped() {
        int n;
        int n2 = 6;
        for (n = 0; n < 12; ++n) {
            this.compressRow(this.blocks[n]);
        }
        int n3 = n = n2;
        while (n >= 0) {
            if (this.blocks[n][0] == 0) {
                --n;
                continue;
            }
            this.blocks[n3] = this.blocks[n];
            --n3;
            --n;
        }
        while (n3 > n) {
            this.blocks[n3] = new byte[15];
            --n3;
        }
        n3 = n = n2 + 1;
        while (n < 12) {
            if (this.blocks[n][0] == 0) {
                ++n;
                continue;
            }
            this.blocks[n3] = this.blocks[n];
            ++n3;
            ++n;
        }
        while (n3 < n) {
            this.blocks[n3] = new byte[15];
            ++n3;
        }
    }

    void compressRow(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 15 && byArray[n2] != 0) {
            if (byArray[n2] == 100) {
                ++n2;
                continue;
            }
            byArray[n] = byArray[n2];
            ++n2;
            ++n;
        }
        while (n < n2) {
            byArray[n] = 0;
            ++n;
        }
    }

    public void fillNewBlocksNow() {
        while (this.numNewBlocks < 12) {
            this.newBlocks[this.numNewBlocks] = this.getRandomBlock();
            ++this.numNewBlocks;
        }
    }

    public void step() {
        if (this.numNewBlocks >= 12) {
            this.activateNewBlocks();
        } else {
            this.newBlocks[this.numNewBlocks] = this.getRandomBlock();
            ++this.numNewBlocks;
        }
    }

    private void activateNewBlocks() {
        int n;
        for (n = 0; n < 12; ++n) {
            if (this.blocks[n][14] == 0) continue;
            this.callback.gameOver();
            return;
        }
        for (n = 0; n < 12; ++n) {
            byte[] byArray = this.blocks[n];
            for (int i = 14; i > 0; --i) {
                byArray[i] = byArray[i - 1];
            }
            byArray[0] = this.newBlocks[n];
            this.newBlocks[n] = 0;
            this.numNewBlocks = 0;
        }
        if (this.numActivatedNewLeftToNextLevel <= 0) {
            n = this.calcLevelBonus();
            this.score += n;
            this.callback.levelCompleted(this.getLevel(), n);
            return;
        }
        --this.numActivatedNewLeftToNextLevel;
    }

    private byte getRandomBlock() {
        int n = Math.abs(this.rand.nextInt());
        int n2 = n % 10000;
        if (n2 < 10) {
            return 125;
        }
        if (n2 < 35) {
            return 109;
        }
        return (byte)(1 + n % this.numActiveColors);
    }

    public void setupNewLevel(int n) {
        this.level = n - 1;
        this.numActivatedNewLeftToNextLevel = numActivateNewBlocksPerLevel[this.level];
        this.numActiveColors = numActiveColorsPerLevel[this.level];
        this.numNewBlocks = 0;
        for (int i = 0; i < 12; ++i) {
            int n2;
            byte[] byArray = this.blocks[i];
            for (n2 = 0; n2 < numStartRowsPerLevel[this.level]; ++n2) {
                byArray[n2] = this.getRandomBlock();
            }
            for (n2 = numStartRowsPerLevel[this.level]; n2 < 15; ++n2) {
                byArray[n2] = 0;
            }
            this.newBlocks[i] = 0;
        }
    }

    public int getLevel() {
        return this.level + 1;
    }

    public int getNumActivatedNewLeftToNextLevel() {
        return this.numActivatedNewLeftToNextLevel;
    }

    public int getScore() {
        return this.score;
    }

    public byte[][] getBlocks() {
        return this.blocks;
    }

    public byte[] getNewBlocks() {
        return this.newBlocks;
    }

    public int getDelay() {
        return stepDelayPerLevel[this.level];
    }

    static {
        MAX_COLORS = 8;
        numActiveColorsPerLevel = new byte[]{3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8};
        numStartRowsPerLevel = new byte[]{4, 4, 4, 5, 4, 4, 4, 5, 4, 4, 4, 5, 4, 4, 4, 5, 4, 4, 4, 5, 4, 5};
        numActivateNewBlocksPerLevel = new byte[]{15, 20, 25, 30, 20, 25, 30, 35, 20, 25, 30, 35, 20, 25, 30, 35, 20, 25, 30, 40, 50, 99};
        stepDelayPerLevel = new int[]{500, 400, 350, 300, 450, 400, 350, 300, 450, 400, 350, 300, 400, 350, 250, 200, 400, 300, 200, 150, 200, 100};
        LEVEL_HEIGHT_BONUS = new int[]{200, 200, 150, 100, 80, 70, 60, 50, 40, 35, 30, 25, 20, 15, 10, 5, 0};
        BOMB25 = (byte)125;
        BOMB9 = (byte)109;
        DROPPED = (byte)100;
        EMPTY = 0;
        BLOCKS_X = 12;
        BLOCKS_Y = 15;
    }
}

