/*
 * Decompiled with CFR 0.152.
 */
package com.innograte.j2me.games.dwindle;

import com.innograte.j2me.games.dwindle.DwindleMidlet;
import com.innograte.j2me.games.dwindle.GlobalHighScore;
import com.innograte.j2me.util.Tokenizer;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class HighScore
extends Canvas
implements CommandListener {
    public final String HIGH_SCORE_RS_NAME;
    public final int numOfHighScores;
    public String[] highScoreNames;
    public int[] highScores;
    public byte[] highScoreLevel;
    private Command backCommand = new Command("Back", 2, 1);
    private Command showGlobalCommand;
    private Command nameInputConfirmCommand = new Command("OK", 4, 1);
    public DwindleMidlet dwindleMidlet;
    public Displayable previousDisplayable = null;
    public GlobalHighScore globalHighScore;
    public int newHighScoreIndex;
    public TextField userInputName;
    static final String SEPARATOR = "|";

    public HighScore(DwindleMidlet dwindleMidlet) {
        this.HIGH_SCORE_RS_NAME = "DwindleRS";
        this.numOfHighScores = 8;
        this.showGlobalCommand = new Command("Show Global", 1, 1);
        this.dwindleMidlet = dwindleMidlet;
        this.highScoreNames = new String[8];
        this.highScoreLevel = new byte[8];
        this.highScores = new int[8];
        this.globalHighScore = new GlobalHighScore(Display.getDisplay((MIDlet)this.dwindleMidlet), (Displayable)this);
        try {
            try {
                RecordStore.deleteRecordStore((String)"DwindleRS");
            }
            catch (Exception exception) {
                // empty catch block
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"DwindleRS", (boolean)true);
            int n = recordStore.getNumRecords();
            if (n == 0) {
                byte[] byArray = this.formatEntry("AAA", (byte)0, 0);
                for (int i = 0; i < 8; ++i) {
                    this.highScores[i] = 0;
                    this.highScoreNames[i] = "AAA";
                    this.highScoreLevel[i] = 0;
                    recordStore.addRecord(byArray, 0, byArray.length);
                }
                recordStore.closeRecordStore();
            } else {
                for (int i = 0; i < 8; ++i) {
                    String string = new String(recordStore.getRecord(i + 1));
                    Tokenizer tokenizer = new Tokenizer(string, '|');
                    this.highScoreNames[i] = tokenizer.nextToken();
                    this.highScoreLevel[i] = (byte)Integer.parseInt(tokenizer.nextToken());
                    this.highScores[i] = Integer.parseInt(tokenizer.nextToken());
                }
                recordStore.closeRecordStore();
            }
            this.addCommand(this.backCommand);
            this.addCommand(this.showGlobalCommand);
            this.setCommandListener(this);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    byte[] formatEntry(String string, byte by, int n) {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(SEPARATOR).append(by).append(SEPARATOR).append(n))).getBytes();
    }

    protected void showNotify() {
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            System.out.println("dwindleMidlet: ".concat(String.valueOf(String.valueOf(this.dwindleMidlet == null ? "null" : "not null"))));
            System.out.println("previousDisplayable: ".concat(String.valueOf(String.valueOf(this.previousDisplayable == null ? "null" : "not null"))));
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent(this.previousDisplayable);
        } else if (command == this.nameInputConfirmCommand) {
            try {
                this.highScoreNames[this.newHighScoreIndex] = this.userInputName.getString().length() > 0 ? this.userInputName.getString() : " ";
                RecordStore recordStore = RecordStore.openRecordStore((String)"DwindleRS", (boolean)true);
                byte[] byArray = this.formatEntry(this.highScoreNames[this.newHighScoreIndex], this.highScoreLevel[this.newHighScoreIndex], this.highScores[this.newHighScoreIndex]);
                recordStore.setRecord(1 + this.newHighScoreIndex, byArray, 0, byArray.length);
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                exception.printStackTrace();
            }
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)this.globalHighScore);
            this.globalHighScore.newScore(this.highScoreNames[this.newHighScoreIndex], this.highScores[this.newHighScoreIndex], "Lvl ".concat(String.valueOf(String.valueOf(this.highScoreLevel[this.newHighScoreIndex]))));
        } else if (command == this.showGlobalCommand) {
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)this.globalHighScore);
            this.globalHighScore.showGlobal();
        }
    }

    public void paint(Graphics graphics) {
        int n = 2;
        int n2 = 3;
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.getWidth(), n);
        graphics.fillRect(0, n, n, this.getHeight());
        graphics.fillRect(this.getWidth() - n, 0, n, this.getHeight());
        graphics.fillRect(0, this.getHeight() - n, this.getWidth(), n);
        Font font = Font.getFont((int)0, (int)1, (int)0);
        graphics.setFont(font);
        graphics.drawString("High Scores", this.getWidth() / 2, n2, 17);
        graphics.fillRect(n, n2 += font.getHeight(), this.getWidth(), n);
        n2 += n + 1;
        font = Font.getFont((int)0, (int)0, (int)0);
        graphics.setFont(font);
        for (int i = 0; i < 8; ++i) {
            graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append("-").append(this.highScoreNames[i]).append(" lvl ").append(this.highScoreLevel[i]))), n + 1, n2, 20);
            graphics.drawString(String.valueOf(String.valueOf(this.highScores[i])).concat(""), this.getWidth() - n - 1, n2, 24);
            n2 += 12;
        }
    }

    public void processNewScore(int n, int n2, Displayable displayable) {
        this.previousDisplayable = displayable;
        for (int i = 0; i < 8; ++i) {
            if (n < this.highScores[i]) continue;
            for (int j = 7; j > i; --j) {
                this.highScores[j] = this.highScores[j - 1];
                this.highScoreNames[j] = this.highScoreNames[j - 1];
                this.highScoreLevel[j] = this.highScoreLevel[j - 1];
            }
            this.newHighScoreIndex = i;
            this.highScores[i] = n;
            this.highScoreLevel[i] = (byte)n2;
            Form form = new Form("New HighScore!");
            this.userInputName = new TextField(String.valueOf(String.valueOf(new StringBuffer("New High score No.").append(i + 1).append(" ").append(n))), "", 24, 0);
            form.append((Item)this.userInputName);
            form.addCommand(this.nameInputConfirmCommand);
            form.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)form);
            break;
        }
    }

    public void displayHighScore(Displayable displayable) {
        this.previousDisplayable = displayable;
        Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)this);
    }

    static {
        SEPARATOR = SEPARATOR;
    }
}

