/*
 * Decompiled with CFR 0.152.
 */
package com.innograte.j2me.games.dwindle;

import com.innograte.j2me.games.dwindle.Dwindle;
import com.innograte.j2me.games.dwindle.DwindleMidlet;
import com.innograte.j2me.games.dwindle.IDwindleCallback;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DwindleCanvas
extends Canvas
implements CommandListener,
IDwindleCallback {
    Dwindle dwindleGame = null;
    public byte curNumCellsX;
    public byte curNumCellsY;
    int newLevel = 0;
    int levelBonus = 0;
    int nextLevelShown = 0;
    int bonus = 0;
    int bonusShown = 0;
    public static final byte PAUSED = 3;
    public static final byte LEVEL_UP = 4;
    public static final byte PLAYING = 5;
    public static final byte GAMEOVER = 6;
    private Command quitCommand = new Command("Menu", 2, 3);
    private Command unpauseCommand;
    private Command pauseCommand = new Command("Pause", 1, 1);
    private short canvasWidth;
    private short canvasHeight;
    private short viewStartX;
    private short viewStartY;
    private short viewWidth;
    private short viewHeight;
    private short boardWidth;
    private short boardHeight;
    private short boardStartX;
    private short boardStartY;
    private short boardEndX;
    private short boardEndY;
    private short cellWidth;
    private short cellHeight;
    private short hudStartX;
    private short hudStartY;
    private short hudWidth;
    private short hudHeight;
    private boolean hudAtSide;
    private Random rand;
    private Font messageFont;
    private int fontHeight;
    private Image[] blockImages;
    private Image boardImage;
    private Image hudImage;
    private Image bomb9Image;
    private Image bomb25Image;
    private Image urlImage;
    private Graphics boardImageGraphics;
    private Image frameBuffer;
    private Graphics frameBufferGraphics;
    private DwindleMidlet dwindleMidlet;
    private byte cursorY;
    private byte cursorX;
    public byte currentMode;
    public long lastEventTime = 0L;
    public long lastSelectionBoxDrawTime = 0L;
    public int inputBuffer = -1;
    int stepDelay;
    private static final int[] BLOCK_COLORS;

    public DwindleCanvas(DwindleMidlet dwindleMidlet) throws Exception {
        this.unpauseCommand = new Command("Resume", 1, 2);
        this.dwindleGame = new Dwindle(this);
        this.curNumCellsX = (byte)12;
        this.curNumCellsY = (byte)15;
        this.rand = new Random();
        this.dwindleMidlet = dwindleMidlet;
        this.currentMode = (byte)5;
        this.canvasWidth = (short)this.getWidth();
        this.canvasHeight = (short)this.getHeight();
        int n = (this.canvasHeight - 5) / (this.curNumCellsY + 1) - 1;
        this.bomb9Image = Image.createImage((int)n, (int)n);
        this.bomb9Image.getGraphics().drawImage(Image.createImage((String)"/images/bomb9.png"), 0, 0, 20);
        this.bomb25Image = Image.createImage((int)n, (int)n);
        this.bomb25Image.getGraphics().drawImage(Image.createImage((String)"/images/bomb25.png"), 0, 0, 20);
        this.urlImage = Image.createImage((String)"/images/url2.png");
        this.blockImages = new Image[9];
        for (int n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
            this.blockImages[n2] = this.createBlockImage(BLOCK_COLORS[n2], n);
        }
        this.messageFont = Font.getFont((int)0, (int)0, (int)8);
        this.fontHeight = this.messageFont.getHeight();
        this.cellWidth = (short)(this.blockImages[0].getWidth() + 1);
        this.cellHeight = (short)(this.blockImages[0].getHeight() + 1);
        this.boardWidth = (short)(this.cellWidth * this.curNumCellsX + 1);
        this.boardHeight = (short)(this.cellHeight * (this.curNumCellsY + 1) + 2);
        this.hudHeight = 0;
        this.viewStartX = 0;
        this.viewWidth = this.canvasWidth;
        this.viewStartY = this.hudHeight;
        this.viewHeight = this.canvasHeight;
        this.cursorX = (byte)6;
        this.cursorY = (byte)5;
        if (this.viewWidth - this.boardWidth > 40) {
            this.hudAtSide = true;
            this.hudImage = Image.createImage((String)"/images/hud2.png");
            this.hudWidth = (short)Math.min(this.hudImage.getWidth(), this.viewWidth - this.boardWidth - 2);
            this.boardStartX = (short)((this.viewWidth - (this.boardWidth + this.hudWidth + 2)) / 2);
            this.hudStartX = (short)(this.boardStartX + this.boardWidth + 2);
            this.hudHeight = (short)this.hudImage.getHeight();
        } else {
            this.boardStartX = (short)((this.viewWidth - this.boardWidth) / 2);
            this.hudStartX = (short)(this.boardStartX + 2);
            this.hudWidth = (short)(this.boardWidth - 4);
            this.hudAtSide = false;
        }
        this.hudStartY = this.boardStartY = (short)((this.viewHeight - this.boardHeight) / 2);
        this.boardEndX = (short)(this.boardStartX + this.boardWidth);
        this.boardEndY = (short)(this.boardStartY + this.boardHeight);
        this.boardImage = Image.createImage((int)this.boardWidth, (int)this.boardHeight);
        this.boardImageGraphics = this.boardImage.getGraphics();
        this.boardImageGraphics.setColor(0, 0, 0);
        this.boardImageGraphics.fillRect(0, 0, (int)this.boardWidth, (int)this.boardHeight);
        this.boardImageGraphics.setColor(255, 230, 75);
        this.boardImageGraphics.fillRect(0, this.boardHeight - this.cellHeight - 2, (int)this.boardWidth, 1);
        this.frameBuffer = Image.createImage((int)this.canvasWidth, (int)this.canvasHeight);
        this.frameBufferGraphics = this.frameBuffer.getGraphics();
        this.frameBufferGraphics.setFont(this.messageFont);
        this.frameBufferGraphics.setColor(255, 200, 40);
        this.frameBufferGraphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
        this.frameBufferGraphics.setColor(200, 160, 30);
        this.frameBufferGraphics.drawRect(this.boardStartX - 1, this.boardStartY - 1, this.boardWidth + 1, this.boardHeight + 1);
        if (this.boardStartX > this.urlImage.getWidth() + 3 && this.canvasHeight > this.urlImage.getHeight()) {
            this.frameBufferGraphics.drawImage(this.urlImage, this.boardStartX - 2, (int)this.boardStartY, 24);
        }
        this.resetGame();
        this.setCommandListener(this);
        this.addCommand(this.quitCommand);
        this.addCommand(this.pauseCommand);
        this.repaintAll();
    }

    Image createBlockImage(int n, int n2) {
        Image image = Image.createImage((int)n2, (int)n2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(n);
        graphics.fillRect(1, 1, n2 - 2, n2 - 2);
        int n3 = ((n & 0xFF0000) >> 16) * 3 / 4;
        int n4 = ((n & 0xFF00) >> 8) * 3 / 4;
        int n5 = (n & 0xFF) * 3 / 4;
        int n6 = n3 << 16 & 0xFF0000 | n4 << 8 & 0xFF00 | n5 & 0xFF;
        graphics.setColor(n6);
        graphics.drawLine(0, 0, n2 - 1, 0);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.drawLine(n2 - 1, n2 - 1, n2 - 1, 0);
        graphics.drawLine(n2 - 1, n2 - 1, 0, n2 - 1);
        return image;
    }

    protected void hideNotify() {
        this.pause();
    }

    private void pause() {
        if (this.currentMode == 5) {
            this.currentMode = (byte)3;
            this.addCommand(this.unpauseCommand);
            this.removeCommand(this.pauseCommand);
            this.repaintAll();
        }
    }

    private void resume() {
        if (this.currentMode == 3) {
            this.currentMode = (byte)5;
            this.addCommand(this.pauseCommand);
            this.removeCommand(this.unpauseCommand);
            this.repaintAll();
        }
    }

    protected void showNotify() {
        this.lastEventTime = System.currentTimeMillis();
        this.dwindleMidlet.animator.enable();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.quitCommand) {
            DwindleMidlet.restart();
        } else if (command == this.unpauseCommand) {
            this.resume();
        } else if (command == this.pauseCommand) {
            this.pause();
        }
    }

    public synchronized void updateWorld() {
        if (this.isShown()) {
            this.processPlayerInput(this.inputBuffer);
            if (this.currentMode == 4) {
                --this.nextLevelShown;
                if (this.nextLevelShown <= 0) {
                    this.dwindleGame.setupNewLevel(this.newLevel);
                    this.stepDelay = this.dwindleGame.getDelay();
                    this.newLevel = 0;
                    this.currentMode = (byte)5;
                }
                return;
            }
            if (this.currentMode != 5) {
                return;
            }
            this.frameBufferGraphics.drawImage(this.boardImage, (int)this.boardStartX, (int)this.boardStartY, 20);
            this.frameBufferGraphics.setColor(255, 255, 255);
            this.frameBufferGraphics.drawRect(this.cursorX * this.cellWidth + this.boardStartX, this.boardStartY + (this.curNumCellsY - this.cursorY - 1) * this.cellHeight - 1, (int)this.cellWidth, (int)this.cellHeight);
            long l = System.currentTimeMillis();
            int n = (int)(l - this.lastEventTime);
            if (n >= this.stepDelay) {
                this.lastEventTime = l;
                this.dwindleGame.step();
                this.drawBoard();
            }
            if (this.currentMode == 5) {
                this.repaintHud();
                this.repaint();
            }
        }
    }

    public void resetGame() {
        this.dwindleGame.setupNewLevel(this.dwindleMidlet.startLevel);
        this.stepDelay = this.dwindleGame.getDelay();
        this.boardImageGraphics.setColor(0, 0, 0);
        this.boardImageGraphics.drawRect(0, 0, (int)this.boardWidth, (int)this.boardHeight);
        this.boardImageGraphics.setColor(255, 230, 75);
        this.boardImageGraphics.fillRect(0, this.boardHeight - this.cellHeight - 2, (int)this.boardWidth, 1);
        this.drawBoard();
        this.frameBufferGraphics.setFont(this.messageFont);
    }

    public void repaintHud() {
        if (this.hudAtSide) {
            this.frameBufferGraphics.drawImage(this.hudImage, (int)this.hudStartX, (int)this.hudStartY, 20);
            this.frameBufferGraphics.setColor(0, 0, 0);
            int n = 21 + this.hudStartY;
            this.frameBufferGraphics.drawString(Integer.toString(this.dwindleGame.getScore()), this.hudStartX + 4, n, 36);
            this.frameBufferGraphics.drawString(Integer.toString(this.dwindleGame.getLevel()), this.hudStartX + 4, n += 22, 36);
            this.frameBufferGraphics.drawString(Integer.toString(this.dwindleGame.getNumActivatedNewLeftToNextLevel()), this.hudStartX + 4, n += 22, 36);
            n += 22;
            if (this.bonusShown > 0) {
                this.frameBufferGraphics.drawString(Integer.toString(this.bonus), this.hudStartX + 4, n, 36);
                --this.bonusShown;
            }
        } else {
            int n = this.hudStartY;
            this.frameBufferGraphics.setColor(255, 255, 255);
            this.frameBufferGraphics.drawString(Integer.toString(this.dwindleGame.getScore()), (int)this.hudStartX, n, 20);
            this.frameBufferGraphics.drawString(Integer.toString(this.dwindleGame.getNumActivatedNewLeftToNextLevel()), this.hudStartX + this.hudWidth, n, 24);
            this.frameBufferGraphics.drawString(Integer.toString(this.dwindleGame.getLevel()), (int)this.hudStartX, n += this.fontHeight + 1, 20);
            if (this.bonusShown > 0) {
                this.frameBufferGraphics.drawString("Bonus ".concat(String.valueOf(String.valueOf(this.bonus))), this.hudStartX + this.hudWidth, n, 24);
                --this.bonusShown;
            }
        }
    }

    public synchronized void repaintAll() {
        this.frameBufferGraphics.drawImage(this.boardImage, (int)this.boardStartX, (int)this.boardStartY, 20);
        this.repaintHud();
        if (this.currentMode != 5) {
            String string = null;
            String string2 = "";
            if (this.currentMode == 6) {
                string = "Game over!!!";
                string2 = "Score ".concat(String.valueOf(String.valueOf(this.dwindleGame.getScore())));
            } else if (this.currentMode == 4) {
                string = "Level Bonus: ".concat(String.valueOf(String.valueOf(this.levelBonus)));
                string2 = "Next Level: ".concat(String.valueOf(String.valueOf(this.newLevel)));
            } else if (this.currentMode == 3) {
                string = "Paused!";
            }
            if (string != null) {
                int n = Math.max(this.messageFont.stringWidth(string), this.messageFont.stringWidth(string2)) + 8;
                int n2 = this.messageFont.getHeight() * 2 + 8;
                int n3 = this.boardStartX + (this.boardWidth - n) / 2;
                int n4 = (this.canvasHeight - n2) / 2;
                n3 = Math.max(0, n3);
                n4 = Math.max(0, n4);
                int n5 = n3 + n / 2;
                this.frameBufferGraphics.setColor(255, 255, 255);
                this.frameBufferGraphics.fillRect(n3, n4, n, n2);
                this.frameBufferGraphics.setColor(0, 0, 0);
                this.frameBufferGraphics.drawString(string, n5, n4 + 4, 17);
                this.frameBufferGraphics.drawString(string2, n5, n4 + this.messageFont.getHeight() + 2, 17);
                this.frameBufferGraphics.drawRect(n3, n4, n - 1, n2);
            }
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.frameBuffer, 0, 0, 20);
    }

    protected void keyRepeated(int n) {
        if (this.hasRepeatEvents()) {
            this.keyPressed(n);
        }
    }

    protected void keyPressed(int n) {
        switch (n) {
            case 50: {
                this.inputBuffer = 1;
                break;
            }
            case 52: {
                this.inputBuffer = 2;
                break;
            }
            case 54: {
                this.inputBuffer = 5;
                break;
            }
            case 56: {
                this.inputBuffer = 6;
                break;
            }
            case 49: {
                this.inputBuffer = 10;
                break;
            }
            case 55: {
                this.inputBuffer = 11;
                break;
            }
            case 57: {
                this.inputBuffer = 10;
                break;
            }
            default: {
                this.inputBuffer = this.getGameAction(n);
            }
        }
    }

    protected boolean processPlayerInput(int n) {
        if (this.currentMode == 5) {
            switch (n) {
                case 6: {
                    if (this.cursorY > 0) {
                        this.cursorY = (byte)(this.cursorY - 1);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 1: {
                    if (this.cursorY < this.curNumCellsY - 1) {
                        this.cursorY = (byte)(this.cursorY + 1);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 2: {
                    if (this.cursorX > 0) {
                        this.cursorX = (byte)(this.cursorX - 1);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 5: {
                    if (this.cursorX < this.curNumCellsX - 1) {
                        this.cursorX = (byte)(this.cursorX + 1);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 8: 
                case 9: {
                    if (this.dwindleGame.action(this.cursorX, this.cursorY)) {
                        this.dwindleGame.cleanupDropped();
                        this.drawBoard();
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 10: {
                    this.dwindleGame.fillNewBlocksNow();
                    this.inputBuffer = -1;
                    return true;
                }
                case 11: {
                    this.inputBuffer = -1;
                    return true;
                }
            }
        } else if (this.currentMode == 3 && n == 9) {
            this.resume();
        }
        this.inputBuffer = -1;
        return false;
    }

    void drawBoard() {
        try {
            byte[][] byArray = this.dwindleGame.getBlocks();
            byte[] byArray2 = this.dwindleGame.getNewBlocks();
            int n = 1;
            for (int i = 0; i < this.curNumCellsX; ++i) {
                int n2 = this.curNumCellsY * this.cellHeight;
                this.boardImageGraphics.drawImage(this.getBlockImage(byArray2[i]), n, n2 + 2, 20);
                for (int j = 0; j < this.curNumCellsY; ++j) {
                    this.boardImageGraphics.drawImage(this.getBlockImage(byArray[i][j]), n, n2 -= this.cellHeight, 20);
                }
                n += this.cellWidth;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    Image getBlockImage(byte by) {
        if (by == 109) {
            return this.bomb9Image;
        }
        if (by == 125) {
            return this.bomb25Image;
        }
        if (by == 100) {
            return this.blockImages[0];
        }
        return this.blockImages[by];
    }

    public void gameOver() {
        this.dwindleMidlet.animator.disable();
        this.currentMode = (byte)6;
        this.repaintAll();
        this.dwindleMidlet.highScore.processNewScore(this.dwindleGame.getScore(), this.dwindleGame.getLevel(), (Displayable)this);
        this.lastEventTime = System.currentTimeMillis();
    }

    public void levelCompleted(int n, int n2) {
        this.levelBonus = n2;
        this.nextLevelShown = 20;
        this.newLevel = n + 1;
        this.currentMode = (byte)4;
        this.repaintAll();
    }

    public void bonus(int n) {
        this.bonus = n;
        this.bonusShown = 12;
    }

    public void activateNewBlocks(int n) {
    }

    static {
        PAUSED = (byte)3;
        LEVEL_UP = (byte)4;
        PLAYING = (byte)5;
        GAMEOVER = (byte)6;
        BLOCK_COLORS = new int[]{0, 0xFF0000, 65280, 255, 16710720, 0xFFFFFF, 9031121, 0xFF33FF, 5381212};
    }
}

