/*
 * Decompiled with CFR 0.152.
 */
package com.innograte.j2me.games.dwindle;

import com.innograte.j2me.games.dwindle.DwindleMidlet;
import com.innograte.j2me.games.dwindle.SplashAnimator;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class Splash
extends Canvas
implements CommandListener {
    public static final byte SPLASH2 = 1;
    public static final byte FADING = 2;
    byte status;
    short canvasHeight;
    short canvasWidth;
    public Command startGameCommand;
    public Command startLevelCommand;
    public Command highScoreCommand;
    public Command helpCommand;
    public Command aboutCommand;
    public Command quitCommand;
    private Command backCommand;
    DwindleMidlet dwindleMidlet;
    SplashAnimator splashAnimator;
    Timer timer;
    Image splashImage;
    Image splashBuffer;
    Graphics splashBufferGraphics;
    Image fadingBuffer;
    Graphics fadingBufferGraphics;
    short fadingOffsetX;
    short fadingOffsetY;
    List difficultyList;

    public Splash(DwindleMidlet dwindleMidlet, byte by) {
        by = 1;
        this.startGameCommand = new Command("Start Game", 1, 1);
        this.startLevelCommand = new Command("Start Level", 1, 2);
        this.highScoreCommand = new Command("High Scores", 1, 3);
        this.helpCommand = new Command("Help", 1, 4);
        this.aboutCommand = new Command("About", 1, 5);
        this.quitCommand = new Command("Quit", 6, 9);
        this.backCommand = new Command("Back", 2, 1);
        this.fadingOffsetX = 0;
        this.fadingOffsetY = 0;
        String[] stringArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        this.difficultyList = new List("Start Level", 3, stringArray, null);
        this.dwindleMidlet = dwindleMidlet;
        this.status = by;
        try {
            this.canvasHeight = (short)this.getHeight();
            this.canvasWidth = (short)this.getWidth();
            this.splashImage = Image.createImage((String)"/images/splash.png");
            this.splashBuffer = Image.createImage((int)this.canvasWidth, (int)this.canvasHeight);
            this.splashBufferGraphics = this.splashBuffer.getGraphics();
            this.fadingBuffer = Image.createImage((int)this.canvasWidth, (int)this.canvasHeight);
            this.fadingBufferGraphics = this.fadingBuffer.getGraphics();
            this.timer = new Timer();
            this.splashAnimator = new SplashAnimator(this);
            this.timer.schedule((TimerTask)this.splashAnimator, 50L, 50L);
            this.setCommandListener(this);
            this.addCommand(this.startGameCommand);
            this.addCommand(this.startLevelCommand);
            this.addCommand(this.highScoreCommand);
            this.addCommand(this.helpCommand);
            this.addCommand(this.aboutCommand);
            this.addCommand(this.quitCommand);
            this.paint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.startGameCommand) {
            this.status = (byte)2;
        } else if (command == this.startLevelCommand) {
            this.difficultyList.setSelectedIndex(this.dwindleMidlet.startLevel - 1, true);
            this.difficultyList.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)this.difficultyList);
        } else if (command == List.SELECT_COMMAND) {
            this.dwindleMidlet.startLevel = this.difficultyList.getSelectedIndex() + 1;
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)this);
        } else if (command == this.quitCommand) {
            this.timer.cancel();
            DwindleMidlet.quit();
        } else if (command == this.highScoreCommand) {
            this.dwindleMidlet.highScore.displayHighScore((Displayable)this);
        } else if (command == this.helpCommand) {
            Form form = new Form("Help");
            form.append("Dwindle is similar to an upside-down tetris. New blocks are inserted from the bottom row. To remove blocks, click on any block that has two or more adjacent block of the same color. Level bonus is higher the lower the stack of blocks. Extra bonus is awarded for removing 10 or more blocks at the same time. Number 9 can be used to get a full new row.");
            form.addCommand(this.backCommand);
            form.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)form);
        } else if (command == this.aboutCommand) {
            Form form = new Form("About");
            form.append(String.valueOf(String.valueOf(new StringBuffer("Dwindle! Version ").append(DwindleMidlet.VERSION).append(" by Patrik Ekstr\u00f6m, Innograte AB 2002."))));
            form.addCommand(this.backCommand);
            form.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)form);
        } else if (command == this.backCommand) {
            Display.getDisplay((MIDlet)this.dwindleMidlet).setCurrent((Displayable)this);
        }
    }

    public void paint() {
        switch (this.status) {
            case 1: {
                this.splashBufferGraphics.setColor(255, 255, 255);
                this.splashBufferGraphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
                this.splashBufferGraphics.drawImage(this.splashImage, this.canvasWidth / 2, this.canvasHeight / 2, 3);
                break;
            }
            case 2: {
                this.fadingBufferGraphics.setColor(255, 255, 255);
                this.fadingBufferGraphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
                if (this.fadingOffsetX >= this.canvasWidth / 2 || this.fadingOffsetY >= this.canvasHeight / 2) break;
                this.fadingBufferGraphics.setClip((int)this.fadingOffsetX, (int)this.fadingOffsetY, this.canvasWidth - this.fadingOffsetX * 2, this.canvasHeight - this.fadingOffsetY * 2);
                this.fadingBufferGraphics.drawImage(this.splashBuffer, 0, 0, 20);
                break;
            }
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        switch (this.status) {
            case 2: {
                graphics.drawImage(this.fadingBuffer, 0, 0, 20);
                break;
            }
            default: {
                graphics.drawImage(this.splashBuffer, 0, 0, 20);
            }
        }
    }

    static {
        SPLASH2 = 1;
        FADING = (byte)2;
    }
}

