/*
 * Decompiled with CFR 0.152.
 */
package com.softstar.mj13;

import com.softstar.mj13.Player;
import com.softstar.util.ArrayUtil;
import java.util.Random;

public class MJRule {
    public static final byte UNCHECKED = 0;
    public static final byte SEQUENCE = 1;
    public static final byte TRIPLE = 2;
    public static final byte PAIR = 3;
    public static final byte UNRELATED = 4;
    public static final byte CHOW_F = 10;
    public static final byte CHOW_M = 11;
    public static final byte CHOW_L = 12;
    public static final byte PONG_C = 13;
    public static final byte KONG_U = 14;
    public static final byte KONG_C = 15;
    private byte[] m_abtInHand;

    public MJRule(Player player) {
        this.m_abtInHand = player.getInHand();
    }

    public boolean isTen() {
        return this.checkTenSTP() || this.checkTenTPS() || this.checkTenSTPO() || this.checkTenTPSO();
    }

    private boolean checkTenTPSO() {
        byte[] byArray = new byte[this.m_abtInHand.length];
        byte[] byArray2 = new byte[]{};
        while (this.getUnrelatedCount(byArray) < 3 && this.getUncheckedCount(byArray) != 0) {
            byte by = this.getNextUncheckedO(byArray);
            if (this.isTripleO(this.m_abtInHand, byArray, by) || this.isPairO(this.m_abtInHand, byArray, by) || this.isSequenceO(this.m_abtInHand, byArray, by)) continue;
            byArray[by] = 4;
            byArray2 = ArrayUtil.arrayGrowing(byArray2, this.m_abtInHand[by]);
        }
        return this.reachTenCondition(byArray, byArray2);
    }

    private boolean checkTenSTPO() {
        byte[] byArray = new byte[this.m_abtInHand.length];
        byte[] byArray2 = new byte[]{};
        while (this.getUnrelatedCount(byArray) < 3 && this.getUncheckedCount(byArray) != 0) {
            byte by = this.getNextUncheckedO(byArray);
            if (this.isSequenceO(this.m_abtInHand, byArray, by) || this.isTripleO(this.m_abtInHand, byArray, by) || this.isPairO(this.m_abtInHand, byArray, by)) continue;
            byArray[by] = 4;
            byArray2 = ArrayUtil.arrayGrowing(byArray2, this.m_abtInHand[by]);
        }
        return this.reachTenCondition(byArray, byArray2);
    }

    private boolean checkTenTPS() {
        byte[] byArray = new byte[this.m_abtInHand.length];
        byte[] byArray2 = new byte[]{};
        while (this.getUnrelatedCount(byArray) < 3 && this.getUncheckedCount(byArray) != 0) {
            byte by = this.getNextUnchecked(byArray);
            if (this.isTriple(this.m_abtInHand, byArray, by) || this.isPair(this.m_abtInHand, byArray, by) || this.isSequence(this.m_abtInHand, byArray, by)) continue;
            byArray[by] = 4;
            byArray2 = ArrayUtil.arrayGrowing(byArray2, this.m_abtInHand[by]);
        }
        return this.reachTenCondition(byArray, byArray2);
    }

    private boolean checkTenSTP() {
        byte[] byArray = new byte[this.m_abtInHand.length];
        byte[] byArray2 = new byte[]{};
        while (this.getUnrelatedCount(byArray) < 3 && this.getUncheckedCount(byArray) != 0) {
            byte by = this.getNextUnchecked(byArray);
            if (this.isSequence(this.m_abtInHand, byArray, by) || this.isTriple(this.m_abtInHand, byArray, by) || this.isPair(this.m_abtInHand, byArray, by)) continue;
            byArray[by] = 4;
            byArray2 = ArrayUtil.arrayGrowing(byArray2, this.m_abtInHand[by]);
        }
        return this.reachTenCondition(byArray, byArray2);
    }

    private boolean reachTenCondition(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        byte by = this.getPairCount(byArray);
        ArrayUtil.bubbleSort(byArray2);
        if (by == 12 || by == 4 && byArray2.length == 0 || by == 0 && byArray2.length == 1) {
            bl = true;
        } else if (byArray2.length == 2 && by == 2) {
            bl = byArray2[0] < 30 && (byArray2[0] % 10 != 9 && byArray2[0] + 1 == byArray2[1] || byArray2[0] % 10 < 8 && byArray2[0] + 2 == byArray2[1]);
        }
        return bl;
    }

    public byte getDiscardPos(byte by) {
        byte by2 = 0;
        byte[] byArray = new byte[]{};
        byte by3 = 0;
        while (by3 < this.m_abtInHand.length) {
            if (!(by3 < this.m_abtInHand.length - 1 && (this.m_abtInHand[by3] == this.m_abtInHand[by3 + 1] || this.m_abtInHand[by3] < 30 && (this.m_abtInHand[by3] + 1 == this.m_abtInHand[by3 + 1] || this.m_abtInHand[by3] % 10 < 8 && this.m_abtInHand[by3] + 2 == this.m_abtInHand[by3 + 1])) || by3 > 0 && (this.m_abtInHand[by3] == this.m_abtInHand[by3 - 1] || this.m_abtInHand[by3] < 30 && (this.m_abtInHand[by3] - 1 == this.m_abtInHand[by3 - 1] || this.m_abtInHand[by3] % 10 > 2 && this.m_abtInHand[by3] - 2 == this.m_abtInHand[by3 - 1])))) {
                byArray = ArrayUtil.arrayGrowing(byArray, by3);
            }
            by3 = (byte)(by3 + 1);
        }
        if (byArray.length == 0) {
            by2 = (byte)(Math.abs(new Random().nextInt()) % this.m_abtInHand.length);
        } else if (byArray.length == 1) {
            by2 = byArray[0];
        } else {
            int n = 0;
            while (n < byArray.length) {
                if (by != this.m_abtInHand[byArray[n]] && (by >= 30 || Math.abs(by - this.m_abtInHand[byArray[n]]) != 1)) {
                    by2 = byArray[n];
                    break;
                }
                n = (byte)(n + 1);
            }
        }
        return by2;
    }

    public byte[] gotMeldChance(byte by) {
        byte[] byArray = new byte[]{};
        if (this.gotChowFChance(by)) {
            byArray = ArrayUtil.arrayGrowing(byArray, (byte)10);
        }
        if (this.gotChowMChance(by)) {
            byArray = ArrayUtil.arrayGrowing(byArray, (byte)11);
        }
        if (this.gotChowLChance(by)) {
            byArray = ArrayUtil.arrayGrowing(byArray, (byte)12);
        }
        if (this.gotPongChance(by)) {
            byArray = ArrayUtil.arrayGrowing(byArray, (byte)13);
        }
        if (this.gotKongUChance(by)) {
            byArray = ArrayUtil.arrayGrowing(byArray, (byte)14);
        }
        return byArray;
    }

    private boolean gotKongUChance(byte by) {
        return this.getTileCount(this.m_abtInHand, by) == 3;
    }

    private boolean gotPongChance(byte by) {
        return this.getTileCount(this.m_abtInHand, by) > 1;
    }

    private byte getTileCount(byte[] byArray, byte by) {
        byte by2 = 0;
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == by) {
                by2 = (byte)(by2 + 1);
            }
            n = (byte)(n + 1);
        }
        return by2;
    }

    private boolean gotChowLChance(byte by) {
        return by < 30 && by % 10 > 2 && this.gotTile(this.m_abtInHand, (byte)(by - 1)) && this.gotTile(this.m_abtInHand, (byte)(by - 2));
    }

    private boolean gotChowMChance(byte by) {
        return by < 30 && by % 10 > 1 && by % 10 < 9 && this.gotTile(this.m_abtInHand, (byte)(by - 1)) && this.gotTile(this.m_abtInHand, (byte)(by + 1));
    }

    private boolean gotChowFChance(byte by) {
        return by < 30 && by % 10 < 8 && this.gotTile(this.m_abtInHand, (byte)(by + 1)) && this.gotTile(this.m_abtInHand, (byte)(by + 2));
    }

    private boolean gotTile(byte[] byArray, byte by) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < byArray.length) {
            int n2 = n;
            n = (byte)(n + 1);
            boolean bl2 = bl = byArray[n2] == by;
        }
        return bl;
    }

    public boolean gotHouChance(byte by) {
        byte[] byArray = ArrayUtil.arrayGrowing(this.m_abtInHand, by);
        ArrayUtil.bubbleSort(byArray);
        return this.checkHouSTP(byArray) || this.checkHouTPS(byArray) || this.checkHouSTPO(byArray) || this.checkHouTPSO(byArray);
    }

    private boolean checkHouTPSO(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        while (this.getUnrelatedCount(byArray2) == 0 && this.getUncheckedCount(byArray2) != 0) {
            byte by = this.getNextUncheckedO(byArray2);
            if (this.isTripleO(byArray, byArray2, by) || this.isPairO(byArray, byArray2, by) || this.isSequenceO(byArray, byArray2, by)) continue;
            byArray2[by] = 4;
        }
        return this.reachHouCondition(byArray2);
    }

    private boolean checkHouSTPO(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        while (this.getUnrelatedCount(byArray2) == 0 && this.getUncheckedCount(byArray2) != 0) {
            byte by = this.getNextUncheckedO(byArray2);
            if (this.isSequenceO(byArray, byArray2, by) || this.isTripleO(byArray, byArray2, by) || this.isPairO(byArray, byArray2, by)) continue;
            byArray2[by] = 4;
        }
        return this.reachHouCondition(byArray2);
    }

    private boolean isPairO(byte[] byArray, byte[] byArray2, byte by) {
        boolean bl = false;
        byte by2 = this.searchTileO(byArray, byArray[by], byArray2, (byte)(by - 1));
        if (by2 != -1) {
            byArray2[by] = 3;
            byArray2[by2] = 3;
            bl = true;
        }
        return bl;
    }

    private boolean isTripleO(byte[] byArray, byte[] byArray2, byte by) {
        byte by2;
        boolean bl = false;
        byte by3 = this.searchTileO(byArray, byArray[by], byArray2, (byte)(by - 1));
        if (by3 != -1 && (by2 = this.searchTileO(byArray, byArray[by], byArray2, (byte)(by3 - 1))) != -1) {
            byArray2[by] = 2;
            byArray2[by3] = 2;
            byArray2[by2] = 2;
            bl = true;
        }
        return bl;
    }

    private boolean isSequenceO(byte[] byArray, byte[] byArray2, byte by) {
        byte by2;
        byte by3;
        boolean bl = false;
        if (byArray[by] <= 30 && byArray[by] % 10 >= 3 && (by3 = this.searchTileO(byArray, (byte)(byArray[by] - 1), byArray2, (byte)(by - 1))) != -1 && (by2 = this.searchTileO(byArray, (byte)(byArray[by] - 2), byArray2, (byte)(by3 - 1))) != -1) {
            byArray2[by] = 1;
            byArray2[by3] = 1;
            byArray2[by2] = 1;
            bl = true;
        }
        return bl;
    }

    protected byte searchTileO(byte[] byArray, byte by, byte[] byArray2, byte by2) {
        byte by3 = -1;
        while (by3 == -1 && by2 >= 0 && byArray[by2] >= by) {
            if (byArray[by2] == by && byArray2[by2] == 0) {
                by3 = by2;
            }
            by2 = (byte)(by2 - 1);
        }
        return by3;
    }

    protected byte getNextUncheckedO(byte[] byArray) {
        byte by = (byte)(byArray.length - 1);
        while (by >= 0 && byArray[by] != 0) {
            by = (byte)(by - 1);
        }
        return by;
    }

    private boolean checkHouTPS(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        while (this.getUnrelatedCount(byArray2) == 0 && this.getUncheckedCount(byArray2) != 0) {
            byte by = this.getNextUnchecked(byArray2);
            if (this.isTriple(byArray, byArray2, by) || this.isPair(byArray, byArray2, by) || this.isSequence(byArray, byArray2, by)) continue;
            byArray2[by] = 4;
        }
        return this.reachHouCondition(byArray2);
    }

    private boolean checkHouSTP(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        while (this.getUnrelatedCount(byArray2) == 0 && this.getUncheckedCount(byArray2) != 0) {
            byte by = this.getNextUnchecked(byArray2);
            if (this.isSequence(byArray, byArray2, by) || this.isTriple(byArray, byArray2, by) || this.isPair(byArray, byArray2, by)) continue;
            byArray2[by] = 4;
        }
        return this.reachHouCondition(byArray2);
    }

    protected boolean reachHouCondition(byte[] byArray) {
        boolean bl = false;
        if (this.getUnrelatedCount(byArray) == 0) {
            byte by = this.getPairCount(byArray);
            bl = by == 2 || by == 14;
        }
        return bl;
    }

    private byte getPairCount(byte[] byArray) {
        return this.getStateCount(byArray, (byte)3);
    }

    private boolean isPair(byte[] byArray, byte[] byArray2, byte by) {
        boolean bl = false;
        byte by2 = this.searchTile(byArray, byArray[by], byArray2, (byte)(by + 1));
        if (by2 != -1) {
            byArray2[by] = 3;
            byArray2[by2] = 3;
            bl = true;
        }
        return bl;
    }

    private boolean isTriple(byte[] byArray, byte[] byArray2, byte by) {
        byte by2;
        boolean bl = false;
        byte by3 = this.searchTile(byArray, byArray[by], byArray2, (byte)(by + 1));
        if (by3 != -1 && (by2 = this.searchTile(byArray, byArray[by], byArray2, (byte)(by3 + 1))) != -1) {
            byArray2[by] = 2;
            byArray2[by3] = 2;
            byArray2[by2] = 2;
            bl = true;
        }
        return bl;
    }

    private boolean isSequence(byte[] byArray, byte[] byArray2, byte by) {
        byte by2;
        byte by3;
        boolean bl = false;
        if (byArray[by] <= 30 && byArray[by] % 10 <= 7 && (by3 = this.searchTile(byArray, (byte)(byArray[by] + 1), byArray2, (byte)(by + 1))) != -1 && (by2 = this.searchTile(byArray, (byte)(byArray[by] + 2), byArray2, (byte)(by3 + 1))) != -1) {
            byArray2[by] = 1;
            byArray2[by3] = 1;
            byArray2[by2] = 1;
            bl = true;
        }
        return bl;
    }

    protected byte searchTile(byte[] byArray, byte by, byte[] byArray2, byte n) {
        int n2 = -1;
        while (n2 == -1 && n < byArray.length && byArray[n] <= by) {
            if (byArray[n] == by && byArray2[n] == 0) {
                n2 = n;
            }
            n = (byte)(n + 1);
        }
        return (byte)n2;
    }

    protected byte getNextUnchecked(byte[] byArray) {
        byte by = 0;
        while (by < byArray.length && byArray[by] != 0) {
            by = (byte)(by + 1);
        }
        return by;
    }

    protected byte getUncheckedCount(byte[] byArray) {
        return this.getStateCount(byArray, (byte)0);
    }

    protected byte getUnrelatedCount(byte[] byArray) {
        return this.getStateCount(byArray, (byte)4);
    }

    private byte getStateCount(byte[] byArray, byte by) {
        byte by2 = 0;
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == by) {
                by2 = (byte)(by2 + 1);
            }
            n = (byte)(n + 1);
        }
        return by2;
    }
}

