/*
 * Decompiled with CFR 0.152.
 */
package com.softstar.util.midp;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RichRMS {
    private Hashtable m_hRecords = new Hashtable();
    private RecordStore m_RecordStore;

    private RichRMS(String string) throws RecordStoreException {
        this.m_RecordStore = RecordStore.openRecordStore((String)string, (boolean)true);
    }

    public void close() {
        try {
            this.m_RecordStore.closeRecordStore();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void save() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Enumeration enumeration = this.m_hRecords.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            byteArrayOutputStream.write((byte)string.length());
            byteArrayOutputStream.write(string.getBytes(), 0, string.length());
            String string2 = (String)this.m_hRecords.get(string);
            byteArrayOutputStream.write((byte)string2.length());
            byteArrayOutputStream.write(string2.getBytes(), 0, string2.length());
        }
        if (this.getNumRecords_RecordStore() == 0) {
            this.addRecord_RecordStore(byteArrayOutputStream.toByteArray());
        } else {
            this.setRecord_RecordStore(byteArrayOutputStream.toByteArray());
        }
    }

    private void setRecord_RecordStore(byte[] byArray) {
        try {
            this.m_RecordStore.setRecord(1, byArray, 0, byArray.length);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void addRecord_RecordStore(byte[] byArray) {
        try {
            this.m_RecordStore.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public String get(String string) {
        return (String)this.m_hRecords.get(string);
    }

    public void put(String string, String string2) {
        this.m_hRecords.put(string, string2);
    }

    public static RichRMS openRichRMS(String string) {
        RichRMS richRMS = RichRMS.newRichRMS(string);
        if (richRMS != null && !richRMS.init()) {
            richRMS = null;
        }
        return richRMS;
    }

    private boolean init() {
        boolean bl = true;
        byte by = this.getNumRecords_RecordStore();
        if (by == -1) {
            bl = false;
        } else if (by == 1) {
            bl = this.getRecord();
        }
        return bl;
    }

    private boolean getRecord() {
        byte[] byArray = this.getRecord_RecordStore();
        return byArray == null ? false : this.makeHashtable(byArray);
    }

    private boolean makeHashtable(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n++];
            int n2 = n + by;
            StringBuffer stringBuffer = new StringBuffer();
            while (n < n2) {
                stringBuffer.append("" + (char)byArray[n++]);
            }
            by = byArray[n++];
            n2 = n + by;
            StringBuffer stringBuffer2 = new StringBuffer();
            while (n < n2) {
                stringBuffer2.append("" + (char)byArray[n++]);
            }
            this.m_hRecords.put(stringBuffer.toString(), stringBuffer2.toString());
        }
        return true;
    }

    private byte[] getRecord_RecordStore() {
        byte[] byArray = null;
        try {
            byArray = this.m_RecordStore.getRecord(1);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return byArray;
    }

    private byte getNumRecords_RecordStore() {
        byte by = -1;
        try {
            by = (byte)this.m_RecordStore.getNumRecords();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            // empty catch block
        }
        return by;
    }

    private static RichRMS newRichRMS(String string) {
        RichRMS richRMS = null;
        try {
            richRMS = new RichRMS(string);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return richRMS;
    }
}

