/*
 * Decompiled with CFR 0.152.
 */
package henson.games;

import henson.games.FirstCanvas;
import henson.games.Location;
import henson.games.MainCanvas;
import henson.games.MainList;
import henson.games.MessageForm;
import henson.games.State;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class MoscowpolyMIDlet
extends MIDlet {
    public static MoscowpolyMIDlet instance;
    public static final int[][] streetMap;
    private FirstCanvas _$63992 = new FirstCanvas();
    private MainCanvas _$63585 = new MainCanvas();
    private MessageForm _$63993 = null;
    private Alert _$63995 = null;
    private MainList _$63996 = null;
    public State[] state = new State[2];
    public Vector locations = new Vector();
    public int which = 0;
    private Random _$65261 = new Random(System.currentTimeMillis());

    public MoscowpolyMIDlet() {
        this.state[0] = new State("Player");
        this.state[1] = new State("Computer");
        instance = this;
        this.locations.addElement(new Location("GO", 0, 4, 0, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Olympic Village", 0x993399, 8, 30, 0, 30, 30, 2, 10, 30, 90, 160, 250, 60, 50));
        this.locations.addElement(new Location("Community Chest", 0, 1, 60, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Proletarskaya Avenue", 0x993399, 8, 90, 0, 30, 30, 4, 20, 60, 180, 320, 450, 60, 50));
        this.locations.addElement(new Location("Income Tax", 0, 3, 120, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("North Railways", 0, 9, 150, 0, 30, 30, -1, 25, 50, 100, 200, -1, 200, -1));
        this.locations.addElement(new Location("Semenovskaya Street", 0x99FFFF, 8, 180, 0, 30, 30, 6, 30, 90, 270, 400, 550, 100, 50));
        this.locations.addElement(new Location("Chance", 0, 0, 210, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Turgenevskaya Square", 0x99FFFF, 8, 240, 0, 30, 30, 6, 30, 90, 270, 400, 550, 100, 50));
        this.locations.addElement(new Location("Teatralnaya Square", 0x99FFFF, 8, 270, 0, 30, 30, 8, 40, 100, 300, 450, 600, 120, 50));
        this.locations.addElement(new Location("Jail", 0, 5, 300, 0, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Pushkinskaya Square", 0xFF99FF, 8, 300, 30, 30, 30, 10, 50, 150, 450, 625, 750, 140, 100));
        this.locations.addElement(new Location("Mosenergo", 0, 10, 300, 60, 30, 30, -1, 4, 10, -1, -1, -1, 150, -1));
        this.locations.addElement(new Location("Begovaya Street", 0xFF99FF, 8, 300, 90, 30, 30, 10, 50, 150, 450, 625, 750, 140, 100));
        this.locations.addElement(new Location("1905 Street", 0xFF99FF, 8, 300, 120, 30, 30, 12, 60, 180, 500, 700, 900, 160, 100));
        this.locations.addElement(new Location("East Railways", 0, 9, 300, 150, 30, 30, -1, 25, 50, 100, 200, -1, 200, -1));
        this.locations.addElement(new Location("Kievskaya Avenue", 0xFFCC00, 8, 300, 180, 30, 30, 14, 70, 200, 550, 750, 950, 180, 100));
        this.locations.addElement(new Location("Community Chest", 0, 1, 300, 210, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Entuziastov Avenue", 0xFFCC00, 8, 300, 240, 30, 30, 14, 70, 200, 550, 750, 950, 180, 100));
        this.locations.addElement(new Location("Andropova Avenue", 0xFFCC00, 8, 300, 270, 30, 30, 16, 80, 220, 600, 800, 1000, 200, 100));
        this.locations.addElement(new Location("Free Parking", 0, 7, 300, 300, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Maneznaja Square", 0xFF0000, 8, 270, 300, 30, 30, 18, 90, 250, 700, 875, 1050, 220, 150));
        this.locations.addElement(new Location("Chance", 0, 0, 240, 300, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Red Square", 0xFF0000, 8, 210, 300, 30, 30, 18, 90, 250, 700, 875, 1050, 220, 150));
        this.locations.addElement(new Location("Kremlin", 0xFF0000, 8, 180, 300, 30, 30, 20, 100, 300, 750, 925, 1100, 240, 150));
        this.locations.addElement(new Location("South Railways", 0, 9, 150, 300, 30, 30, -1, 25, 50, 100, 200, -1, 200, -1));
        this.locations.addElement(new Location("Mayakovskogo Street", 0xFFFF00, 8, 120, 300, 30, 30, 22, 110, 330, 800, 975, 1150, 260, 150));
        this.locations.addElement(new Location("Kashirskaya Avenue", 0xFFFF00, 8, 90, 300, 30, 30, 22, 110, 330, 800, 975, 1150, 260, 150));
        this.locations.addElement(new Location("Mosvodokanal", 0, 10, 60, 300, 30, 30, -1, 4, 10, -1, -1, -1, 150, -1));
        this.locations.addElement(new Location("Rublevskoye Avenue", 0xFFFF00, 8, 30, 300, 30, 30, 24, 120, 360, 850, 1025, 1200, 280, 150));
        this.locations.addElement(new Location("Go To Jail", 0, 6, 0, 300, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Mira Avenue", 0x33FF33, 8, 0, 270, 30, 30, 26, 130, 390, 900, 1100, 1275, 300, 200));
        this.locations.addElement(new Location("Leningradskaya Avenue", 0x33FF33, 8, 0, 240, 30, 30, 26, 130, 390, 900, 1100, 1275, 300, 200));
        this.locations.addElement(new Location("Community Chest", 0, 1, 0, 210, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Leninskaya Avenue", 0x33FF33, 8, 0, 180, 30, 30, 28, 150, 450, 1000, 1200, 1400, 320, 200));
        this.locations.addElement(new Location("West Railways", 0, 9, 0, 150, 30, 30, -1, 25, 50, 100, 200, -1, 200, -1));
        this.locations.addElement(new Location("Chance", 0, 0, 0, 120, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Tverskaja Street", 0x3333FF, 8, 0, 90, 30, 30, 35, 175, 500, 1100, 1300, 1500, 350, 200));
        this.locations.addElement(new Location("Luxury Tax", 0, 2, 0, 60, 30, 30, -1, -1, -1, -1, -1, -1, -1, -1));
        this.locations.addElement(new Location("Arbat", 0x3333FF, 8, 0, 30, 30, 30, 50, 200, 600, 1400, 1700, 2000, 400, 200));
    }

    public void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$63992);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public void ShowMessageBox(String title, String message) {
        this._$63993 = new MessageForm(title, message);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$63993);
    }

    public void Congratulions() {
        this._$63995 = new Alert("Congratulations!", "You are winner!!!", null, AlertType.ALARM);
        this._$63995.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(this._$63995, (Displayable)this._$63992);
    }

    public void Loose() {
        this._$63995 = new Alert("Ooooops!", "You loose your chance! Your opponent win.", null, AlertType.ALARM);
        this._$63995.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(this._$63995, (Displayable)this._$63992);
    }

    public void ShowInfoBox(String title, String message, boolean modal, AlertType at) {
        this._$63995 = new Alert(title, message, null, at);
        if (modal) {
            this._$63995.setTimeout(-2);
        }
        Display.getDisplay((MIDlet)this).setCurrent(this._$63995, (Displayable)this._$63585);
    }

    public void ShowMainCanvas(int state) {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$63585);
        switch (state) {
            case -1: {
                break;
            }
            default: {
                this._$63585.ProcessForm(state);
            }
        }
    }

    public void ShowMainList(String name, Vector v, int type) {
        this._$63996 = new MainList(name, 3);
        this._$63996.UpdateList(v, type);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$63996);
    }

    public void NewGame() {
        int i;
        this.which = this.nextRand(2);
        this._$63585.init();
        for (i = 0; i < this.state.length; ++i) {
            this.state[i].init();
        }
        for (i = 0; i < this.locations.size(); ++i) {
            Location loc = (Location)this.locations.elementAt(i);
            if (loc == null) continue;
            loc.init();
        }
        this.state[1].computer = true;
        this._$63585.startComputerTimer();
        this._$63995 = new Alert("New game", String.valueOf(String.valueOf(new StringBuffer("All players rolled the dice and ").append(this.state[this.which].name).append(" rolled the highest total. Therefore ").append(this.state[this.which].name).append(" goes first."))), null, AlertType.INFO);
        this._$63995.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(this._$63995, (Displayable)this._$63585);
    }

    public void OpenGame(String name) {
        try {
            RecordStore r = RecordStore.openRecordStore((String)name, (boolean)true);
            byte[] data = r.getRecord(1);
            if (data != null) {
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                try {
                    int i;
                    this.which = din.readInt();
                    for (i = 0; i < this.state.length; ++i) {
                        this.state[i].serialize(din);
                    }
                    for (i = 0; i < this.locations.size(); ++i) {
                        Location loc = (Location)this.locations.elementAt(i);
                        loc.serialize(din);
                    }
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            r.closeRecordStore();
            this.Continue();
        }
        catch (RecordStoreNotFoundException e) {
            System.out.println((Object)e);
        }
        catch (RecordStoreFullException e) {
            System.out.println((Object)e);
        }
        catch (RecordStoreException e) {
            System.out.println((Object)e);
        }
    }

    public boolean SaveGame(String name) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            int i;
            RecordStore r = RecordStore.openRecordStore((String)name, (boolean)true);
            dout.writeInt(this.which);
            for (i = 0; i < this.state.length; ++i) {
                this.state[i].serialize(dout);
            }
            for (i = 0; i < this.locations.size(); ++i) {
                Location loc = (Location)this.locations.elementAt(i);
                loc.serialize(dout);
            }
            if (r.getNumRecords() > 0) {
                r.setRecord(1, bout.toByteArray(), 0, bout.size());
            } else {
                r.addRecord(bout.toByteArray(), 0, bout.size());
            }
            r.closeRecordStore();
            this.Continue();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println(e);
            boolean bl = false;
            return bl;
        }
    }

    public void Continue() {
        this._$63585.startComputerTimer();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$63585);
    }

    public void ShowMenu() {
        this._$63585.stopComputerTimer();
        System.gc();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this._$63992);
    }

    public Vector BuildHouseList(boolean buy) {
        Vector<Integer> v = new Vector<Integer>();
        int which = MoscowpolyMIDlet.instance.which;
        int cash = this.state[which].cash;
        for (int i = 0; i < streetMap.length; ++i) {
            Location loc;
            int j;
            boolean success = true;
            int minValue = 10;
            int maxValue = 0;
            for (j = 0; j < streetMap[i].length; ++j) {
                loc = this._$63585.GetLoc(streetMap[i][j]);
                if (loc.owner != which) {
                    success = false;
                    break;
                }
                if (buy) {
                    minValue = Math.min(minValue, loc.level);
                    continue;
                }
                maxValue = Math.max(maxValue, loc.level);
            }
            if (!success) continue;
            for (j = 0; j < streetMap[i].length; ++j) {
                loc = (Location)this.locations.elementAt(streetMap[i][j]);
                if (buy) {
                    if (loc.level != minValue || minValue >= 5 || cash < loc.priceHouse) continue;
                    v.addElement(new Integer(streetMap[i][j]));
                    continue;
                }
                if (loc.level != maxValue || maxValue <= 0) continue;
                v.addElement(new Integer(streetMap[i][j]));
            }
        }
        return v;
    }

    public Vector BuildMortgageList(boolean mortgage) {
        Vector<Integer> v = new Vector<Integer>();
        int which = MoscowpolyMIDlet.instance.which;
        int cash = MoscowpolyMIDlet.instance.state[which].cash;
        int[][] map = new int[][]{{1, 3}, {6, 8, 9}, {11, 13, 14}, {16, 18, 19}, {21, 23, 24}, {26, 27, 29}, {31, 32, 34}, {37, 39}};
        for (int i = 0; i < map.length; ++i) {
            for (int j = 0; j < map[i].length; ++j) {
                Location loc = (Location)this.locations.elementAt(map[i][j]);
                if (mortgage) {
                    if (loc.owner != which || loc.level != 0 || loc.mortgaged) continue;
                    v.addElement(new Integer(map[i][j]));
                    continue;
                }
                int cost = loc.price >> 1;
                cost += cost / 10;
                if (loc.owner != which || !loc.mortgaged || cash < cost) continue;
                v.addElement(new Integer(map[i][j]));
            }
        }
        return v;
    }

    public Vector BuildOthersList() {
        Vector<Integer> v = new Vector<Integer>();
        int cash = this.state[this.which].cash;
        int[][] map = new int[][]{{5, 15, 25, 35}, {12, 28}, {1, 3}, {6, 8, 9}, {11, 13, 14}, {16, 18, 19}, {21, 23, 24}, {26, 27, 29}, {31, 32, 34}, {37, 39}};
        for (int i = 0; i < map.length; ++i) {
            for (int j = 0; j < map[i].length; ++j) {
                boolean check;
                Location loc = (Location)this.locations.elementAt(map[i][j]);
                boolean bl = check = loc.type == 8 && loc.mortgaged || loc.type != 8 && !loc.mortgaged;
                if (loc.owner != this.which || loc.level != 0 || !check) continue;
                v.addElement(new Integer(map[i][j]));
            }
        }
        return v;
    }

    public boolean CheckFullHouse(Integer pos) {
        int[][] map = new int[][]{{5, 15, 25, 35}, {12, 28}, {1, 3}, {6, 8, 9}, {11, 13, 14}, {16, 18, 19}, {21, 23, 24}, {26, 27, 29}, {31, 32, 34}, {37, 39}};
        for (int i = 0; i < map.length; ++i) {
            boolean fullhouse = true;
            boolean foundlocation = false;
            for (int j = 0; j < map[i].length; ++j) {
                Location l = (Location)this.locations.elementAt(map[i][j]);
                if (l.owner != this.which) {
                    fullhouse = false;
                }
                if (pos != map[i][j]) continue;
                foundlocation = true;
            }
            if (!foundlocation) continue;
            return fullhouse;
        }
        return false;
    }

    public int nextRand(int _l) {
        return (int)((long)Math.abs(this._$65261.nextInt()) * (long)_l >>> 31);
    }

    static {
        streetMap = new int[][]{{1, 3}, {6, 8, 9}, {11, 13, 14}, {16, 18, 19}, {21, 23, 24}, {26, 27, 29}, {31, 32, 34}, {37, 39}};
    }
}

