/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Menu {
    private Vector items = new Vector();
    private MenuItem selectedItem;
    private int index;
    private int yOffset;
    private MenuListener listener;
    private boolean visible = false;
    private int MenuStart;

    public Menu(int offsetY, int start) {
        this.yOffset = offsetY;
        this.MenuStart = start;
    }

    public void setListener(MenuListener ml) {
        this.listener = ml;
    }

    public void add(MenuItem mi) {
        if (this.items.size() == 0) {
            this.selectedItem = mi;
            mi.setSelect(true);
        }
        this.items.addElement(mi);
    }

    public void select() {
        this.listener.select(this.selectedItem);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public void up() {
        try {
            this.selectedItem.setSelect(false);
            this.selectedItem = (MenuItem)this.items.elementAt(this.index - 1);
            --this.index;
            this.selectedItem.setSelect(true);
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            this.selectedItem.setSelect(true);
        }
    }

    public void down() {
        try {
            this.selectedItem.setSelect(false);
            this.selectedItem = (MenuItem)this.items.elementAt(this.index + 1);
            ++this.index;
            this.selectedItem.setSelect(true);
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            this.selectedItem.setSelect(true);
        }
    }

    public MenuItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(MenuItem mi) {
        this.selectedItem = mi;
        this.index = this.items.indexOf(mi);
    }

    public void paint(Graphics g) {
        int y = this.MenuStart;
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem tmpItem = (MenuItem)this.items.elementAt(i);
            tmpItem.paint(g, y);
            y += this.yOffset;
        }
    }
}

