/*
 * Decompiled with CFR 0.152.
 */
package toneoflove;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import toneoflove.Config;
import toneoflove.GameDisplayable;
import toneoflove.ToneOfLove;

public class Element {
    public static int WIDTH = 20;
    public static int HEIGHT = 20;
    public int xPos;
    public int yPos;
    public int xEnde;
    public int yEnde;
    public int xStart;
    public int yStart;
    private int number;
    private Image image;
    private boolean hidden = true;
    private boolean active = false;
    private int color;

    public Element(Image i, int x, int y, int xs, int ys, int num) {
        this.image = i;
        this.xPos = xs;
        this.yPos = ys;
        this.xStart = xs;
        this.yStart = ys;
        this.xEnde = x;
        this.yEnde = y;
        this.number = num;
    }

    public void resetPos() {
        this.xPos = this.xStart;
        this.yPos = this.yStart;
        this.hidden = true;
        this.active = false;
    }

    public boolean isMoving() {
        return this.yPos != this.yEnde;
    }

    public boolean moveDown(int step, int state, int num) {
        if (num >= this.number) {
            this.yPos += step;
        }
        if (this.yPos >= this.yEnde && state == GameDisplayable.INIT) {
            this.yPos = this.yEnde;
            return false;
        }
        if (this.yPos >= Config.SCREENHEIGHT && state == GameDisplayable.COMPLETE) {
            this.yPos = Config.SCREENHEIGHT + 10;
            return false;
        }
        return true;
    }

    public int getX() {
        return this.xPos;
    }

    public int getY() {
        return this.yPos;
    }

    public void paint(Graphics g) {
        if (this.active) {
            g.drawImage(this.image, this.xPos, this.yPos, 20);
            g.drawImage(ToneOfLove.noteImage, this.xPos + Config.ELEMENTDIMENSIONX / 2, this.yPos + Config.ELEMENTDIMENSIONY / 2, 3);
        } else {
            g.drawImage(ToneOfLove.hiddenImage, this.xPos, this.yPos, 20);
            if (ToneOfLove.display.isColor()) {
                g.setColor(Config.COLORS[this.number - 1]);
            } else {
                g.setColor(0, 0, 0);
            }
            int xp = this.xPos + ToneOfLove.hiddenImage.getWidth() / 2 - Config.RADIUS;
            int yp = this.yPos + ToneOfLove.hiddenImage.getHeight() / 2 - Config.RADIUS;
            g.fillRoundRect(xp, yp, 2 * Config.RADIUS, 2 * Config.RADIUS, 2 * Config.RADIUS, 2 * Config.RADIUS);
            if (ToneOfLove.display.isColor()) {
                g.setColor(0, 0, 0);
            } else {
                g.setColor(255, 255, 255);
            }
            if (Config.RADIUS * 2 < Config.FONTHEIGHT) {
                g.setFont(Font.getFont((int)0, (int)0, (int)8));
            } else {
                g.setFont(Font.getFont((int)0, (int)1, (int)Config.ELEMENTFONTSIZE));
            }
            g.drawString(Integer.toString(this.number), this.xPos + WIDTH / 2, this.yPos - 3 + Config.ELEMENTDIMENSIONY / 2 + Font.getDefaultFont().getHeight() / 2, 65);
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setAppear(boolean state) {
        this.active = state;
    }
}

