/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.MenuListener;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuItem {
    private Image selectedImage = null;
    private Image unselectedImage = null;
    private boolean isSelected;
    private MenuListener listener;
    private String text;
    private boolean visible = false;
    private int fontSize;
    private int colorActive;
    private int colorInactive;
    private int colorBg = -1;
    private static int width = 0;
    private static int height = 0;

    public MenuItem(Image selected, Image unselected) {
        this.selectedImage = selected;
        this.unselectedImage = unselected;
        height = this.selectedImage.getHeight();
        width = this.selectedImage.getWidth();
    }

    public MenuItem(String t, int c1, int c0, int f_Size) {
        this.init(t, c1, c0, f_Size);
    }

    public MenuItem(String t, int c1, int c0, int cbg, int f_Size) {
        this.colorBg = cbg;
        Font f = Font.getFont((int)32, (int)1, (int)f_Size);
        int w = f.charWidth('a') * (t.length() + 2);
        if (w > width) {
            width = w;
        }
        this.init(t, c1, c0, f_Size);
    }

    private void init(String t, int c1, int c0, int f_Size) {
        height = Font.getFont((int)32, (int)1, (int)f_Size).getHeight();
        this.colorActive = c1;
        this.colorInactive = c0;
        this.fontSize = f_Size;
        this.text = t;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public void setListener(MenuListener ml) {
        this.listener = ml;
    }

    public void setSelect(boolean state) {
        this.isSelected = state;
    }

    public void toggle() {
        this.isSelected = !this.isSelected;
    }

    public void perform() {
        this.listener.select(this);
    }

    public void paint(Graphics g, int y) {
        this.paint(g, g.getClipWidth() / 2, y);
    }

    public void paint(Graphics g, int x, int y) {
        if (this.selectedImage != null) {
            if (this.isSelected) {
                g.drawImage(this.selectedImage, x, y, 3);
            } else {
                g.drawImage(this.unselectedImage, x, y, 3);
            }
        } else if (this.isSelected) {
            if (this.colorBg != -1) {
                g.setColor(this.colorBg);
                g.setStrokeStyle(1);
                g.fillRoundRect(x - width / 2, y, width, height, height, height);
            }
            g.setFont(Font.getFont((int)32, (int)1, (int)this.fontSize));
            g.setColor(0, 0, 0);
            g.drawString(this.text, x + 1, y + 1, 17);
            g.setColor(this.colorActive);
            g.drawString(this.text, x, y, 17);
        } else {
            g.setFont(Font.getFont((int)32, (int)1, (int)this.fontSize));
            g.setColor(0, 0, 0);
            g.drawString(this.text, x + 1, y + 1, 17);
            g.setColor(this.colorInactive);
            g.drawString(this.text, x, y, 17);
        }
    }
}

