/*
 * Decompiled with CFR 0.152.
 */
package toneoflove;

import de.tuttas.GameAPI.Menu;
import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import toneoflove.Config;
import toneoflove.Melody;
import toneoflove.MyCanvas;
import toneoflove.Playfield;
import toneoflove.ToneOfLove;

public class GameDisplayable
extends MyCanvas
implements MenuListener {
    public static int INIT = 1;
    public static int PLAY = 2;
    public static int REPLAY = 3;
    public static int COMPLETE = 4;
    public static int FINISH = 5;
    public static int ERROR = 6;
    public static int INFO = 7;
    public int state = INIT;
    Playfield playfield;
    Image image;
    MenuItem cont;
    MenuItem exit;
    Menu m;
    Melody melody = new Melody(3);
    int lives = 3;
    private Image offscreen = null;
    private Graphics saved;
    public static int level;

    public GameDisplayable() {
        this.m = new Menu(2 * Font.getDefaultFont().getHeight(), Config.MENUSTART);
        this.m.setListener(this);
        try {
            this.image = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            Graphics g = this.image.getGraphics();
            g.setColor(254, 254, 254);
            g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
            if (ToneOfLove.display.isColor()) {
                g.drawImage(Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("bg1.png")), this.getWidth() / 2, this.getHeight() / 2, 3);
                this.cont = new MenuItem("Continue", 0xFFFF00, 0x9F9F9F, 0x840840, 16);
                this.exit = new MenuItem("Exit", 0xFFFF00, 0x9F9F9F, 0x840840, 16);
            } else {
                g.drawImage(Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("bg1bw.png")), this.getWidth() / 2, this.getHeight() / 2, 3);
                this.cont = new MenuItem("Continue", 0xFFFFFF, 0xFFFFFF, 0, 16);
                this.exit = new MenuItem("Exit", 0xFFFFFF, 0xFFFFFF, 0, 16);
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        this.m.add(this.cont);
        this.m.add(this.exit);
        this.offscreen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.playfield = new Playfield(this.image, 3 * Config.ELEMENTDIMENSIONX, 3 * Config.ELEMENTDIMENSIONY);
        level = 0;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        level = 0;
        this.lives = 3;
        this.state = INIT;
        this.melody = new Melody(3);
        this.m.setVisible(false);
        System.gc();
        this.playfield = new Playfield(this.image, 3 * Config.ELEMENTDIMENSIONX, 3 * Config.ELEMENTDIMENSIONY);
    }

    private void jbInit() throws Exception {
    }

    public void nextLevel() {
        this.state = INFO;
        this.melody.inc();
        ++level;
        this.playfield.reset();
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
        if (this.state != INFO) {
            g.drawImage(this.playfield.bgImage, g.getClipWidth() / 2, g.getClipHeight() / 2, 3);
        }
        if (this.m.isVisible()) {
            this.m.paint(g);
        } else if (this.state == INIT) {
            this.playfield.fillElements(g, this.state);
            if (this.playfield.completeAnimation()) {
                this.state = PLAY;
            }
        } else if (this.state == INFO) {
            int y = 10;
            g.setFont(Font.getFont((int)0, (int)1, (int)Config.HELPFONTSIZE));
            g.setColor(0, 0, 0);
            g.drawString("Evaluation !", g.getClipWidth() / 2, y, 17);
            g.drawString("Only one nice", g.getClipWidth() / 2, y += Config.FONTHEIGHT, 17);
            g.drawString("Pinupgirl", g.getClipWidth() / 2, y += Config.FONTHEIGHT, 17);
        } else if (this.state == COMPLETE) {
            this.playfield.removeElements(g);
            if (this.playfield.completeAnimation()) {
                if (this.melody.finished()) {
                    g.drawImage(ToneOfLove.solvedImage, Config.SCREENWIDTH / 2, Config.SCREENHEIGHT / 2, 3);
                    this.state = FINISH;
                } else {
                    this.stopThread();
                    --this.lives;
                    if (this.lives == 0) {
                        g.drawImage(ToneOfLove.gameoverImage, Config.SCREENWIDTH / 2, Config.SCREENHEIGHT / 2, 3);
                    } else {
                        Config.drawLives(g, this.lives);
                    }
                    this.state = ERROR;
                }
            }
        } else if (this.state == PLAY || this.state == REPLAY) {
            this.playfield.paint(g);
            if (this.melody.finished() || this.melody.recalError()) {
                this.state = COMPLETE;
                this.startThread();
            }
        } else if (this.state == FINISH) {
            g.drawImage(ToneOfLove.solvedImage, Config.SCREENWIDTH / 2, Config.SCREENHEIGHT / 2, 3);
        } else if (this.state == ERROR) {
            if (this.lives == 0) {
                g.drawImage(ToneOfLove.gameoverImage, Config.SCREENWIDTH / 2, Config.SCREENHEIGHT / 2, 3);
            } else {
                Config.drawLives(g, this.lives);
            }
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            if (this.state == INIT || this.state == COMPLETE) {
                this.repaint();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.state != PLAY) continue;
            this.repaint();
            if (!this.melody.next()) {
                this.state = REPLAY;
                this.stopThread();
            }
            try {
                Thread.sleep(Config.STARTAPPEAR);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!this.melody.recalError()) {
                this.playfield.disappear();
                this.repaint();
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (this.m.isVisible()) {
            switch (action) {
                case 1: {
                    this.m.up();
                    this.repaint();
                    break;
                }
                case 6: {
                    this.m.down();
                    this.repaint();
                    break;
                }
                case 8: {
                    this.m.select();
                    this.repaint();
                }
            }
        } else if (keyCode < 0) {
            this.m.setVisible(true);
            this.stopThread();
            this.repaint();
        } else if (this.state == REPLAY) {
            switch (keyCode) {
                case 49: {
                    this.playfield.hit(0, 0);
                    break;
                }
                case 50: {
                    this.playfield.hit(1, 0);
                    break;
                }
                case 51: {
                    this.playfield.hit(2, 0);
                    break;
                }
                case 52: {
                    this.playfield.hit(0, 1);
                    break;
                }
                case 53: {
                    this.playfield.hit(1, 1);
                    break;
                }
                case 54: {
                    this.playfield.hit(2, 1);
                    break;
                }
                case 55: {
                    this.playfield.hit(0, 2);
                    break;
                }
                case 56: {
                    this.playfield.hit(1, 2);
                    break;
                }
                case 57: {
                    this.playfield.hit(2, 2);
                }
            }
            this.repaint();
        } else if (this.state == FINISH || this.state == ERROR || this.state == INFO) {
            if (this.state == FINISH) {
                this.nextLevel();
            } else if (this.state == INFO) {
                this.state = INIT;
                this.startThread();
            } else if (this.lives <= 0) {
                System.gc();
                ToneOfLove.startDisplay.toggle = false;
                ToneOfLove.display.setCurrent((Displayable)ToneOfLove.startDisplay);
            } else {
                this.melody.reset();
                this.playfield.reset();
                this.state = INIT;
                this.startThread();
            }
        }
    }

    public void select(MenuItem mi) {
        if (mi == this.exit) {
            System.gc();
            ToneOfLove.startDisplay.toggle = false;
            ToneOfLove.display.setCurrent((Displayable)ToneOfLove.startDisplay);
        } else if (mi == this.cont) {
            this.m.setVisible(false);
            this.startThread();
        }
    }
}

