/*
 * Decompiled with CFR 0.152.
 */
package toneoflove;

import de.tuttas.GameAPI.Menu;
import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import de.tuttas.GameAPI.ScoreDisplayListener;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import toneoflove.Config;
import toneoflove.GameDisplayable;
import toneoflove.HelpDisplayable;
import toneoflove.MyCanvas;
import toneoflove.SlideDisplayable;
import toneoflove.ToneOfLove;

public class StartDisplayable
extends MyCanvas
implements CommandListener,
MenuListener,
ScoreDisplayListener {
    public static final int START = 1;
    public static final int HIGHSCORE = 2;
    public static final int SLIDESHOW = 3;
    public static final int EXIT = 4;
    public static final int HELP = 5;
    SlideDisplayable sd;
    public boolean toggle = false;
    public Image image;
    Menu m;
    MenuItem start;
    MenuItem exit;
    MenuItem help;
    MenuItem about;

    public StartDisplayable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m = new Menu(Font.getDefaultFont().getHeight() + 2, Config.MENUSTART);
        this.m.setListener(this);
        if (ToneOfLove.display.isColor()) {
            this.image = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("titel.png"));
            this.start = new MenuItem("Start", 0xFFFF00, 0x9F9F9F, 0x840840, Config.FONTSIZE);
            this.exit = new MenuItem("Exit", 0xFFFF00, 0x9F9F9F, 0x840840, Config.FONTSIZE);
            this.help = new MenuItem("Help", 0xFFFF00, 0x9F9F9F, 0x840840, Config.FONTSIZE);
            this.about = new MenuItem("About", 0xFFFF00, 0x9F9F9F, 0x840840, Config.FONTSIZE);
        } else {
            this.image = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("titelbw.png"));
            this.start = new MenuItem("Start", 0xFFFFFF, 0xFFFFFF, 0, Config.FONTSIZE);
            this.exit = new MenuItem("Exit", 0xFFFFFF, 0xFFFFFF, 0, Config.FONTSIZE);
            this.help = new MenuItem("Help", 0xFFFFFF, 0xFFFFFF, 0, Config.FONTSIZE);
            this.about = new MenuItem("About", 0xFFFFFF, 0xFFFFFF, 0, Config.FONTSIZE);
        }
        this.m.add(this.start);
        this.m.add(this.help);
        this.m.add(this.about);
        this.m.add(this.exit);
    }

    public void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: {
                this.m.up();
                this.repaint();
                break;
            }
            case 6: {
                this.m.down();
                this.repaint();
                break;
            }
            case 8: {
                if (!this.toggle) {
                    this.m.select();
                }
                this.toggle = true;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    protected void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
        g.drawImage(this.image, 0, Config.SCREENHEIGHT, 36);
        this.m.paint(g);
    }

    public void run() {
    }

    public void select(MenuItem mi) {
        if (mi == this.start) {
            this.sd = null;
            ToneOfLove.gameDisplayable = null;
            System.gc();
            Config.gcWait();
            ToneOfLove.gameDisplayable = new GameDisplayable();
            ToneOfLove.gameDisplayable.init();
            ToneOfLove.gameDisplayable.startThread();
            ToneOfLove.display.setCurrent((Displayable)ToneOfLove.gameDisplayable);
        } else if (mi == this.exit) {
            ToneOfLove.quitApp();
        } else if (mi == this.help) {
            HelpDisplayable hd = new HelpDisplayable(HelpDisplayable.HELP);
            ToneOfLove.display.setCurrent((Displayable)hd);
        } else if (mi == this.about) {
            HelpDisplayable hd = new HelpDisplayable(HelpDisplayable.ABOUT);
            ToneOfLove.display.setCurrent((Displayable)hd);
        }
    }

    public void scoreFinished() {
        ToneOfLove.display.setCurrent((Displayable)this);
    }

    static {
        START = 1;
        HIGHSCORE = 2;
        SLIDESHOW = 3;
        EXIT = 4;
        HELP = 5;
    }
}

