/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class BreakoutCanvas
extends Canvas
implements Runnable {
    private static short mode = 0;
    static final short GAME = 0;
    static final short GAMEOVER = 1;
    static final short HIGHSCORE = 2;
    static final short SPLASHSCREEN = 3;
    static final short NEXTLEVEL = 4;
    static int width;
    static int height;
    private static int DEFAULT_WAIT;
    static boolean forceRedraw;

    public BreakoutCanvas(Breakout breakout) {
        width = this.getWidth();
        height = this.getHeight();
        StatusBar.init(this);
        BrickField.init(width, height, StatusBar.height, 4);
        Paddle.init(width / 5, 3, height - 6, width);
        Ball.init(2, width, this);
        forceRedraw = true;
    }

    public void newGame() {
        mode = 0;
        StatusBar.lives = 3;
        StatusBar.score = 0;
        BrickField.fillRandom();
        Ball.resetBall();
        Paddle.stop();
        Item.clear();
    }

    public void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 2: {
                Paddle.moveLeft();
                break;
            }
            case 5: {
                Paddle.moveRight();
                break;
            }
            case 1: {
                Ball.start();
                break;
            }
            case 8: {
                if (mode != 4) break;
                this.nextLevel();
            }
        }
    }

    public void keyReleased(int n) {
        switch (this.getGameAction(n)) {
            case 2: {
                Paddle.stop();
                break;
            }
            case 5: {
                Paddle.stop();
                break;
            }
        }
    }

    void clearCanvas(Graphics graphics) {
        graphics.setColor(Brick.color[0]);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public static void gameOver() {
        mode = 1;
        forceRedraw = true;
        if (HighScores.isHighScore(StatusBar.score)) {
            Breakout.getName();
        }
    }

    public void splashScreen() {
        mode = (short)3;
        forceRedraw = true;
    }

    public static void levelComplete() {
        mode = (short)4;
        forceRedraw = true;
        StatusBar.score = (short)(StatusBar.score + 50);
    }

    public void nextLevel() {
        BrickField.fillRandom();
        forceRedraw = true;
        mode = 0;
        Paddle.width -= Paddle.width / 5;
        Ball.resetBall();
        Paddle.stop();
    }

    public void paint(Graphics graphics) {
        if (mode == 1) {
            if (!forceRedraw) {
                return;
            }
            forceRedraw = false;
            this.clearCanvas(graphics);
            Font font = Font.getFont((int)0, (int)1, (int)0);
            graphics.setFont(font);
            StatusBar.paint(graphics);
            graphics.setColor(0);
            graphics.drawString("Game Over!!!", width / 2, StatusBar.height + 2, 17);
            HighScores.paint(graphics, StatusBar.height + graphics.getFont().getHeight() + 2);
        } else if (mode == 4) {
            if (!forceRedraw) {
                return;
            }
            forceRedraw = false;
            graphics.setColor(0);
            graphics.drawString("Level Complete!", width / 2, StatusBar.height + 5, 17);
            graphics.drawString("Fire to Continue!", width / 2, StatusBar.height + 20, 17);
        } else if (mode == 3) {
            if (!forceRedraw) {
                return;
            }
            forceRedraw = false;
            this.clearCanvas(graphics);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)16));
            graphics.setColor(0x2200FF);
            graphics.drawString("Breakout", width / 2, StatusBar.height + 5, 17);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
            graphics.setColor(0);
            graphics.drawString("by Jonas Diemer\n", width / 2, StatusBar.height + 20, 17);
        } else if (mode == 0) {
            if (forceRedraw) {
                forceRedraw = false;
                this.clearCanvas(graphics);
                BrickField.repaint(graphics);
            } else {
                BrickField.paint(graphics);
            }
            StatusBar.paint(graphics);
            Paddle.paint(graphics);
            Item.paint(graphics);
            Ball.paint(graphics);
        }
    }

    protected void hideNotify() {
        forceRedraw = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    BreakoutCanvas breakoutCanvas = this;
                    synchronized (breakoutCanvas) {
                        Paddle.update();
                        Ball.update();
                        Item.update();
                        this.repaint();
                        this.wait(DEFAULT_WAIT);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static {
        DEFAULT_WAIT = 13;
    }
}

