/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class BrickField {
    static int width;
    static int height;
    static int yPos;
    static short[][] bricks;
    static int brickCount;
    static int hitX;
    static int hitY;
    static int rowPainted;

    private BrickField() {
    }

    public static void init(int n, int n2, int n3, int n4) {
        hitX = -1;
        hitY = -1;
        width = n / 7;
        height = n2 / 6 - n4;
        yPos = n3;
        bricks = new short[width][height];
        BrickField.clearField();
        rowPainted = 0;
    }

    private static void clearField() {
        int n = 0;
        while (n < width) {
            int n2 = 0;
            while (n2 < height) {
                BrickField.bricks[n][n2] = 0;
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
    }

    public static void fillRandom() {
        brickCount = 0;
        Random random = new Random(StatusBar.score);
        int n = 1;
        while (n < width - 1) {
            int n2 = 0;
            while (n2 < height) {
                short s;
                BrickField.bricks[n][n2] = s = (short)(Math.abs(random.nextInt() % 2) + 1);
                brickCount += s;
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
    }

    public static boolean checkCollision(int n, int n2) {
        int n3 = BrickField.getCellX(n);
        int n4 = BrickField.getCellY(n2);
        if (n3 >= width || n3 < 0 || n4 >= height || n4 < 0) {
            return false;
        }
        return bricks[n3][n4] != 0;
    }

    public static int getCellX(int n) {
        return n / 7;
    }

    public static int getCellY(int n) {
        if (n - yPos < 0) {
            return -1;
        }
        return (n - yPos) / 4;
    }

    public static int hitBrick(int n, int n2) {
        short[] sArray = bricks[n / 7];
        int n3 = (n2 - yPos) / 4;
        sArray[n3] = (short)(sArray[n3] - 1);
        if (sArray[n3] == 0) {
            Item.create();
        }
        BrickField.scheduleRedrawCell(n / 7, (n2 - yPos) / 4);
        if (--brickCount <= 0) {
            BreakoutCanvas.levelComplete();
        }
        return 1;
    }

    static void drawCell(int n, int n2, Graphics graphics) {
        graphics.setColor(Brick.color[bricks[n][n2]]);
        graphics.fillRect(n * 7 + 2, yPos + n2 * 4 + 2, 5, 2);
    }

    public static void drawRegion(int n, int n2, int n3, int n4, Graphics graphics) {
        if (n < 0) {
            n = 0;
        }
        if (n3 >= width) {
            n3 = width - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 >= height) {
            n4 = height - 1;
        }
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                BrickField.drawCell(n5, n6, graphics);
                ++n6;
            }
            ++n5;
        }
    }

    private static void scheduleRedrawCell(int n, int n2) {
        hitY = n2;
        hitX = n;
    }

    static void redrawRow(int n, Graphics graphics) {
        int n2 = 0;
        while (n2 < height) {
            BrickField.drawCell(n, n2, graphics);
            n2 = (short)(n2 + 1);
        }
    }

    public static void repaint(Graphics graphics) {
        int n = 0;
        while (n < width) {
            int n2 = 0;
            while (n2 < height) {
                BrickField.drawCell(n, n2, graphics);
                ++n2;
            }
            ++n;
        }
    }

    public static void paint(Graphics graphics) {
        if (hitX != -1 && hitY != -1) {
            BrickField.drawRegion(hitX - 1, hitY - 1, hitX + 1, hitY + 1, graphics);
        }
        BrickField.redrawRow(rowPainted, graphics);
        if (++rowPainted >= width) {
            rowPainted = 0;
        }
    }
}

