/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.CubasisMobile;
import app.Session;
import app.Translation;
import com.siemens.mp.io.File;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class LoadSessionScreen
extends List
implements CommandListener {
    private CubasisMobile cumo;
    String[] files;
    int[] fileIndexTable;
    int sessionStartIndex;
    int factorySessionStartIndex;

    public LoadSessionScreen(CubasisMobile cumo) {
        super(Translation.strings.LOAD_TITLE, 3);
        this.cumo = cumo;
        this.addCommand(new Command(Translation.strings.BACK_COMMAND_LABEL, 2, 0));
        this.setCommandListener(this);
        try {
            int i;
            int index = 0;
            this.files = File.list((String)cumo.appPath);
            this.fileIndexTable = new int[this.files.length];
            for (i = 0; i < this.files.length; ++i) {
                if (!this.files[i].endsWith(".comp") || this.files[i].startsWith("default")) continue;
                String name = Session.readCompositionName(this.files[i].substring(0, this.files[i].lastIndexOf(46)));
                this.append(name, null);
                this.fileIndexTable[index] = i;
                ++index;
            }
            this.sessionStartIndex = index;
            for (i = 0; i < this.files.length; ++i) {
                if (!this.files[i].endsWith(".ses") || this.files[i].startsWith("output")) continue;
                this.append(this.files[i].substring(0, this.files[i].lastIndexOf(46)), null);
                this.fileIndexTable[index] = i;
                ++index;
            }
            this.factorySessionStartIndex = index;
            i = 0;
            while (i < cumo.factoryList.size()) {
                this.append((String)cumo.factoryList.elementAt(i), null);
                ++i;
                ++index;
            }
        }
        catch (Exception e) {
            cumo.alert(e.getMessage());
        }
    }

    public void commandAction(Command c, Displayable d) {
        String label = c.getLabel();
        if (label == Translation.strings.BACK_COMMAND_LABEL) {
            this.cumo.gotoAppMenu();
        } else {
            int index = this.getSelectedIndex();
            if (index >= 0) {
                try {
                    if (index < this.sessionStartIndex) {
                        String fileName = this.files[this.fileIndexTable[index]];
                        int extensionStart = fileName.lastIndexOf(46);
                        fileName = fileName.substring(0, extensionStart);
                        this.cumo.session.readComposition(fileName);
                        this.cumo.session.setCompositionName(Session.readCompositionName(fileName));
                    } else if (index < this.factorySessionStartIndex) {
                        String fileName = this.files[this.fileIndexTable[index]];
                        int extensionStart = fileName.lastIndexOf(46);
                        fileName = fileName.substring(0, extensionStart);
                        this.cumo.session.readSessionData(fileName);
                        this.cumo.session.setCompositionName(fileName);
                    } else {
                        this.cumo.session.readFactorySession(this.getString(index));
                        this.cumo.session.setCompositionName(this.getString(index));
                    }
                    this.cumo.session.decode();
                    this.cumo.display.setCurrent((Displayable)this.cumo.editScreen);
                }
                catch (Exception e) {
                    this.cumo.restart();
                    this.cumo.alert(e.getMessage());
                }
            }
        }
    }
}

