/*
 * Decompiled with CFR 0.152.
 */
package app;

import com.siemens.mp.io.File;
import com.siemens.mp.media.Manager;
import com.siemens.mp.media.MediaException;
import com.siemens.mp.media.Player;
import com.siemens.mp.media.PlayerListener;
import com.siemens.mp.media.control.VolumeControl;

public class Previewer
implements PlayerListener {
    private Player player;
    public static final byte STOPPED = 0;
    public static final byte PAUSED = 1;
    public static final byte RUNNING = 2;
    private byte state = 0;
    public int volume = 80;

    public void stop() throws Exception {
        if (this.state != 0) {
            this.player.stop();
            this.player = null;
            this.state = 0;
        }
    }

    public void playerUpdate(Player player, String str, Object obj) {
        System.out.println("playerUpdate ".concat(String.valueOf(String.valueOf(str))));
    }

    public void play(byte[] buffer, String mediaType, boolean looped) throws Exception {
        if (this.state != 0) {
            this.stop();
        }
        try {
            String path = "output.mid";
            File file = new File();
            int fd = -1;
            if (File.exists((String)path) >= 0) {
                File.delete((String)path);
            }
            fd = file.open(path);
            file.write(fd, buffer, 0, buffer.length);
            file.close(fd);
            this.play("file://".concat(String.valueOf(String.valueOf(path))), looped);
        }
        catch (Exception e) {
            this.player = null;
            throw e;
        }
    }

    public void play(String path, boolean looped) throws Exception {
        if (this.state != 0) {
            this.stop();
        }
        try {
            System.gc();
            this.player = Manager.createPlayer((String)path);
            this.player.addPlayerListener((PlayerListener)this);
            this.player.setLoopCount(looped ? -1 : 1);
            this.player.realize();
            VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(this.volume);
            }
            System.gc();
            this.player.start();
            this.state = (byte)2;
        }
        catch (Exception e) {
            this.player = null;
            throw e;
        }
    }

    public void pause() throws Exception {
        if (this.state == 2) {
            this.player.stop();
            this.state = 1;
        }
    }

    public void cont() throws Exception {
        if (this.state == 1) {
            try {
                this.player.start();
            }
            catch (MediaException e) {
                this.player = null;
                this.state = 0;
                throw e;
            }
            this.state = (byte)2;
        }
    }

    public int getState() {
        return this.state;
    }

    static {
        STOPPED = 0;
        PAUSED = 1;
        RUNNING = (byte)2;
    }
}

