/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.Event;
import app.EventCollector;
import app.EventReader;
import app.Translation;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

class MidiFile {
    static final byte kNoteOff = -128;
    static final byte kNoteOn = -112;
    static final byte kPolyPressure = -96;
    static final byte kController = -80;
    static final byte kProgramChange = -64;
    static final byte kAfterTouch = -48;
    static final byte kPitchBend = -32;
    static final byte kSysexStart = -16;
    static final byte kSysexEnd = -9;
    static final byte kMidiReset = -1;
    static final byte kMessageMask = -16;
    static final byte kChannelMask = 15;
    static final byte kSmfSequenceNumber = 0;
    static final byte kSmfTextEvent = 1;
    static final byte kSmfCopyrightNotice = 2;
    static final byte kSmfTrackName = 3;
    static final byte kSmfInstrumentName = 4;
    static final byte kSmfLyric = 5;
    static final byte kSmfMarker = 6;
    static final byte kSmfCuePoint = 7;
    static final byte kSmfMidiChannelPrefix = 32;
    static final byte kSmfEndOfTrack = 47;
    static final byte kSmfSetTempo = 81;
    static final byte kSmfSMPTEOffset = 84;
    static final byte kSmfTimeSignature = 88;
    static final byte kSmfKeySignature = 89;
    static final byte kSmfSequencerSpecificMetaEvent = 127;
    DataOutputStream outputStream;
    DataInputStream inputStream;
    EventCollector collector;
    EventReader eventReader;
    int byteCounter;

    MidiFile(DataInputStream inputStream, EventCollector collector) {
        this.inputStream = inputStream;
        this.collector = collector;
    }

    MidiFile(EventReader eventReader) {
        this.eventReader = eventReader;
    }

    public void read() throws Exception {
        this.byteCounter = 0;
        int id = this.inputStream.readInt();
        int length = this.inputStream.readInt();
        if (id != 1297377380) {
            throw new Exception(Translation.strings.FORMAT_ERROR);
        }
        short format = this.inputStream.readShort();
        int trackCount = this.inputStream.readShort();
        this.collector.setDivision(this.inputStream.readShort());
        for (int i = 0; i < trackCount; ++i) {
            id = this.inputStream.readInt();
            length = this.inputStream.readInt();
            if (id != 1297379947) {
                throw new Exception(Translation.strings.FORMAT_ERROR);
            }
            this.readTrack(i, length);
        }
    }

    public void readTrack(int trackIndex, int length) {
        byte lastStatus = 0;
        int lastMessageLength = 0;
        int timeTotal = 0;
        boolean isMasterTrack = false;
        String trackName = "name";
        boolean hasTrackName = false;
        try {
            this.byteCounter = 0;
            block18: while (length > this.byteCounter) {
                byte value2;
                byte value1;
                int deltaTime = this.readVarLen();
                byte status = this.readMidiByte();
                timeTotal += deltaTime;
                switch (status & 0xFFFFFFF0) {
                    case -128: 
                    case -112: 
                    case -96: 
                    case -80: 
                    case -32: {
                        value1 = this.readMidiByte();
                        value2 = this.readMidiByte();
                        lastStatus = status;
                        lastMessageLength = 2;
                        this.collector.addEvent(trackIndex, timeTotal, status, value1, value2);
                        continue block18;
                    }
                    case -64: 
                    case -48: {
                        value1 = this.readMidiByte();
                        value2 = 0;
                        lastStatus = status;
                        lastMessageLength = 1;
                        this.collector.addEvent(trackIndex, timeTotal, status, value1, value2);
                        continue block18;
                    }
                    case -16: {
                        switch (status) {
                            case -1: {
                                value1 = this.readMidiByte();
                                int messageLength = this.readVarLen();
                                byte[] message = this.readMessage(messageLength);
                                switch (value1) {
                                    case 47: {
                                        if (isMasterTrack) continue block18;
                                        if (hasTrackName) {
                                            this.collector.setTrackName(trackIndex, trackName);
                                        }
                                        timeTotal = 0;
                                        continue block18;
                                    }
                                    case 3: {
                                        if (message == null || hasTrackName) continue block18;
                                        hasTrackName = true;
                                        trackName = new String(message);
                                        continue block18;
                                    }
                                    case 81: {
                                        isMasterTrack = true;
                                        int sbp = (message[0] & 0xFF) * 65536;
                                        sbp += (message[1] & 0xFF) * 256;
                                        int tempo = 60000000 / (sbp += message[2] & 0xFF);
                                        this.collector.setTempo(tempo);
                                        continue block18;
                                    }
                                    case 88: {
                                        isMasterTrack = true;
                                        this.collector.setTimeSignature(message[0], 1 << message[1]);
                                        continue block18;
                                    }
                                    case 1: {
                                        continue block18;
                                    }
                                }
                                continue block18;
                            }
                            case -16: 
                            case -9: {
                                int messageLength = this.readVarLen();
                                byte[] message = new byte[messageLength + 1];
                                message[0] = -16;
                                this.inputStream.read(message, 1, messageLength);
                                message[messageLength] = -9;
                                this.collector.addSysex(trackIndex, timeTotal, message);
                                this.byteCounter += messageLength;
                                continue block18;
                            }
                        }
                        continue block18;
                    }
                }
                if (lastMessageLength == 0) continue;
                value1 = status;
                value2 = lastMessageLength == 2 ? this.readMidiByte() : (byte)0;
                this.collector.addEvent(trackIndex, timeTotal, lastStatus, value1, value2);
            }
        }
        catch (Exception exception) {
        }
    }

    public byte[] writeFormat0(int loopCount) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(8000);
        this.outputStream = new DataOutputStream(stream);
        this.outputStream.writeInt(1297377380);
        this.outputStream.writeInt(6);
        this.outputStream.writeShort(0);
        this.outputStream.writeShort(1);
        int division = this.eventReader.getDivision();
        this.outputStream.writeShort(division);
        this.outputStream.writeInt(1297379947);
        this.outputStream.writeInt(-1);
        this.byteCounter = 0;
        this.outputStream.write(0);
        this.outputStream.write(-1);
        this.outputStream.write(3);
        this.writeVarLen(2);
        this.outputStream.write(116);
        this.outputStream.write(116);
        this.byteCounter += 5;
        int nom = this.eventReader.getNom();
        int denom = this.eventReader.getDenom();
        int count = 1;
        while (denom > 2) {
            denom >>= 1;
            ++count;
        }
        this.outputStream.write(0);
        this.outputStream.write(-1);
        this.outputStream.write(88);
        this.outputStream.write(4);
        this.outputStream.write(nom);
        this.outputStream.write(count);
        this.outputStream.write(24);
        this.outputStream.write(8);
        this.byteCounter += 8;
        int t = 60000000 / this.eventReader.getTempo();
        this.outputStream.write(0);
        this.outputStream.write(-1);
        this.outputStream.write(81);
        this.outputStream.write(3);
        this.outputStream.write(t >> 16);
        this.outputStream.write(t >> 8);
        this.outputStream.write(t);
        this.byteCounter += 7;
        Event event = new Event();
        byte previousStatus = 0;
        int previousPosition = 0;
        for (int i = 0; i < loopCount; ++i) {
            boolean found = this.eventReader.first(event);
            while (found) {
                this.writeVarLen(event.position - previousPosition);
                previousPosition = event.position;
                if (previousStatus != event.status) {
                    this.outputStream.write(event.status);
                    ++this.byteCounter;
                    previousStatus = event.status;
                }
                this.outputStream.write(event.value1);
                ++this.byteCounter;
                byte eventType = (byte)(event.status & 0xFFFFFFF0);
                if (eventType == -128 || eventType == -112 || eventType == -96 || eventType == -80 || eventType == -32) {
                    this.outputStream.write(event.value2);
                    ++this.byteCounter;
                }
                found = this.eventReader.next(event);
            }
        }
        int compositionLength = this.eventReader.getBarLength() * this.eventReader.getBarCount();
        this.writeVarLen(compositionLength - previousPosition);
        this.writeTrackEnd();
        byte[] output = stream.toByteArray();
        output[18] = (byte)(this.byteCounter >> 24);
        output[19] = (byte)(this.byteCounter >> 16);
        output[20] = (byte)(this.byteCounter >> 8);
        output[21] = (byte)this.byteCounter;
        return output;
    }

    void writeTrackEnd() throws Exception {
        this.outputStream.write(255);
        this.outputStream.write(47);
        this.outputStream.write(0);
        this.byteCounter += 3;
    }

    void writeVarLen(int value) throws Exception {
        if (value == 0) {
            this.outputStream.write(0);
            ++this.byteCounter;
            return;
        }
        int buffer = value & 0x7F;
        ++this.byteCounter;
        while ((value >>= 7) > 0) {
            buffer <<= 8;
            buffer |= 0x80;
            buffer += value & 0x7F;
            ++this.byteCounter;
        }
        while (true) {
            this.outputStream.write(buffer);
            if ((buffer & 0x80) == 0) break;
            buffer >>= 8;
        }
    }

    byte readMidiByte() throws Exception {
        byte c = this.inputStream.readByte();
        ++this.byteCounter;
        return c;
    }

    byte[] readMessage(int length) throws Exception {
        byte[] message = null;
        if (length > 0) {
            message = new byte[length + 1];
            this.inputStream.read(message, 0, length);
            this.byteCounter += length;
            message[length] = 0;
        }
        return message;
    }

    int readVarLen() throws Exception {
        int c = this.inputStream.readByte();
        ++this.byteCounter;
        int result = c;
        if (((long)result & 0x80L) != (long)0) {
            result &= 0x7F;
            do {
                c = this.inputStream.readByte();
                ++this.byteCounter;
                result = (result << 7) + (c & 0x7F);
            } while ((c & 0x80) != 0);
        }
        return result;
    }

    static {
        kNoteOff = (byte)-128;
        kNoteOn = (byte)-112;
        kPolyPressure = (byte)-96;
        kController = (byte)-80;
        kProgramChange = (byte)-64;
        kAfterTouch = (byte)-48;
        kPitchBend = (byte)-32;
        kSysexStart = (byte)-16;
        kSysexEnd = (byte)-9;
        kMidiReset = (byte)-1;
        kMessageMask = (byte)-16;
        kChannelMask = (byte)15;
        kSmfSequenceNumber = 0;
        kSmfTextEvent = 1;
        kSmfCopyrightNotice = (byte)2;
        kSmfTrackName = (byte)3;
        kSmfInstrumentName = (byte)4;
        kSmfLyric = (byte)5;
        kSmfMarker = (byte)6;
        kSmfCuePoint = (byte)7;
        kSmfMidiChannelPrefix = (byte)32;
        kSmfEndOfTrack = (byte)47;
        kSmfSetTempo = (byte)81;
        kSmfSMPTEOffset = (byte)84;
        kSmfTimeSignature = (byte)88;
        kSmfKeySignature = (byte)89;
        kSmfSequencerSpecificMetaEvent = (byte)127;
    }
}

