/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.CubasisMobile;
import app.QuestionDialog;
import app.Translation;
import com.siemens.mp.io.File;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class SaveSessionScreen
extends Form
implements CommandListener {
    private CubasisMobile cumo;
    private TextField textField;
    boolean writeData = false;

    public SaveSessionScreen(CubasisMobile cumo, boolean writeSessionData) {
        super(Translation.strings.SAVE_TITLE);
        this.cumo = cumo;
        this.writeData = writeSessionData;
        this.addCommand(new Command(Translation.strings.OK_COMMAND_LABEL, 7, 0));
        this.addCommand(new Command(Translation.strings.BACK_COMMAND_LABEL, 2, 0));
        this.setCommandListener(this);
        String name = cumo.session.getCompositionName();
        this.textField = new TextField("", name, 15, 0);
        this.append((Item)this.textField);
    }

    public void commandAction(Command c, Displayable d) {
        String label = c.getLabel();
        String name = this.textField.getString();
        try {
            if (label == Translation.strings.OK_COMMAND_LABEL) {
                File file = new File();
                if (File.exists((String)String.valueOf(String.valueOf(name)).concat(".ses")) >= 0 || File.exists((String)String.valueOf(String.valueOf(name)).concat(".comp")) >= 0) {
                    QuestionDialog alert = new QuestionDialog(Translation.strings.APP_TITLE, Translation.strings.FILE_EXIST_QUESTION, Translation.strings.REPLACE_COMMAND_LABEL, Translation.strings.CANCEL_COMMAND_LABEL);
                    alert.setCommandListener(this);
                    this.cumo.display.setCurrent((Displayable)alert);
                } else {
                    this.storeSession(name);
                    this.cumo.gotoAppMenu();
                }
            } else if (label == Translation.strings.CANCEL_COMMAND_LABEL) {
                this.cumo.display.setCurrent((Displayable)this);
            } else if (label == Translation.strings.REPLACE_COMMAND_LABEL) {
                this.storeSession(name);
                this.cumo.gotoAppMenu();
            } else if (label == Translation.strings.BACK_COMMAND_LABEL) {
                this.cumo.gotoAppMenu();
            }
        }
        catch (Exception e) {
            this.cumo.alert(e.getMessage());
            return;
        }
    }

    void storeSession(String name) throws Exception {
        this.cumo.session.setCompositionName(name);
        if (this.writeData) {
            this.cumo.session.writeSessionData(name);
        } else {
            this.cumo.session.writeComposition(name, this.cumo.session.getCompositionData());
        }
    }
}

