/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.Event;
import app.EventCollector;
import app.EventReader;
import app.Track;
import app.Variation;

public class Composition
implements EventReader,
EventCollector {
    public Event[] queue;
    public int bar;
    public boolean collectCellOnly;
    public int activeBar;
    public int activeTrack;
    public String name = new String("Session");
    public Track[] tracks = new Track[4];
    public short division;
    public int barLength;
    public int variationLength;
    public int tempo = 120;
    public int nom;
    public int denom;
    public int numVariations = 3;
    public int barsPerVariation = 1;
    public static final int numBars = 4;
    public static final int numTracks = 4;

    public Composition() {
        this.queue = new Event[4];
        this.division = (short)480;
        this.setTimeSignature(4, 4);
        for (int i = 0; i < 4; ++i) {
            this.tracks[i] = new Track();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public int getTempo() {
        return this.tempo;
    }

    public void setTimeSignature(int nom, int denom) {
        this.nom = nom;
        this.denom = denom;
        this.barLength = this.division * nom / denom * 4;
        this.variationLength = this.barLength * this.barsPerVariation;
    }

    public int getNom() {
        return this.nom;
    }

    public int getDenom() {
        return this.denom;
    }

    public int getDivision() {
        return this.division;
    }

    public void setDivision(int division) {
        this.division = (short)division;
    }

    public int getBarCount() {
        return 4;
    }

    public int getBarLength() {
        return this.barLength;
    }

    public void setTrackName(int trackIndex, String name) {
        if (trackIndex != 0) {
            this.tracks[trackIndex - 1].name = name;
        }
    }

    public void addEvent(int trackIndex, int timeTotal, byte status, byte value1, byte value2) throws Exception {
        int variationIndex;
        if (trackIndex == 0) {
            throw new Exception(new String("MIDI data on track zero"));
        }
        Track track = this.tracks[trackIndex - 1];
        if ((status & 0xF0) == 192) {
            track.program = value1;
        }
        if ((variationIndex = timeTotal / this.variationLength) >= this.numVariations) {
            variationIndex = this.numVariations - 1;
        }
        Variation variation = track.variations[variationIndex];
        int position = timeTotal % this.variationLength;
        variation.addNote(position, status, value1, value2);
    }

    public void addSysex(int trackIndex, int timeTotal, byte[] buffer) {
        if (buffer.length != 23) {
            return;
        }
        int messageStart = 0;
        if (buffer[0] == -16 && buffer[1] == -16) {
            messageStart = 1;
        }
        if (buffer[messageStart] != -16 && buffer[messageStart + 1] != 17 && buffer[messageStart + 2] != 17 && buffer[messageStart + 3] != 16) {
            return;
        }
        this.barsPerVariation = buffer[messageStart + 4];
        if (this.barsPerVariation <= 0) {
            this.barsPerVariation = 1;
        }
        this.variationLength = this.barLength * this.barsPerVariation;
        for (int i = 0; i < 16; ++i) {
            byte value = buffer[i + messageStart + 5];
            if (value < 0) {
                value = 0;
            }
            if (value > this.numVariations) {
                value = (byte)this.numVariations;
            }
            this.tracks[i / 4].matrix[i % 4] = value;
        }
    }

    public boolean first(Event result) throws Exception {
        this.bar = 0;
        this.getVariations();
        return this.next(result);
    }

    public boolean next(Event result) {
        Event event = this.queue[0];
        int found = 0;
        try {
            if (this.collectCellOnly) {
                event = this.queue[this.activeTrack];
                found = this.activeTrack;
            } else {
                for (int i = 1; i < 4; ++i) {
                    Event next = this.queue[i];
                    if (event != null) {
                        if (next == null || next.position >= event.position) continue;
                        found = i;
                        event = next;
                        continue;
                    }
                    if (next == null) continue;
                    found = i;
                    event = next;
                }
            }
            if (event == null) {
                if (this.collectCellOnly) {
                    boolean bl = false;
                    return bl;
                }
                ++this.bar;
                if (this.bar >= 4) {
                    boolean bl = false;
                    return bl;
                }
                this.getVariations();
                boolean bl = this.next(result);
                return bl;
            }
            this.queue[found] = event.next;
            result.position = event.position + this.bar * this.variationLength;
            result.status = event.status;
            result.value1 = event.value1;
            result.value2 = event.value2;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void getVariations() throws Exception {
        if (this.collectCellOnly) {
            for (int i = 0; i < 4; ++i) {
                int varIndex;
                this.queue[i] = null;
                if (i != this.activeTrack || (varIndex = this.tracks[i].matrix[this.activeBar]) <= 0) continue;
                if (varIndex > 3) {
                    varIndex = 3;
                }
                this.queue[i] = this.tracks[i].variations[varIndex - 1].firstEvent;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                int varIndex = this.tracks[i].matrix[this.bar];
                if (varIndex > 0) {
                    if (varIndex > 3) {
                        varIndex = 3;
                    }
                    this.queue[i] = this.tracks[i].variations[varIndex - 1].firstEvent;
                    continue;
                }
                this.queue[i] = null;
            }
        }
    }

    static {
        numBars = 4;
        numTracks = 4;
    }
}

