/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.AboutScreen;
import app.DeleteAllSessionScreen;
import app.DeleteSessionScreen;
import app.DownloadScreen;
import app.EditScreen;
import app.ExitScreen;
import app.HelpScreen;
import app.LoadSessionScreen;
import app.OptionScreen;
import app.PlayScreen;
import app.Previewer;
import app.QuestionDialog;
import app.SaveSessionScreen;
import app.SendSessionScreen;
import app.Session;
import app.SplashScreen;
import app.StoreRingtoneScreen;
import app.Synchronizer;
import app.Translation;
import com.siemens.mp.game.Light;
import com.siemens.mp.io.Connection;
import com.siemens.mp.io.ConnectionListener;
import com.siemens.mp.io.File;
import com.siemens.mp.m55.Ledcontrol;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class CubasisMobile
extends MIDlet
implements CommandListener,
ConnectionListener,
Runnable {
    static final boolean DOWNLOAD = true;
    static final boolean PREVIEW = true;
    boolean initDone = false;
    long timeOutStart;
    static final int QUIT_ACTION = 0;
    static final int JUKEBOX_ACTION = 1;
    int action;
    byte light = 1;
    byte ledOption;
    boolean hasLed;
    public Display display;
    public Session session;
    public Previewer previewer;
    public Synchronizer sync;
    public SplashScreen splash;
    public EditScreen editScreen;
    public PlayScreen playScreen;
    public List mainMenu;
    public List appMenu;
    public QuestionDialog saveDialog;
    public Translation translation;
    public Vector factoryList;
    private Connection conn;
    public String appidString = "54481583";
    public String appPath = "a:\\java\\jam\\CubasisMobile\\storage\\";

    public void startApp() {
        SplashScreen splashScreen = null;
        String phoneModel = System.getProperty("microedition.platform");
        this.hasLed = phoneModel.compareTo("M55") == 0;
        this.ledOption = 0;
        try {
            System.gc();
            this.display = Display.getDisplay((MIDlet)this);
            Light.setLightOn();
            if (!this.initDone) {
                String prop;
                this.factoryList = new Vector();
                int i = 0;
                while ((prop = this.getAppProperty("PRESET_".concat(String.valueOf(String.valueOf(i))))) != null) {
                    this.factoryList.addElement(prop);
                    ++i;
                }
                if (this.factoryList.isEmpty()) {
                    this.factoryList.addElement(new String("Techno"));
                    this.factoryList.addElement(new String("Chillout"));
                    this.factoryList.addElement(new String("Pop"));
                }
                this.translation = new Translation();
                this.beginWait();
                splashScreen = new SplashScreen(this.getImage("startup.png"));
                this.display.setCurrent((Displayable)splashScreen);
                this.session = new Session();
                this.previewer = new Previewer();
                this.editScreen = new EditScreen(this);
                this.mainMenu = new List(Translation.strings.APP_TITLE, 3);
                this.mainMenu.append(Translation.strings.EDIT_COMMAND_LABEL, null);
                this.mainMenu.append(Translation.strings.JUKEBOX_COMMAND_LABEL, null);
                this.mainMenu.append(Translation.strings.HELP_COMMAND_LABEL, null);
                this.mainMenu.append(Translation.strings.ABOUT_COMMAND_LABEL, null);
                this.mainMenu.append(Translation.strings.OPTIONS_COMMAND_LABEL, null);
                this.mainMenu.append(Translation.strings.EXIT_COMMAND_LABEL, null);
                this.mainMenu.addCommand(new Command(Translation.strings.EXIT_COMMAND_LABEL, 2, 1));
                this.mainMenu.setCommandListener((CommandListener)this);
                this.appMenu = new List(Translation.strings.APP_TITLE, 3);
                this.appMenu.append(Translation.strings.RETURN_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.JUKEBOX_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.STORE_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.LOAD_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.SEND_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.STORERINGTONE_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.DELETE_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.DELETE_ALL_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.HELP_COMMAND_LABEL, null);
                this.appMenu.append(Translation.strings.BACK_COMMAND_LABEL, null);
                this.appMenu.addCommand(new Command(Translation.strings.BACK_COMMAND_LABEL, 2, 1));
                this.appMenu.setCommandListener((CommandListener)this);
                this.initDone = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readOptions();
        this.restart();
        if (splashScreen != null) {
            while (!this.endWait(2000L) && !splashScreen.screenAbort) {
            }
            if (!splashScreen.screenAbort) {
                splashScreen = new SplashScreen(this.getImage("siemens.png"));
                this.display.setCurrent((Displayable)splashScreen);
                this.beginWait();
                while (!this.endWait(2000L) && !splashScreen.screenAbort) {
                }
            }
        }
        if (!splashScreen.screenAbort) {
            splashScreen = new SplashScreen(this.getImage("about.png"));
            this.display.setCurrent((Displayable)splashScreen);
            this.beginWait();
            while (!this.endWait(2000L) && !splashScreen.screenAbort) {
            }
        }
        System.gc();
        this.display.setCurrent((Displayable)this.mainMenu);
        try {
            this.conn = new Connection("SMS:0815:".concat(String.valueOf(String.valueOf(this.appidString))));
            this.conn.setListener((ConnectionListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseApp() {
        try {
            this.previewer.stop();
            this.deactivate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyApp(boolean bool) {
        try {
            this.previewer.stop();
            this.deactivate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void quitApp() {
        this.beginWait();
        this.display.setCurrent((Displayable)new ExitScreen());
        this.action = 0;
        this.display.callSerially((Runnable)this);
    }

    public void run() {
        if (this.action == 0) {
            this.destroyApp(true);
            while (!this.endWait(3000L)) {
            }
            this.notifyDestroyed();
        } else if (this.action == 1) {
            this.showPlayScreen();
        }
        this.action = -1;
    }

    public void saveSession(boolean writeSessionData) throws Exception {
        this.display.setCurrent((Displayable)new SaveSessionScreen(this, writeSessionData));
    }

    public void loadSession() throws Exception {
        if (this.session.dirty) {
            this.saveDialog = new QuestionDialog(Translation.strings.APP_TITLE, Translation.strings.SAVE_QUESTION, Translation.strings.YES_COMMAND_LABEL, Translation.strings.NO_COMMAND_LABEL);
            this.saveDialog.setCommandListener(this);
            this.display.setCurrent((Displayable)this.saveDialog);
        } else {
            this.display.setCurrent((Displayable)new LoadSessionScreen(this));
        }
    }

    public void deleteSession() throws Exception {
        this.display.setCurrent((Displayable)new DeleteSessionScreen(this));
    }

    public void sendSession() throws Exception {
        this.display.setCurrent((Displayable)new SendSessionScreen(this));
    }

    public void deleteAllSessions() throws Exception {
        this.display.setCurrent((Displayable)new DeleteAllSessionScreen(this));
    }

    public void downloadSession(String name, String url) throws Exception {
        this.session.download(name, url);
        this.session.decode();
    }

    public void receiveData(byte[] data) {
        block9: {
            String url = new String(data);
            try {
                if (url.startsWith("http:")) {
                    int nameEnd;
                    int nameStart = url.lastIndexOf(47);
                    String name = url.substring(nameStart + 1, nameEnd = url.lastIndexOf(46));
                    if (name.length() <= 0) {
                        name = "Session";
                    }
                    DownloadScreen screen = new DownloadScreen(this);
                    screen.setUrl(url);
                    this.display.setCurrent((Displayable)screen);
                    this.downloadSession(name, url);
                    this.saveSession(true);
                    break block9;
                }
                if (!url.startsWith("comp:")) break block9;
                byte[] compData = new byte[data.length - 5];
                for (int i = 0; i < compData.length; ++i) {
                    compData[i] = data[i + 5];
                }
                try {
                    this.session.setCompositionData(compData);
                }
                catch (Exception e) {
                    try {
                        String name = Session.extractCompositionName(compData);
                        this.session.writeComposition(name, compData);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.alert(String.valueOf(String.valueOf(Translation.strings.RECEIVE_SUCCESS)).concat(String.valueOf(String.valueOf(e.getMessage()))));
                    this.restart();
                    return;
                }
                this.message(Translation.strings.RECEIVE_SUCCESS, (Displayable)this.editScreen);
            }
            catch (Exception e) {
                this.alert(e.getMessage());
                this.restart();
            }
        }
    }

    public void storeRingtone() {
        this.display.setCurrent((Displayable)new StoreRingtoneScreen(this));
    }

    public void gotoEditScreen() {
        try {
            this.session.decode();
            this.display.setCurrent((Displayable)this.editScreen);
            this.setLight(this.light);
        }
        catch (Exception e) {
            this.alert(e.getMessage());
        }
    }

    public void gotoPlayScreen() {
        this.sync = new Synchronizer();
        this.playScreen = new PlayScreen(this, this.sync);
        this.display.setCurrent((Displayable)this.playScreen);
        this.action = 1;
        this.display.callSerially((Runnable)this);
    }

    public void showPlayScreen() {
        try {
            this.sync.tempo = this.session.getTempo();
            this.sync.denominator = this.session.composition.denom;
            this.sync.nominator = this.session.composition.nom;
            this.setLight(this.light);
            if (this.hasLed && this.ledOption > 0) {
                int[] ledTable = new int[]{0, 7, 0, 2, 4, 6, 1, 3, 5};
                Ledcontrol.playPattern((int)ledTable[this.ledOption]);
            }
            this.preview(true);
            this.sync.start();
            Thread gameThread = new Thread(this.playScreen);
            gameThread.start();
        }
        catch (Exception e) {
            this.alert(e.getMessage());
        }
    }

    public void gotoMainMenu() {
        try {
            this.previewer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.display.setCurrent((Displayable)this.mainMenu);
    }

    public void gotoAppMenu() {
        try {
            this.previewer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.display.setCurrent((Displayable)this.appMenu);
    }

    public void commandAction(Command c, Displayable d) {
        String label = c.getLabel();
        try {
            if (d.equals(this.appMenu)) {
                if (label.compareTo(Translation.strings.BACK_COMMAND_LABEL) == 0) {
                    this.gotoMainMenu();
                } else {
                    switch (this.appMenu.getSelectedIndex()) {
                        case 0: {
                            this.gotoEditScreen();
                            break;
                        }
                        case 1: {
                            this.gotoPlayScreen();
                            break;
                        }
                        case 2: {
                            this.saveSession(false);
                            break;
                        }
                        case 3: {
                            this.loadSession();
                            break;
                        }
                        case 4: {
                            this.sendSession();
                            break;
                        }
                        case 5: {
                            this.storeRingtone();
                            break;
                        }
                        case 6: {
                            this.deleteSession();
                            break;
                        }
                        case 7: {
                            this.deleteAllSessions();
                            break;
                        }
                        case 8: {
                            this.display.setCurrent((Displayable)new HelpScreen(this, (Displayable)this.appMenu));
                            break;
                        }
                        case 9: {
                            this.gotoMainMenu();
                        }
                    }
                }
            } else if (d.equals(this.mainMenu)) {
                if (label.compareTo(Translation.strings.EXIT_COMMAND_LABEL) == 0) {
                    this.quitApp();
                } else {
                    switch (this.mainMenu.getSelectedIndex()) {
                        case 0: {
                            this.gotoEditScreen();
                            break;
                        }
                        case 1: {
                            this.gotoPlayScreen();
                            break;
                        }
                        case 2: {
                            this.display.setCurrent((Displayable)new HelpScreen(this, (Displayable)this.mainMenu));
                            break;
                        }
                        case 3: {
                            this.display.setCurrent((Displayable)new AboutScreen(this));
                            break;
                        }
                        case 4: {
                            this.display.setCurrent((Displayable)new OptionScreen(this));
                            break;
                        }
                        case 5: {
                            this.quitApp();
                        }
                    }
                }
            } else if (d.equals((Object)this.saveDialog)) {
                if (label.compareTo(Translation.strings.YES_COMMAND_LABEL) == 0) {
                    this.saveSession(false);
                } else {
                    this.session.dirty = false;
                    this.loadSession();
                }
                this.saveDialog = null;
            } else if (label.compareTo(Translation.strings.EXIT_COMMAND_LABEL) == 0) {
                this.gotoMainMenu();
            }
        }
        catch (Exception e) {
            this.alert(e.getMessage());
        }
    }

    public void preview(boolean looped) throws Exception {
        this.previewer.stop();
        this.previewer.play(this.session.encodeMidiFile(looped ? 4 : 1), "audio/x-mid", looped);
    }

    public void previewBar(int track, int bar) throws Exception {
        try {
            this.previewer.stop();
            this.previewer.play(this.session.encodeBar(track, bar), "audio/x-mid", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void togglePreview() throws Exception {
        if (this.previewer.getState() == 2) {
            this.previewer.pause();
        } else if (this.previewer.getState() == 1) {
            this.previewer.cont();
        } else {
            this.preview(false);
        }
    }

    public void previewStop() throws Exception {
        this.previewer.stop();
    }

    public void deactivate() throws Exception {
        this.writeOptions();
        this.session.writeComposition("default", this.session.getCompositionData());
        this.conn.setListener(null);
        this.conn = null;
    }

    public void adjustTempo(int step) {
        this.session.setTempo(this.session.getTempo() + step);
    }

    public void alert(String message) {
        Alert a = new Alert("Exception", message, null, AlertType.ERROR);
        a.setTimeout(-2);
        this.display.setCurrent(a, (Displayable)this.mainMenu);
    }

    public void message(String message, Displayable next) {
        Alert a = new Alert(Translation.strings.APP_TITLE, message, null, AlertType.CONFIRMATION);
        a.setTimeout(-2);
        this.display.setCurrent(a, next);
    }

    void beginWait() {
        try {
            this.timeOutStart = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.timeOutStart = 0L;
        }
    }

    boolean endWait(long milliseconds) {
        try {
            if (this.timeOutStart > (long)0) {
                long currentTime = System.currentTimeMillis();
                if (milliseconds - (currentTime - this.timeOutStart) < (long)0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void readOptions() {
        File file = new File();
        try {
            int fd = file.open(new String("options"));
            byte[] buffer = new byte[10];
            if (file.read(fd, buffer, 0, buffer.length) == buffer.length) {
                this.previewer.volume = buffer[0];
                this.setLight(buffer[1]);
                this.setLED(buffer[2]);
            }
            file.close(fd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeOptions() {
        File file = new File();
        try {
            int fd = file.open(new String("options"));
            byte[] buffer = new byte[10];
            buffer[0] = (byte)this.previewer.volume;
            buffer[1] = this.light;
            buffer[2] = this.ledOption;
            file.write(fd, buffer, 0, buffer.length);
            file.close(fd);
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
        }
    }

    public void setLight(byte state) {
        this.light = state;
        if (this.light == 1) {
            Light.setLightOn();
        } else {
            Light.setLightOff();
        }
    }

    public void setLED(int option) {
        this.ledOption = (byte)option;
    }

    void restart() {
        try {
            this.session.readComposition("default");
            this.session.decode();
            return;
        }
        catch (Exception exception) {
            try {
                this.session.readFactorySession((String)this.factoryList.elementAt(0));
                this.session.setCompositionName((String)this.factoryList.elementAt(0));
                this.session.decode();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }

    Image getImage(String name) {
        try {
            String base = this.display.isColor() ? new String("/app/cl/") : new String("/app/bw/");
            Image image = Image.createImage((String)String.valueOf(String.valueOf(base)).concat(String.valueOf(String.valueOf(name))));
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        DOWNLOAD = true;
        PREVIEW = true;
        QUIT_ACTION = 0;
        JUKEBOX_ACTION = 1;
    }
}

