/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.CubasisMobile;
import app.Translation;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;

public class OptionScreen
extends Form
implements CommandListener {
    private CubasisMobile cumo;
    private Gauge volumeControl;
    private ChoiceGroup choices;
    private ChoiceGroup ledChoices;

    public OptionScreen(CubasisMobile cumo) {
        super(Translation.strings.OPTIONS_TITLE);
        this.cumo = cumo;
        this.addCommand(new Command(Translation.strings.OK_COMMAND_LABEL, 4, 0));
        this.addCommand(new Command(Translation.strings.CANCEL_COMMAND_LABEL, 2, 0));
        this.setCommandListener(this);
        this.volumeControl = new Gauge(Translation.strings.VOLUME_LABEL, true, 100, cumo.previewer.volume);
        this.append((Item)this.volumeControl);
        this.choices = new ChoiceGroup("", 2);
        this.choices.append(Translation.strings.LIGHT_LABEL, null);
        this.choices.setSelectedIndex(0, cumo.light != 0);
        this.append((Item)this.choices);
        if (cumo.hasLed) {
            String[] stringArray = new String[]{Translation.strings.LED_Off, Translation.strings.LED_Strobo, Translation.strings.LED_Speed, Translation.strings.LED_Wave, Translation.strings.LED_Runway, Translation.strings.LED_Eternity, Translation.strings.LED_Lighthouse, Translation.strings.LED_Beat, Translation.strings.LED_Trance};
            this.ledChoices = new ChoiceGroup(Translation.strings.LED_LABEL, 1, stringArray, null);
            this.ledChoices.setSelectedIndex((int)cumo.ledOption, true);
            this.append((Item)this.ledChoices);
        }
        this.setCommandListener(this);
    }

    public void commandAction(Command c, Displayable d) {
        String label = c.getLabel();
        if (label == Translation.strings.OK_COMMAND_LABEL) {
            this.cumo.previewer.volume = this.volumeControl.getValue();
            this.cumo.setLight(this.choices.isSelected(0) ? (byte)1 : 0);
            if (this.cumo.hasLed) {
                this.cumo.setLED(this.ledChoices.getSelectedIndex());
            }
            this.cumo.gotoMainMenu();
        }
        if (label == Translation.strings.CANCEL_COMMAND_LABEL) {
            this.cumo.gotoMainMenu();
        }
    }
}

