/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.CubasisMobile;
import app.Synchronizer;
import com.siemens.mp.color_game.GameCanvas;
import com.siemens.mp.color_game.Layer;
import com.siemens.mp.color_game.LayerManager;
import com.siemens.mp.m55.Ledcontrol;
import javax.microedition.lcdui.Graphics;

public class PlayScreen
extends GameCanvas
implements Runnable {
    int frames;
    public boolean done;
    boolean readyToPaint;
    boolean lastPaint;
    LayerManager layerManager;
    Layer land;
    Synchronizer sync;
    CubasisMobile cumo;

    public PlayScreen(CubasisMobile cumo, Synchronizer sync) {
        super(false);
        this.cumo = cumo;
        this.sync = sync;
        this.done = false;
        this.showNotify();
        this.layerManager = new LayerManager();
        try {
            this.layerManager.append((Layer)new Circles(sync));
            this.layerManager.append((Layer)new TestLayer(sync));
            this.layerManager.append((Layer)new Background(sync));
        }
        catch (Exception e) {
            System.out.println("PlayScreen Init Exception: ".concat(String.valueOf(String.valueOf(e))));
        }
        System.gc();
        this.readyToPaint = true;
    }

    public void keyPressed(int keyCode) {
        this.done = true;
        if (this.cumo.hasLed) {
            Ledcontrol.stopPattern();
        }
    }

    private void animate() {
    }

    public void paint(Graphics g) {
        if (this.readyToPaint) {
            try {
                this.layerManager.paint(g, 0, 0);
                ++this.frames;
            }
            catch (Exception e) {
                System.out.println("GraphicsManager.paint() Exception: ".concat(String.valueOf(String.valueOf(e))));
            }
        }
        if (this.lastPaint) {
            this.readyToPaint = false;
            this.lastPaint = false;
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (!this.done) {
            try {
                Thread.yield();
                Thread.sleep(30L);
            }
            catch (Exception e) {
                System.out.println("Thread Exception: ".concat(String.valueOf(String.valueOf(e))));
            }
            this.sync.updateTime();
            this.repaint();
            this.serviceRepaints();
            this.flushGraphics();
        }
        thisThread = null;
        this.readyToPaint = false;
        this.cumo.gotoAppMenu();
    }

    private static class TestLayer
    extends Layer {
        int deltaX;
        int deltaY;
        Synchronizer sync;

        public TestLayer(Synchronizer sync) {
            super(101, 80);
            this.sync = sync;
        }

        public void paint(Graphics g) {
            g.setColor(255, 255, 0);
            g.fillRect(20 + this.sync.currentBeat * 15, 20 + this.sync.remainder / 3, 15, 15 + (50 + this.sync.remainder / 2));
        }
    }

    private static class Background
    extends Layer {
        Synchronizer sync;

        public Background(Synchronizer sync) {
            super(101, 80);
            this.sync = sync;
        }

        public void paint(Graphics g) {
            g.setColor(0, 0, 50 + this.sync.remainder * 2);
            g.fillRect(0, 0, 101, 40);
            g.setColor(50 + this.sync.remainder * 2, 255 - this.sync.remainder * 2, 0);
            g.fillRect(0, 40, 101, 40);
        }
    }

    private static class Circles
    extends Layer {
        Synchronizer sync;

        public Circles(Synchronizer sync) {
            super(101, 80);
            this.sync = sync;
        }

        public void paint(Graphics g) {
            int width = this.sync.remainder / 3;
            g.setColor(0, 255, 0);
            g.fillArc(10, 10, 10 + width, 10 + width, 0, 360);
            g.drawArc(71 - (33 - width), 50 - (33 - width), 10 + width, 10 + width, 0, 360);
            g.setColor(255, 0, 0);
            g.fillArc(20, 20, 10 + width, 10 + width, 0, 360);
            g.drawArc(61 - (33 - width), 40 - (33 - width), 10 + width, 10 + width, 0, 360);
            g.setColor(0, 0, 255);
            g.fillArc(30, 30, 10 + width, 10 + width, 0, 360);
            g.drawArc(51 - (33 - width), 30 - (33 - width), 10 + width, 10 + width, 0, 360);
        }
    }
}

