/*
 * Decompiled with CFR 0.152.
 */
package Space;

import Space.SpaceCanvas;
import Space.Weapon;
import com.siemens.mp.color_game.Layer;
import com.siemens.mp.color_game.LayerManager;
import com.siemens.mp.color_game.Sprite;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ship {
    public static final int shape_width = 31;
    private byte[][] shape;
    public int posX = -100;
    public int posY = -100;
    private int _counter = 0;
    public int dir = 6;
    public int spdX = 0;
    public int spdY = 0;
    public int rotSpd = 0;
    public int maxLives = 0;
    public int lives = 0;
    public int armor = 0;
    private int acc = 60;
    private int maxSpd = 400;
    final int NUM_SHAPE_SIZES;
    private int[] shape_size = new int[5];
    private Image[][] iShape = new Image[5][];
    public Sprite sprite;
    private Weapon[] wep = new Weapon[2];
    private String[] weapon_name = new String[2];
    private int[][][] wep_out = new int[2][2][2];
    private int[] wep_out_spd = new int[2];
    private int[] wep_out_at_once = new int[2];
    private int[] active_wep_out = new int[2];
    private int old_dir = -1;
    private int old_size = -1;
    public Ship enemy_ship;
    public boolean[] strat_fire = new boolean[2];
    public int strat_dest_dir = -1;
    public boolean strat_enabled = false;
    public boolean strat_accelerate = false;
    public int strat_towards_enemy = 0;
    private long strat_last_dist_2 = 10000000L;
    private int strat_want_to_turn_back;
    private int key_cache = 0;
    private int[] wep_out_counter = new int[2];
    private int rotate_counter = 0;
    SpaceCanvas spaceCanvas;

    public Ship() {
        this.NUM_SHAPE_SIZES = 5;
    }

    public Weapon[] init(String filename, SpaceCanvas _spaceCanvas, int _posX, int _posY, LayerManager layMan, Ship enemy_ship, boolean _strat_enabmed) {
        this.strat_enabled = _strat_enabmed;
        this.enemy_ship = enemy_ship;
        this.posX = _posX;
        this.posY = _posY;
        this.spaceCanvas = _spaceCanvas;
        for (int e = 0; e < 5; ++e) {
            int now_cam = (this.spaceCanvas.mincam * (4 - e) + this.spaceCanvas.maxcam * e) / 4;
            this.shape_size[e] = 3100 / now_cam;
        }
        this.shape_size[0] = 31;
        this.shape_size[1] = 24;
        this.shape_size[2] = 18;
        this.shape_size[3] = 10;
        this.shape_size[4] = 6;
        this.shape = new byte[31][31];
        this.spaceCanvas.out_text(String.valueOf(String.valueOf(new StringBuffer("Load: ").append(filename).append(".bmp"))));
        this.shape = this.spaceCanvas.loadBMP(String.valueOf(String.valueOf(filename)).concat(".bmp"), 31, 31);
        this.spaceCanvas.out_text(String.valueOf(String.valueOf(new StringBuffer("Rotate: ").append(filename).append(".bmp"))));
        this.iShape = this.spaceCanvas.rotate_shapes(5, this.shape_size, 31, this.shape);
        this.spaceCanvas.out_text(String.valueOf(String.valueOf(new StringBuffer("Load: ").append(filename).append(".dat"))));
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(filename)).concat(".dat"));
            if (is == null) {
                IOException exe = new IOException("hehe");
                throw exe;
            }
            this.maxSpd = SpaceCanvas.read11(is);
            this.acc = SpaceCanvas.read11(is);
            this.rotSpd = SpaceCanvas.read11(is);
            this.maxLives = this.lives = SpaceCanvas.read11(is);
            this.armor = SpaceCanvas.read11(is);
            this.weapon_name[0] = SpaceCanvas.readS(is);
            this.wep_out[0][0][0] = SpaceCanvas.read11(is);
            this.wep_out[0][0][1] = SpaceCanvas.read11(is);
            this.wep_out[0][1][0] = SpaceCanvas.read11(is);
            this.wep_out[0][1][1] = SpaceCanvas.read11(is);
            this.wep_out_spd[0] = SpaceCanvas.read11(is);
            this.wep_out_at_once[0] = SpaceCanvas.read11(is);
            this.wep[0] = new Weapon();
            this.wep[0].init(this.weapon_name[0], this.spaceCanvas, layMan, this);
            this.weapon_name[1] = SpaceCanvas.readS(is);
            this.wep_out[1][0][0] = SpaceCanvas.read11(is);
            this.wep_out[1][0][1] = SpaceCanvas.read11(is);
            this.wep_out[1][1][0] = SpaceCanvas.read11(is);
            this.wep_out[1][1][1] = SpaceCanvas.read11(is);
            this.wep_out_spd[1] = SpaceCanvas.read11(is);
            this.wep_out_at_once[1] = SpaceCanvas.read11(is);
            this.wep[1] = new Weapon();
            this.wep[1].init(this.weapon_name[1], this.spaceCanvas, layMan, this);
            is.close();
        }
        catch (IOException exe) {
            // empty catch block
        }
        this.active_wep_out[1] = 0;
        this.active_wep_out[0] = 0;
        this.wep_out_counter[1] = 0;
        this.wep_out_counter[0] = 0;
        this.sprite = new Sprite(this.iShape[0][0]);
        int which_shape = this.get_which_shape();
        int ss = this.shape_size[which_shape] / 2;
        this.sprite.setPosition(this.spaceCanvas.get_scr_pos(this.posX) - ss + this.spaceCanvas.width / 2, this.spaceCanvas.get_scr_pos(this.posY) - ss + this.spaceCanvas.height / 2);
        layMan.append((Layer)this.sprite);
        return this.wep;
    }

    private int get_which_shape() {
        int best_match = 0;
        int last_diff = 10000;
        int real_size = 3100 / this.spaceCanvas.cam;
        for (int e = 0; e < 5; ++e) {
            int now_diff = Math.abs(this.shape_size[e] - real_size);
            if (now_diff >= last_diff) continue;
            best_match = e;
            last_diff = now_diff;
        }
        return best_match;
    }

    public void draw(Graphics g) {
        int which_shape = this.get_which_shape();
        int ss = this.shape_size[which_shape] / 2;
        if (this.lives <= 0 && this.lives > -32) {
            this.sprite.setImage(this.spaceCanvas.explode_im32[-this.lives / 2], 32, 32);
            this.sprite.setPosition(this.spaceCanvas.get_scr_pos(this.posX) - 15 + this.spaceCanvas.width / 2, this.spaceCanvas.get_scr_pos(this.posY) - 15 + this.spaceCanvas.height / 2);
            --this.lives;
            return;
        }
        if (this.old_dir != this.dir || this.old_size != which_shape) {
            this.sprite.setImage(this.iShape[which_shape][this.dir], this.shape_size[which_shape], this.shape_size[which_shape]);
            this.old_dir = this.dir;
            this.old_size = which_shape;
            int a = this.shape_size[which_shape] / 6;
            this.sprite.setCollisionRectangle(a, a, this.shape_size[which_shape] - a, this.shape_size[which_shape] - a);
        }
        this.sprite.setPosition(this.spaceCanvas.get_scr_pos(this.posX) - ss + this.spaceCanvas.width / 2, this.spaceCanvas.get_scr_pos(this.posY) - ss + this.spaceCanvas.height / 2);
    }

    public boolean live() {
        --this.rotate_counter;
        this.wep_out_counter[0] = this.wep_out_counter[0] - 1;
        this.wep_out_counter[1] = this.wep_out_counter[1] - 1;
        if (this.lives <= -31) {
            return false;
        }
        if (this.strat_enabled) {
            int translate_dir = -6 - this.dir;
            int strat_dest_dir_diff = (this.strat_dest_dir + translate_dir + 12) % 12;
            if (strat_dest_dir_diff < 6) {
                this.keyStates(4);
            }
            if (strat_dest_dir_diff > 6) {
                this.keyStates(32);
            }
            if (this.strat_fire[0]) {
                this.fire(0);
            }
            if (this.strat_fire[1]) {
                this.fire(1);
            }
            if (this.strat_accelerate) {
                this.accelerate();
            }
        }
        this.posX += this.spdX;
        this.posY += this.spdY;
        return this.lives > -31;
    }

    private int signum(int a) {
        if (a == 0) {
            return 0;
        }
        return a >= 0 ? 1 : -1;
    }

    private boolean accelerate() {
        boolean greater2;
        int sin = SpaceCanvas.get_sin((this.dir + 9) % 12);
        int cos = SpaceCanvas.get_cos((this.dir + 9) % 12);
        int optimalX = this.maxSpd * cos / 1000;
        int optimalY = this.maxSpd * sin / 1000;
        boolean greater = this.spdX <= optimalX;
        this.spdX += this.signum(optimalX - this.spdX) * this.acc;
        boolean bl = greater2 = this.spdX <= optimalX;
        if (greater != greater2) {
            this.spdX = optimalX;
        }
        greater = this.spdY <= optimalY;
        this.spdY += this.signum(optimalY - this.spdY) * this.acc;
        boolean bl2 = greater2 = this.spdY <= optimalY;
        if (greater != greater2) {
            this.spdY = optimalY;
        }
        return true;
    }

    private boolean fire(int active_wep) {
        if (this.wep_out_counter[active_wep] >= 0) {
            return false;
        }
        this.wep_out_counter[active_wep] = this.wep_out_spd[active_wep];
        for (int out_now = 0; out_now < this.wep_out_at_once[active_wep]; ++out_now) {
            if (this.weapon_name[active_wep].compareTo("flamewep2") == 0) {
                int distX = this.enemy_ship.posX - this.posX;
                int distY = -(this.enemy_ship.posY - this.posY);
                int enemy_dir = Weapon.get_arc_tan(distX, distY);
                this.wep[active_wep].create_new(this.posX - 1000, this.posY - 1000, this.spdX, this.spdY, enemy_dir);
                this.wep[active_wep].create_new(this.posX - 1000, this.posY + 1000, this.spdX, this.spdY, enemy_dir);
                this.wep[active_wep].create_new(this.posX + 1000, this.posY - 1000, this.spdX, this.spdY, enemy_dir);
                this.wep[active_wep].create_new(this.posX + 1000, this.posY + 1000, this.spdX, this.spdY, enemy_dir);
                continue;
            }
            if (this.wep_out[active_wep][1][0] > 0) {
                this.active_wep_out[active_wep] = (this.active_wep_out[active_wep] + 1) % 2;
            }
            int sin = SpaceCanvas.get_sin((this.dir + 6) % 12);
            int cos = SpaceCanvas.get_cos((this.dir + 6) % 12);
            int e_rotated = ((this.wep_out[active_wep][this.active_wep_out[active_wep]][0] - 15) * cos + (this.wep_out[active_wep][this.active_wep_out[active_wep]][1] - 15) * sin) / 10;
            int f_rotated = ((this.wep_out[active_wep][this.active_wep_out[active_wep]][0] - 15) * sin - (this.wep_out[active_wep][this.active_wep_out[active_wep]][1] - 15) * cos) / 10;
            this.wep[active_wep].create_new(this.posX + e_rotated, this.posY + f_rotated, this.spdX, this.spdY, this.dir);
        }
        return true;
    }

    public boolean rotate(int diff) {
        if (this.rotate_counter >= 0) {
            return false;
        }
        this.dir = (this.dir + 12 + diff) % 12;
        this.rotate_counter = this.rotSpd;
        return true;
    }

    public void keyStates(int key) {
        if (this.lives < 0) {
            return;
        }
        this.key_cache |= key;
        if (this.key_cache == 0) {
            return;
        }
        if ((this.key_cache & 4) > 0) {
            if (this.rotate(-1)) {
                this.key_cache -= 4;
            }
        } else if ((this.key_cache & 0x20) > 0) {
            if (this.rotate(1)) {
                this.key_cache -= 32;
            }
        } else if ((this.key_cache & 2) > 0) {
            if (this.accelerate()) {
                this.key_cache -= 2;
            }
        } else if ((this.key_cache & 0x40) > 0) {
            if (this.fire(0)) {
                this.key_cache -= 64;
            }
        } else if ((this.key_cache & 0x100) > 0 && this.fire(1)) {
            this.key_cache -= 256;
        }
    }

    public boolean hit(int damage) {
        if (this.lives <= 0) {
            return false;
        }
        this.lives -= damage / this.armor;
        if (this.lives <= 0) {
            this.sprite.setImage(this.spaceCanvas.explode_im32[6], 32, 32);
            this.lives = -12;
            return false;
        }
        return true;
    }

    public void ships_swapped() {
        this.strat_towards_enemy *= -1;
        this.strat_want_to_turn_back = 0;
    }

    public void think() {
        this.strat_fire[0] = false;
        this.strat_fire[1] = false;
        int distX = this.enemy_ship.posX - this.posX;
        int distY = -(this.enemy_ship.posY - this.posY);
        int enemy_dir = Weapon.get_arc_tan(distX, distY);
        boolean[] close_enough_for_wep = new boolean[2];
        long dist_2 = distX * distX + distY * distY;
        long enemy_speed_2 = this.enemy_ship.spdX * this.enemy_ship.spdX + this.enemy_ship.spdY * this.enemy_ship.spdY;
        int wep_max_distance = this.wep[0].MAX_LIFETIME * this.wep[0].maxSpd;
        int sin = SpaceCanvas.get_sin((enemy_dir + 9) % 12);
        int cos = SpaceCanvas.get_cos((enemy_dir + 9) % 12);
        int max_distX = wep_max_distance * cos / 1000;
        int max_distY = wep_max_distance * sin / 1000;
        close_enough_for_wep[0] = Math.abs(distX) < Math.abs(max_distX) + 3000 && Math.abs(distY) < Math.abs(max_distY) + 3000;
        int strat_dest_dir_diff0 = Math.abs(enemy_dir - this.dir);
        if (close_enough_for_wep[0] && strat_dest_dir_diff0 < 2) {
            this.strat_fire[0] = true;
        }
        this.strat_accelerate = false;
        if (close_enough_for_wep[0]) {
            this.strat_dest_dir = enemy_dir;
        } else {
            if (this.strat_towards_enemy == 0) {
                this.strat_towards_enemy = 1;
            }
            if (dist_2 >= this.strat_last_dist_2 && this.strat_towards_enemy == 1) {
                ++this.strat_want_to_turn_back;
            } else if (dist_2 <= this.strat_last_dist_2 && this.strat_towards_enemy == -1) {
                ++this.strat_want_to_turn_back;
            } else if (this.strat_want_to_turn_back >= 0) {
                this.strat_want_to_turn_back = 0;
            }
            if (this.strat_want_to_turn_back >= 6) {
                this.strat_towards_enemy *= -1;
                this.strat_want_to_turn_back = -5;
            }
            if (this.strat_towards_enemy == 1) {
                this.strat_dest_dir = dist_2 > (long)400000000 ? enemy_dir : (enemy_dir + 1) % 12;
                if (this.strat_dest_dir == this.dir) {
                    this.strat_accelerate = true;
                }
            }
            if (this.strat_towards_enemy == -1) {
                this.strat_dest_dir = (enemy_dir + 6) % 12;
                if (Math.abs(this.strat_dest_dir - this.dir) < 4) {
                    this.strat_accelerate = true;
                }
            }
        }
        int wep_min_distance = this.wep[1].rotSpd * this.wep[0].maxSpd;
        int translate_dir = -6 - this.dir;
        int strat_dest_dir_diff = Math.abs(enemy_dir - this.dir);
        if (strat_dest_dir_diff <= 3 && (long)(strat_dest_dir_diff * wep_min_distance * wep_min_distance) < dist_2 + (long)10000) {
            this.strat_fire[1] = true;
        }
        this.strat_last_dist_2 = dist_2;
    }

    public void reinit(int _posX, int _posY) {
        this.posX = _posX;
        this.posY = _posY;
        this.lives = this.maxLives;
        this.wep[0].reinit();
        this.wep[1].reinit();
        this.active_wep_out[1] = 0;
        this.active_wep_out[0] = 0;
    }

    static {
        shape_width = 31;
    }
}

