/*
 * Decompiled with CFR 0.152.
 */
package Space;

import Space.Ship;
import Space.SpaceCanvas;
import com.siemens.mp.color_game.Layer;
import com.siemens.mp.color_game.LayerManager;
import com.siemens.mp.color_game.Sprite;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Weapon {
    int MAX_WEAPONS = 20;
    int MAX_LIFETIME = 30;
    private final int shape_width;
    private byte[][] shape;
    public int[] posX;
    public int[] posY;
    private int _counter = 0;
    private int[] dir;
    private int[] spdX;
    private int[] spdY;
    private int acc = 0;
    private int reloadSpd = 0;
    private int[] rotNow;
    public int maxSpd = 1000;
    public int rotSpd = 0;
    public int damage = 0;
    private boolean is_targeting = false;
    final int NUM_SHAPE_SIZES;
    private int[] shape_size = new int[3];
    private Image[][] iShape = new Image[3][12];
    private boolean[][] shape_rotated = new boolean[3][12];
    public Sprite[] sprite;
    public int[] life_time;
    private int[] old_dir;
    private int old_size = -1;
    private String weapon_name;
    private Ship my_ship;
    private Ship enemy_ship;
    SpaceCanvas spaceCanvas;

    public Weapon() {
        this.shape_width = 9;
        this.NUM_SHAPE_SIZES = 3;
    }

    public void init(String filename, SpaceCanvas _spaceCanvas, LayerManager layMan, Ship my_ship) {
        int e;
        this.my_ship = my_ship;
        this.enemy_ship = my_ship.enemy_ship;
        this.spaceCanvas = _spaceCanvas;
        this.spaceCanvas.out_text(String.valueOf(String.valueOf(new StringBuffer("Load: ").append(filename).append(".dat"))));
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(filename)).concat(".dat"));
            if (is == null) {
                IOException exe = new IOException("hehe");
                throw exe;
            }
            this.weapon_name = SpaceCanvas.readS(is);
            this.maxSpd = SpaceCanvas.read11(is);
            this.acc = SpaceCanvas.read11(is);
            this.rotSpd = SpaceCanvas.read11(is);
            this.damage = SpaceCanvas.read11(is);
            this.MAX_WEAPONS = SpaceCanvas.read11(is);
            this.MAX_LIFETIME = SpaceCanvas.read11(is);
            is.close();
            if (this.rotSpd != 0) {
                this.is_targeting = true;
            }
        }
        catch (IOException exe) {
            // empty catch block
        }
        this.posX = new int[this.MAX_WEAPONS];
        this.posY = new int[this.MAX_WEAPONS];
        this.dir = new int[this.MAX_WEAPONS];
        this.spdX = new int[this.MAX_WEAPONS];
        this.spdY = new int[this.MAX_WEAPONS];
        this.sprite = new Sprite[this.MAX_WEAPONS];
        this.life_time = new int[this.MAX_WEAPONS];
        this.old_dir = new int[this.MAX_WEAPONS];
        this.rotNow = new int[this.MAX_WEAPONS];
        for (e = 0; e < this.MAX_WEAPONS; ++e) {
            this.old_dir[e] = -1;
        }
        for (e = 0; e < this.MAX_WEAPONS; ++e) {
            this.rotNow[e] = this.rotSpd;
        }
        for (e = 0; e < this.MAX_WEAPONS; ++e) {
            this.life_time[e] = 0;
        }
        for (e = 0; e < 3; ++e) {
            int now_cam = (this.spaceCanvas.mincam * (2 - e) + this.spaceCanvas.maxcam * e) / 2;
            this.shape_size[e] = 900 / now_cam;
        }
        this.shape_size[0] = 9;
        this.shape_size[1] = 6;
        this.shape_size[2] = 3;
        this.shape = new byte[9][9];
        this.spaceCanvas.out_text(String.valueOf(String.valueOf(new StringBuffer("Load: ").append(filename).append(".bmp"))));
        this.shape = this.spaceCanvas.loadBMP(String.valueOf(String.valueOf(this.weapon_name)).concat(".bmp"), 9, 9);
        this.spaceCanvas.out_text(String.valueOf(String.valueOf(new StringBuffer("Rotate: ").append(this.weapon_name).append(".bmp"))));
        this.iShape = this.spaceCanvas.rotate_shapes(3, this.shape_size, 9, this.shape);
        for (e = 0; e < this.MAX_WEAPONS; ++e) {
            this.sprite[e] = new Sprite(this.iShape[0][0]);
            this.sprite[e].setVisible(false);
            layMan.append((Layer)this.sprite[e]);
        }
    }

    private int get_which_shape() {
        int best_match = 0;
        int last_diff = 10000;
        int real_size = 900 / this.spaceCanvas.cam;
        for (int e = 0; e < 3; ++e) {
            int now_diff = Math.abs(this.shape_size[e] - real_size);
            if (now_diff >= last_diff) continue;
            best_match = e;
            last_diff = now_diff;
        }
        return best_match;
    }

    public void draw(Graphics g) {
        int ss = this.shape_size[this.get_which_shape()] / 2;
        int which_shape = this.get_which_shape();
        for (int e = 0; e < this.MAX_WEAPONS; ++e) {
            if (this.life_time[e] > 0) {
                if (this.old_size != which_shape || this.old_dir[e] != this.dir[e]) {
                    this.sprite[e].setImage(this.iShape[which_shape][this.dir[e]], this.shape_size[which_shape], this.shape_size[which_shape]);
                    this.old_dir[e] = this.dir[e];
                    this.old_size = which_shape;
                }
                this.sprite[e].setPosition(this.spaceCanvas.get_scr_pos(this.posX[e]) - ss + this.spaceCanvas.width / 2, this.spaceCanvas.get_scr_pos(this.posY[e]) - ss + this.spaceCanvas.height / 2);
                this.sprite[e].setCollisionRectangle(0, 0, this.shape_size[which_shape], this.shape_size[which_shape]);
                continue;
            }
            if (this.life_time[e] >= 0) continue;
            this.sprite[e].setFrame(-this.life_time[e] - 1);
        }
    }

    public void live() {
        for (int e = 0; e < this.MAX_WEAPONS; ++e) {
            if (this.life_time[e] > 0) {
                this.accelerate(e);
                int n = e;
                this.posX[n] = this.posX[n] + this.spdX[e];
                int n2 = e;
                this.posY[n2] = this.posY[n2] + this.spdY[e];
                int n3 = e;
                this.life_time[n3] = this.life_time[n3] - 1;
                if (this.life_time[e] != 0) continue;
                this.sprite[e].setVisible(false);
                continue;
            }
            if (this.life_time[e] >= 0) continue;
            int n = e;
            this.life_time[n] = this.life_time[n] - 1;
            if (this.life_time[e] >= -8) continue;
            this.life_time[e] = 0;
            this.sprite[e].setVisible(false);
        }
    }

    public static int get_arc_tan(int x, int y) {
        if (x == 0) {
            return y <= 0 ? 6 : 0;
        }
        if (y == 0) {
            return x <= 0 ? 9 : 3;
        }
        int tan = y * 1000 / x;
        if (x < 0) {
            if (y < 0) {
                if (tan < 267) {
                    return 9;
                }
                if (tan < 1000) {
                    return 8;
                }
                if (tan < 3732) {
                    return 7;
                }
                return 6;
            }
            if (tan > -267) {
                return 9;
            }
            if (tan > -1000) {
                return 10;
            }
            if (tan > -3732) {
                return 11;
            }
            return 0;
        }
        if (y < 0) {
            if (tan > -267) {
                return 3;
            }
            if (tan > -1000) {
                return 4;
            }
            if (tan > -3732) {
                return 5;
            }
            return 6;
        }
        if (tan < 267) {
            return 3;
        }
        if (tan < 1000) {
            return 2;
        }
        if (tan < 3732) {
            return 1;
        }
        return 0;
    }

    private int get_optimum_dir(int which) {
        int distX = this.enemy_ship.posX - this.posX[which];
        int distY = -(this.enemy_ship.posY - this.posY[which]);
        return Weapon.get_arc_tan(distX, distY);
    }

    private void accelerate(int e) {
        if (this.is_targeting) {
            if (this.rotNow[e] == 0) {
                int opti = this.get_optimum_dir(e);
                int translate_dir = -6 - this.dir[e];
                if ((opti = (opti + translate_dir + 24) % 12) < 6) {
                    this.dir[e] = (this.dir[e] + 11) % 12;
                }
                if (opti > 6) {
                    this.dir[e] = (this.dir[e] + 1) % 12;
                }
                this.spdX[e] = this.maxSpd * SpaceCanvas.get_cos((this.dir[e] + 9) % 12) / 1000;
                this.spdY[e] = this.maxSpd * SpaceCanvas.get_sin((this.dir[e] + 9) % 12) / 1000;
                this.rotNow[e] = this.rotSpd;
            }
            int n = e;
            this.rotNow[n] = this.rotNow[n] - 1;
        }
    }

    public void create_new(int posX, int posY, int spdX, int spdY, int dir) {
        for (int e = 0; e < this.MAX_WEAPONS; ++e) {
            if (this.life_time[e] != 0) continue;
            this.posX[e] = posX;
            this.posY[e] = posY;
            this.sprite[e].setPosition(-1000, -1000);
            this.dir[e] = dir;
            if (!this.is_targeting) {
                this.spdX[e] = spdX + this.maxSpd * SpaceCanvas.get_cos((this.dir[e] + 9) % 12) / 1000;
                this.spdY[e] = spdY + this.maxSpd * SpaceCanvas.get_sin((this.dir[e] + 9) % 12) / 1000;
            } else {
                this.spdX[e] = this.maxSpd * SpaceCanvas.get_cos((this.dir[e] + 9) % 12) / 1000;
                this.spdY[e] = this.maxSpd * SpaceCanvas.get_sin((this.dir[e] + 9) % 12) / 1000;
            }
            this.life_time[e] = this.MAX_LIFETIME;
            this.sprite[e].setVisible(true);
            this.old_dir[e] = -1;
            break;
        }
    }

    public void translate(int trX, int trY) {
        int e = 0;
        while (e < this.MAX_WEAPONS) {
            int n = e;
            this.posX[n] = this.posX[n] - trX;
            int n2 = e++;
            this.posY[n2] = this.posY[n2] - trY;
        }
    }

    public void exploded(int which) {
        this.life_time[which] = -1;
        this.sprite[which].setImage(this.spaceCanvas.explode_im, 16, 16);
        this.sprite[which].setPosition(this.spaceCanvas.get_scr_pos(this.posX[which]) - 8 + this.spaceCanvas.width / 2, this.spaceCanvas.get_scr_pos(this.posY[which]) - 8 + this.spaceCanvas.height / 2);
    }

    public void reinit() {
        for (int e = 0; e < this.MAX_WEAPONS; ++e) {
            this.life_time[0] = 0;
            this.sprite[e].setVisible(false);
            this.old_dir[e] = -1;
            this.rotNow[e] = this.rotSpd;
        }
    }
}

