/*
 * Decompiled with CFR 0.152.
 */
package Puzzle3D;

import Puzzle3D.FameScreen;
import Puzzle3D.PuzzleCanvas;
import Puzzle3D.PuzzleMidlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class PuzzleState {
    private final byte STATEVERSION = (byte)8;
    private byte stateVersion;
    private String stateFilename;
    private RecordStore rs = null;
    private int stateRecId = 1;
    private final int FACES;
    private final int OFFSET_STATEVERSION;
    private byte[] recData;

    private byte getStateVersion() {
        return this.recData[0];
    }

    private void setStateVersion(byte version) {
        this.recData[0] = version;
    }

    private void createNewRecord() {
        this.recData = new byte[1];
        try {
            this.rs.addRecord(this.recData, 0, this.recData.length);
        }
        catch (RecordStoreFullException e) {
        }
        catch (RecordStoreNotOpenException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
    }

    public boolean load() {
        boolean result = false;
        try {
            this.rs = RecordStore.openRecordStore((String)this.stateFilename, (boolean)true);
        }
        catch (RecordStoreException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        try {
            this.recData = this.rs.getRecord(this.stateRecId);
            result = true;
        }
        catch (InvalidRecordIDException e) {
            this.createNewRecord();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Exception: " + e);
        }
        catch (RecordStoreNotOpenException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        if (result & this.getStateVersion() < this.stateVersion) {
            this.setStateVersion(this.stateVersion);
            result = false;
        }
        return result;
    }

    public void save() {
        try {
            this.rs.setRecord(this.stateRecId, this.recData, 0, this.recData.length);
        }
        catch (RecordStoreFullException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        catch (InvalidRecordIDException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        catch (RecordStoreNotOpenException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
        catch (RecordStoreException e) {
            System.out.println("Exception: " + (Object)((Object)e));
        }
    }

    public void saveAllClassStates(PuzzleMidlet midlet, PuzzleCanvas tetraCanvas, FameScreen fameForm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            outputStream.writeByte(this.stateVersion);
            midlet.saveMe(outputStream);
            tetraCanvas.saveMe(outputStream);
            fameForm.saveMe(outputStream);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        this.recData = baos.toByteArray();
        this.save();
    }

    public void loadAllClassStates(PuzzleMidlet midlet, PuzzleCanvas tetraCanvas, FameScreen fameForm) {
        boolean result = this.load();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.recData);
        DataInputStream inputStream = new DataInputStream(bais);
        if (!result) {
            midlet.initMe();
            tetraCanvas.initMe();
            fameForm.initMe();
            return;
        }
        try {
            byte version = inputStream.readByte();
        }
        catch (Exception eofe) {
            System.out.println(eofe);
            eofe.printStackTrace();
        }
        try {
            midlet.loadMe(inputStream);
            tetraCanvas.loadMe(inputStream);
            fameForm.loadMe(inputStream);
        }
        catch (Exception eofe) {
            System.out.println(eofe);
            eofe.printStackTrace();
        }
    }

    public PuzzleState(byte version, String filename) {
        this.FACES = 4;
        this.OFFSET_STATEVERSION = 0;
        this.stateVersion = version;
        this.stateFilename = filename;
    }
}

