/*
 * Decompiled with CFR 0.152.
 */
package gpong;

import gpong.Ball;
import gpong.Brick;
import gpong.Config;
import gpong.HotShot;
import gpong.PongCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Level {
    public static final int TYPE1 = 1;
    public static final int TYPE2 = 2;
    public static final int TYPE3 = 3;
    public static final int bg1R = 115;
    public static final int bg1G = 138;
    public static final int bg1B = 99;
    public static final int bg2R = 206;
    public static final int bg2G = 255;
    public static final int bg2B = 206;
    public static int width;
    private int x1;
    private int y1;
    private Brick tmpBrick;
    private int xLives;
    private int yLives;
    private int xLevel;
    private int yLevel;
    private int xScore;
    private int yScore;
    static PongCanvas pCanvas;
    public int xOffset;
    public int yOffset;
    private Image image;
    public Image gameImage;
    private Image levelPanelImage;
    private Brick[][] bricks;
    private int levelCounter = 1;
    private int levelOffset = 0;
    private int multiplikator = 1;
    public int lives = 3;
    public long score = 0L;
    private final int spalten;
    private final int zeilen;
    private int maxLevel;
    private int numberBricks;
    private byte[] balls = new byte[]{1, 1, 2, 2, 2, 2, 2, 3};
    private static Image image1;
    private static Image image2;
    private static Image image3;
    Image levelTopImage;
    Image levelButtomImage;
    private byte[][][] brickField = new byte[][][]{new byte[][]{{1, 1, 2, 1, 1}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 0, 0, 0, 0}}, new byte[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {1, 2, 2, 2, 1}, {0, 1, 1, 1, 0}}, new byte[][]{{1, 0, 0, 0, 1}, {1, 2, 0, 2, 1}, {2, 2, 0, 2, 2}, {0, 0, 0, 0, 0}}, new byte[][]{{0, 0, 2, 0, 0}, {0, 2, 2, 2, 0}, {2, 2, 2, 2, 2}, {0, 0, 2, 0, 0}}, new byte[][]{{3, 3, 3, 3, 3}, {2, 1, 0, 1, 2}, {2, 1, 0, 1, 2}, {1, 1, 0, 1, 1}}, new byte[][]{{0, 3, 3, 3, 0}, {0, 3, 1, 3, 0}, {0, 3, 3, 3, 0}, {0, 0, 0, 0, 0}}, new byte[][]{{2, 2, 2, 2, 2}, {0, 2, 0, 2, 0}, {0, 2, 0, 2, 0}, {1, 2, 1, 2, 1}}, new byte[][]{{2, 2, 2, 2, 2}, {3, 1, 3, 1, 3}, {3, 1, 3, 1, 3}, {0, 1, 3, 1, 0}}};

    public Level(PongCanvas pC) {
        this.spalten = 5;
        this.zeilen = 4;
        pCanvas = pC;
        this.xOffset = Level.pCanvas.centerX - Level.pCanvas.gameWidth / 2;
        this.yOffset = Level.pCanvas.brickHeight;
        this.maxLevel = this.brickField.length;
        image1 = Image.createImage((int)Config.BRICKWIDTH, (int)Config.BRICKHEIGHT);
        image2 = Image.createImage((int)Config.BRICKWIDTH, (int)Config.BRICKHEIGHT);
        image3 = Image.createImage((int)Config.BRICKWIDTH, (int)Config.BRICKHEIGHT);
        Level.create3DImage(image1, 128, 128, 128, 1, Config.BRICKWIDTH, Config.BRICKHEIGHT);
        Level.create3DImage(image2, 255, 0, 0, 2, Config.BRICKWIDTH, Config.BRICKHEIGHT);
        Level.create3DImage(image3, 255, 255, 0, 3, Config.BRICKWIDTH, Config.BRICKHEIGHT);
        try {
            this.image = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("lives.png"));
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        this.bricks = new Brick[5][4];
        this.initField();
        this.createPanelImage();
        this.gameImage = Image.createImage((int)Config.WIDTH, (int)Config.HEIGHT);
        this.repaintImage();
    }

    public static void create3DImage(Image i, int r, int g, int b, int bwtype, int w, int h) {
        Graphics gr = i.getGraphics();
        if (!HotShot.display.isColor()) {
            gr.setColor(255, 255, 255);
            gr.fillRect(0, 0, gr.getClipWidth(), gr.getClipHeight());
            gr.setColor(0, 0, 0);
            gr.drawRect(0, 0, w - 1, h - 1);
            if (bwtype != 1) {
                gr.fillRect(0, 0, w, h);
            }
        } else {
            gr.setColor(r, g, b);
            gr.fillRect(0, 0, gr.getClipWidth(), gr.getClipHeight());
            gr.setColor(255, 255, 255);
            gr.drawLine(0, 0, gr.getClipWidth(), 0);
            gr.drawLine(0, 0, 0, gr.getClipHeight());
            gr.setColor(50, 50, 50);
            gr.drawLine(gr.getClipWidth() - 1, 0, gr.getClipWidth() - 1, gr.getClipHeight() - 1);
            gr.drawLine(0, gr.getClipHeight() - 1, gr.getClipWidth() - 1, gr.getClipHeight() - 1);
        }
    }

    public static Image getImage(int mode) {
        if (mode == 1) {
            return image1;
        }
        if (mode == 2) {
            return image2;
        }
        if (mode == 3) {
            return image3;
        }
        return null;
    }

    private void createPanelImage() {
        try {
            this.levelTopImage = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("scorePanelOben.png"));
            this.levelButtomImage = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("scorePanelUnten.png"));
            this.levelPanelImage = Image.createImage((int)width, (int)Config.HEIGHT);
            Graphics gr = this.levelPanelImage.getGraphics();
            gr.setColor(0, 0, 0);
            gr.setColor(115, 138, 99);
            gr.fillRect(0, 0, gr.getClipWidth(), gr.getClipHeight());
            gr.drawImage(this.levelTopImage, width / 2, 2, 17);
            gr.drawImage(this.levelButtomImage, width / 2, gr.getClipHeight() - 5 + Config.SCOREPANELOFFSET, 33);
            this.xLives = Config.WIDTH - width + 8;
            this.yLives = 23 + Config.LIVESYOFFSET;
            this.xLevel = this.xLives;
            this.yLevel = 15 + Config.LEVELYOFFSET;
            this.xScore = this.xLevel;
            this.yScore = Config.HEIGHT - 5 + Config.SCOREYOFFSET;
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
    }

    public boolean nextLevel() {
        return this.numberBricks == 0;
    }

    public int getBalls() {
        return this.balls[this.levelCounter - 1] * this.multiplikator;
    }

    public int getLevel() {
        return this.levelCounter + this.levelOffset;
    }

    public void decLives() {
        --this.lives;
        this.drawLives();
    }

    private void drawLives() {
        Graphics g = this.gameImage.getGraphics();
        int x = this.xLives;
        g.setColor(206, 255, 206);
        g.fillRect(this.xLives, this.yLives, this.image.getWidth() * 3 + 3, this.image.getHeight());
        for (int i = 0; i < this.lives; ++i) {
            g.drawImage(this.image, x, this.yLives, 20);
            x = x + this.image.getWidth() + 1;
        }
    }

    private void drawLevel() {
        Graphics g = this.gameImage.getGraphics();
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        g.drawString(Integer.toString(this.getLevel()), this.xLevel, this.yLevel, 68);
    }

    private void drawScore() {
        String s = Long.toString(this.score);
        Graphics g = this.gameImage.getGraphics();
        g.setColor(206, 255, 206);
        g.fillRect(this.xScore, this.yScore - 10, this.levelButtomImage.getWidth() - 8, 10);
        g.setColor(0, 0, 0);
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        g.drawString(s, this.xScore, this.yScore, 68);
    }

    public Image getImage() {
        return this.gameImage;
    }

    public void repaintImage() {
        Graphics g = this.gameImage.getGraphics();
        try {
            Image backgroundImage = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat(String.valueOf(String.valueOf(Config.backgrounds[this.levelCounter - 1]))));
            g.drawImage(backgroundImage, Level.pCanvas.centerX, Level.pCanvas.centerY, 3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        g.drawImage(this.levelPanelImage, g.getClipWidth(), 0, 24);
        this.drawLives();
        this.drawScore();
        this.drawLevel();
    }

    public void incScore(int offset) {
        this.score += (long)offset;
        this.drawScore();
    }

    public void incLevel() {
        ++this.levelCounter;
        if (this.levelCounter > this.maxLevel) {
            this.levelOffset = this.levelOffset + this.levelCounter - 1;
            this.levelCounter = 1;
            ++this.multiplikator;
        }
        this.initField();
        this.repaintImage();
        this.drawLevel();
    }

    public void removeBricks(Brick b) {
        --this.numberBricks;
        this.bricks[b.xi][b.yi] = null;
    }

    public boolean gameOver() {
        return this.lives == 0;
    }

    public void initField() {
        byte[][] tmpBrickField = this.brickField[this.levelCounter - 1];
        this.numberBricks = 0;
        int xPos = 0;
        int yPos = 0;
        for (int xp = 0; xp < 5; ++xp) {
            for (int yp = 0; yp < tmpBrickField.length; ++yp) {
                if (tmpBrickField[yp][xp] != 0) {
                    Brick b = new Brick(pCanvas, xPos, yPos, tmpBrickField[yp][xp], xp, yp);
                    ++this.numberBricks;
                    this.bricks[xp][yp] = b;
                }
                yPos += Level.pCanvas.brickHeight;
            }
            xPos += Level.pCanvas.brickWidth;
            yPos = 0;
        }
    }

    protected void paintField(Graphics g) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.bricks[i][j] == null) continue;
                this.bricks[i][j].paint(g, this.xOffset, this.yOffset);
            }
        }
    }

    public Brick collision(Ball ball) {
        if (ball.getY() + ball.getR() > Level.pCanvas.gameHeight + 2 * Level.pCanvas.brickHeight) {
            return null;
        }
        this.x1 = (ball.getX() + Config.RADIUS / 2 - this.xOffset) / Config.BRICKWIDTH;
        this.y1 = (ball.getY() + Config.RADIUS / 2 - this.yOffset) / Config.BRICKHEIGHT;
        --this.x1;
        --this.y1;
        this.tmpBrick = this.getBrick(this.x1, this.y1);
        if (this.tmpBrick != null && this.tmpBrick.collision(ball, this.xOffset, this.yOffset)) {
            return this.tmpBrick;
        }
        this.tmpBrick = this.getBrick(this.x1 + 1, this.y1);
        if (this.tmpBrick != null && this.tmpBrick.collision(ball, this.xOffset, this.yOffset)) {
            return this.tmpBrick;
        }
        this.tmpBrick = this.getBrick(this.x1, this.y1 + 1);
        if (this.tmpBrick != null && this.tmpBrick.collision(ball, this.xOffset, this.yOffset)) {
            return this.tmpBrick;
        }
        this.tmpBrick = this.getBrick(this.x1 + 1, this.y1 + 1);
        if (this.tmpBrick != null && this.tmpBrick.collision(ball, this.xOffset, this.yOffset)) {
            return this.tmpBrick;
        }
        return null;
    }

    private Brick getBrick(int xi, int yi) {
        try {
            Brick brick = this.bricks[xi][yi];
            return brick;
        }
        catch (ArrayIndexOutOfBoundsException ab) {
            Brick brick = null;
            return brick;
        }
    }

    static {
        TYPE1 = 1;
        TYPE2 = 2;
        TYPE3 = 3;
        bg1R = 115;
        bg1G = 138;
        bg1B = 99;
        bg2R = 206;
        bg2G = 255;
        bg2B = 206;
        width = Config.PANELWIDTH;
    }
}

