/*
 * Decompiled with CFR 0.152.
 */
package ws.boardgames;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import ws.boardgames.ChessFigure;
import ws.boardgames.Field;
import ws.boardgames.MainForm;
import ws.boardgames.Move;
import ws.boardgames.NetMobileChess;
import ws.boardgames.Request;
import ws.boardgames.Server;

public class ChessDesk
extends Canvas
implements CommandListener {
    public static final byte ms_dim = 8;
    public static final int WHITE = 0xFFFFFF;
    public static final int BLACK = 0;
    public static final int BG_COLOR = 0xFFFFFF;
    public static final byte FIGURECHOICE = 0;
    public static final byte MOVECHOICE = 1;
    public static final byte ENEMYTURN = 2;
    public static final byte GAMEOVER = 3;
    public static final byte BLACKWON = 0;
    public static final byte DRAW = 1;
    public static final byte WHITEWON = 2;
    public static final byte fieldSize = 8;
    byte m_result;
    ChessFigure[][] figures;
    private boolean[][] paintedFields;
    private Field cursor = new Field();
    private Field selectedField = null;
    boolean myColor;
    boolean activeColor;
    Move lastMove;
    private boolean local = true;
    private int tableId = -1;
    protected boolean m_bWhiteKingGone;
    protected boolean m_bBlackKingGone;

    public ChessDesk(boolean side, boolean l, int id) {
        this.tableId = id;
        this.local = l;
        try {
            this.jbInit(side);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit(boolean side) throws Exception {
        this.activeColor = true;
        this.myColor = side;
        this.m_result = (byte)-1;
        this.m_bWhiteKingGone = false;
        this.m_bBlackKingGone = false;
        this.figures = new ChessFigure[8][8];
        for (int a_idxV = 0; a_idxV < 8; ++a_idxV) {
            for (int a_idxH = 0; a_idxH < 8; ++a_idxH) {
                this.figures[a_idxV][a_idxH] = null;
            }
        }
        for (int a_i = 0; a_i < 8; ++a_i) {
            this.figures[a_i][1] = new ChessFigure(1, true);
            this.figures[a_i][6] = new ChessFigure(1, false);
        }
        this.figures[1][0] = new ChessFigure(2, true);
        this.figures[6][0] = new ChessFigure(2, true);
        this.figures[1][7] = new ChessFigure(2, false);
        this.figures[6][7] = new ChessFigure(2, false);
        this.figures[2][0] = new ChessFigure(3, true);
        this.figures[5][0] = new ChessFigure(3, true);
        this.figures[2][7] = new ChessFigure(3, false);
        this.figures[5][7] = new ChessFigure(3, false);
        this.figures[0][0] = new ChessFigure(4, true);
        this.figures[7][0] = new ChessFigure(4, true);
        this.figures[0][7] = new ChessFigure(4, false);
        this.figures[7][7] = new ChessFigure(4, false);
        this.figures[3][0] = new ChessFigure(5, true);
        this.figures[3][7] = new ChessFigure(5, false);
        this.figures[4][0] = new ChessFigure(6, true);
        this.figures[4][7] = new ChessFigure(6, false);
        this.setCommandListener(this);
        if (!this.local) {
            this.addCommand(new Command("Update", 1, 1));
            this.loadGame();
        }
        this.addCommand(new Command("Exit", 7, 3));
    }

    protected Move getMoveFromServer() {
        if (this.local) {
            return null;
        }
        Request req = new Request();
        req.tableId = this.tableId;
        req.action = (byte)7;
        Vector v = new Vector();
        try {
            v = Server.getResults(req);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Move.parseMove((String)v.elementAt(0));
    }

    public void commandAction(Command command, Displayable displayable) {
        Move m;
        this.paintedFields = null;
        if (command.getCommandType() == 3) {
            m = new Move();
            m.proposal = 0;
            try {
                this.Send(m);
                this.gameOver(this.activeColor ? (byte)0 : 2);
            }
            catch (Exception exception) {}
        } else if (command == List.SELECT_COMMAND) {
            List list = (List)displayable;
            Display.getDisplay((MIDlet)NetMobileChess.instance).setCurrent((Displayable)this);
            this.paintedFields = null;
            this.repaint();
            this.localCheckAndMove((byte)(list.getSelectedIndex() + 2));
            return;
        }
        if (command.getCommandType() == 7) {
            NetMobileChess.quitApp();
        } else if (command.getCommandType() == 1) {
            if (this.local) {
                return;
            }
            if (this.myColor == this.activeColor) {
                return;
            }
            m = this.getMoveFromServer();
            if (this.lastMove == null || !this.lastMove.equals(m)) {
                this.performStep(m);
                this.paintedFields = null;
                this.repaint();
            }
        }
    }

    private void needRepaint(byte v, byte h, boolean b) {
        if (this.paintedFields == null) {
            this.initPaintedFields();
        }
        this.paintedFields[v][h] = b;
    }

    private void initPaintedFields() {
        if (this.paintedFields == null) {
            this.paintedFields = new boolean[8][8];
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.paintedFields[i][j] = false;
            }
        }
    }

    private void paintField(Graphics g, byte v, byte h) {
        this.needRepaint(v, h, true);
        boolean fColor = Field.getColor(v, h);
        g.setColor(fColor ? 0xFFFFFF : 0);
        g.fillRect(0, 0, 8, 8);
        if (this.figures[v][h] != null) {
            this.figures[v][h].paint(g, fColor);
        }
        if (this.cursor.equals(v, h)) {
            Field.paintSelection(g, fColor, this.activeColor == this.myColor);
        }
        if (this.selectedField != null && this.selectedField.equals(v, h)) {
            Field.paintSelection(g, fColor, this.activeColor == this.myColor);
        }
    }

    protected void paint(Graphics g) {
        int a_height = g.getClipHeight();
        int a_width = g.getClipWidth();
        if (this.paintedFields == null) {
            this.initPaintedFields();
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, g.getClipHeight(), g.getClipWidth());
        }
        boolean a_bColor = false;
        g.translate(0, 56);
        for (byte a_idxV = 0; a_idxV < 8; a_idxV = (byte)(a_idxV + 1)) {
            for (byte a_idxH = 0; a_idxH < 8; a_idxH = (byte)(a_idxH + 1)) {
                if (!this.paintedFields[this.getV(a_idxV)][this.getH(a_idxH)]) {
                    this.paintField(g, this.getV(a_idxV), this.getH(a_idxH));
                }
                g.translate(0, -8);
            }
            g.translate(8, 64);
        }
        g.translate(-g.getTranslateX(), -g.getTranslateY());
    }

    private byte getH(byte h) {
        return this.myColor ? h : (byte)(7 - h);
    }

    private byte getV(byte v) {
        return this.myColor ? v : (byte)(7 - v);
    }

    private void mutationList() {
        List mutList = new List("Choose figure", 3);
        mutList.append("Knight", ChessFigure.getImage((byte)6, this.myColor, true));
        mutList.append("Bishop", ChessFigure.getImage((byte)3, this.myColor, true));
        mutList.append("Rock", ChessFigure.getImage((byte)4, this.myColor, true));
        mutList.append("Queen", ChessFigure.getImage((byte)5, this.myColor, true));
        mutList.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)NetMobileChess.instance).setCurrent((Displayable)mutList);
    }

    private void enterPressed() {
        boolean mutation;
        this.needRepaint(this.cursor.v, this.cursor.h, false);
        if (this.selectedField != null) {
            this.needRepaint(this.selectedField.v, this.selectedField.h, false);
        }
        if (this.selectedField != null && this.selectedField.equals(this.cursor)) {
            this.needRepaint(this.selectedField.v, this.selectedField.h, false);
            this.selectedField = null;
            return;
        }
        ChessFigure f = this.figures[this.cursor.v][this.cursor.h];
        if (f != null && f.color == this.myColor) {
            this.selectedField = new Field(this.cursor);
            return;
        }
        if (this.selectedField == null) {
            return;
        }
        if (this.myColor != this.activeColor) {
            return;
        }
        this.needRepaint(this.selectedField.v, this.selectedField.h, false);
        f = this.figures[this.selectedField.v][this.selectedField.h];
        boolean bl = mutation = f.type == 1 && (f.color && this.cursor.h == 7 || !f.color && this.cursor.h == 0);
        if (mutation) {
            this.mutationList();
            return;
        }
        this.localCheckAndMove((byte)-1);
    }

    private void localCheckAndMove(byte mut) {
        Move m = new Move();
        m.pos1 = new Field(this.selectedField);
        m.pos2 = new Field(this.cursor);
        m.mutation = mut;
        if (!this.checkStep(m, this.activeColor)) {
            return;
        }
        this.performStep(m);
        this.selectedField = null;
        if (this.local) {
            this.myColor = this.activeColor;
        } else {
            this.Send(this.lastMove);
        }
    }

    protected void keyPressed(int p_keyCode) {
        int d_d;
        int n = d_d = this.myColor ? 1 : -1;
        if (this.paintedFields == null) {
            this.initPaintedFields();
        }
        this.needRepaint(this.cursor.v, this.cursor.h, false);
        if (this.selectedField != null) {
            this.paintedFields[this.selectedField.v][this.selectedField.h] = false;
        }
        switch (p_keyCode) {
            case 56: {
                this.cursor.h = (byte)(this.cursor.h - d_d);
                break;
            }
            case 50: {
                this.cursor.h = (byte)(this.cursor.h + d_d);
                break;
            }
            case 52: {
                this.cursor.v = (byte)(this.cursor.v - d_d);
                break;
            }
            case 54: {
                this.cursor.v = (byte)(this.cursor.v + d_d);
                break;
            }
            case 49: {
                this.cursor.h = (byte)(this.cursor.h + d_d);
                this.cursor.v = (byte)(this.cursor.v - d_d);
                break;
            }
            case 51: {
                this.cursor.h = (byte)(this.cursor.h + d_d);
                this.cursor.v = (byte)(this.cursor.v + d_d);
                break;
            }
            case 55: {
                this.cursor.h = (byte)(this.cursor.h - d_d);
                this.cursor.v = (byte)(this.cursor.v - d_d);
                break;
            }
            case 57: {
                this.cursor.h = (byte)(this.cursor.h - d_d);
                this.cursor.v = (byte)(this.cursor.v + d_d);
                break;
            }
            case 53: {
                this.enterPressed();
                this.repaint();
                return;
            }
        }
        this.cursor.placeOnField();
        this.paintedFields[this.cursor.v][this.cursor.h] = false;
        this.repaint();
    }

    boolean checkStep(Move p_mv, boolean p_bSide) {
        if (p_mv == null) {
            return false;
        }
        byte a_h1 = p_mv.pos1.h;
        byte a_v1 = p_mv.pos1.v;
        byte a_h2 = p_mv.pos2.h;
        byte a_v2 = p_mv.pos2.v;
        if (a_v1 == a_v2 && a_h1 == a_h2) {
            return false;
        }
        if (!this.CheckBorders(p_mv.pos1)) {
            return false;
        }
        if (!this.CheckBorders(p_mv.pos2)) {
            return false;
        }
        if (this.figures[a_v1][a_h1] == null) {
            return false;
        }
        if (this.figures[a_v1][a_h1].color != p_bSide) {
            return false;
        }
        if (this.figures[a_v2][a_h2] != null && this.figures[a_v2][a_h2].color == this.figures[a_v1][a_h1].color) {
            return false;
        }
        switch (this.figures[a_v1][a_h1].type) {
            case 1: {
                if (this.CheckPawnMove(p_mv)) break;
                return false;
            }
            case 2: {
                if (this.CheckKnightMove(p_mv)) break;
                return false;
            }
            case 3: {
                if (this.CheckBishopMove(p_mv)) break;
                return false;
            }
            case 4: {
                if (this.CheckRockMove(p_mv)) break;
                return false;
            }
            case 5: {
                if (this.CheckQueenMove(p_mv)) break;
                return false;
            }
            case 6: {
                if (this.CheckKingMove(p_mv)) break;
                return false;
            }
        }
        return !this.CheckTheCheck(p_mv, this.figures[a_v1][a_h1].color);
    }

    void performStep(Move p_mv) {
        this.lastMove = p_mv;
        if (p_mv.proposal >= 0) {
            switch (p_mv.proposal) {
                case 0: {
                    this.gameOver(this.activeColor ? (byte)2 : 0, true);
                    return;
                }
            }
        }
        byte a_v1 = p_mv.pos1.v;
        byte a_h1 = p_mv.pos1.h;
        byte a_v2 = p_mv.pos2.v;
        byte a_h2 = p_mv.pos2.h;
        if (a_v1 == 4 && a_v2 == 6 && a_h1 == 0 && a_h2 == 0 && this.figures[a_v1][a_h1].type == 6) {
            this.figures[5][0] = this.figures[7][0];
            this.figures[7][0] = null;
        }
        if (a_v1 == 4 && a_v2 == 2 && a_h1 == 0 && a_h2 == 0 && this.figures[a_v1][a_h1].type == 6) {
            this.figures[3][0] = this.figures[0][0];
            this.figures[0][0] = null;
        }
        if (a_v1 == 4 && a_v2 == 6 && a_h1 == 7 && a_h2 == 7 && this.figures[a_v1][a_h1].type == 6) {
            this.figures[5][7] = this.figures[7][7];
            this.figures[7][7] = null;
        }
        if (a_v1 == 4 && a_v2 == 2 && a_h1 == 7 && a_h2 == 7 && this.figures[a_v1][a_h1].type == 6) {
            this.figures[3][7] = this.figures[0][7];
            this.figures[0][7] = null;
        }
        this.figures[a_v2][a_h2] = this.figures[a_v1][a_h1];
        this.figures[a_v1][a_h1] = null;
        if (p_mv.mutation < 6 && p_mv.mutation > 1) {
            try {
                this.figures[a_v2][a_h2].mutate(p_mv.mutation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.figures[a_v2][a_h2].type == 6) {
            if (this.figures[a_v2][a_h2].color) {
                this.m_bWhiteKingGone = true;
            } else {
                this.m_bBlackKingGone = true;
            }
        }
        if (this.PateCheck(!this.figures[a_v2][a_h2].color)) {
            if (this.CheckMateCheck(!this.figures[a_v2][a_h2].color)) {
                this.gameOver(this.figures[a_v2][a_h2].color ? (byte)2 : 0, true);
            } else {
                this.gameOver((byte)1, true);
            }
        }
        boolean bl = this.activeColor = !this.activeColor;
        if (this.local) {
            this.paintedFields = null;
        }
        this.repaint();
    }

    boolean CheckPawnMove(Move p_mv) {
        byte a_v1 = p_mv.pos1.v;
        byte a_h1 = p_mv.pos1.h;
        byte a_v2 = p_mv.pos2.v;
        byte a_h2 = p_mv.pos2.h;
        if (this.figures[a_v1][a_h1].color) {
            if (a_v1 == a_v2 && a_h2 == a_h1 + 1 && a_h1 < 7 && this.figures[a_v2][a_h2] == null) {
                return true;
            }
            if (a_v1 == a_v2 && a_h2 == a_h1 + 1 && p_mv.mutation > 1 && p_mv.mutation < 6 && this.figures[a_v2][a_h2] == null) {
                return true;
            }
            if (a_h1 == 1 && a_v1 == a_v2 && a_h2 == 3 && this.figures[a_v2][a_h2] == null && this.figures[a_v2][a_h2 - 1] == null) {
                return true;
            }
            if (a_h1 == a_h2 - 1 && a_v1 == a_v2 - 1 && this.figures[a_v2][a_h2] != null && a_h2 < 7 && !this.figures[a_v2][a_h2].color) {
                return true;
            }
            if (a_h1 == a_h2 - 1 && a_v1 == a_v2 - 1 && this.figures[a_v2][a_h2] != null && a_h2 == 7 && p_mv.mutation > 1 && p_mv.mutation < 6 && !this.figures[a_v2][a_h2].color) {
                return true;
            }
            if (a_h1 == a_h2 - 1 && a_v1 == a_v2 + 1 && this.figures[a_v2][a_h2] != null && a_h2 < 7 && !this.figures[a_v2][a_h2].color) {
                return true;
            }
            if (a_h1 == a_h2 - 1 && a_v1 == a_v2 + 1 && this.figures[a_v2][a_h2] != null && a_h2 == 7 && p_mv.mutation > 1 && p_mv.mutation < 6 && !this.figures[a_v2][a_h2].color) {
                return true;
            }
        } else {
            if (a_h2 == 0) {
                a_h2 = 0;
            }
            if (a_v1 == a_v2 && a_h2 == a_h1 - 1 && a_h1 > 0 && this.figures[a_v2][a_h2] == null) {
                return true;
            }
            if (a_v1 == a_v2 && a_h2 == 1 && a_h2 == 0 && p_mv.mutation > 1 && p_mv.mutation < 6 && this.figures[a_v2][a_h2] == null) {
                return true;
            }
            if (a_h1 == 6 && a_v1 == a_v2 && a_h2 == 4 && this.figures[a_v2][a_h2] == null && this.figures[a_v2][a_h2 + 1] == null) {
                return true;
            }
            if (a_h1 == a_h2 + 1 && a_v1 == a_v2 - 1 && this.figures[a_v2][a_h2] != null && a_h2 > 0 && this.figures[a_v2][a_h2].color) {
                return true;
            }
            if (a_h1 == a_h2 + 1 && a_v1 == a_v2 - 1 && this.figures[a_v2][a_h2] != null && a_h2 == 0 && p_mv.mutation > 1 && p_mv.mutation < 6 && this.figures[a_v2][a_h2].color) {
                return true;
            }
            if (a_h1 == a_h2 + 1 && a_v1 == a_v2 + 1 && this.figures[a_v2][a_h2] != null && a_h2 > 0 && !this.figures[a_v2][a_h2].color) {
                return true;
            }
            if (a_h1 == a_h2 + 1 && a_v1 == a_v2 + 1 && this.figures[a_v2][a_h2] != null && a_h2 == 0 && p_mv.mutation > 1 && p_mv.mutation < 6 && this.figures[a_v2][a_h2].color) {
                return true;
            }
        }
        return false;
    }

    boolean CheckKnightMove(Move p_mv) {
        byte a_v1 = p_mv.pos1.v;
        byte a_v2 = p_mv.pos2.v;
        byte a_h1 = p_mv.pos1.h;
        byte a_h2 = p_mv.pos2.h;
        return (a_v1 - a_v2) * (a_v1 - a_v2) + (a_h1 - a_h2) * (a_h1 - a_h2) == 5;
    }

    boolean CheckBishopMove(Move p_mv) {
        byte a_v1 = p_mv.pos1.v;
        byte a_h1 = p_mv.pos1.h;
        byte a_v2 = p_mv.pos2.v;
        byte a_h2 = p_mv.pos2.h;
        short a_dv = (short)(a_v1 < a_v2 ? 1 : -1);
        short a_dh = (short)(a_h1 < a_h2 ? 1 : -1);
        if (a_h2 - a_h1 != a_v2 - a_v1 && a_h2 - a_h1 != a_v1 - a_v2) {
            return false;
        }
        a_v1 = (byte)(a_v1 + a_dv);
        a_h1 = (byte)(a_h1 + a_dh);
        while (a_v1 != a_v2) {
            if (this.figures[a_v1][a_h1] != null) {
                return false;
            }
            a_v1 = (byte)(a_v1 + a_dv);
            a_h1 = (byte)(a_h1 + a_dh);
        }
        return true;
    }

    boolean CheckRockMove(Move p_mv) {
        byte a_v1 = p_mv.pos1.v;
        byte a_v2 = p_mv.pos2.v;
        byte a_h1 = p_mv.pos1.h;
        byte a_h2 = p_mv.pos2.h;
        if ((a_v1 - a_v2) * (a_h1 - a_h2) != 0) {
            return false;
        }
        int a_dv = 0;
        int a_dh = 0;
        if (a_v1 < a_v2) {
            a_dv = 1;
        }
        if (a_v1 > a_v2) {
            a_dv = -1;
        }
        if (a_h1 < a_h2) {
            a_dh = 1;
        }
        if (a_h1 > a_h2) {
            a_dh = -1;
        }
        a_v1 = (byte)(a_v1 + a_dv);
        a_h1 = (byte)(a_h1 + a_dh);
        while (a_v1 != a_v2 || a_h1 != a_h2) {
            if (this.figures[a_v1][a_h1] != null) {
                return false;
            }
            a_v1 = (byte)(a_v1 + a_dv);
            a_h1 = (byte)(a_h1 + a_dh);
        }
        return true;
    }

    boolean CheckQueenMove(Move p_mv) {
        if (this.CheckBishopMove(p_mv)) {
            return true;
        }
        return this.CheckRockMove(p_mv);
    }

    boolean CheckKingMove(Move p_mv) {
        byte a_v1 = p_mv.pos1.v;
        byte a_h1 = p_mv.pos1.h;
        byte a_v2 = p_mv.pos2.v;
        byte a_h2 = p_mv.pos2.h;
        if (this.figures[a_v1][a_h1].color && a_v1 == 4 && a_h1 == 0 && !this.m_bWhiteKingGone) {
            if (a_v2 == 6 && a_h2 == 0) {
                Field a_F;
                if (this.CheckTheCheck(null, true)) {
                    return false;
                }
                if (this.figures[5][0] != null) {
                    return false;
                }
                if (this.figures[6][0] != null) {
                    return false;
                }
                if (this.figures[7][0] == null) {
                    return false;
                }
                if (this.figures[7][0].type != 4) {
                    return false;
                }
                if (!this.figures[7][0].color) {
                    return false;
                }
                Move a_mv = new Move();
                a_mv.pos1 = a_F = new Field(4, 0);
                a_mv.pos2 = a_F = new Field(5, 0);
                return !this.CheckTheCheck(a_mv, true);
            }
            if (a_v2 == 2 && a_h2 == 0) {
                Field a_F;
                if (this.CheckTheCheck(null, true)) {
                    return false;
                }
                if (this.figures[3][0] != null) {
                    return false;
                }
                if (this.figures[2][0] != null) {
                    return false;
                }
                if (this.figures[0][0] == null) {
                    return false;
                }
                if (this.figures[0][0].type != 4) {
                    return false;
                }
                if (!this.figures[0][0].color) {
                    return false;
                }
                Move a_mv = new Move();
                a_mv.pos1 = a_F = new Field(4, 0);
                a_mv.pos2 = a_F = new Field(3, 0);
                return !this.CheckTheCheck(a_mv, true);
            }
        }
        if (!this.figures[a_v1][a_h1].color && a_v1 == 4 && a_h1 == 7 && !this.m_bBlackKingGone) {
            if (a_v2 == 6 && a_h2 == 7) {
                Field a_F;
                if (this.CheckTheCheck(null, false)) {
                    return false;
                }
                if (this.figures[5][7] != null) {
                    return false;
                }
                if (this.figures[6][7] != null) {
                    return false;
                }
                if (this.figures[7][7] == null) {
                    return false;
                }
                if (this.figures[7][7].type != 4) {
                    return false;
                }
                if (this.figures[7][7].color) {
                    return false;
                }
                Move a_mv = new Move();
                a_mv.pos1 = a_F = new Field(4, 7);
                a_mv.pos2 = a_F = new Field(5, 7);
                return !this.CheckTheCheck(a_mv, false);
            }
            if (a_v2 == 2 && a_h2 == 7) {
                Field a_F;
                if (this.CheckTheCheck(null, false)) {
                    return false;
                }
                if (this.figures[3][7] != null) {
                    return false;
                }
                if (this.figures[2][7] != null) {
                    return false;
                }
                if (this.figures[0][7] == null) {
                    return false;
                }
                if (this.figures[0][7].type != 4) {
                    return false;
                }
                if (this.figures[0][7].color) {
                    return false;
                }
                Move a_mv = new Move();
                a_mv.pos1 = a_F = new Field(4, 7);
                a_mv.pos2 = a_F = new Field(3, 7);
                return !this.CheckTheCheck(a_mv, false);
            }
        }
        if (a_v1 - a_v2 > 1) {
            return false;
        }
        if (a_v1 - a_v2 < -1) {
            return false;
        }
        if (a_h1 - a_h2 > 1) {
            return false;
        }
        return a_h1 - a_h2 >= -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean CheckTheCheck(Move p_mv, boolean p_bSide) {
        int a_idx2;
        int a_idx1;
        boolean a_Check = false;
        byte a_v1 = 0;
        byte a_h1 = 0;
        byte a_v2 = 0;
        byte a_h2 = 0;
        ChessFigure a_bakFigure = null;
        if (p_mv != null) {
            a_v1 = p_mv.pos1.v;
            a_h1 = p_mv.pos1.h;
            a_v2 = p_mv.pos2.v;
            a_h2 = p_mv.pos2.h;
            a_bakFigure = this.figures[a_v2][a_h2];
            this.figures[a_v2][a_h2] = this.figures[a_v1][a_h1];
            this.figures[a_v1][a_h1] = null;
        }
        Field a_kingF = new Field();
        block8: for (a_idx1 = 0; a_idx1 < 8; a_idx1 = (int)((byte)(a_idx1 + 1))) {
            for (a_idx2 = 0; a_idx2 < 8; a_idx2 = (int)((byte)(a_idx2 + 1))) {
                if (this.figures[a_idx1][a_idx2] == null || this.figures[a_idx1][a_idx2].type != 6 || this.figures[a_idx1][a_idx2].color != p_bSide) continue;
                a_kingF.v = (byte)a_idx1;
                a_kingF.h = (byte)a_idx2;
                break block8;
            }
        }
        block10: for (a_idx1 = 0; a_idx1 < 8; a_idx1 = (int)((byte)(a_idx1 + 1))) {
            a_idx2 = 0;
            while (a_idx2 < 8) {
                if (this.figures[a_idx1][a_idx2] != null && this.figures[a_idx1][a_idx2].color != p_bSide) {
                    Move a_tmpMove = new Move();
                    Field a_F = new Field();
                    a_F.h = (byte)a_idx2;
                    a_F.v = (byte)a_idx1;
                    a_tmpMove.pos1 = a_F;
                    a_tmpMove.pos2 = a_kingF;
                    switch (this.figures[a_idx1][a_idx2].type) {
                        case 1: {
                            if (a_kingF.h == 0 || a_kingF.h == 7) {
                                a_tmpMove.mutation = (byte)2;
                            }
                            if (!this.CheckPawnMove(a_tmpMove)) break;
                            a_Check = true;
                            break block10;
                        }
                        case 2: {
                            if (!this.CheckKnightMove(a_tmpMove)) break;
                            a_Check = true;
                            break block10;
                        }
                        case 3: {
                            if (!this.CheckBishopMove(a_tmpMove)) break;
                            a_Check = true;
                            break block10;
                        }
                        case 4: {
                            if (!this.CheckRockMove(a_tmpMove)) break;
                            a_Check = true;
                            break block10;
                        }
                        case 5: {
                            if (!this.CheckQueenMove(a_tmpMove)) break;
                            a_Check = true;
                            break block10;
                        }
                        case 6: {
                            if (!this.CheckKingMove(a_tmpMove)) break;
                            a_Check = true;
                            break block10;
                        }
                    }
                }
                a_idx2 = (byte)(a_idx2 + 1);
            }
        }
        if (p_mv != null) {
            this.figures[a_v1][a_h1] = this.figures[a_v2][a_h2];
            this.figures[a_v2][a_h2] = a_bakFigure;
        }
        return a_Check;
    }

    boolean PateCheck(boolean p_Side) {
        for (int a_idxV = 0; a_idxV < 8; a_idxV = (int)((byte)(a_idxV + 1))) {
            block9: for (int a_idxH = 0; a_idxH < 8; a_idxH = (int)((byte)(a_idxH + 1))) {
                if (this.figures[a_idxV][a_idxH] == null || this.figures[a_idxV][a_idxH].color != p_Side) continue;
                switch (this.figures[a_idxV][a_idxH].type) {
                    case 1: {
                        int a_idx;
                        Field a_Field = new Field();
                        a_Field.h = (byte)a_idxH;
                        a_Field.v = (byte)a_idxV;
                        Move[] a_ArrOfMoves = this.GetPawnMoves(a_Field);
                        for (a_idx = 0; a_idx < a_ArrOfMoves.length; ++a_idx) {
                            if (!this.checkStep(a_ArrOfMoves[a_idx], p_Side)) continue;
                            return false;
                        }
                        continue block9;
                    }
                    case 2: {
                        int a_idx;
                        Field a_Field = new Field();
                        a_Field.h = (byte)a_idxH;
                        a_Field.v = (byte)a_idxV;
                        Move[] a_ArrOfMoves = this.GetKnightMoves(a_Field);
                        for (a_idx = 0; a_idx < a_ArrOfMoves.length; ++a_idx) {
                            if (!this.checkStep(a_ArrOfMoves[a_idx], p_Side)) continue;
                            return false;
                        }
                        continue block9;
                    }
                    case 3: {
                        int a_idx;
                        Field a_Field = new Field();
                        a_Field.h = (byte)a_idxH;
                        a_Field.v = (byte)a_idxV;
                        Move[] a_ArrOfMoves = this.GetBishopMoves(a_Field);
                        for (a_idx = 0; a_idx < a_ArrOfMoves.length; ++a_idx) {
                            if (!this.checkStep(a_ArrOfMoves[a_idx], p_Side)) continue;
                            return false;
                        }
                        continue block9;
                    }
                    case 4: {
                        int a_idx;
                        Field a_Field = new Field();
                        a_Field.h = (byte)a_idxH;
                        a_Field.v = (byte)a_idxV;
                        Move[] a_ArrOfMoves = this.GetRockMoves(a_Field);
                        for (a_idx = 0; a_idx < a_ArrOfMoves.length; ++a_idx) {
                            if (!this.checkStep(a_ArrOfMoves[a_idx], p_Side)) continue;
                            return false;
                        }
                        continue block9;
                    }
                    case 5: {
                        int a_idx;
                        Field a_Field = new Field();
                        a_Field.h = (byte)a_idxH;
                        a_Field.v = (byte)a_idxV;
                        Move[] a_ArrOfMoves = this.GetQueenMoves(a_Field);
                        for (a_idx = 0; a_idx < a_ArrOfMoves.length; ++a_idx) {
                            if (!this.checkStep(a_ArrOfMoves[a_idx], p_Side)) continue;
                            return false;
                        }
                        continue block9;
                    }
                    case 6: {
                        int a_idx;
                        Field a_Field = new Field();
                        a_Field.h = (byte)a_idxH;
                        a_Field.v = (byte)a_idxV;
                        Move[] a_ArrOfMoves = this.GetKingMoves(a_Field);
                        for (a_idx = 0; a_idx < a_ArrOfMoves.length; ++a_idx) {
                            if (!this.checkStep(a_ArrOfMoves[a_idx], p_Side)) continue;
                            return false;
                        }
                        continue block9;
                    }
                }
            }
        }
        return true;
    }

    boolean CheckMateCheck(boolean p_Color) {
        return this.CheckTheCheck(null, p_Color);
    }

    void Send(Move p_mv) {
        Request req = new Request();
        req.action = (byte)9;
        req.tableId = this.tableId;
        req.move = p_mv.toString();
        try {
            Server.getResults(req);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Move[] GetPawnMoves(Field p_F) {
        byte a_v = p_F.v;
        byte a_h = p_F.h;
        Move[] arr = new Move[4];
        Field a_F = new Field();
        arr[0] = new Move();
        arr[0].pos1 = p_F;
        a_F.v = p_F.v;
        a_F.h = this.figures[a_v][a_h].color ? (byte)(p_F.h + 1) : (byte)(p_F.h - 1);
        arr[0].pos2 = a_F;
        if (a_F.h == 0 || a_F.h == 7) {
            arr[0].mutation = (byte)5;
        }
        if (a_v > 0) {
            a_F = new Field();
            arr[1] = new Move();
            arr[1].pos1 = p_F;
            a_F.v = (byte)(p_F.v - 1);
            a_F.h = this.figures[a_v][a_h].color ? (byte)(p_F.h + 1) : (byte)(p_F.h - 1);
            arr[1].pos2 = a_F;
            if (a_F.h == 0 || a_F.h == 7) {
                arr[1].mutation = (byte)5;
            }
        }
        if (a_v < 7) {
            a_F = new Field();
            arr[2] = new Move();
            arr[2].pos1 = p_F;
            a_F.v = (byte)(p_F.v + 1);
            a_F.h = this.figures[a_v][a_h].color ? (byte)(p_F.h + 1) : (byte)(p_F.h - 1);
            arr[2].pos2 = a_F;
            if (a_F.h == 0 || a_F.h == 7) {
                arr[2].mutation = (byte)5;
            }
        }
        if (a_h == 1 && this.figures[a_v][a_h].color) {
            a_F = new Field();
            arr[3] = new Move();
            arr[3].pos1 = p_F;
            a_F.v = p_F.v;
            a_F.h = (byte)(p_F.h + 2);
            arr[3].pos2 = a_F;
        }
        if (a_h == 6 && !this.figures[a_v][a_h].color) {
            a_F = new Field();
            arr[3] = new Move();
            arr[3].pos1 = p_F;
            a_F.v = p_F.v;
            a_F.h = (byte)(p_F.h - 2);
            arr[3].pos2 = a_F;
        }
        return arr;
    }

    boolean CheckBorders(Field p_F) {
        return p_F.h > -1 && p_F.h < 8 && p_F.v > -1 && p_F.v < 8;
    }

    Move[] GetKnightMoves(Field p_F) {
        byte a_v = p_F.v;
        byte a_h = p_F.h;
        Move[] arr = new Move[8];
        int a_idx = 0;
        for (int a_dv = -2; a_dv < 3; a_dv = (int)((byte)(a_dv + 1))) {
            for (int a_dh = -2; a_dh < 3; a_dh = (int)((byte)(a_dh + 1))) {
                if (a_dv * a_dv + a_dh * a_dh != 5) continue;
                Field a_F = new Field();
                a_F.v = (byte)(a_F.v + a_dv);
                a_F.h = (byte)(a_F.h + a_dh);
                if (!this.CheckBorders(a_F)) continue;
                arr[a_idx] = new Move();
                arr[a_idx].pos1 = p_F;
                arr[a_idx].pos2 = a_F;
                ++a_idx;
            }
        }
        return arr;
    }

    Move[] GetBishopMoves(Field p_F) {
        byte a_v = p_F.v;
        byte a_h = p_F.h;
        Move[] arr = new Move[16];
        int a_idx = 0;
        for (int a_d = -7; a_d < 8; a_d = (int)((byte)(a_d + 1))) {
            Field a_F = new Field();
            a_F.v = (byte)(a_F.v + a_d);
            a_F.h = (byte)(a_F.h + a_d);
            if (this.CheckBorders(a_F)) {
                arr[a_idx] = new Move();
                arr[a_idx].pos1 = p_F;
                arr[a_idx].pos2 = a_F;
                ++a_idx;
            }
            a_F = new Field();
            a_F.v = (byte)(a_F.v + a_d);
            a_F.h = (byte)(a_F.h - a_d);
            if (!this.CheckBorders(a_F)) continue;
            arr[a_idx] = new Move();
            arr[a_idx].pos1 = p_F;
            arr[a_idx].pos2 = a_F;
            ++a_idx;
        }
        return arr;
    }

    Move[] GetRockMoves(Field p_F) {
        byte a_v = p_F.v;
        byte a_h = p_F.h;
        Move[] arr = new Move[16];
        int a_idx = 0;
        for (int a_d = -7; a_d < 8; a_d = (int)((byte)(a_d + 1))) {
            Field a_F = new Field();
            a_F.v = (byte)(a_F.v + a_d);
            a_F.h = a_F.h;
            if (this.CheckBorders(a_F)) {
                arr[a_idx] = new Move();
                arr[a_idx].pos1 = p_F;
                arr[a_idx].pos2 = a_F;
                ++a_idx;
            }
            a_F = new Field();
            a_F.v = a_F.v;
            a_F.h = (byte)(a_F.h + a_d);
            if (!this.CheckBorders(a_F)) continue;
            arr[a_idx] = new Move();
            arr[a_idx].pos1 = p_F;
            arr[a_idx].pos2 = a_F;
            ++a_idx;
        }
        return arr;
    }

    Move[] GetQueenMoves(Field p_F) {
        Move[] arr = new Move[32];
        Move[] BishopMoves = this.GetBishopMoves(p_F);
        Move[] RockMoves = this.GetRockMoves(p_F);
        for (int a_idx1 = 0; a_idx1 < BishopMoves.length; ++a_idx1) {
            arr[a_idx1] = BishopMoves[a_idx1];
        }
        for (int a_idx2 = 0; a_idx2 < RockMoves.length; ++a_idx2) {
            arr[a_idx1 + a_idx2] = RockMoves[a_idx2];
        }
        return arr;
    }

    Move[] GetKingMoves(Field p_F) {
        Move[] arr = new Move[8];
        int a_idx = 0;
        for (int a_idx1 = -1; a_idx1 < 2; a_idx1 = (int)((byte)(a_idx1 + 1))) {
            for (int a_idx2 = -1; a_idx2 < 2; a_idx2 = (int)((byte)(a_idx2 + 1))) {
                if (a_idx1 * a_idx1 + a_idx2 * a_idx2 == 0) continue;
                Field a_F = new Field();
                a_F.h = (byte)(p_F.h + a_idx2);
                a_F.v = (byte)(p_F.v + a_idx1);
                arr[a_idx] = new Move();
                arr[a_idx].pos1 = p_F;
                arr[a_idx].pos2 = a_F;
                ++a_idx;
            }
        }
        return arr;
    }

    void loadGame() {
        Vector moves = this.getGameFromServer();
        for (int a_idx1 = 0; a_idx1 < moves.size(); ++a_idx1) {
            this.performStep((Move)moves.elementAt(a_idx1));
        }
    }

    void gameOver(byte newState) {
        this.gameOver(newState, false);
    }

    void gameOver(byte newState, boolean sendToServer) {
        String message;
        this.m_result = newState;
        if (sendToServer && !this.local) {
            try {
                Request r = new Request();
                r.action = (byte)13;
                r.tableId = this.tableId;
                Server.getResults(r);
            }
            catch (Exception r) {
                // empty catch block
            }
        }
        switch (this.m_result) {
            case 0: {
                message = "Black won!";
                break;
            }
            case 2: {
                message = "White won!";
                break;
            }
            default: {
                message = "Draw!";
            }
        }
        Alert alert = new Alert("Game over", message, null, AlertType.INFO);
        MainForm form = new MainForm();
        Display.getDisplay((MIDlet)NetMobileChess.instance).setCurrent(alert, (Displayable)form);
    }

    Vector getGameFromServer() {
        Vector<Move> moves = new Vector<Move>();
        if (this.local) {
            return null;
        }
        Request req = new Request();
        req.tableId = this.tableId;
        req.action = (byte)8;
        Vector v = new Vector();
        try {
            v = Server.getResults(req);
            for (int i = 0; i < v.size(); ++i) {
                String str = (String)v.elementAt(i);
                if (str.length() <= 0) continue;
                Move m = Move.parseMove(str);
                moves.addElement(m);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return moves;
    }

    static {
        ms_dim = (byte)8;
        WHITE = 0xFFFFFF;
        BLACK = 0;
        BG_COLOR = 0xFFFFFF;
        FIGURECHOICE = 0;
        MOVECHOICE = 1;
        ENEMYTURN = (byte)2;
        GAMEOVER = (byte)3;
        BLACKWON = 0;
        DRAW = 1;
        WHITEWON = (byte)2;
        fieldSize = (byte)8;
    }
}

