/*
 * Decompiled with CFR 0.152.
 */
package ws.boardgames;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ws.boardgames.WrongFigureNumException;
import ws.boardgames.WrongFigureTypeException;

public class ChessFigure {
    public static final byte PAWN = 1;
    public static final byte KNIGHT = 2;
    public static final byte BISHOP = 3;
    public static final byte ROCK = 4;
    public static final byte QUEEN = 5;
    public static final byte KING = 6;
    byte type = 1;
    boolean color;

    public ChessFigure() {
    }

    public static Image getImage(byte type, boolean color, boolean fColor) {
        String fname = String.valueOf(String.valueOf(new StringBuffer("/").append(type).append(color ? "w" : "b").append(fColor ? "w" : "b").append(".png")));
        Image img = null;
        try {
            img = Image.createImage((String)fname);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return img;
    }

    public void paint(Graphics g, boolean fColor) {
        Image img = ChessFigure.getImage(this.type, this.color, fColor);
        g.drawImage(img, 1, 1, 20);
    }

    public ChessFigure(byte p_Type, boolean p_bColor) {
        this.type = p_Type;
        this.color = p_bColor;
    }

    public void CreateFigure(byte p_Type, boolean p_bColor) throws WrongFigureNumException {
        if (p_Type < 1 || p_Type > 6) {
            throw new WrongFigureNumException("cannot create such a figure");
        }
        this.type = p_Type;
        this.color = p_bColor;
    }

    public void mutate(byte p_NewType) throws WrongFigureTypeException {
        if (this.type != 1) {
            throw new WrongFigureTypeException("only pawn can mutate");
        }
        if (p_NewType < 2 || p_NewType > 6) {
            throw new WrongFigureTypeException("pawn can mutate only to knight, bishop, rock or queen");
        }
        this.type = p_NewType;
    }

    static {
        PAWN = 1;
        KNIGHT = (byte)2;
        BISHOP = (byte)3;
        ROCK = (byte)4;
        QUEEN = (byte)5;
        KING = (byte)6;
    }
}

