/*
 * Decompiled with CFR 0.152.
 */
package ws.boardgames;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import ws.boardgames.ChessDesk;
import ws.boardgames.NetMobileChess;
import ws.boardgames.Request;
import ws.boardgames.Server;

public class TablesForm
extends List
implements CommandListener {
    private List colorsList = null;
    private Vector ids = new Vector();
    private Vector availablePlace = new Vector();
    private int room_id = -1;

    public TablesForm(int id) {
        super("Choose table", 3);
        this.room_id = id;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void FillTables() {
        this.ids = new Vector();
        this.availablePlace = new Vector();
        Request req = new Request();
        if (this.room_id > 0) {
            req.action = 1;
            req.roomId = this.room_id;
        } else {
            req.action = (byte)12;
        }
        try {
            Vector tables = Server.getResults(req);
            int i = 0;
            int size = tables.size();
            while (i < size) {
                String str = (String)tables.elementAt(i++);
                Integer val = new Integer(Integer.parseInt(str));
                this.ids.addElement(val);
                String player1 = (String)tables.elementAt(i++);
                String player2 = (String)tables.elementAt(i++);
                String login = Request.login;
                boolean temp = false;
                if (player1.equals(login) || player2.length() == 0) {
                    temp = true;
                } else if (player2.equals(login) || player1.length() == 0) {
                    temp = false;
                }
                this.availablePlace.addElement(new Boolean(temp));
                if (this.room_id > 0) {
                    boolean color = player1.length() != 0;
                    this.append(String.valueOf(String.valueOf(color ? player1 : player2)).concat(String.valueOf(String.valueOf(color ? " - white" : " - black"))), null);
                    continue;
                }
                this.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(player1))).append(" ").append(player2))), null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.setCommandListener(this);
        this.addCommand(new Command("Exit", 7, 1));
        if (this.room_id != -1) {
            this.addCommand(new Command("Create table", 4, 2));
        }
        this.FillTables();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            NetMobileChess.quitApp();
        }
        if (command.getCommandType() == 4) {
            int n = this.getSelectedIndex();
        }
        if (command == List.SELECT_COMMAND) {
            if (this.colorsList != null) {
                Request req = new Request();
                req.action = (byte)2;
                req.side = this.colorsList.getSelectedIndex() == 0;
                req.roomId = this.room_id;
                try {
                    Vector v = Server.getResults(req);
                    String str = (String)v.elementAt(0);
                    ChessDesk table = new ChessDesk(this.colorsList.getSelectedIndex() == 0, false, Integer.parseInt(str));
                    Display.getDisplay((MIDlet)NetMobileChess.instance).setCurrent((Displayable)table);
                    this.colorsList = null;
                }
                catch (IOException v) {
                    // empty catch block
                }
                return;
            }
            int selected = this.getSelectedIndex();
            int id = (Integer)this.ids.elementAt(selected);
            boolean b = (Boolean)this.availablePlace.elementAt(selected);
            if (this.room_id > 0) {
                Request req = new Request();
                req.action = (byte)3;
                req.tableId = id;
                try {
                    Vector v = Server.getResults(req);
                    ChessDesk table = new ChessDesk(!b, false, Integer.parseInt((String)v.elementAt(0)));
                    Display.getDisplay((MIDlet)NetMobileChess.instance).setCurrent((Displayable)table);
                }
                catch (IOException iOException) {}
            } else {
                ChessDesk table = new ChessDesk(b, false, id);
                Display.getDisplay((MIDlet)NetMobileChess.instance).setCurrent((Displayable)table);
            }
        } else if (command.getCommandType() == 4) {
            this.colorsList = new List("Choose color", 3);
            this.colorsList.setCommandListener((CommandListener)this);
            this.colorsList.append("White", null);
            this.colorsList.append("Black", null);
            Display.getDisplay((MIDlet)NetMobileChess.instance).setCurrent((Displayable)this.colorsList);
        }
    }
}

