/*
 * Decompiled with CFR 0.152.
 */
package nbs_tetris;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import nbs_tetris.TetrisView;
import nbs_tetris.Utils;
import nbs_tetris.tetrisMIDlet;

public class TetrisItem {
    private static final byte[] BIT_ACCESS = new byte[]{8, 4, 2, 1};
    private int[] COLORS;
    public static final byte ELEMENT_BIG_L = 13;
    private static final byte[] ELEMENT_BIG_L_IMPL;
    public static final byte ELEMENT_BIG_P = 9;
    private static final byte[] ELEMENT_BIG_P_IMPL;
    public static final byte ELEMENT_BIG_T = 14;
    private static final byte[] ELEMENT_BIG_T_IMPL;
    public static final byte ELEMENT_CROSS = 10;
    private static final byte[] ELEMENT_CROSS_IMPL;
    public static final byte ELEMENT_DOT = 11;
    private static final byte[] ELEMENT_DOT_IMPL;
    public static final byte ELEMENT_GAMEOVER = 3;
    public static final byte ELEMENT_JAM = 7;
    private static final byte[] ELEMENT_JAM_IMPL;
    public static final byte ELEMENT_LG = 4;
    private static final byte[] ELEMENT_LG_IMPL;
    public static final byte ELEMENT_LINE = 0;
    private static final byte[] ELEMENT_LINE_IMPL;
    public static final byte ELEMENT_LZIGZAG = 2;
    private static final byte[] ELEMENT_LZIGZAG_IMPL;
    public static final byte[][] ELEMENT_MAPS;
    public static final byte ELEMENT_ONWAY = 1;
    public static final byte ELEMENT_RG = 5;
    private static final byte[] ELEMENT_RG_IMPL;
    public static final byte ELEMENT_RZIGZAG = 3;
    private static final byte[] ELEMENT_RZIGZAG_IMPL;
    public static final byte ELEMENT_SMALL_L = 12;
    private static final byte[] ELEMENT_SMALL_L_IMPL;
    public static final byte ELEMENT_SMALL_P = 8;
    private static final byte[] ELEMENT_SMALL_P_IMPL;
    public static final byte ELEMENT_SMALL_T = 6;
    private static final byte[] ELEMENT_SMALL_T_IMPL;
    public static final byte ELEMENT_SQUARE = 1;
    private static final byte[] ELEMENT_SQUARE_IMPL;
    public static final byte ELEMENT_STOPPED = 2;
    private byte[][][] ROTATE_TABLE;
    private int[] cell;
    public int color;
    private int[][] glass_map;
    public byte[] map;
    private tetrisMIDlet midlet = tetrisMIDlet.getInstance();
    private int num_colors;
    private int orientation;
    private int size;
    private TetrisView tetris;
    private int[] top = new int[]{0, 0};
    private int type;

    static {
        ELEMENT_LINE_IMPL = new byte[]{4, 4, 4, 4};
        ELEMENT_SQUARE_IMPL = new byte[]{0, 6, 6, 0};
        ELEMENT_LZIGZAG_IMPL = new byte[]{4, 6, 2, 0};
        ELEMENT_RZIGZAG_IMPL = new byte[]{2, 6, 4, 0};
        ELEMENT_LG_IMPL = new byte[]{0, 6, 2, 2};
        ELEMENT_RG_IMPL = new byte[]{0, 6, 4, 4};
        ELEMENT_SMALL_T_IMPL = new byte[]{2, 6, 2, 0};
        ELEMENT_JAM_IMPL = new byte[]{6, 15, 0, 0};
        ELEMENT_SMALL_P_IMPL = new byte[]{0, 7, 5, 0};
        ELEMENT_BIG_P_IMPL = new byte[]{0, 7, 5, 5};
        ELEMENT_CROSS_IMPL = new byte[]{4, 14, 4, 0};
        ELEMENT_DOT_IMPL = new byte[]{0, 2, 0, 0};
        ELEMENT_SMALL_L_IMPL = new byte[]{4, 14, 10, 0};
        ELEMENT_BIG_L_IMPL = new byte[]{4, 14, 10, 10};
        ELEMENT_BIG_T_IMPL = new byte[]{0, 7, 2, 2};
        ELEMENT_MAPS = new byte[][]{ELEMENT_LINE_IMPL, ELEMENT_SQUARE_IMPL, ELEMENT_LZIGZAG_IMPL, ELEMENT_RZIGZAG_IMPL, ELEMENT_RG_IMPL, ELEMENT_LG_IMPL, ELEMENT_SMALL_T_IMPL, ELEMENT_JAM_IMPL, ELEMENT_SMALL_P_IMPL, ELEMENT_BIG_P_IMPL, ELEMENT_CROSS_IMPL, ELEMENT_DOT_IMPL, ELEMENT_SMALL_L_IMPL, ELEMENT_BIG_L_IMPL, ELEMENT_BIG_T_IMPL};
    }

    public TetrisItem(TetrisView tetrisView) {
        this.cell = new int[]{0, 0};
        this.map = new byte[BIT_ACCESS.length];
        this.COLORS = new int[]{1, 255, 65280, 0xFF0000, 0xBB0000, 47872, 187, 48059, 0xBBBB00, 0x222222, 0x880077, 0xFF00FF, 0x22DD22, 52445, 0xDDCC00};
        this.ROTATE_TABLE = new byte[][][]{new byte[][]{{3, 0}, {3, 1}, {3, 2}, {3, 3}}, new byte[][]{{2, 0}, {2, 1}, {2, 2}, {2, 3}}, new byte[][]{{1, 0}, {1, 1}, {1, 2}, {1, 3}}, new byte[][]{{0, 0}, {0, 1}, {0, 2}, {0, 3}}};
        this.tetris = tetrisView;
        this.randomize();
        this.orientation = this.tetris.getOrientation();
        this.size = this.tetris.getCell_size();
        this.glass_map = this.tetris.getGlass_map();
    }

    public static void drawCell(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(n4);
        graphics.fillRect(n, n2, n3, n3);
    }

    public int[] getCell() {
        return this.cell;
    }

    public byte[] getMap() {
        return this.map;
    }

    public int getNum_colors() {
        return this.num_colors;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getSize() {
        return this.size;
    }

    public int[] getTop() {
        return this.top;
    }

    public int getType() {
        return this.type;
    }

    public synchronized void moveLeft() {
        int n = 0;
        while (n < this.map.length) {
            int n2 = 0;
            while (n2 < this.map.length) {
                if ((this.map[n2] & BIT_ACCESS[n]) > 0) {
                    int n3 = this.cell[0] + n;
                    int n4 = this.cell[1] + n2 - 1;
                    if (n3 <= 0) {
                        return;
                    }
                    if (n4 >= 0 && n4 < this.glass_map[n3].length - 1 && this.glass_map[n3 - 1][n4] != 0) {
                        return;
                    }
                }
                ++n2;
            }
            ++n;
        }
        this.cell[0] = this.cell[0] - 1;
    }

    public synchronized void moveRight() {
        int n = this.map.length - 1;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < this.map.length) {
                if ((this.map[n2] & BIT_ACCESS[n]) > 0) {
                    int n3 = this.cell[0] + n;
                    int n4 = this.cell[1] + n2 - 1;
                    if (n3 >= this.tetris.getNum_cols() - 1) {
                        return;
                    }
                    if (n4 >= 0 && n4 < this.glass_map[n3].length - 1 && n3 + 1 < this.tetris.getNum_cols() - 1 && this.glass_map[n3 + 1][n4] != 0) {
                        return;
                    }
                }
                ++n2;
            }
            --n;
        }
        this.cell[0] = this.cell[0] + 1;
    }

    void pack() {
        int n = 0;
        while (n < this.map.length) {
            if (this.map[n] != 0) break;
            ++n;
        }
        if (n > 0) {
            int n2 = 0;
            while (n < this.map.length) {
                this.map[n2] = this.map[n];
                this.map[n] = 0;
                ++n2;
                ++n;
            }
        }
    }

    public void paint(Graphics graphics) {
        int n = graphics.getColor();
        int n2 = 0;
        while (n2 < this.map.length) {
            if (this.map[n2] != 0) {
                int n3 = 0;
                while (n3 < this.map.length) {
                    if ((this.map[n2] & BIT_ACCESS[n3]) > 0) {
                        if (this.top[0] != this.tetris.getNext_item_lt()[0]) {
                            if (this.orientation == 2) {
                                TetrisItem.drawCell(graphics, this.top[0] + (this.tetris.getNum_rows() - this.cell[1] - n2) * this.size + (this.tetris.isShow_grid() ? 1 : 0), this.top[1] + (this.tetris.getNum_cols() - this.cell[0] - n3 - 1) * this.size - 2, this.size, this.color);
                            } else {
                                TetrisItem.drawCell(graphics, this.top[0] + this.size * n3 + this.cell[0] * this.size - (this.tetris.isShow_grid() ? 1 : 0), this.top[1] + this.size * n2 + this.cell[1] * this.size - (this.tetris.isShow_grid() ? 1 : 0), this.size, this.color);
                            }
                        } else if (this.orientation == 2) {
                            TetrisItem.drawCell(graphics, this.top[0] + this.size * this.map.length - this.size * (n2 + 1), this.top[1] + this.size * this.map.length - this.size * (n3 + 1), this.size, this.color);
                        } else {
                            TetrisItem.drawCell(graphics, this.top[0] + this.size * n3, this.top[1] + n2 * this.size, this.size, this.color);
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        graphics.setColor(n);
    }

    public void randomize() {
        do {
            this.type = Utils.getRandomNumber(ELEMENT_MAPS.length - 1);
            if (this.type < 7) break;
            int n = 1;
        } while ((this.tetris.getProhibition_elements() & (n <<= this.type)) <= 0);
        System.arraycopy(ELEMENT_MAPS[this.type], 0, this.map, 0, this.map.length);
        byte[] byArray = new byte[this.map.length];
        int n = Utils.getRandomNumber(3);
        int n2 = 0;
        while (n2 < n) {
            this.rotate(byArray);
            ++n2;
        }
        this.color = this.midlet.isColor_phone() ? this.COLORS[Utils.getRandomNumber(this.COLORS.length - 1)] : 1;
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        this.cell[0] = dataInputStream.readInt();
        this.cell[1] = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        dataInputStream.read(this.map);
    }

    public void rotate(byte[] byArray) {
        if (this.type != 1 && this.type != 10 && this.type != 11) {
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = 0;
                ++n;
            }
            int n2 = 0;
            while (n2 < this.map.length) {
                if (this.map[n2] != 0) {
                    int n3 = 0;
                    while (n3 < this.map.length) {
                        if ((this.map[n2] & BIT_ACCESS[n3]) > 0) {
                            byte[] byArray2 = this.ROTATE_TABLE[n2][n3];
                            byte by = byArray2[1];
                            byArray[by] = (byte)(byArray[by] | BIT_ACCESS[byArray2[0]]);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            System.arraycopy(byArray, 0, this.map, 0, this.map.length);
        }
    }

    public synchronized void rotateElement(byte[] byArray) {
        this.rotate(byArray);
        this.pack();
        if (this.cell[0] < 0) {
            int n = 0;
            int n2 = 0;
            block0: while (n2 < this.map.length) {
                int n3 = 0;
                while (n3 < this.map.length) {
                    if ((this.map[n3] & BIT_ACCESS[n2]) > 0) {
                        n = n2;
                        break block0;
                    }
                    ++n3;
                }
                ++n2;
            }
            while (this.cell[0] + n > 0) {
                this.cell[0] = this.cell[0] - 1;
            }
            if (this.cell[0] + n < 0) {
                this.cell[0] = -n;
            }
        } else if (this.cell[0] > this.glass_map.length - this.map.length - 2) {
            int n = 0;
            int n4 = this.map.length - 1;
            block3: while (n4 >= 0) {
                int n5 = 0;
                while (n5 < this.map.length) {
                    if ((this.map[n5] & BIT_ACCESS[n4]) > 0) {
                        n = n4;
                        break block3;
                    }
                    ++n5;
                }
                --n4;
            }
            while (this.cell[0] + n < this.glass_map.length - this.map.length - 1) {
                this.cell[0] = this.cell[0] + 1;
            }
            if (this.cell[0] + n > this.glass_map.length - 1) {
                this.cell[0] = this.glass_map.length - this.map.length + (this.map.length - n) - 1;
            }
        }
    }

    public void saveToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.cell[0]);
        dataOutputStream.writeInt(this.cell[1]);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.write(this.map);
    }

    public void setCell(int n, int n2) {
        this.cell[0] = n;
        this.cell[1] = n2;
    }

    public void setCell(int[] nArray) {
        System.arraycopy(nArray, 0, this.cell, 0, this.cell.length);
    }

    public void setNum_colors(int n) {
        this.num_colors = n;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setTop(int n, int n2) {
        this.top[0] = n;
        this.top[1] = n2;
    }

    public void setTop(int[] nArray) {
        System.arraycopy(nArray, 0, this.top, 0, this.top.length);
    }

    public void setType(int n) {
        this.type = n;
    }

    public synchronized byte stepElement() {
        int n = this.map.length - 1;
        try {
            while (this.map[n] == 0) {
                --n;
            }
            int n2 = n;
            while (n >= 0) {
                int n3 = 0;
                while (n3 < this.map.length) {
                    int n4;
                    int n5 = this.cell[0] + n3;
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 >= this.glass_map.length) {
                        n5 = this.glass_map.length - 1;
                    }
                    if ((n4 = this.cell[1] + n) < 0 || n4 > this.glass_map[n5].length) break;
                    if (n4 >= this.glass_map[n5].length || (BIT_ACCESS[n3] & this.map[n]) > 0 && this.glass_map[n5][n4] != 0) {
                        if (this.cell[1] <= 1) {
                            return 3;
                        }
                        int n6 = 0;
                        while (n6 < this.map.length) {
                            int n7 = 0;
                            while (n7 <= n2) {
                                if ((this.map[n7] & BIT_ACCESS[n6]) > 0) {
                                    this.glass_map[this.cell[0] + n6][this.cell[1] + n7 - 1] = this.color;
                                }
                                ++n7;
                            }
                            ++n6;
                        }
                        this.randomize();
                        return 2;
                    }
                    ++n3;
                }
                --n;
            }
            this.cell[1] = this.cell[1] + 1;
            return 1;
        }
        catch (Exception exception) {
            return 2;
        }
    }
}

