/*
 * Decompiled with CFR 0.152.
 */
package nbs_tetris;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import nbs_tetris.PropertyBundle;
import nbs_tetris.TetrisView;
import nbs_tetris.tetrisMIDlet;

public class HelpBox
extends Canvas {
    private static final int BORDER_HORZ = 5;
    private static final int BORDER_VERT = 5;
    private tetrisMIDlet midlet = tetrisMIDlet.getInstance();
    private Vector prev_text_pos = new Vector();
    private String text;
    private int text_pos = 0;
    private int text_size;

    public HelpBox() {
        try {
            String string = "/res/" + this.midlet.getLng() + "/help.data";
            PropertyBundle propertyBundle = new PropertyBundle(string);
            this.text = propertyBundle.getString("hlp");
            this.text_size = this.text.length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 0: 
            case 6: {
                if (this.text_pos < this.text_size) {
                    if (this.prev_text_pos.isEmpty() || (Integer)this.prev_text_pos.lastElement() != this.text_pos) {
                        this.prev_text_pos.addElement(new Integer(this.text_pos));
                    }
                    this.repaint();
                    break;
                }
                this.midlet.showMenu();
                break;
            }
            case 1: {
                if (!this.prev_text_pos.isEmpty()) {
                    this.prev_text_pos.removeElement(this.prev_text_pos.lastElement());
                    if (!this.prev_text_pos.isEmpty()) {
                        this.text_pos = (Integer)this.prev_text_pos.lastElement();
                        this.prev_text_pos.removeElement(this.prev_text_pos.lastElement());
                    } else {
                        this.text_pos = 0;
                    }
                } else {
                    this.text_pos = 0;
                }
                this.repaint();
            }
        }
    }

    protected void paint(Graphics graphics) {
        int n = 5;
        int n2 = 5;
        int n3 = 0;
        this.paintClipRect(graphics);
        Font font = Font.getFont((int)0, (int)0, (int)8);
        graphics.setFont(font);
        while (n2 < this.getHeight() - 10) {
            if (this.text_pos >= this.text_size - 1) break;
            n3 = 1;
            while (this.text_pos + n3 <= this.text_size && font.substringWidth(this.text, this.text_pos, n3) < this.getWidth() - 10) {
                ++n3;
            }
            graphics.drawSubstring(this.text, this.text_pos, --n3, n, n2, 20);
            n2 += font.getHeight() + 2;
            this.text_pos += n3;
        }
    }

    protected void paintClipRect(Graphics graphics) {
        TetrisView.st_paintClipRect(graphics);
    }

    public void show() {
        this.midlet.getDisplay().setCurrent((Displayable)this);
    }
}

