/*
 * Decompiled with CFR 0.152.
 */
package nbs_tetris;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import nbs_tetris.ScoreRecord;
import nbs_tetris.ScoresComparator;
import nbs_tetris.tetrisMIDlet;

public class HighScores
extends List
implements CommandListener {
    private static final String RMS_SCORES = "s";
    private tetrisMIDlet midlet = tetrisMIDlet.getInstance();
    private Vector scores = new Vector(10);

    public HighScores() {
        super("", 3);
        this.setTitle(this.midlet.getI18n("high_scores"));
        try {
            this.setCommandListener(this);
            this.addCommand(new Command(this.midlet.getI18n("ok"), 7, 1));
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_SCORES, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, (RecordComparator)new ScoresComparator(), false);
            while (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                long l = dataInputStream.readLong();
                String string = dataInputStream.readUTF();
                this.scores.addElement(new ScoreRecord(string, l));
                this.append(string + ": " + String.valueOf(l), null);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.append(this.midlet.getI18n("list_empty"), null);
            exception.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        this.midlet.showMenu();
    }

    public long getHighScores() {
        if (this.scores.size() > 0) {
            ScoreRecord scoreRecord = (ScoreRecord)this.scores.firstElement();
            return scoreRecord.score;
        }
        return 0L;
    }

    public long getLowScores() {
        if (this.scores.size() > 1) {
            ScoreRecord scoreRecord = (ScoreRecord)this.scores.lastElement();
            return scoreRecord.score;
        }
        return 0L;
    }

    public Vector getScores() {
        return this.scores;
    }

    public void saveScores() {
        while (this.scores.size() > 10) {
            this.scores.removeElement(this.scores.lastElement());
        }
        try {
            RecordStore.deleteRecordStore((String)RMS_SCORES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_SCORES, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            Enumeration enumeration = this.scores.elements();
            while (enumeration.hasMoreElements()) {
                ScoreRecord scoreRecord = (ScoreRecord)enumeration.nextElement();
                dataOutputStream.writeLong(scoreRecord.score);
                dataOutputStream.writeUTF(scoreRecord.name);
                dataOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                recordStore.addRecord(byArray, 0, byArray.length);
                byteArrayOutputStream.reset();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {}
    }

    public void show() {
        this.midlet.getDisplay().setCurrent((Displayable)this);
    }
}

